var content;
var frameWrapper;
var frame;
var finished = false;

var init = function(){
	content = $("#content");
	frameWrapper = $("#frameWrapper");
	frame = $("#frame");

	_aspectRatio = $(frame).width()/$(frame).height();
	_loadEvents();
	_updateFrame();
	// questions = shuffle(questions);
	_drawQuestions();
	_selectNextQuestion();
};

var _loadEvents = function(){
	$("#content img").on("click", function(e){
		var parentOffset = $(this).parent().offset();
		var relX = e.pageX - parentOffset.left;
		var relY = e.pageY - parentOffset.top;

		var pX = relX/$(frameWrapper).width()*100;
		var pY = relY/$(frameWrapper).height()*100;

		// console.log("pX: " + pX);
		// console.log("pY: " + pY);
	});


	var _lastResizeCall = -1000;
	window.onresize = function(event){
		var t = new Date().getTime();
		if((t - _lastResizeCall) > 1000){
			_lastResizeCall = t;
			//Onresize code here
			_updateFrame();
		} else {
			setTimeout(function(){
				window.onresize();
			},500);
		}
	};

	$(document).on('click','img.checkbox', function(e){
		if(finished){
			return;
		}
		var response = $(e.target).attr("questionid");
		if(response===currentQuestion.id.toString()){
			$(e.target).attr("src","img/checkbox_checked.png");
		} else {
			$("#question_"+currentQuestion.id).attr("src","img/checkbox_wrong.png");
		}
		_selectNextQuestion();
	});
};

var _aspectRatio;
var _updateFrame = function(){
	contentAspectRatio = ($(content).width()/$(content).height());
	if(_aspectRatio < contentAspectRatio){
		//Limit height
		$(frameWrapper).css("height","100%");
		var width = $(frameWrapper).height()*_aspectRatio;
		$(frameWrapper).css("width",width)+"px";
		var marginLeft = ($(content).width()-width)/2;
		$(frameWrapper).css("margin-left",marginLeft+"px");
		$(frameWrapper).css("margin-right",marginLeft+"px");
	} else {
		//Limit width
		$(frameWrapper).css("width","100%");
		$(frameWrapper).css("height",$(frameWrapper).width()/_aspectRatio+"px");
		$(frameWrapper).css("margin-left","0px");
		$(frameWrapper).css("margin-right","0px");
	}
};

var _drawQuestions = function(){
	for(var i=0; i<questions.length; i++){
		_prepareQuestion(questions[i]);
		_drawQuestion(questions[i]);
	};
};

var availableQuestions = [];
var currentQuestion;
var totalQuestions;
var _prepareQuestion = function(q){
	if(typeof q.id != "undefined"){
		availableQuestions.push(q);
	}
	totalQuestions = availableQuestions.length;
};

var _drawQuestion = function(q){
	var img = $("<img class='checkbox' questionId='"+q.id+"' id='question_"+q.id+"' src='img/checkbox.png' />");
	$(img).attr("style","left:" + q.x + "%; top:" + q.y + "%;");
	$(frameWrapper).append(img);
};

var _selectNextQuestion = function(){
	if(availableQuestions.length===0){
		//End
		finished = true;
		$("#headermsg").html("¡Has terminado! Acertaste " + $("img.checkbox[src='img/checkbox_checked.png']").length + "/" + totalQuestions + " preguntas");
	} else {
		var q = availableQuestions.shift();
		currentQuestion = q;
		_initQuestion(q);
	}
};

var _initQuestion = function(q){
	$("#headermsg").html("<span>Haz clic en:</span> " + q.name);
};

function shuffle(o){ //v1.0
    for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
    return o;
};