/*
 * jQuery JavaScript Library v1.7.2
 * http://jquery.com/
 *
 * Copyright 2011, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 * Copyright 2011, The Dojo Foundation
 * Released under the MIT, BSD, and GPL Licenses.
 *
 * Date: Wed Mar 21 12:46:34 2012 -0700
 */
(function(window,undefined){var document=window.document,navigator=window.navigator,location=window.location;var jQuery=(function(){var jQuery=function(selector,context){return new jQuery.fn.init(selector,context,rootjQuery)},_jQuery=window.jQuery,_$=window.$,rootjQuery,quickExpr=/^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,rnotwhite=/\S/,trimLeft=/^\s+/,trimRight=/\s+$/,rsingleTag=/^<(\w+)\s*\/?>(?:<\/\1>)?$/,rvalidchars=/^[\],:{}\s]*$/,rvalidescape=/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,rvalidtokens=/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,rvalidbraces=/(?:^|:|,)(?:\s*\[)+/g,rwebkit=/(webkit)[ \/]([\w.]+)/,ropera=/(opera)(?:.*version)?[ \/]([\w.]+)/,rmsie=/(msie) ([\w.]+)/,rmozilla=/(mozilla)(?:.*? rv:([\w.]+))?/,rdashAlpha=/-([a-z]|[0-9])/ig,rmsPrefix=/^-ms-/,fcamelCase=function(all,letter){return(letter+"").toUpperCase()},userAgent=navigator.userAgent,browserMatch,readyList,DOMContentLoaded,toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,push=Array.prototype.push,slice=Array.prototype.slice,trim=String.prototype.trim,indexOf=Array.prototype.indexOf,class2type={};jQuery.fn=jQuery.prototype={constructor:jQuery,init:function(selector,context,rootjQuery){var match,elem,ret,doc;if(!selector){return this}if(selector.nodeType){this.context=this[0]=selector;this.length=1;return this}if(selector==="body"&&!context&&document.body){this.context=document;this[0]=document.body;this.selector=selector;this.length=1;return this}if(typeof selector==="string"){if(selector.charAt(0)==="<"&&selector.charAt(selector.length-1)===">"&&selector.length>=3){match=[null,selector,null]}else{match=quickExpr.exec(selector)}if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;doc=(context?context.ownerDocument||context:document);ret=rsingleTag.exec(selector);if(ret){if(jQuery.isPlainObject(context)){selector=[document.createElement(ret[1])];jQuery.fn.attr.call(selector,context,true)}else{selector=[doc.createElement(ret[1])]}}else{ret=jQuery.buildFragment([match[1]],[doc]);selector=(ret.cacheable?jQuery.clone(ret.fragment):ret.fragment).childNodes}return jQuery.merge(this,selector)}else{elem=document.getElementById(match[2]);if(elem&&elem.parentNode){if(elem.id!==match[2]){return rootjQuery.find(selector)}this.length=1;this[0]=elem}this.context=document;this.selector=selector;return this}}else{if(!context||context.jquery){return(context||rootjQuery).find(selector)}else{return this.constructor(context).find(selector)}}}else{if(jQuery.isFunction(selector)){return rootjQuery.ready(selector)}}if(selector.selector!==undefined){this.selector=selector.selector;this.context=selector.context}return jQuery.makeArray(selector,this)},selector:"",jquery:"1.7.2",length:0,size:function(){return this.length},toArray:function(){return slice.call(this,0)},get:function(num){return num==null?this.toArray():(num<0?this[this.length+num]:this[num])},pushStack:function(elems,name,selector){var ret=this.constructor();if(jQuery.isArray(elems)){push.apply(ret,elems)}else{jQuery.merge(ret,elems)}ret.prevObject=this;ret.context=this.context;if(name==="find"){ret.selector=this.selector+(this.selector?" ":"")+selector}else{if(name){ret.selector=this.selector+"."+name+"("+selector+")"}}return ret},each:function(callback,args){return jQuery.each(this,callback,args)},ready:function(fn){jQuery.bindReady();readyList.add(fn);return this},eq:function(i){i=+i;return i===-1?this.slice(i):this.slice(i,i+1)},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},slice:function(){return this.pushStack(slice.apply(this,arguments),"slice",slice.call(arguments).join(","))},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem)}))},end:function(){return this.prevObject||this.constructor(null)},push:push,sort:[].sort,splice:[].splice};jQuery.fn.init.prototype=jQuery.fn;jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=false;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2}if(typeof target!=="object"&&!jQuery.isFunction(target)){target={}}if(length===i){target=this;--i}for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){src=target[name];copy=options[name];if(target===copy){continue}if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=jQuery.isArray(copy)))){if(copyIsArray){copyIsArray=false;clone=src&&jQuery.isArray(src)?src:[]}else{clone=src&&jQuery.isPlainObject(src)?src:{}}target[name]=jQuery.extend(deep,clone,copy)}else{if(copy!==undefined){target[name]=copy}}}}}return target};jQuery.extend({noConflict:function(deep){if(window.$===jQuery){window.$=_$}if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery}return jQuery},isReady:false,readyWait:1,holdReady:function(hold){if(hold){jQuery.readyWait++}else{jQuery.ready(true)}},ready:function(wait){if((wait===true&&!--jQuery.readyWait)||(wait!==true&&!jQuery.isReady)){if(!document.body){return setTimeout(jQuery.ready,1)}jQuery.isReady=true;if(wait!==true&&--jQuery.readyWait>0){return }readyList.fireWith(document,[jQuery]);if(jQuery.fn.trigger){jQuery(document).trigger("ready").off("ready")}}},bindReady:function(){if(readyList){return }readyList=jQuery.Callbacks("once memory");if(document.readyState==="complete"){return setTimeout(jQuery.ready,1)}if(document.addEventListener){document.addEventListener("DOMContentLoaded",DOMContentLoaded,false);window.addEventListener("load",jQuery.ready,false)}else{if(document.attachEvent){document.attachEvent("onreadystatechange",DOMContentLoaded);window.attachEvent("onload",jQuery.ready);var toplevel=false;try{toplevel=window.frameElement==null}catch(e){}if(document.documentElement.doScroll&&toplevel){doScrollCheck()}}}},isFunction:function(obj){return jQuery.type(obj)==="function"},isArray:Array.isArray||function(obj){return jQuery.type(obj)==="array"},isWindow:function(obj){return obj!=null&&obj==obj.window},isNumeric:function(obj){return !isNaN(parseFloat(obj))&&isFinite(obj)},type:function(obj){return obj==null?String(obj):class2type[toString.call(obj)]||"object"},isPlainObject:function(obj){if(!obj||jQuery.type(obj)!=="object"||obj.nodeType||jQuery.isWindow(obj)){return false}try{if(obj.constructor&&!hasOwn.call(obj,"constructor")&&!hasOwn.call(obj.constructor.prototype,"isPrototypeOf")){return false}}catch(e){return false}var key;for(key in obj){}return key===undefined||hasOwn.call(obj,key)},isEmptyObject:function(obj){for(var name in obj){return false}return true},error:function(msg){throw new Error(msg)},parseJSON:function(data){if(typeof data!=="string"||!data){return null}data=jQuery.trim(data);if(window.JSON&&window.JSON.parse){return window.JSON.parse(data)}if(rvalidchars.test(data.replace(rvalidescape,"@").replace(rvalidtokens,"]").replace(rvalidbraces,""))){return(new Function("return "+data))()}jQuery.error("Invalid JSON: "+data)},parseXML:function(data){if(typeof data!=="string"||!data){return null}var xml,tmp;try{if(window.DOMParser){tmp=new DOMParser();xml=tmp.parseFromString(data,"text/xml")}else{xml=new ActiveXObject("Microsoft.XMLDOM");xml.async="false";xml.loadXML(data)}}catch(e){xml=undefined}if(!xml||!xml.documentElement||xml.getElementsByTagName("parsererror").length){jQuery.error("Invalid XML: "+data)}return xml},noop:function(){},globalEval:function(data){if(data&&rnotwhite.test(data)){(window.execScript||function(data){window.eval.call(window,data)})(data)}},camelCase:function(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase)},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()===name.toUpperCase()},each:function(object,callback,args){var name,i=0,length=object.length,isObj=length===undefined||jQuery.isFunction(object);if(args){if(isObj){for(name in object){if(callback.apply(object[name],args)===false){break}}}else{for(;i<length;){if(callback.apply(object[i++],args)===false){break}}}}else{if(isObj){for(name in object){if(callback.call(object[name],name,object[name])===false){break}}}else{for(;i<length;){if(callback.call(object[i],i,object[i++])===false){break}}}}return object},trim:trim?function(text){return text==null?"":trim.call(text)}:function(text){return text==null?"":text.toString().replace(trimLeft,"").replace(trimRight,"")},makeArray:function(array,results){var ret=results||[];if(array!=null){var type=jQuery.type(array);if(array.length==null||type==="string"||type==="function"||type==="regexp"||jQuery.isWindow(array)){push.call(ret,array)}else{jQuery.merge(ret,array)}}return ret},inArray:function(elem,array,i){var len;if(array){if(indexOf){return indexOf.call(array,elem,i)}len=array.length;i=i?i<0?Math.max(0,len+i):i:0;for(;i<len;i++){if(i in array&&array[i]===elem){return i}}}return -1},merge:function(first,second){var i=first.length,j=0;if(typeof second.length==="number"){for(var l=second.length;j<l;j++){first[i++]=second[j]}}else{while(second[j]!==undefined){first[i++]=second[j++]}}first.length=i;return first},grep:function(elems,callback,inv){var ret=[],retVal;inv=!!inv;for(var i=0,length=elems.length;i<length;i++){retVal=!!callback(elems[i],i);if(inv!==retVal){ret.push(elems[i])}}return ret},map:function(elems,callback,arg){var value,key,ret=[],i=0,length=elems.length,isArray=elems instanceof jQuery||length!==undefined&&typeof length==="number"&&((length>0&&elems[0]&&elems[length-1])||length===0||jQuery.isArray(elems));if(isArray){for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret[ret.length]=value}}}else{for(key in elems){value=callback(elems[key],key,arg);if(value!=null){ret[ret.length]=value}}}return ret.concat.apply([],ret)},guid:1,proxy:function(fn,context){if(typeof context==="string"){var tmp=fn[context];context=fn;fn=tmp}if(!jQuery.isFunction(fn)){return undefined}var args=slice.call(arguments,2),proxy=function(){return fn.apply(context,args.concat(slice.call(arguments)))};proxy.guid=fn.guid=fn.guid||proxy.guid||jQuery.guid++;return proxy},access:function(elems,fn,key,value,chainable,emptyGet,pass){var exec,bulk=key==null,i=0,length=elems.length;if(key&&typeof key==="object"){for(i in key){jQuery.access(elems,fn,i,key[i],1,emptyGet,value)}chainable=1}else{if(value!==undefined){exec=pass===undefined&&jQuery.isFunction(value);if(bulk){if(exec){exec=fn;fn=function(elem,key,value){return exec.call(jQuery(elem),value)}}else{fn.call(elems,value);fn=null}}if(fn){for(;i<length;i++){fn(elems[i],key,exec?value.call(elems[i],i,fn(elems[i],key)):value,pass)}}chainable=1}}return chainable?elems:bulk?fn.call(elems):length?fn(elems[0],key):emptyGet},now:function(){return(new Date()).getTime()},uaMatch:function(ua){ua=ua.toLowerCase();var match=rwebkit.exec(ua)||ropera.exec(ua)||rmsie.exec(ua)||ua.indexOf("compatible")<0&&rmozilla.exec(ua)||[];return{browser:match[1]||"",version:match[2]||"0"}},sub:function(){function jQuerySub(selector,context){return new jQuerySub.fn.init(selector,context)}jQuery.extend(true,jQuerySub,this);jQuerySub.superclass=this;jQuerySub.fn=jQuerySub.prototype=this();jQuerySub.fn.constructor=jQuerySub;jQuerySub.sub=this.sub;jQuerySub.fn.init=function init(selector,context){if(context&&context instanceof jQuery&&!(context instanceof jQuerySub)){context=jQuerySub(context)}return jQuery.fn.init.call(this,selector,context,rootjQuerySub)};jQuerySub.fn.init.prototype=jQuerySub.fn;var rootjQuerySub=jQuerySub(document);return jQuerySub},browser:{}});jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "),function(i,name){class2type["[object "+name+"]"]=name.toLowerCase()});browserMatch=jQuery.uaMatch(userAgent);if(browserMatch.browser){jQuery.browser[browserMatch.browser]=true;jQuery.browser.version=browserMatch.version}if(jQuery.browser.webkit){jQuery.browser.safari=true}if(rnotwhite.test("\xA0")){trimLeft=/^[\s\xA0]+/;trimRight=/[\s\xA0]+$/}rootjQuery=jQuery(document);if(document.addEventListener){DOMContentLoaded=function(){document.removeEventListener("DOMContentLoaded",DOMContentLoaded,false);jQuery.ready()}}else{if(document.attachEvent){DOMContentLoaded=function(){if(document.readyState==="complete"){document.detachEvent("onreadystatechange",DOMContentLoaded);jQuery.ready()}}}}function doScrollCheck(){if(jQuery.isReady){return }try{document.documentElement.doScroll("left")}catch(e){setTimeout(doScrollCheck,1);return }jQuery.ready()}return jQuery})();var flagsCache={};function createFlags(flags){var object=flagsCache[flags]={},i,length;flags=flags.split(/\s+/);for(i=0,length=flags.length;i<length;i++){object[flags[i]]=true}return object}jQuery.Callbacks=function(flags){flags=flags?(flagsCache[flags]||createFlags(flags)):{};var list=[],stack=[],memory,fired,firing,firingStart,firingLength,firingIndex,add=function(args){var i,length,elem,type,actual;for(i=0,length=args.length;i<length;i++){elem=args[i];type=jQuery.type(elem);if(type==="array"){add(elem)}else{if(type==="function"){if(!flags.unique||!self.has(elem)){list.push(elem)}}}}},fire=function(context,args){args=args||[];memory=!flags.memory||[context,args];fired=true;firing=true;firingIndex=firingStart||0;firingStart=0;firingLength=list.length;for(;list&&firingIndex<firingLength;firingIndex++){if(list[firingIndex].apply(context,args)===false&&flags.stopOnFalse){memory=true;break}}firing=false;if(list){if(!flags.once){if(stack&&stack.length){memory=stack.shift();self.fireWith(memory[0],memory[1])}}else{if(memory===true){self.disable()}else{list=[]}}}},self={add:function(){if(list){var length=list.length;add(arguments);if(firing){firingLength=list.length}else{if(memory&&memory!==true){firingStart=length;fire(memory[0],memory[1])}}}return this},remove:function(){if(list){var args=arguments,argIndex=0,argLength=args.length;for(;argIndex<argLength;argIndex++){for(var i=0;i<list.length;i++){if(args[argIndex]===list[i]){if(firing){if(i<=firingLength){firingLength--;if(i<=firingIndex){firingIndex--}}}list.splice(i--,1);if(flags.unique){break}}}}}return this},has:function(fn){if(list){var i=0,length=list.length;for(;i<length;i++){if(fn===list[i]){return true}}}return false},empty:function(){list=[];return this},disable:function(){list=stack=memory=undefined;return this},disabled:function(){return !list},lock:function(){stack=undefined;if(!memory||memory===true){self.disable()}return this},locked:function(){return !stack},fireWith:function(context,args){if(stack){if(firing){if(!flags.once){stack.push([context,args])}}else{if(!(flags.once&&memory)){fire(context,args)}}}return this},fire:function(){self.fireWith(this,arguments);return this},fired:function(){return !!fired}};return self};var sliceDeferred=[].slice;jQuery.extend({Deferred:function(func){var doneList=jQuery.Callbacks("once memory"),failList=jQuery.Callbacks("once memory"),progressList=jQuery.Callbacks("memory"),state="pending",lists={resolve:doneList,reject:failList,notify:progressList},promise={done:doneList.add,fail:failList.add,progress:progressList.add,state:function(){return state},isResolved:doneList.fired,isRejected:failList.fired,then:function(doneCallbacks,failCallbacks,progressCallbacks){deferred.done(doneCallbacks).fail(failCallbacks).progress(progressCallbacks);return this},always:function(){deferred.done.apply(deferred,arguments).fail.apply(deferred,arguments);return this},pipe:function(fnDone,fnFail,fnProgress){return jQuery.Deferred(function(newDefer){jQuery.each({done:[fnDone,"resolve"],fail:[fnFail,"reject"],progress:[fnProgress,"notify"]},function(handler,data){var fn=data[0],action=data[1],returned;if(jQuery.isFunction(fn)){deferred[handler](function(){returned=fn.apply(this,arguments);if(returned&&jQuery.isFunction(returned.promise)){returned.promise().then(newDefer.resolve,newDefer.reject,newDefer.notify)}else{newDefer[action+"With"](this===deferred?newDefer:this,[returned])}})}else{deferred[handler](newDefer[action])}})}).promise()},promise:function(obj){if(obj==null){obj=promise}else{for(var key in promise){obj[key]=promise[key]}}return obj}},deferred=promise.promise({}),key;for(key in lists){deferred[key]=lists[key].fire;deferred[key+"With"]=lists[key].fireWith}deferred.done(function(){state="resolved"},failList.disable,progressList.lock).fail(function(){state="rejected"},doneList.disable,progressList.lock);if(func){func.call(deferred,deferred)}return deferred},when:function(firstParam){var args=sliceDeferred.call(arguments,0),i=0,length=args.length,pValues=new Array(length),count=length,pCount=length,deferred=length<=1&&firstParam&&jQuery.isFunction(firstParam.promise)?firstParam:jQuery.Deferred(),promise=deferred.promise();function resolveFunc(i){return function(value){args[i]=arguments.length>1?sliceDeferred.call(arguments,0):value;if(!(--count)){deferred.resolveWith(deferred,args)}}}function progressFunc(i){return function(value){pValues[i]=arguments.length>1?sliceDeferred.call(arguments,0):value;deferred.notifyWith(promise,pValues)}}if(length>1){for(;i<length;i++){if(args[i]&&args[i].promise&&jQuery.isFunction(args[i].promise)){args[i].promise().then(resolveFunc(i),deferred.reject,progressFunc(i))}else{--count}}if(!count){deferred.resolveWith(deferred,args)}}else{if(deferred!==firstParam){deferred.resolveWith(deferred,length?[firstParam]:[])}}return promise}});jQuery.support=(function(){var support,all,a,select,opt,input,fragment,tds,events,eventName,i,isSupported,div=document.createElement("div"),documentElement=document.documentElement;div.setAttribute("className","t");div.innerHTML="   <link/><table></table><a href='/a' style='top:1px;float:left;opacity:.55;'>a</a><input type='checkbox'/>";all=div.getElementsByTagName("*");a=div.getElementsByTagName("a")[0];if(!all||!all.length||!a){return{}}select=document.createElement("select");opt=select.appendChild(document.createElement("option"));input=div.getElementsByTagName("input")[0];support={leadingWhitespace:(div.firstChild.nodeType===3),tbody:!div.getElementsByTagName("tbody").length,htmlSerialize:!!div.getElementsByTagName("link").length,style:/top/.test(a.getAttribute("style")),hrefNormalized:(a.getAttribute("href")==="/a"),opacity:/^0.55/.test(a.style.opacity),cssFloat:!!a.style.cssFloat,checkOn:(input.value==="on"),optSelected:opt.selected,getSetAttribute:div.className!=="t",enctype:!!document.createElement("form").enctype,html5Clone:document.createElement("nav").cloneNode(true).outerHTML!=="<:nav></:nav>",submitBubbles:true,changeBubbles:true,focusinBubbles:false,deleteExpando:true,noCloneEvent:true,inlineBlockNeedsLayout:false,shrinkWrapBlocks:false,reliableMarginRight:true,pixelMargin:true};jQuery.boxModel=support.boxModel=(document.compatMode==="CSS1Compat");input.checked=true;support.noCloneChecked=input.cloneNode(true).checked;select.disabled=true;support.optDisabled=!opt.disabled;try{delete div.test}catch(e){support.deleteExpando=false}if(!div.addEventListener&&div.attachEvent&&div.fireEvent){div.attachEvent("onclick",function(){support.noCloneEvent=false});div.cloneNode(true).fireEvent("onclick")}input=document.createElement("input");input.value="t";input.setAttribute("type","radio");support.radioValue=input.value==="t";input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);fragment=document.createDocumentFragment();fragment.appendChild(div.lastChild);support.checkClone=fragment.cloneNode(true).cloneNode(true).lastChild.checked;support.appendChecked=input.checked;fragment.removeChild(input);fragment.appendChild(div);if(div.attachEvent){for(i in {submit:1,change:1,focusin:1}){eventName="on"+i;isSupported=(eventName in div);if(!isSupported){div.setAttribute(eventName,"return;");isSupported=(typeof div[eventName]==="function")}support[i+"Bubbles"]=isSupported}}fragment.removeChild(div);fragment=select=opt=div=input=null;jQuery(function(){var container,outer,inner,table,td,offsetSupport,marginDiv,conMarginTop,style,html,positionTopLeftWidthHeight,paddingMarginBorderVisibility,paddingMarginBorder,body=document.getElementsByTagName("body")[0];if(!body){return }conMarginTop=1;paddingMarginBorder="padding:0;margin:0;border:";positionTopLeftWidthHeight="position:absolute;top:0;left:0;width:1px;height:1px;";paddingMarginBorderVisibility=paddingMarginBorder+"0;visibility:hidden;";style="style='"+positionTopLeftWidthHeight+paddingMarginBorder+"5px solid #000;";html="<div "+style+"display:block;'><div style='"+paddingMarginBorder+"0;display:block;overflow:hidden;'></div></div><table "+style+"' cellpadding='0' cellspacing='0'><tr><td></td></tr></table>";container=document.createElement("div");container.style.cssText=paddingMarginBorderVisibility+"width:0;height:0;position:static;top:0;margin-top:"+conMarginTop+"px";body.insertBefore(container,body.firstChild);div=document.createElement("div");container.appendChild(div);div.innerHTML="<table><tr><td style='"+paddingMarginBorder+"0;display:none'></td><td>t</td></tr></table>";tds=div.getElementsByTagName("td");isSupported=(tds[0].offsetHeight===0);tds[0].style.display="";tds[1].style.display="none";support.reliableHiddenOffsets=isSupported&&(tds[0].offsetHeight===0);if(window.getComputedStyle){div.innerHTML="";marginDiv=document.createElement("div");marginDiv.style.width="0";marginDiv.style.marginRight="0";div.style.width="2px";div.appendChild(marginDiv);support.reliableMarginRight=(parseInt((window.getComputedStyle(marginDiv,null)||{marginRight:0}).marginRight,10)||0)===0}if(typeof div.style.zoom!=="undefined"){div.innerHTML="";div.style.width=div.style.padding="1px";div.style.border=0;div.style.overflow="hidden";div.style.display="inline";div.style.zoom=1;support.inlineBlockNeedsLayout=(div.offsetWidth===3);div.style.display="block";div.style.overflow="visible";div.innerHTML="<div style='width:5px;'></div>";support.shrinkWrapBlocks=(div.offsetWidth!==3)}div.style.cssText=positionTopLeftWidthHeight+paddingMarginBorderVisibility;div.innerHTML=html;outer=div.firstChild;inner=outer.firstChild;td=outer.nextSibling.firstChild.firstChild;offsetSupport={doesNotAddBorder:(inner.offsetTop!==5),doesAddBorderForTableAndCells:(td.offsetTop===5)};inner.style.position="fixed";inner.style.top="20px";offsetSupport.fixedPosition=(inner.offsetTop===20||inner.offsetTop===15);inner.style.position=inner.style.top="";outer.style.overflow="hidden";outer.style.position="relative";offsetSupport.subtractsBorderForOverflowNotVisible=(inner.offsetTop===-5);offsetSupport.doesNotIncludeMarginInBodyOffset=(body.offsetTop!==conMarginTop);if(window.getComputedStyle){div.style.marginTop="1%";support.pixelMargin=(window.getComputedStyle(div,null)||{marginTop:0}).marginTop!=="1%"}if(typeof container.style.zoom!=="undefined"){container.style.zoom=1}body.removeChild(container);marginDiv=div=container=null;jQuery.extend(support,offsetSupport)});return support})();var rbrace=/^(?:\{.*\}|\[.*\])$/,rmultiDash=/([A-Z])/g;jQuery.extend({cache:{},uuid:0,expando:"jQuery"+(jQuery.fn.jquery+Math.random()).replace(/\D/g,""),noData:{embed:true,object:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",applet:true},hasData:function(elem){elem=elem.nodeType?jQuery.cache[elem[jQuery.expando]]:elem[jQuery.expando];return !!elem&&!isEmptyDataObject(elem)},data:function(elem,name,data,pvt){if(!jQuery.acceptData(elem)){return }var privateCache,thisCache,ret,internalKey=jQuery.expando,getByName=typeof name==="string",isNode=elem.nodeType,cache=isNode?jQuery.cache:elem,id=isNode?elem[internalKey]:elem[internalKey]&&internalKey,isEvents=name==="events";if((!id||!cache[id]||(!isEvents&&!pvt&&!cache[id].data))&&getByName&&data===undefined){return }if(!id){if(isNode){elem[internalKey]=id=++jQuery.uuid}else{id=internalKey}}if(!cache[id]){cache[id]={};if(!isNode){cache[id].toJSON=jQuery.noop}}if(typeof name==="object"||typeof name==="function"){if(pvt){cache[id]=jQuery.extend(cache[id],name)}else{cache[id].data=jQuery.extend(cache[id].data,name)}}privateCache=thisCache=cache[id];if(!pvt){if(!thisCache.data){thisCache.data={}}thisCache=thisCache.data}if(data!==undefined){thisCache[jQuery.camelCase(name)]=data}if(isEvents&&!thisCache[name]){return privateCache.events}if(getByName){ret=thisCache[name];if(ret==null){ret=thisCache[jQuery.camelCase(name)]}}else{ret=thisCache}return ret},removeData:function(elem,name,pvt){if(!jQuery.acceptData(elem)){return }var thisCache,i,l,internalKey=jQuery.expando,isNode=elem.nodeType,cache=isNode?jQuery.cache:elem,id=isNode?elem[internalKey]:internalKey;if(!cache[id]){return }if(name){thisCache=pvt?cache[id]:cache[id].data;if(thisCache){if(!jQuery.isArray(name)){if(name in thisCache){name=[name]}else{name=jQuery.camelCase(name);if(name in thisCache){name=[name]}else{name=name.split(" ")}}}for(i=0,l=name.length;i<l;i++){delete thisCache[name[i]]}if(!(pvt?isEmptyDataObject:jQuery.isEmptyObject)(thisCache)){return }}}if(!pvt){delete cache[id].data;if(!isEmptyDataObject(cache[id])){return }}if(jQuery.support.deleteExpando||!cache.setInterval){delete cache[id]}else{cache[id]=null}if(isNode){if(jQuery.support.deleteExpando){delete elem[internalKey]}else{if(elem.removeAttribute){elem.removeAttribute(internalKey)}else{elem[internalKey]=null}}}},_data:function(elem,name,data){return jQuery.data(elem,name,data,true)},acceptData:function(elem){if(elem.nodeName){var match=jQuery.noData[elem.nodeName.toLowerCase()];if(match){return !(match===true||elem.getAttribute("classid")!==match)}}return true}});jQuery.fn.extend({data:function(key,value){var parts,part,attr,name,l,elem=this[0],i=0,data=null;if(key===undefined){if(this.length){data=jQuery.data(elem);if(elem.nodeType===1&&!jQuery._data(elem,"parsedAttrs")){attr=elem.attributes;for(l=attr.length;i<l;i++){name=attr[i].name;if(name.indexOf("data-")===0){name=jQuery.camelCase(name.substring(5));dataAttr(elem,name,data[name])}}jQuery._data(elem,"parsedAttrs",true)}}return data}if(typeof key==="object"){return this.each(function(){jQuery.data(this,key)})}parts=key.split(".",2);parts[1]=parts[1]?"."+parts[1]:"";part=parts[1]+"!";return jQuery.access(this,function(value){if(value===undefined){data=this.triggerHandler("getData"+part,[parts[0]]);if(data===undefined&&elem){data=jQuery.data(elem,key);data=dataAttr(elem,key,data)}return data===undefined&&parts[1]?this.data(parts[0]):data}parts[1]=value;this.each(function(){var self=jQuery(this);self.triggerHandler("setData"+part,parts);jQuery.data(this,key,value);self.triggerHandler("changeData"+part,parts)})},null,value,arguments.length>1,null,false)},removeData:function(key){return this.each(function(){jQuery.removeData(this,key)})}});function dataAttr(elem,key,data){if(data===undefined&&elem.nodeType===1){var name="data-"+key.replace(rmultiDash,"-$1").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=data==="true"?true:data==="false"?false:data==="null"?null:jQuery.isNumeric(data)?+data:rbrace.test(data)?jQuery.parseJSON(data):data}catch(e){}jQuery.data(elem,key,data)}else{data=undefined}}return data}function isEmptyDataObject(obj){for(var name in obj){if(name==="data"&&jQuery.isEmptyObject(obj[name])){continue}if(name!=="toJSON"){return false}}return true}function handleQueueMarkDefer(elem,type,src){var deferDataKey=type+"defer",queueDataKey=type+"queue",markDataKey=type+"mark",defer=jQuery._data(elem,deferDataKey);if(defer&&(src==="queue"||!jQuery._data(elem,queueDataKey))&&(src==="mark"||!jQuery._data(elem,markDataKey))){setTimeout(function(){if(!jQuery._data(elem,queueDataKey)&&!jQuery._data(elem,markDataKey)){jQuery.removeData(elem,deferDataKey,true);defer.fire()}},0)}}jQuery.extend({_mark:function(elem,type){if(elem){type=(type||"fx")+"mark";jQuery._data(elem,type,(jQuery._data(elem,type)||0)+1)}},_unmark:function(force,elem,type){if(force!==true){type=elem;elem=force;force=false}if(elem){type=type||"fx";var key=type+"mark",count=force?0:((jQuery._data(elem,key)||1)-1);if(count){jQuery._data(elem,key,count)}else{jQuery.removeData(elem,key,true);handleQueueMarkDefer(elem,type,"mark")}}},queue:function(elem,type,data){var q;if(elem){type=(type||"fx")+"queue";q=jQuery._data(elem,type);if(data){if(!q||jQuery.isArray(data)){q=jQuery._data(elem,type,jQuery.makeArray(data))}else{q.push(data)}}return q||[]}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),fn=queue.shift(),hooks={};if(fn==="inprogress"){fn=queue.shift()}if(fn){if(type==="fx"){queue.unshift("inprogress")}jQuery._data(elem,type+".run",hooks);fn.call(elem,function(){jQuery.dequeue(elem,type)},hooks)}if(!queue.length){jQuery.removeData(elem,type+"queue "+type+".run",true);handleQueueMarkDefer(elem,type,"queue")}}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--}if(arguments.length<setter){return jQuery.queue(this[0],type)}return data===undefined?this:this.each(function(){var queue=jQuery.queue(this,type,data);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type)}})},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type)})},delay:function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(next,hooks){var timeout=setTimeout(next,time);hooks.stop=function(){clearTimeout(timeout)}})},clearQueue:function(type){return this.queue(type||"fx",[])},promise:function(type,object){if(typeof type!=="string"){object=type;type=undefined}type=type||"fx";var defer=jQuery.Deferred(),elements=this,i=elements.length,count=1,deferDataKey=type+"defer",queueDataKey=type+"queue",markDataKey=type+"mark",tmp;function resolve(){if(!(--count)){defer.resolveWith(elements,[elements])}}while(i--){if((tmp=jQuery.data(elements[i],deferDataKey,undefined,true)||(jQuery.data(elements[i],queueDataKey,undefined,true)||jQuery.data(elements[i],markDataKey,undefined,true))&&jQuery.data(elements[i],deferDataKey,jQuery.Callbacks("once memory"),true))){count++;tmp.add(resolve)}}resolve();return defer.promise(object)}});var rclass=/[\n\t\r]/g,rspace=/\s+/,rreturn=/\r/g,rtype=/^(?:button|input)$/i,rfocusable=/^(?:button|input|object|select|textarea)$/i,rclickable=/^a(?:rea)?$/i,rboolean=/^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,getSetAttribute=jQuery.support.getSetAttribute,nodeHook,boolHook,fixSpecified;jQuery.fn.extend({attr:function(name,value){return jQuery.access(this,jQuery.attr,name,value,arguments.length>1)},removeAttr:function(name){return this.each(function(){jQuery.removeAttr(this,name)})},prop:function(name,value){return jQuery.access(this,jQuery.prop,name,value,arguments.length>1)},removeProp:function(name){name=jQuery.propFix[name]||name;return this.each(function(){try{this[name]=undefined;delete this[name]}catch(e){}})},addClass:function(value){var classNames,i,l,elem,setClass,c,cl;if(jQuery.isFunction(value)){return this.each(function(j){jQuery(this).addClass(value.call(this,j,this.className))})}if(value&&typeof value==="string"){classNames=value.split(rspace);for(i=0,l=this.length;i<l;i++){elem=this[i];if(elem.nodeType===1){if(!elem.className&&classNames.length===1){elem.className=value}else{setClass=" "+elem.className+" ";for(c=0,cl=classNames.length;c<cl;c++){if(!~setClass.indexOf(" "+classNames[c]+" ")){setClass+=classNames[c]+" "}}elem.className=jQuery.trim(setClass)}}}}return this},removeClass:function(value){var classNames,i,l,elem,className,c,cl;if(jQuery.isFunction(value)){return this.each(function(j){jQuery(this).removeClass(value.call(this,j,this.className))})}if((value&&typeof value==="string")||value===undefined){classNames=(value||"").split(rspace);for(i=0,l=this.length;i<l;i++){elem=this[i];if(elem.nodeType===1&&elem.className){if(value){className=(" "+elem.className+" ").replace(rclass," ");for(c=0,cl=classNames.length;c<cl;c++){className=className.replace(" "+classNames[c]+" "," ")}elem.className=jQuery.trim(className)}else{elem.className=""}}}}return this},toggleClass:function(value,stateVal){var type=typeof value,isBool=typeof stateVal==="boolean";if(jQuery.isFunction(value)){return this.each(function(i){jQuery(this).toggleClass(value.call(this,i,this.className,stateVal),stateVal)})}return this.each(function(){if(type==="string"){var className,i=0,self=jQuery(this),state=stateVal,classNames=value.split(rspace);while((className=classNames[i++])){state=isBool?state:!self.hasClass(className);self[state?"addClass":"removeClass"](className)}}else{if(type==="undefined"||type==="boolean"){if(this.className){jQuery._data(this,"__className__",this.className)}this.className=this.className||value===false?"":jQuery._data(this,"__className__")||""}}})},hasClass:function(selector){var className=" "+selector+" ",i=0,l=this.length;for(;i<l;i++){if(this[i].nodeType===1&&(" "+this[i].className+" ").replace(rclass," ").indexOf(className)>-1){return true}}return false},val:function(value){var hooks,ret,isFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get" in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret}ret=elem.value;return typeof ret==="string"?ret.replace(rreturn,""):ret==null?"":ret}return }isFunction=jQuery.isFunction(value);return this.each(function(i){var self=jQuery(this),val;if(this.nodeType!==1){return }if(isFunction){val=value.call(this,i,self.val())}else{val=value}if(val==null){val=""}else{if(typeof val==="number"){val+=""}else{if(jQuery.isArray(val)){val=jQuery.map(val,function(value){return value==null?"":value+""})}}}hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set" in hooks)||hooks.set(this,val,"value")===undefined){this.value=val}})}});jQuery.extend({valHooks:{option:{get:function(elem){var val=elem.attributes.value;return !val||val.specified?elem.value:elem.text}},select:{get:function(elem){var value,i,max,option,index=elem.selectedIndex,values=[],options=elem.options,one=elem.type==="select-one";if(index<0){return null}i=one?index:0;max=one?index+1:options.length;for(;i<max;i++){option=options[i];if(option.selected&&(jQuery.support.optDisabled?!option.disabled:option.getAttribute("disabled")===null)&&(!option.parentNode.disabled||!jQuery.nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value}values.push(value)}}if(one&&!values.length&&options.length){return jQuery(options[index]).val()}return values},set:function(elem,value){var values=jQuery.makeArray(value);jQuery(elem).find("option").each(function(){this.selected=jQuery.inArray(jQuery(this).val(),values)>=0});if(!values.length){elem.selectedIndex=-1}return values}}},attrFn:{val:true,css:true,html:true,text:true,data:true,width:true,height:true,offset:true},attr:function(elem,name,value,pass){var ret,hooks,notxml,nType=elem.nodeType;if(!elem||nType===3||nType===8||nType===2){return }if(pass&&name in jQuery.attrFn){return jQuery(elem)[name](value)}if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value)}notxml=nType!==1||!jQuery.isXMLDoc(elem);if(notxml){name=name.toLowerCase();hooks=jQuery.attrHooks[name]||(rboolean.test(name)?boolHook:nodeHook)}if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return }else{if(hooks&&"set" in hooks&&notxml&&(ret=hooks.set(elem,value,name))!==undefined){return ret}else{elem.setAttribute(name,""+value);return value}}}else{if(hooks&&"get" in hooks&&notxml&&(ret=hooks.get(elem,name))!==null){return ret}else{ret=elem.getAttribute(name);return ret===null?undefined:ret}}},removeAttr:function(elem,value){var propName,attrNames,name,l,isBool,i=0;if(value&&elem.nodeType===1){attrNames=value.toLowerCase().split(rspace);l=attrNames.length;for(;i<l;i++){name=attrNames[i];if(name){propName=jQuery.propFix[name]||name;isBool=rboolean.test(name);if(!isBool){jQuery.attr(elem,name,"")}elem.removeAttribute(getSetAttribute?name:propName);if(isBool&&propName in elem){elem[propName]=false}}}}},attrHooks:{type:{set:function(elem,value){if(rtype.test(elem.nodeName)&&elem.parentNode){jQuery.error("type property can't be changed")}else{if(!jQuery.support.radioValue&&value==="radio"&&jQuery.nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val}return value}}}},value:{get:function(elem,name){if(nodeHook&&jQuery.nodeName(elem,"button")){return nodeHook.get(elem,name)}return name in elem?elem.value:null},set:function(elem,value,name){if(nodeHook&&jQuery.nodeName(elem,"button")){return nodeHook.set(elem,value,name)}elem.value=value}}},propFix:{tabindex:"tabIndex",readonly:"readOnly","for":"htmlFor","class":"className",maxlength:"maxLength",cellspacing:"cellSpacing",cellpadding:"cellPadding",rowspan:"rowSpan",colspan:"colSpan",usemap:"useMap",frameborder:"frameBorder",contenteditable:"contentEditable"},prop:function(elem,name,value){var ret,hooks,notxml,nType=elem.nodeType;if(!elem||nType===3||nType===8||nType===2){return }notxml=nType!==1||!jQuery.isXMLDoc(elem);if(notxml){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name]}if(value!==undefined){if(hooks&&"set" in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}else{return(elem[name]=value)}}else{if(hooks&&"get" in hooks&&(ret=hooks.get(elem,name))!==null){return ret}else{return elem[name]}}},propHooks:{tabIndex:{get:function(elem){var attributeNode=elem.getAttributeNode("tabindex");return attributeNode&&attributeNode.specified?parseInt(attributeNode.value,10):rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href?0:undefined}}}});jQuery.attrHooks.tabindex=jQuery.propHooks.tabIndex;boolHook={get:function(elem,name){var attrNode,property=jQuery.prop(elem,name);return property===true||typeof property!=="boolean"&&(attrNode=elem.getAttributeNode(name))&&attrNode.nodeValue!==false?name.toLowerCase():undefined},set:function(elem,value,name){var propName;if(value===false){jQuery.removeAttr(elem,name)}else{propName=jQuery.propFix[name]||name;if(propName in elem){elem[propName]=true}elem.setAttribute(name,name.toLowerCase())}return name}};if(!getSetAttribute){fixSpecified={name:true,id:true,coords:true};nodeHook=jQuery.valHooks.button={get:function(elem,name){var ret;ret=elem.getAttributeNode(name);return ret&&(fixSpecified[name]?ret.nodeValue!=="":ret.specified)?ret.nodeValue:undefined},set:function(elem,value,name){var ret=elem.getAttributeNode(name);if(!ret){ret=document.createAttribute(name);elem.setAttributeNode(ret)}return(ret.nodeValue=value+"")}};jQuery.attrHooks.tabindex.set=nodeHook.set;jQuery.each(["width","height"],function(i,name){jQuery.attrHooks[name]=jQuery.extend(jQuery.attrHooks[name],{set:function(elem,value){if(value===""){elem.setAttribute(name,"auto");return value}}})});jQuery.attrHooks.contenteditable={get:nodeHook.get,set:function(elem,value,name){if(value===""){value="false"}nodeHook.set(elem,value,name)}}}if(!jQuery.support.hrefNormalized){jQuery.each(["href","src","width","height"],function(i,name){jQuery.attrHooks[name]=jQuery.extend(jQuery.attrHooks[name],{get:function(elem){var ret=elem.getAttribute(name,2);return ret===null?undefined:ret}})})}if(!jQuery.support.style){jQuery.attrHooks.style={get:function(elem){return elem.style.cssText.toLowerCase()||undefined},set:function(elem,value){return(elem.style.cssText=""+value)}}}if(!jQuery.support.optSelected){jQuery.propHooks.selected=jQuery.extend(jQuery.propHooks.selected,{get:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex}}return null}})}if(!jQuery.support.enctype){jQuery.propFix.enctype="encoding"}if(!jQuery.support.checkOn){jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={get:function(elem){return elem.getAttribute("value")===null?"on":elem.value}}})}jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]=jQuery.extend(jQuery.valHooks[this],{set:function(elem,value){if(jQuery.isArray(value)){return(elem.checked=jQuery.inArray(jQuery(elem).val(),value)>=0)}}})});var rformElems=/^(?:textarea|input|select)$/i,rtypenamespace=/^([^\.]*)?(?:\.(.+))?$/,rhoverHack=/(?:^|\s)hover(\.\S+)?\b/,rkeyEvent=/^key/,rmouseEvent=/^(?:mouse|contextmenu)|click/,rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,rquickIs=/^(\w*)(?:#([\w\-]+))?(?:\.([\w\-]+))?$/,quickParse=function(selector){var quick=rquickIs.exec(selector);if(quick){quick[1]=(quick[1]||"").toLowerCase();quick[3]=quick[3]&&new RegExp("(?:^|\\s)"+quick[3]+"(?:\\s|$)")}return quick},quickIs=function(elem,m){var attrs=elem.attributes||{};return((!m[1]||elem.nodeName.toLowerCase()===m[1])&&(!m[2]||(attrs.id||{}).value===m[2])&&(!m[3]||m[3].test((attrs["class"]||{}).value)))},hoverHack=function(events){return jQuery.event.special.hover?events:events.replace(rhoverHack,"mouseenter$1 mouseleave$1")};jQuery.event={add:function(elem,types,handler,data,selector){var elemData,eventHandle,events,t,tns,type,namespaces,handleObj,handleObjIn,quick,handlers,special;if(elem.nodeType===3||elem.nodeType===8||!types||!handler||!(elemData=jQuery._data(elem))){return }if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector}if(!handler.guid){handler.guid=jQuery.guid++}events=elemData.events;if(!events){elemData.events=events={}}eventHandle=elemData.handle;if(!eventHandle){elemData.handle=eventHandle=function(e){return typeof jQuery!=="undefined"&&(!e||jQuery.event.triggered!==e.type)?jQuery.event.dispatch.apply(eventHandle.elem,arguments):undefined};eventHandle.elem=elem}types=jQuery.trim(hoverHack(types)).split(" ");for(t=0;t<types.length;t++){tns=rtypenamespace.exec(types[t])||[];type=tns[1];namespaces=(tns[2]||"").split(".").sort();special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:tns[1],data:data,handler:handler,guid:handler.guid,selector:selector,quick:selector&&quickParse(selector),namespace:namespaces.join(".")},handleObjIn);handlers=events[type];if(!handlers){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===false){if(elem.addEventListener){elem.addEventListener(type,eventHandle,false)}else{if(elem.attachEvent){elem.attachEvent("on"+type,eventHandle)}}}}if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid}}if(selector){handlers.splice(handlers.delegateCount++,0,handleObj)}else{handlers.push(handleObj)}jQuery.event.global[type]=true}elem=null},global:{},remove:function(elem,types,handler,selector,mappedTypes){var elemData=jQuery.hasData(elem)&&jQuery._data(elem),t,tns,type,origType,namespaces,origCount,j,events,special,handle,eventType,handleObj;if(!elemData||!(events=elemData.events)){return }types=jQuery.trim(hoverHack(types||"")).split(" ");for(t=0;t<types.length;t++){tns=rtypenamespace.exec(types[t])||[];type=origType=tns[1];namespaces=tns[2];if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,true)}continue}special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;eventType=events[type]||[];origCount=eventType.length;namespaces=namespaces?new RegExp("(^|\\.)"+namespaces.split(".").sort().join("\\.(?:.*\\.)?")+"(\\.|$)"):null;for(j=0;j<eventType.length;j++){handleObj=eventType[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!namespaces||namespaces.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){eventType.splice(j--,1);if(handleObj.selector){eventType.delegateCount--}if(special.remove){special.remove.call(elem,handleObj)}}}if(eventType.length===0&&origCount!==eventType.length){if(!special.teardown||special.teardown.call(elem,namespaces)===false){jQuery.removeEvent(elem,type,elemData.handle)}delete events[type]}}if(jQuery.isEmptyObject(events)){handle=elemData.handle;if(handle){handle.elem=null}jQuery.removeData(elem,["events","handle"],true)}},customEvent:{getData:true,setData:true,changeData:true},trigger:function(event,data,elem,onlyHandlers){if(elem&&(elem.nodeType===3||elem.nodeType===8)){return }var type=event.type||event,namespaces=[],cache,exclusive,i,cur,old,ontype,special,handle,eventPath,bubbleType;if(rfocusMorph.test(type+jQuery.event.triggered)){return }if(type.indexOf("!")>=0){type=type.slice(0,-1);exclusive=true}if(type.indexOf(".")>=0){namespaces=type.split(".");type=namespaces.shift();namespaces.sort()}if((!elem||jQuery.event.customEvent[type])&&!jQuery.event.global[type]){return }event=typeof event==="object"?event[jQuery.expando]?event:new jQuery.Event(type,event):new jQuery.Event(type);event.type=type;event.isTrigger=true;event.exclusive=exclusive;event.namespace=namespaces.join(".");event.namespace_re=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.)?")+"(\\.|$)"):null;ontype=type.indexOf(":")<0?"on"+type:"";if(!elem){cache=jQuery.cache;for(i in cache){if(cache[i].events&&cache[i].events[type]){jQuery.event.trigger(event,data,cache[i].handle.elem,true)}}return }event.result=undefined;if(!event.target){event.target=elem}data=data!=null?jQuery.makeArray(data):[];data.unshift(event);special=jQuery.event.special[type]||{};if(special.trigger&&special.trigger.apply(elem,data)===false){return }eventPath=[[elem,special.bindType||type]];if(!onlyHandlers&&!special.noBubble&&!jQuery.isWindow(elem)){bubbleType=special.delegateType||type;cur=rfocusMorph.test(bubbleType+type)?elem:elem.parentNode;old=null;for(;cur;cur=cur.parentNode){eventPath.push([cur,bubbleType]);old=cur}if(old&&old===elem.ownerDocument){eventPath.push([old.defaultView||old.parentWindow||window,bubbleType])}}for(i=0;i<eventPath.length&&!event.isPropagationStopped();i++){cur=eventPath[i][0];event.type=eventPath[i][1];handle=(jQuery._data(cur,"events")||{})[event.type]&&jQuery._data(cur,"handle");if(handle){handle.apply(cur,data)}handle=ontype&&cur[ontype];if(handle&&jQuery.acceptData(cur)&&handle.apply(cur,data)===false){event.preventDefault()}}event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(elem.ownerDocument,data)===false)&&!(type==="click"&&jQuery.nodeName(elem,"a"))&&jQuery.acceptData(elem)){if(ontype&&elem[type]&&((type!=="focus"&&type!=="blur")||event.target.offsetWidth!==0)&&!jQuery.isWindow(elem)){old=elem[ontype];if(old){elem[ontype]=null}jQuery.event.triggered=type;elem[type]();jQuery.event.triggered=undefined;if(old){elem[ontype]=old}}}}return event.result},dispatch:function(event){event=jQuery.event.fix(event||window.event);var handlers=((jQuery._data(this,"events")||{})[event.type]||[]),delegateCount=handlers.delegateCount,args=[].slice.call(arguments,0),run_all=!event.exclusive&&!event.namespace,special=jQuery.event.special[event.type]||{},handlerQueue=[],i,j,cur,jqcur,ret,selMatch,matched,matches,handleObj,sel,related;args[0]=event;event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===false){return }if(delegateCount&&!(event.button&&event.type==="click")){jqcur=jQuery(this);jqcur.context=this.ownerDocument||this;for(cur=event.target;cur!=this;cur=cur.parentNode||this){if(cur.disabled!==true){selMatch={};matches=[];jqcur[0]=cur;for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector;if(selMatch[sel]===undefined){selMatch[sel]=(handleObj.quick?quickIs(cur,handleObj.quick):jqcur.is(sel))}if(selMatch[sel]){matches.push(handleObj)}}if(matches.length){handlerQueue.push({elem:cur,matches:matches})}}}}if(handlers.length>delegateCount){handlerQueue.push({elem:this,matches:handlers.slice(delegateCount)})}for(i=0;i<handlerQueue.length&&!event.isPropagationStopped();i++){matched=handlerQueue[i];event.currentTarget=matched.elem;for(j=0;j<matched.matches.length&&!event.isImmediatePropagationStopped();j++){handleObj=matched.matches[j];if(run_all||(!event.namespace&&!handleObj.namespace)||event.namespace_re&&event.namespace_re.test(handleObj.namespace)){event.data=handleObj.data;event.handleObj=handleObj;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){event.result=ret;if(ret===false){event.preventDefault();event.stopPropagation()}}}}}if(special.postDispatch){special.postDispatch.call(this,event)}return event.result},props:"attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(event,original){if(event.which==null){event.which=original.charCode!=null?original.charCode:original.keyCode}return event}},mouseHooks:{props:"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(event,original){var eventDoc,doc,body,button=original.button,fromElement=original.fromElement;if(event.pageX==null&&original.clientX!=null){eventDoc=event.target.ownerDocument||document;doc=eventDoc.documentElement;body=eventDoc.body;event.pageX=original.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0);event.pageY=original.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0)}if(!event.relatedTarget&&fromElement){event.relatedTarget=fromElement===event.target?original.toElement:fromElement}if(!event.which&&button!==undefined){event.which=(button&1?1:(button&2?3:(button&4?2:0)))}return event}},fix:function(event){if(event[jQuery.expando]){return event}var i,prop,originalEvent=event,fixHook=jQuery.event.fixHooks[event.type]||{},copy=fixHook.props?this.props.concat(fixHook.props):this.props;event=jQuery.Event(originalEvent);for(i=copy.length;i;){prop=copy[--i];event[prop]=originalEvent[prop]}if(!event.target){event.target=originalEvent.srcElement||document}if(event.target.nodeType===3){event.target=event.target.parentNode}if(event.metaKey===undefined){event.metaKey=event.ctrlKey}return fixHook.filter?fixHook.filter(event,originalEvent):event},special:{ready:{setup:jQuery.bindReady},load:{noBubble:true},focus:{delegateType:"focusin"},blur:{delegateType:"focusout"},beforeunload:{setup:function(data,namespaces,eventHandle){if(jQuery.isWindow(this)){this.onbeforeunload=eventHandle}},teardown:function(namespaces,eventHandle){if(this.onbeforeunload===eventHandle){this.onbeforeunload=null}}}},simulate:function(type,elem,event,bubble){var e=jQuery.extend(new jQuery.Event(),event,{type:type,isSimulated:true,originalEvent:{}});if(bubble){jQuery.event.trigger(e,null,elem)}else{jQuery.event.dispatch.call(elem,e)}if(e.isDefaultPrevented()){event.preventDefault()}}};jQuery.event.handle=jQuery.event.dispatch;jQuery.removeEvent=document.removeEventListener?function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle,false)}}:function(elem,type,handle){if(elem.detachEvent){elem.detachEvent("on"+type,handle)}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props)}if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=(src.defaultPrevented||src.returnValue===false||src.getPreventDefault&&src.getPreventDefault())?returnTrue:returnFalse}else{this.type=src}if(props){jQuery.extend(this,props)}this.timeStamp=src&&src.timeStamp||jQuery.now();this[jQuery.expando]=true};function returnFalse(){return false}function returnTrue(){return true}jQuery.Event.prototype={preventDefault:function(){this.isDefaultPrevented=returnTrue;var e=this.originalEvent;if(!e){return }if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}},stopPropagation:function(){this.isPropagationStopped=returnTrue;var e=this.originalEvent;if(!e){return }if(e.stopPropagation){e.stopPropagation()}e.cancelBubble=true},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue;this.stopPropagation()},isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse};jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var target=this,related=event.relatedTarget,handleObj=event.handleObj,selector=handleObj.selector,ret;if(!related||(related!==target&&!jQuery.contains(target,related))){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix}return ret}}});if(!jQuery.support.submitBubbles){jQuery.event.special.submit={setup:function(){if(jQuery.nodeName(this,"form")){return false}jQuery.event.add(this,"click._submit keypress._submit",function(e){var elem=e.target,form=jQuery.nodeName(elem,"input")||jQuery.nodeName(elem,"button")?elem.form:undefined;if(form&&!form._submit_attached){jQuery.event.add(form,"submit._submit",function(event){event._submit_bubble=true});form._submit_attached=true}})},postDispatch:function(event){if(event._submit_bubble){delete event._submit_bubble;if(this.parentNode&&!event.isTrigger){jQuery.event.simulate("submit",this.parentNode,event,true)}}},teardown:function(){if(jQuery.nodeName(this,"form")){return false}jQuery.event.remove(this,"._submit")}}}if(!jQuery.support.changeBubbles){jQuery.event.special.change={setup:function(){if(rformElems.test(this.nodeName)){if(this.type==="checkbox"||this.type==="radio"){jQuery.event.add(this,"propertychange._change",function(event){if(event.originalEvent.propertyName==="checked"){this._just_changed=true}});jQuery.event.add(this,"click._change",function(event){if(this._just_changed&&!event.isTrigger){this._just_changed=false;jQuery.event.simulate("change",this,event,true)}})}return false}jQuery.event.add(this,"beforeactivate._change",function(e){var elem=e.target;if(rformElems.test(elem.nodeName)&&!elem._change_attached){jQuery.event.add(elem,"change._change",function(event){if(this.parentNode&&!event.isSimulated&&!event.isTrigger){jQuery.event.simulate("change",this.parentNode,event,true)}});elem._change_attached=true}})},handle:function(event){var elem=event.target;if(this!==elem||event.isSimulated||event.isTrigger||(elem.type!=="radio"&&elem.type!=="checkbox")){return event.handleObj.handler.apply(this,arguments)}},teardown:function(){jQuery.event.remove(this,"._change");return rformElems.test(this.nodeName)}}}if(!jQuery.support.focusinBubbles){jQuery.each({focus:"focusin",blur:"focusout"},function(orig,fix){var attaches=0,handler=function(event){jQuery.event.simulate(fix,event.target,jQuery.event.fix(event),true)};jQuery.event.special[fix]={setup:function(){if(attaches++===0){document.addEventListener(orig,handler,true)}},teardown:function(){if(--attaches===0){document.removeEventListener(orig,handler,true)}}}})}jQuery.fn.extend({on:function(types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined}for(type in types){this.on(type,selector,data,types[type],one)}return this}if(data==null&&fn==null){fn=selector;data=selector=undefined}else{if(fn==null){if(typeof selector==="string"){fn=data;data=undefined}else{fn=data;data=selector;selector=undefined}}}if(fn===false){fn=returnFalse}else{if(!fn){return this}}if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments)};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++)}return this.each(function(){jQuery.event.add(this,types,fn,data,selector)})},one:function(types,selector,data,fn){return this.on(types,selector,data,fn,1)},off:function(types,selector,fn){if(types&&types.preventDefault&&types.handleObj){var handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this}if(typeof types==="object"){for(var type in types){this.off(type,selector,types[type])}return this}if(selector===false||typeof selector==="function"){fn=selector;selector=undefined}if(fn===false){fn=returnFalse}return this.each(function(){jQuery.event.remove(this,types,fn,selector)})},bind:function(types,data,fn){return this.on(types,null,data,fn)},unbind:function(types,fn){return this.off(types,null,fn)},live:function(types,data,fn){jQuery(this.context).on(types,this.selector,data,fn);return this},die:function(types,fn){jQuery(this.context).off(types,this.selector||"**",fn);return this},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn)},undelegate:function(selector,types,fn){return arguments.length==1?this.off(selector,"**"):this.off(types,selector,fn)},trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this)})},triggerHandler:function(type,data){if(this[0]){return jQuery.event.trigger(type,data,this[0],true)}},toggle:function(fn){var args=arguments,guid=fn.guid||jQuery.guid++,i=0,toggler=function(event){var lastToggle=(jQuery._data(this,"lastToggle"+fn.guid)||0)%i;jQuery._data(this,"lastToggle"+fn.guid,lastToggle+1);event.preventDefault();return args[lastToggle].apply(this,arguments)||false};toggler.guid=guid;while(i<args.length){args[i++].guid=guid}return this.click(toggler)},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver)}});jQuery.each(("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu").split(" "),function(i,name){jQuery.fn[name]=function(data,fn){if(fn==null){fn=data;data=null}return arguments.length>0?this.on(name,null,data,fn):this.trigger(name)};if(jQuery.attrFn){jQuery.attrFn[name]=true}if(rkeyEvent.test(name)){jQuery.event.fixHooks[name]=jQuery.event.keyHooks}if(rmouseEvent.test(name)){jQuery.event.fixHooks[name]=jQuery.event.mouseHooks}});
/*
 * Sizzle CSS Selector Engine
 *  Copyright 2011, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,expando="sizcache"+(Math.random()+"").replace(".",""),done=0,toString=Object.prototype.toString,hasDuplicate=false,baseHasDuplicate=true,rBackslash=/\\/g,rReturn=/\r\n/g,rNonWord=/\W/;[0,0].sort(function(){baseHasDuplicate=false;return 0});var Sizzle=function(selector,context,results,seed){results=results||[];context=context||document;var origContext=context;if(context.nodeType!==1&&context.nodeType!==9){return[]}if(!selector||typeof selector!=="string"){return results}var m,set,checkSet,extra,ret,cur,pop,i,prune=true,contextXML=Sizzle.isXML(context),parts=[],soFar=selector;do{chunker.exec("");m=chunker.exec(soFar);if(m){soFar=m[3];parts.push(m[1]);if(m[2]){extra=m[3];break}}}while(m);if(parts.length>1&&origPOS.exec(selector)){if(parts.length===2&&Expr.relative[parts[0]]){set=posProcess(parts[0]+parts[1],context,seed)}else{set=Expr.relative[parts[0]]?[context]:Sizzle(parts.shift(),context);while(parts.length){selector=parts.shift();if(Expr.relative[selector]){selector+=parts.shift()}set=posProcess(selector,set,seed)}}}else{if(!seed&&parts.length>1&&context.nodeType===9&&!contextXML&&Expr.match.ID.test(parts[0])&&!Expr.match.ID.test(parts[parts.length-1])){ret=Sizzle.find(parts.shift(),context,contextXML);context=ret.expr?Sizzle.filter(ret.expr,ret.set)[0]:ret.set[0]}if(context){ret=seed?{expr:parts.pop(),set:makeArray(seed)}:Sizzle.find(parts.pop(),parts.length===1&&(parts[0]==="~"||parts[0]==="+")&&context.parentNode?context.parentNode:context,contextXML);set=ret.expr?Sizzle.filter(ret.expr,ret.set):ret.set;if(parts.length>0){checkSet=makeArray(set)}else{prune=false}while(parts.length){cur=parts.pop();pop=cur;if(!Expr.relative[cur]){cur=""}else{pop=parts.pop()}if(pop==null){pop=context}Expr.relative[cur](checkSet,pop,contextXML)}}else{checkSet=parts=[]}}if(!checkSet){checkSet=set}if(!checkSet){Sizzle.error(cur||selector)}if(toString.call(checkSet)==="[object Array]"){if(!prune){results.push.apply(results,checkSet)}else{if(context&&context.nodeType===1){for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&(checkSet[i]===true||checkSet[i].nodeType===1&&Sizzle.contains(context,checkSet[i]))){results.push(set[i])}}}else{for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&checkSet[i].nodeType===1){results.push(set[i])}}}}}else{makeArray(checkSet,results)}if(extra){Sizzle(extra,origContext,results,seed);Sizzle.uniqueSort(results)}return results};Sizzle.uniqueSort=function(results){if(sortOrder){hasDuplicate=baseHasDuplicate;results.sort(sortOrder);if(hasDuplicate){for(var i=1;i<results.length;i++){if(results[i]===results[i-1]){results.splice(i--,1)}}}}return results};Sizzle.matches=function(expr,set){return Sizzle(expr,null,null,set)};Sizzle.matchesSelector=function(node,expr){return Sizzle(expr,null,null,[node]).length>0};Sizzle.find=function(expr,context,isXML){var set,i,len,match,type,left;if(!expr){return[]}for(i=0,len=Expr.order.length;i<len;i++){type=Expr.order[i];if((match=Expr.leftMatch[type].exec(expr))){left=match[1];match.splice(1,1);if(left.substr(left.length-1)!=="\\"){match[1]=(match[1]||"").replace(rBackslash,"");set=Expr.find[type](match,context,isXML);if(set!=null){expr=expr.replace(Expr.match[type],"");break}}}}if(!set){set=typeof context.getElementsByTagName!=="undefined"?context.getElementsByTagName("*"):[]}return{set:set,expr:expr}};Sizzle.filter=function(expr,set,inplace,not){var match,anyFound,type,found,item,filter,left,i,pass,old=expr,result=[],curLoop=set,isXMLFilter=set&&set[0]&&Sizzle.isXML(set[0]);while(expr&&set.length){for(type in Expr.filter){if((match=Expr.leftMatch[type].exec(expr))!=null&&match[2]){filter=Expr.filter[type];left=match[1];anyFound=false;match.splice(1,1);if(left.substr(left.length-1)==="\\"){continue}if(curLoop===result){result=[]}if(Expr.preFilter[type]){match=Expr.preFilter[type](match,curLoop,inplace,result,not,isXMLFilter);if(!match){anyFound=found=true}else{if(match===true){continue}}}if(match){for(i=0;(item=curLoop[i])!=null;i++){if(item){found=filter(item,match,i,curLoop);pass=not^found;if(inplace&&found!=null){if(pass){anyFound=true}else{curLoop[i]=false}}else{if(pass){result.push(item);anyFound=true}}}}}if(found!==undefined){if(!inplace){curLoop=result}expr=expr.replace(Expr.match[type],"");if(!anyFound){return[]}break}}}if(expr===old){if(anyFound==null){Sizzle.error(expr)}else{break}}old=expr}return curLoop};Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)};var getText=Sizzle.getText=function(elem){var i,node,nodeType=elem.nodeType,ret="";if(nodeType){if(nodeType===1||nodeType===9||nodeType===11){if(typeof elem.textContent==="string"){return elem.textContent}else{if(typeof elem.innerText==="string"){return elem.innerText.replace(rReturn,"")}else{for(elem=elem.firstChild;elem;elem=elem.nextSibling){ret+=getText(elem)}}}}else{if(nodeType===3||nodeType===4){return elem.nodeValue}}}else{for(i=0;(node=elem[i]);i++){if(node.nodeType!==8){ret+=getText(node)}}}return ret};var Expr=Sizzle.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF\-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF\-]|\\.)+)\s*(?:(\S?=)\s*(?:(['"])(.*?)\3|(#?(?:[\w\u00c0-\uFFFF\-]|\\.)*)|)|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*\-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\(\s*(even|odd|(?:[+\-]?\d+|(?:[+\-]?\d*)?n\s*(?:[+\-]\s*\d+)?))\s*\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^\-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF\-]|\\.)+)(?:\((['"]?)((?:\([^\)]+\)|[^\(\)]*)+)\2\))?/},leftMatch:{},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(elem){return elem.getAttribute("href")},type:function(elem){return elem.getAttribute("type")}},relative:{"+":function(checkSet,part){var isPartStr=typeof part==="string",isTag=isPartStr&&!rNonWord.test(part),isPartStrNotTag=isPartStr&&!isTag;if(isTag){part=part.toLowerCase()}for(var i=0,l=checkSet.length,elem;i<l;i++){if((elem=checkSet[i])){while((elem=elem.previousSibling)&&elem.nodeType!==1){}checkSet[i]=isPartStrNotTag||elem&&elem.nodeName.toLowerCase()===part?elem||false:elem===part}}if(isPartStrNotTag){Sizzle.filter(part,checkSet,true)}},">":function(checkSet,part){var elem,isPartStr=typeof part==="string",i=0,l=checkSet.length;if(isPartStr&&!rNonWord.test(part)){part=part.toLowerCase();for(;i<l;i++){elem=checkSet[i];if(elem){var parent=elem.parentNode;checkSet[i]=parent.nodeName.toLowerCase()===part?parent:false}}}else{for(;i<l;i++){elem=checkSet[i];if(elem){checkSet[i]=isPartStr?elem.parentNode:elem.parentNode===part}}if(isPartStr){Sizzle.filter(part,checkSet,true)}}},"":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!rNonWord.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck}checkFn("parentNode",part,doneName,checkSet,nodeCheck,isXML)},"~":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!rNonWord.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck}checkFn("previousSibling",part,doneName,checkSet,nodeCheck,isXML)}},find:{ID:function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m&&m.parentNode?[m]:[]}},NAME:function(match,context){if(typeof context.getElementsByName!=="undefined"){var ret=[],results=context.getElementsByName(match[1]);for(var i=0,l=results.length;i<l;i++){if(results[i].getAttribute("name")===match[1]){ret.push(results[i])}}return ret.length===0?null:ret}},TAG:function(match,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(match[1])}}},preFilter:{CLASS:function(match,curLoop,inplace,result,not,isXML){match=" "+match[1].replace(rBackslash,"")+" ";if(isXML){return match}for(var i=0,elem;(elem=curLoop[i])!=null;i++){if(elem){if(not^(elem.className&&(" "+elem.className+" ").replace(/[\t\n\r]/g," ").indexOf(match)>=0)){if(!inplace){result.push(elem)}}else{if(inplace){curLoop[i]=false}}}}return false},ID:function(match){return match[1].replace(rBackslash,"")},TAG:function(match,curLoop){return match[1].replace(rBackslash,"").toLowerCase()},CHILD:function(match){if(match[1]==="nth"){if(!match[2]){Sizzle.error(match[0])}match[2]=match[2].replace(/^\+|\s*/g,"");var test=/(-?)(\d*)(?:n([+\-]?\d*))?/.exec(match[2]==="even"&&"2n"||match[2]==="odd"&&"2n+1"||!/\D/.test(match[2])&&"0n+"+match[2]||match[2]);match[2]=(test[1]+(test[2]||1))-0;match[3]=test[3]-0}else{if(match[2]){Sizzle.error(match[0])}}match[0]=done++;return match},ATTR:function(match,curLoop,inplace,result,not,isXML){var name=match[1]=match[1].replace(rBackslash,"");if(!isXML&&Expr.attrMap[name]){match[1]=Expr.attrMap[name]}match[4]=(match[4]||match[5]||"").replace(rBackslash,"");if(match[2]==="~="){match[4]=" "+match[4]+" "}return match},PSEUDO:function(match,curLoop,inplace,result,not){if(match[1]==="not"){if((chunker.exec(match[3])||"").length>1||/^\w/.test(match[3])){match[3]=Sizzle(match[3],null,null,curLoop)}else{var ret=Sizzle.filter(match[3],curLoop,inplace,true^not);if(!inplace){result.push.apply(result,ret)}return false}}else{if(Expr.match.POS.test(match[0])||Expr.match.CHILD.test(match[0])){return true}}return match},POS:function(match){match.unshift(true);return match}},filters:{enabled:function(elem){return elem.disabled===false&&elem.type!=="hidden"},disabled:function(elem){return elem.disabled===true},checked:function(elem){return elem.checked===true},selected:function(elem){if(elem.parentNode){elem.parentNode.selectedIndex}return elem.selected===true},parent:function(elem){return !!elem.firstChild},empty:function(elem){return !elem.firstChild},has:function(elem,i,match){return !!Sizzle(match[3],elem).length},header:function(elem){return(/h\d/i).test(elem.nodeName)},text:function(elem){var attr=elem.getAttribute("type"),type=elem.type;return elem.nodeName.toLowerCase()==="input"&&"text"===type&&(attr===type||attr===null)},radio:function(elem){return elem.nodeName.toLowerCase()==="input"&&"radio"===elem.type},checkbox:function(elem){return elem.nodeName.toLowerCase()==="input"&&"checkbox"===elem.type},file:function(elem){return elem.nodeName.toLowerCase()==="input"&&"file"===elem.type},password:function(elem){return elem.nodeName.toLowerCase()==="input"&&"password"===elem.type},submit:function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&"submit"===elem.type},image:function(elem){return elem.nodeName.toLowerCase()==="input"&&"image"===elem.type},reset:function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&"reset"===elem.type},button:function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&"button"===elem.type||name==="button"},input:function(elem){return(/input|select|textarea|button/i).test(elem.nodeName)},focus:function(elem){return elem===elem.ownerDocument.activeElement}},setFilters:{first:function(elem,i){return i===0},last:function(elem,i,match,array){return i===array.length-1},even:function(elem,i){return i%2===0},odd:function(elem,i){return i%2===1},lt:function(elem,i,match){return i<match[3]-0},gt:function(elem,i,match){return i>match[3]-0},nth:function(elem,i,match){return match[3]-0===i},eq:function(elem,i,match){return match[3]-0===i}},filter:{PSEUDO:function(elem,match,i,array){var name=match[1],filter=Expr.filters[name];if(filter){return filter(elem,i,match,array)}else{if(name==="contains"){return(elem.textContent||elem.innerText||getText([elem])||"").indexOf(match[3])>=0}else{if(name==="not"){var not=match[3];for(var j=0,l=not.length;j<l;j++){if(not[j]===elem){return false}}return true}else{Sizzle.error(name)}}}},CHILD:function(elem,match){var first,last,doneName,parent,cache,count,diff,type=match[1],node=elem;switch(type){case"only":case"first":while((node=node.previousSibling)){if(node.nodeType===1){return false}}if(type==="first"){return true}node=elem;case"last":while((node=node.nextSibling)){if(node.nodeType===1){return false}}return true;case"nth":first=match[2];last=match[3];if(first===1&&last===0){return true}doneName=match[0];parent=elem.parentNode;if(parent&&(parent[expando]!==doneName||!elem.nodeIndex)){count=0;for(node=parent.firstChild;node;node=node.nextSibling){if(node.nodeType===1){node.nodeIndex=++count}}parent[expando]=doneName}diff=elem.nodeIndex-last;if(first===0){return diff===0}else{return(diff%first===0&&diff/first>=0)}}},ID:function(elem,match){return elem.nodeType===1&&elem.getAttribute("id")===match},TAG:function(elem,match){return(match==="*"&&elem.nodeType===1)||!!elem.nodeName&&elem.nodeName.toLowerCase()===match},CLASS:function(elem,match){return(" "+(elem.className||elem.getAttribute("class"))+" ").indexOf(match)>-1},ATTR:function(elem,match){var name=match[1],result=Sizzle.attr?Sizzle.attr(elem,name):Expr.attrHandle[name]?Expr.attrHandle[name](elem):elem[name]!=null?elem[name]:elem.getAttribute(name),value=result+"",type=match[2],check=match[4];return result==null?type==="!=":!type&&Sizzle.attr?result!=null:type==="="?value===check:type==="*="?value.indexOf(check)>=0:type==="~="?(" "+value+" ").indexOf(check)>=0:!check?value&&result!==false:type==="!="?value!==check:type==="^="?value.indexOf(check)===0:type==="$="?value.substr(value.length-check.length)===check:type==="|="?value===check||value.substr(0,check.length+1)===check+"-":false},POS:function(elem,match,i,array){var name=match[2],filter=Expr.setFilters[name];if(filter){return filter(elem,i,match,array)}}}};var origPOS=Expr.match.POS,fescape=function(all,num){return"\\"+(num-0+1)};for(var type in Expr.match){Expr.match[type]=new RegExp(Expr.match[type].source+(/(?![^\[]*\])(?![^\(]*\))/.source));Expr.leftMatch[type]=new RegExp(/(^(?:.|\r|\n)*?)/.source+Expr.match[type].source.replace(/\\(\d+)/g,fescape))}Expr.match.globalPOS=origPOS;var makeArray=function(array,results){array=Array.prototype.slice.call(array,0);if(results){results.push.apply(results,array);return results}return array};try{Array.prototype.slice.call(document.documentElement.childNodes,0)[0].nodeType}catch(e){makeArray=function(array,results){var i=0,ret=results||[];if(toString.call(array)==="[object Array]"){Array.prototype.push.apply(ret,array)}else{if(typeof array.length==="number"){for(var l=array.length;i<l;i++){ret.push(array[i])}}else{for(;array[i];i++){ret.push(array[i])}}}return ret}}var sortOrder,siblingCheck;if(document.documentElement.compareDocumentPosition){sortOrder=function(a,b){if(a===b){hasDuplicate=true;return 0}if(!a.compareDocumentPosition||!b.compareDocumentPosition){return a.compareDocumentPosition?-1:1}return a.compareDocumentPosition(b)&4?-1:1}}else{sortOrder=function(a,b){if(a===b){hasDuplicate=true;return 0}else{if(a.sourceIndex&&b.sourceIndex){return a.sourceIndex-b.sourceIndex}}var al,bl,ap=[],bp=[],aup=a.parentNode,bup=b.parentNode,cur=aup;if(aup===bup){return siblingCheck(a,b)}else{if(!aup){return -1}else{if(!bup){return 1}}}while(cur){ap.unshift(cur);cur=cur.parentNode}cur=bup;while(cur){bp.unshift(cur);cur=cur.parentNode}al=ap.length;bl=bp.length;for(var i=0;i<al&&i<bl;i++){if(ap[i]!==bp[i]){return siblingCheck(ap[i],bp[i])}}return i===al?siblingCheck(a,bp[i],-1):siblingCheck(ap[i],b,1)};siblingCheck=function(a,b,ret){if(a===b){return ret}var cur=a.nextSibling;while(cur){if(cur===b){return -1}cur=cur.nextSibling}return 1}}(function(){var form=document.createElement("div"),id="script"+(new Date()).getTime(),root=document.documentElement;form.innerHTML="<a name='"+id+"'/>";root.insertBefore(form,root.firstChild);if(document.getElementById(id)){Expr.find.ID=function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?m.id===match[1]||typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id").nodeValue===match[1]?[m]:undefined:[]}};Expr.filter.ID=function(elem,match){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return elem.nodeType===1&&node&&node.nodeValue===match}}root.removeChild(form);root=form=null})();(function(){var div=document.createElement("div");div.appendChild(document.createComment(""));if(div.getElementsByTagName("*").length>0){Expr.find.TAG=function(match,context){var results=context.getElementsByTagName(match[1]);if(match[1]==="*"){var tmp=[];for(var i=0;results[i];i++){if(results[i].nodeType===1){tmp.push(results[i])}}results=tmp}return results}}div.innerHTML="<a href='#'></a>";if(div.firstChild&&typeof div.firstChild.getAttribute!=="undefined"&&div.firstChild.getAttribute("href")!=="#"){Expr.attrHandle.href=function(elem){return elem.getAttribute("href",2)}}div=null})();if(document.querySelectorAll){(function(){var oldSizzle=Sizzle,div=document.createElement("div"),id="__sizzle__";div.innerHTML="<p class='TEST'></p>";if(div.querySelectorAll&&div.querySelectorAll(".TEST").length===0){return }Sizzle=function(query,context,extra,seed){context=context||document;if(!seed&&!Sizzle.isXML(context)){var match=/^(\w+$)|^\.([\w\-]+$)|^#([\w\-]+$)/.exec(query);if(match&&(context.nodeType===1||context.nodeType===9)){if(match[1]){return makeArray(context.getElementsByTagName(query),extra)}else{if(match[2]&&Expr.find.CLASS&&context.getElementsByClassName){return makeArray(context.getElementsByClassName(match[2]),extra)}}}if(context.nodeType===9){if(query==="body"&&context.body){return makeArray([context.body],extra)}else{if(match&&match[3]){var elem=context.getElementById(match[3]);if(elem&&elem.parentNode){if(elem.id===match[3]){return makeArray([elem],extra)}}else{return makeArray([],extra)}}}try{return makeArray(context.querySelectorAll(query),extra)}catch(qsaError){}}else{if(context.nodeType===1&&context.nodeName.toLowerCase()!=="object"){var oldContext=context,old=context.getAttribute("id"),nid=old||id,hasParent=context.parentNode,relativeHierarchySelector=/^\s*[+~]/.test(query);if(!old){context.setAttribute("id",nid)}else{nid=nid.replace(/'/g,"\\$&")}if(relativeHierarchySelector&&hasParent){context=context.parentNode}try{if(!relativeHierarchySelector||hasParent){return makeArray(context.querySelectorAll("[id='"+nid+"'] "+query),extra)}}catch(pseudoError){}finally{if(!old){oldContext.removeAttribute("id")}}}}}return oldSizzle(query,context,extra,seed)};for(var prop in oldSizzle){Sizzle[prop]=oldSizzle[prop]}div=null})()}(function(){var html=document.documentElement,matches=html.matchesSelector||html.mozMatchesSelector||html.webkitMatchesSelector||html.msMatchesSelector;if(matches){var disconnectedMatch=!matches.call(document.createElement("div"),"div"),pseudoWorks=false;try{matches.call(document.documentElement,"[test!='']:sizzle")}catch(pseudoError){pseudoWorks=true}Sizzle.matchesSelector=function(node,expr){expr=expr.replace(/\=\s*([^'"\]]*)\s*\]/g,"='$1']");if(!Sizzle.isXML(node)){try{if(pseudoWorks||!Expr.match.PSEUDO.test(expr)&&!/!=/.test(expr)){var ret=matches.call(node,expr);if(ret||!disconnectedMatch||node.document&&node.document.nodeType!==11){return ret}}}catch(e){}}return Sizzle(expr,null,null,[node]).length>0}}})();(function(){var div=document.createElement("div");div.innerHTML="<div class='test e'></div><div class='test'></div>";if(!div.getElementsByClassName||div.getElementsByClassName("e").length===0){return }div.lastChild.className="e";if(div.getElementsByClassName("e").length===1){return }Expr.order.splice(1,0,"CLASS");Expr.find.CLASS=function(match,context,isXML){if(typeof context.getElementsByClassName!=="undefined"&&!isXML){return context.getElementsByClassName(match[1])}};div=null})();function dirNodeCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem[expando]===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1&&!isXML){elem[expando]=doneName;elem.sizset=i}if(elem.nodeName.toLowerCase()===cur){match=elem;break}elem=elem[dir]}checkSet[i]=match}}}function dirCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem[expando]===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1){if(!isXML){elem[expando]=doneName;elem.sizset=i}if(typeof cur!=="string"){if(elem===cur){match=true;break}}else{if(Sizzle.filter(cur,[elem]).length>0){match=elem;break}}}elem=elem[dir]}checkSet[i]=match}}}if(document.documentElement.contains){Sizzle.contains=function(a,b){return a!==b&&(a.contains?a.contains(b):true)}}else{if(document.documentElement.compareDocumentPosition){Sizzle.contains=function(a,b){return !!(a.compareDocumentPosition(b)&16)}}else{Sizzle.contains=function(){return false}}}Sizzle.isXML=function(elem){var documentElement=(elem?elem.ownerDocument||elem:0).documentElement;return documentElement?documentElement.nodeName!=="HTML":false};var posProcess=function(selector,context,seed){var match,tmpSet=[],later="",root=context.nodeType?[context]:context;while((match=Expr.match.PSEUDO.exec(selector))){later+=match[0];selector=selector.replace(Expr.match.PSEUDO,"")}selector=Expr.relative[selector]?selector+"*":selector;for(var i=0,l=root.length;i<l;i++){Sizzle(selector,root[i],tmpSet,seed)}return Sizzle.filter(later,tmpSet)};Sizzle.attr=jQuery.attr;Sizzle.selectors.attrMap={};jQuery.find=Sizzle;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.filters;jQuery.unique=Sizzle.uniqueSort;jQuery.text=Sizzle.getText;jQuery.isXMLDoc=Sizzle.isXML;jQuery.contains=Sizzle.contains})();var runtil=/Until$/,rparentsprev=/^(?:parents|prevUntil|prevAll)/,rmultiselector=/,/,isSimple=/^.[^:#\[\.,]*$/,slice=Array.prototype.slice,POS=jQuery.expr.match.globalPOS,guaranteedUnique={children:true,contents:true,next:true,prev:true};jQuery.fn.extend({find:function(selector){var self=this,i,l;if(typeof selector!=="string"){return jQuery(selector).filter(function(){for(i=0,l=self.length;i<l;i++){if(jQuery.contains(self[i],this)){return true}}})}var ret=this.pushStack("","find",selector),length,n,r;for(i=0,l=this.length;i<l;i++){length=ret.length;jQuery.find(selector,this[i],ret);if(i>0){for(n=length;n<ret.length;n++){for(r=0;r<length;r++){if(ret[r]===ret[n]){ret.splice(n--,1);break}}}}}return ret},has:function(target){var targets=jQuery(target);return this.filter(function(){for(var i=0,l=targets.length;i<l;i++){if(jQuery.contains(this,targets[i])){return true}}})},not:function(selector){return this.pushStack(winnow(this,selector,false),"not",selector)},filter:function(selector){return this.pushStack(winnow(this,selector,true),"filter",selector)},is:function(selector){return !!selector&&(typeof selector==="string"?POS.test(selector)?jQuery(selector,this.context).index(this[0])>=0:jQuery.filter(selector,this).length>0:this.filter(selector).length>0)},closest:function(selectors,context){var ret=[],i,l,cur=this[0];if(jQuery.isArray(selectors)){var level=1;while(cur&&cur.ownerDocument&&cur!==context){for(i=0;i<selectors.length;i++){if(jQuery(cur).is(selectors[i])){ret.push({selector:selectors[i],elem:cur,level:level})}}cur=cur.parentNode;level++}return ret}var pos=POS.test(selectors)||typeof selectors!=="string"?jQuery(selectors,context||this.context):0;for(i=0,l=this.length;i<l;i++){cur=this[i];while(cur){if(pos?pos.index(cur)>-1:jQuery.find.matchesSelector(cur,selectors)){ret.push(cur);break}else{cur=cur.parentNode;if(!cur||!cur.ownerDocument||cur===context||cur.nodeType===11){break}}}}ret=ret.length>1?jQuery.unique(ret):ret;return this.pushStack(ret,"closest",selectors)},index:function(elem){if(!elem){return(this[0]&&this[0].parentNode)?this.prevAll().length:-1}if(typeof elem==="string"){return jQuery.inArray(this[0],jQuery(elem))}return jQuery.inArray(elem.jquery?elem[0]:elem,this)},add:function(selector,context){var set=typeof selector==="string"?jQuery(selector,context):jQuery.makeArray(selector&&selector.nodeType?[selector]:selector),all=jQuery.merge(this.get(),set);return this.pushStack(isDisconnected(set[0])||isDisconnected(all[0])?all:jQuery.unique(all))},andSelf:function(){return this.add(this.prevObject)}});function isDisconnected(node){return !node||!node.parentNode||node.parentNode.nodeType===11}jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null},parents:function(elem){return jQuery.dir(elem,"parentNode")},parentsUntil:function(elem,i,until){return jQuery.dir(elem,"parentNode",until)},next:function(elem){return jQuery.nth(elem,2,"nextSibling")},prev:function(elem){return jQuery.nth(elem,2,"previousSibling")},nextAll:function(elem){return jQuery.dir(elem,"nextSibling")},prevAll:function(elem){return jQuery.dir(elem,"previousSibling")},nextUntil:function(elem,i,until){return jQuery.dir(elem,"nextSibling",until)},prevUntil:function(elem,i,until){return jQuery.dir(elem,"previousSibling",until)},siblings:function(elem){return jQuery.sibling((elem.parentNode||{}).firstChild,elem)},children:function(elem){return jQuery.sibling(elem.firstChild)},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes)}},function(name,fn){jQuery.fn[name]=function(until,selector){var ret=jQuery.map(this,fn,until);if(!runtil.test(name)){selector=until}if(selector&&typeof selector==="string"){ret=jQuery.filter(selector,ret)}ret=this.length>1&&!guaranteedUnique[name]?jQuery.unique(ret):ret;if((this.length>1||rmultiselector.test(selector))&&rparentsprev.test(name)){ret=ret.reverse()}return this.pushStack(ret,name,slice.call(arguments).join(","))}});jQuery.extend({filter:function(expr,elems,not){if(not){expr=":not("+expr+")"}return elems.length===1?jQuery.find.matchesSelector(elems[0],expr)?[elems[0]]:[]:jQuery.find.matches(expr,elems)},dir:function(elem,dir,until){var matched=[],cur=elem[dir];while(cur&&cur.nodeType!==9&&(until===undefined||cur.nodeType!==1||!jQuery(cur).is(until))){if(cur.nodeType===1){matched.push(cur)}cur=cur[dir]}return matched},nth:function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir]){if(cur.nodeType===1&&++num===result){break}}return cur},sibling:function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){r.push(n)}}return r}});function winnow(elements,qualifier,keep){qualifier=qualifier||0;if(jQuery.isFunction(qualifier)){return jQuery.grep(elements,function(elem,i){var retVal=!!qualifier.call(elem,i,elem);return retVal===keep})}else{if(qualifier.nodeType){return jQuery.grep(elements,function(elem,i){return(elem===qualifier)===keep})}else{if(typeof qualifier==="string"){var filtered=jQuery.grep(elements,function(elem){return elem.nodeType===1});if(isSimple.test(qualifier)){return jQuery.filter(qualifier,filtered,!keep)}else{qualifier=jQuery.filter(qualifier,filtered)}}}}return jQuery.grep(elements,function(elem,i){return(jQuery.inArray(elem,qualifier)>=0)===keep})}function createSafeFragment(document){var list=nodeNames.split("|"),safeFrag=document.createDocumentFragment();if(safeFrag.createElement){while(list.length){safeFrag.createElement(list.pop())}}return safeFrag}var nodeNames="abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",rinlinejQuery=/ jQuery\d+="(?:\d+|null)"/g,rleadingWhitespace=/^\s+/,rxhtmlTag=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,rtagName=/<([\w:]+)/,rtbody=/<tbody/i,rhtml=/<|&#?\w+;/,rnoInnerhtml=/<(?:script|style)/i,rnocache=/<(?:script|object|embed|option|style)/i,rnoshimcache=new RegExp("<(?:"+nodeNames+")[\\s/>]","i"),rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rscriptType=/\/(java|ecma)script/i,rcleanScript=/^\s*<!(?:\[CDATA\[|\-\-)/,wrapMap={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]},safeFragment=createSafeFragment(document);wrapMap.optgroup=wrapMap.option;wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!jQuery.support.htmlSerialize){wrapMap._default=[1,"div<div>","</div>"]}jQuery.fn.extend({text:function(value){return jQuery.access(this,function(value){return value===undefined?jQuery.text(this):this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(value))},null,value,arguments.length)},wrapAll:function(html){if(jQuery.isFunction(html)){return this.each(function(i){jQuery(this).wrapAll(html.call(this,i))})}if(this[0]){var wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){wrap.insertBefore(this[0])}wrap.map(function(){var elem=this;while(elem.firstChild&&elem.firstChild.nodeType===1){elem=elem.firstChild}return elem}).append(this)}return this},wrapInner:function(html){if(jQuery.isFunction(html)){return this.each(function(i){jQuery(this).wrapInner(html.call(this,i))})}return this.each(function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html)}else{self.append(html)}})},wrap:function(html){var isFunction=jQuery.isFunction(html);return this.each(function(i){jQuery(this).wrapAll(isFunction?html.call(this,i):html)})},unwrap:function(){return this.parent().each(function(){if(!jQuery.nodeName(this,"body")){jQuery(this).replaceWith(this.childNodes)}}).end()},append:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.appendChild(elem)}})},prepend:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.insertBefore(elem,this.firstChild)}})},before:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this)})}else{if(arguments.length){var set=jQuery.clean(arguments);set.push.apply(set,this.toArray());return this.pushStack(set,"before",arguments)}}},after:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this.nextSibling)})}else{if(arguments.length){var set=this.pushStack(this,"after",arguments);set.push.apply(set,jQuery.clean(arguments));return set}}},remove:function(selector,keepData){for(var i=0,elem;(elem=this[i])!=null;i++){if(!selector||jQuery.filter(selector,[elem]).length){if(!keepData&&elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"));jQuery.cleanData([elem])}if(elem.parentNode){elem.parentNode.removeChild(elem)}}}return this},empty:function(){for(var i=0,elem;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"))}while(elem.firstChild){elem.removeChild(elem.firstChild)}}return this},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?false:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents)})},html:function(value){return jQuery.access(this,function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined){return elem.nodeType===1?elem.innerHTML.replace(rinlinejQuery,""):null}if(typeof value==="string"&&!rnoInnerhtml.test(value)&&(jQuery.support.leadingWhitespace||!rleadingWhitespace.test(value))&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=value.replace(rxhtmlTag,"<$1></$2>");try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"));elem.innerHTML=value}}elem=0}catch(e){}}if(elem){this.empty().append(value)}},null,value,arguments.length)},replaceWith:function(value){if(this[0]&&this[0].parentNode){if(jQuery.isFunction(value)){return this.each(function(i){var self=jQuery(this),old=self.html();self.replaceWith(value.call(this,i,old))})}if(typeof value!=="string"){value=jQuery(value).detach()}return this.each(function(){var next=this.nextSibling,parent=this.parentNode;jQuery(this).remove();if(next){jQuery(next).before(value)}else{jQuery(parent).append(value)}})}else{return this.length?this.pushStack(jQuery(jQuery.isFunction(value)?value():value),"replaceWith",value):this}},detach:function(selector){return this.remove(selector,true)},domManip:function(args,table,callback){var results,first,fragment,parent,value=args[0],scripts=[];if(!jQuery.support.checkClone&&arguments.length===3&&typeof value==="string"&&rchecked.test(value)){return this.each(function(){jQuery(this).domManip(args,table,callback,true)})}if(jQuery.isFunction(value)){return this.each(function(i){var self=jQuery(this);args[0]=value.call(this,i,table?self.html():undefined);self.domManip(args,table,callback)})}if(this[0]){parent=value&&value.parentNode;if(jQuery.support.parentNode&&parent&&parent.nodeType===11&&parent.childNodes.length===this.length){results={fragment:parent}}else{results=jQuery.buildFragment(args,this,scripts)}fragment=results.fragment;if(fragment.childNodes.length===1){first=fragment=fragment.firstChild}else{first=fragment.firstChild}if(first){table=table&&jQuery.nodeName(first,"tr");for(var i=0,l=this.length,lastIndex=l-1;i<l;i++){callback.call(table?root(this[i],first):this[i],results.cacheable||(l>1&&i<lastIndex)?jQuery.clone(fragment,true,true):fragment)}}if(scripts.length){jQuery.each(scripts,function(i,elem){if(elem.src){jQuery.ajax({type:"GET",global:false,url:elem.src,async:false,dataType:"script"})}else{jQuery.globalEval((elem.text||elem.textContent||elem.innerHTML||"").replace(rcleanScript,"/*$0*/"))}if(elem.parentNode){elem.parentNode.removeChild(elem)}})}}return this}});function root(elem,cur){return jQuery.nodeName(elem,"table")?(elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody"))):elem}function cloneCopyEvent(src,dest){if(dest.nodeType!==1||!jQuery.hasData(src)){return }var type,i,l,oldData=jQuery._data(src),curData=jQuery._data(dest,oldData),events=oldData.events;if(events){delete curData.handle;curData.events={};for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i])}}}if(curData.data){curData.data=jQuery.extend({},curData.data)}}function cloneFixAttributes(src,dest){var nodeName;if(dest.nodeType!==1){return }if(dest.clearAttributes){dest.clearAttributes()}if(dest.mergeAttributes){dest.mergeAttributes(src)}nodeName=dest.nodeName.toLowerCase();if(nodeName==="object"){dest.outerHTML=src.outerHTML}else{if(nodeName==="input"&&(src.type==="checkbox"||src.type==="radio")){if(src.checked){dest.defaultChecked=dest.checked=src.checked}if(dest.value!==src.value){dest.value=src.value}}else{if(nodeName==="option"){dest.selected=src.defaultSelected}else{if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue}else{if(nodeName==="script"&&dest.text!==src.text){dest.text=src.text}}}}}dest.removeAttribute(jQuery.expando);dest.removeAttribute("_submit_attached");dest.removeAttribute("_change_attached")}jQuery.buildFragment=function(args,nodes,scripts){var fragment,cacheable,cacheresults,doc,first=args[0];if(nodes&&nodes[0]){doc=nodes[0].ownerDocument||nodes[0]}if(!doc.createDocumentFragment){doc=document}if(args.length===1&&typeof first==="string"&&first.length<512&&doc===document&&first.charAt(0)==="<"&&!rnocache.test(first)&&(jQuery.support.checkClone||!rchecked.test(first))&&(jQuery.support.html5Clone||!rnoshimcache.test(first))){cacheable=true;cacheresults=jQuery.fragments[first];if(cacheresults&&cacheresults!==1){fragment=cacheresults}}if(!fragment){fragment=doc.createDocumentFragment();jQuery.clean(args,doc,fragment,scripts)}if(cacheable){jQuery.fragments[first]=cacheresults?fragment:1}return{fragment:fragment,cacheable:cacheable}};jQuery.fragments={};jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var ret=[],insert=jQuery(selector),parent=this.length===1&&this[0].parentNode;if(parent&&parent.nodeType===11&&parent.childNodes.length===1&&insert.length===1){insert[original](this[0]);return this}else{for(var i=0,l=insert.length;i<l;i++){var elems=(i>0?this.clone(true):this).get();jQuery(insert[i])[original](elems);ret=ret.concat(elems)}return this.pushStack(ret,name,insert.selector)}}});function getAll(elem){if(typeof elem.getElementsByTagName!=="undefined"){return elem.getElementsByTagName("*")}else{if(typeof elem.querySelectorAll!=="undefined"){return elem.querySelectorAll("*")}else{return[]}}}function fixDefaultChecked(elem){if(elem.type==="checkbox"||elem.type==="radio"){elem.defaultChecked=elem.checked}}function findInputs(elem){var nodeName=(elem.nodeName||"").toLowerCase();if(nodeName==="input"){fixDefaultChecked(elem)}else{if(nodeName!=="script"&&typeof elem.getElementsByTagName!=="undefined"){jQuery.grep(elem.getElementsByTagName("input"),fixDefaultChecked)}}}function shimCloneNode(elem){var div=document.createElement("div");safeFragment.appendChild(div);div.innerHTML=elem.outerHTML;return div.firstChild}jQuery.extend({clone:function(elem,dataAndEvents,deepDataAndEvents){var srcElements,destElements,i,clone=jQuery.support.html5Clone||jQuery.isXMLDoc(elem)||!rnoshimcache.test("<"+elem.nodeName+">")?elem.cloneNode(true):shimCloneNode(elem);if((!jQuery.support.noCloneEvent||!jQuery.support.noCloneChecked)&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){cloneFixAttributes(elem,clone);srcElements=getAll(elem);destElements=getAll(clone);for(i=0;srcElements[i];++i){if(destElements[i]){cloneFixAttributes(srcElements[i],destElements[i])}}}if(dataAndEvents){cloneCopyEvent(elem,clone);if(deepDataAndEvents){srcElements=getAll(elem);destElements=getAll(clone);for(i=0;srcElements[i];++i){cloneCopyEvent(srcElements[i],destElements[i])}}}srcElements=destElements=null;return clone},clean:function(elems,context,fragment,scripts){var checkScriptType,script,j,ret=[];context=context||document;if(typeof context.createElement==="undefined"){context=context.ownerDocument||context[0]&&context[0].ownerDocument||document}for(var i=0,elem;(elem=elems[i])!=null;i++){if(typeof elem==="number"){elem+=""}if(!elem){continue}if(typeof elem==="string"){if(!rhtml.test(elem)){elem=context.createTextNode(elem)}else{elem=elem.replace(rxhtmlTag,"<$1></$2>");var tag=(rtagName.exec(elem)||["",""])[1].toLowerCase(),wrap=wrapMap[tag]||wrapMap._default,depth=wrap[0],div=context.createElement("div"),safeChildNodes=safeFragment.childNodes,remove;if(context===document){safeFragment.appendChild(div)}else{createSafeFragment(context).appendChild(div)}div.innerHTML=wrap[1]+elem+wrap[2];while(depth--){div=div.lastChild}if(!jQuery.support.tbody){var hasBody=rtbody.test(elem),tbody=tag==="table"&&!hasBody?div.firstChild&&div.firstChild.childNodes:wrap[1]==="<table>"&&!hasBody?div.childNodes:[];for(j=tbody.length-1;j>=0;--j){if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length){tbody[j].parentNode.removeChild(tbody[j])}}}if(!jQuery.support.leadingWhitespace&&rleadingWhitespace.test(elem)){div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]),div.firstChild)}elem=div.childNodes;if(div){div.parentNode.removeChild(div);if(safeChildNodes.length>0){remove=safeChildNodes[safeChildNodes.length-1];if(remove&&remove.parentNode){remove.parentNode.removeChild(remove)}}}}}var len;if(!jQuery.support.appendChecked){if(elem[0]&&typeof (len=elem.length)==="number"){for(j=0;j<len;j++){findInputs(elem[j])}}else{findInputs(elem)}}if(elem.nodeType){ret.push(elem)}else{ret=jQuery.merge(ret,elem)}}if(fragment){checkScriptType=function(elem){return !elem.type||rscriptType.test(elem.type)};for(i=0;ret[i];i++){script=ret[i];if(scripts&&jQuery.nodeName(script,"script")&&(!script.type||rscriptType.test(script.type))){scripts.push(script.parentNode?script.parentNode.removeChild(script):script)}else{if(script.nodeType===1){var jsTags=jQuery.grep(script.getElementsByTagName("script"),checkScriptType);ret.splice.apply(ret,[i+1,0].concat(jsTags))}fragment.appendChild(script)}}}return ret},cleanData:function(elems){var data,id,cache=jQuery.cache,special=jQuery.event.special,deleteExpando=jQuery.support.deleteExpando;for(var i=0,elem;(elem=elems[i])!=null;i++){if(elem.nodeName&&jQuery.noData[elem.nodeName.toLowerCase()]){continue}id=elem[jQuery.expando];if(id){data=cache[id];if(data&&data.events){for(var type in data.events){if(special[type]){jQuery.event.remove(elem,type)}else{jQuery.removeEvent(elem,type,data.handle)}}if(data.handle){data.handle.elem=null}}if(deleteExpando){delete elem[jQuery.expando]}else{if(elem.removeAttribute){elem.removeAttribute(jQuery.expando)}}delete cache[id]}}}});var ralpha=/alpha\([^)]*\)/i,ropacity=/opacity=([^)]*)/,rupper=/([A-Z]|^ms)/g,rnum=/^[\-+]?(?:\d*\.)?\d+$/i,rnumnonpx=/^-?(?:\d*\.)?\d+(?!px)[^\d\s]+$/i,rrelNum=/^([\-+])=([\-+.\de]+)/,rmargin=/^margin/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssExpand=["Top","Right","Bottom","Left"],curCSS,getComputedStyle,currentStyle;jQuery.fn.css=function(name,value){return jQuery.access(this,function(elem,name,value){return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name)},name,value,arguments.length>1)};jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret}else{return elem.style.opacity}}}},cssNumber:{fillOpacity:true,fontWeight:true,lineHeight:true,opacity:true,orphans:true,widows:true,zIndex:true,zoom:true},cssProps:{"float":jQuery.support.cssFloat?"cssFloat":"styleFloat"},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return }var ret,type,origName=jQuery.camelCase(name),style=elem.style,hooks=jQuery.cssHooks[origName];name=jQuery.cssProps[origName]||origName;if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rrelNum.exec(value))){value=(+(ret[1]+1)*+ret[2])+parseFloat(jQuery.css(elem,name));type="number"}if(value==null||type==="number"&&isNaN(value)){return }if(type==="number"&&!jQuery.cssNumber[origName]){value+="px"}if(!hooks||!("set" in hooks)||(value=hooks.set(elem,value))!==undefined){try{style[name]=value}catch(e){}}}else{if(hooks&&"get" in hooks&&(ret=hooks.get(elem,false,extra))!==undefined){return ret}return style[name]}},css:function(elem,name,extra){var ret,hooks;name=jQuery.camelCase(name);hooks=jQuery.cssHooks[name];name=jQuery.cssProps[name]||name;if(name==="cssFloat"){name="float"}if(hooks&&"get" in hooks&&(ret=hooks.get(elem,true,extra))!==undefined){return ret}else{if(curCSS){return curCSS(elem,name)}}},swap:function(elem,options,callback){var old={},ret,name;for(name in options){old[name]=elem.style[name];elem.style[name]=options[name]}ret=callback.call(elem);for(name in options){elem.style[name]=old[name]}return ret}});jQuery.curCSS=jQuery.css;if(document.defaultView&&document.defaultView.getComputedStyle){getComputedStyle=function(elem,name){var ret,defaultView,computedStyle,width,style=elem.style;name=name.replace(rupper,"-$1").toLowerCase();if((defaultView=elem.ownerDocument.defaultView)&&(computedStyle=defaultView.getComputedStyle(elem,null))){ret=computedStyle.getPropertyValue(name);if(ret===""&&!jQuery.contains(elem.ownerDocument.documentElement,elem)){ret=jQuery.style(elem,name)}}if(!jQuery.support.pixelMargin&&computedStyle&&rmargin.test(name)&&rnumnonpx.test(ret)){width=style.width;style.width=ret;ret=computedStyle.width;style.width=width}return ret}}if(document.documentElement.currentStyle){currentStyle=function(elem,name){var left,rsLeft,uncomputed,ret=elem.currentStyle&&elem.currentStyle[name],style=elem.style;if(ret==null&&style&&(uncomputed=style[name])){ret=uncomputed}if(rnumnonpx.test(ret)){left=style.left;rsLeft=elem.runtimeStyle&&elem.runtimeStyle.left;if(rsLeft){elem.runtimeStyle.left=elem.currentStyle.left}style.left=name==="fontSize"?"1em":ret;ret=style.pixelLeft+"px";style.left=left;if(rsLeft){elem.runtimeStyle.left=rsLeft}}return ret===""?"auto":ret}}curCSS=getComputedStyle||currentStyle;function getWidthOrHeight(elem,name,extra){var val=name==="width"?elem.offsetWidth:elem.offsetHeight,i=name==="width"?1:0,len=4;if(val>0){if(extra!=="border"){for(;i<len;i+=2){if(!extra){val-=parseFloat(jQuery.css(elem,"padding"+cssExpand[i]))||0}if(extra==="margin"){val+=parseFloat(jQuery.css(elem,extra+cssExpand[i]))||0}else{val-=parseFloat(jQuery.css(elem,"border"+cssExpand[i]+"Width"))||0}}}return val+"px"}val=curCSS(elem,name);if(val<0||val==null){val=elem.style[name]}if(rnumnonpx.test(val)){return val}val=parseFloat(val)||0;if(extra){for(;i<len;i+=2){val+=parseFloat(jQuery.css(elem,"padding"+cssExpand[i]))||0;if(extra!=="padding"){val+=parseFloat(jQuery.css(elem,"border"+cssExpand[i]+"Width"))||0}if(extra==="margin"){val+=parseFloat(jQuery.css(elem,extra+cssExpand[i]))||0}}}return val+"px"}jQuery.each(["height","width"],function(i,name){jQuery.cssHooks[name]={get:function(elem,computed,extra){if(computed){if(elem.offsetWidth!==0){return getWidthOrHeight(elem,name,extra)}else{return jQuery.swap(elem,cssShow,function(){return getWidthOrHeight(elem,name,extra)})}}},set:function(elem,value){return rnum.test(value)?value+"px":value}}});if(!jQuery.support.opacity){jQuery.cssHooks.opacity={get:function(elem,computed){return ropacity.test((computed&&elem.currentStyle?elem.currentStyle.filter:elem.style.filter)||"")?(parseFloat(RegExp.$1)/100)+"":computed?"1":""},set:function(elem,value){var style=elem.style,currentStyle=elem.currentStyle,opacity=jQuery.isNumeric(value)?"alpha(opacity="+value*100+")":"",filter=currentStyle&&currentStyle.filter||style.filter||"";style.zoom=1;if(value>=1&&jQuery.trim(filter.replace(ralpha,""))===""){style.removeAttribute("filter");if(currentStyle&&!currentStyle.filter){return }}style.filter=ralpha.test(filter)?filter.replace(ralpha,opacity):filter+" "+opacity}}}jQuery(function(){if(!jQuery.support.reliableMarginRight){jQuery.cssHooks.marginRight={get:function(elem,computed){return jQuery.swap(elem,{display:"inline-block"},function(){if(computed){return curCSS(elem,"margin-right")}else{return elem.style.marginRight}})}}}});if(jQuery.expr&&jQuery.expr.filters){jQuery.expr.filters.hidden=function(elem){var width=elem.offsetWidth,height=elem.offsetHeight;return(width===0&&height===0)||(!jQuery.support.reliableHiddenOffsets&&((elem.style&&elem.style.display)||jQuery.css(elem,"display"))==="none")};jQuery.expr.filters.visible=function(elem){return !jQuery.expr.filters.hidden(elem)}}jQuery.each({margin:"",padding:"",border:"Width"},function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i,parts=typeof value==="string"?value.split(" "):[value],expanded={};for(i=0;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0]}return expanded}}});var r20=/%20/g,rbracket=/\[\]$/,rCRLF=/\r?\n/g,rhash=/#.*$/,rheaders=/^(.*?):[ \t]*([^\r\n]*)\r?$/mg,rinput=/^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,rlocalProtocol=/^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,rquery=/\?/,rscript=/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,rselectTextarea=/^(?:select|textarea)/i,rspacesAjax=/\s+/,rts=/([?&])_=[^&]*/,rurl=/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+))?)?/,_load=jQuery.fn.load,prefilters={},transports={},ajaxLocation,ajaxLocParts,allTypes=["*/"]+["*"];try{ajaxLocation=location.href}catch(e){ajaxLocation=document.createElement("a");ajaxLocation.href="";ajaxLocation=ajaxLocation.href}ajaxLocParts=rurl.exec(ajaxLocation.toLowerCase())||[];function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*"}if(jQuery.isFunction(func)){var dataTypes=dataTypeExpression.toLowerCase().split(rspacesAjax),i=0,length=dataTypes.length,dataType,list,placeBefore;for(;i<length;i++){dataType=dataTypes[i];placeBefore=/^\+/.test(dataType);if(placeBefore){dataType=dataType.substr(1)||"*"}list=structure[dataType]=structure[dataType]||[];list[placeBefore?"unshift":"push"](func)}}}}function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,dataType,inspected){dataType=dataType||options.dataTypes[0];inspected=inspected||{};inspected[dataType]=true;var list=structure[dataType],i=0,length=list?list.length:0,executeOnly=(structure===prefilters),selection;for(;i<length&&(executeOnly||!selection);i++){selection=list[i](options,originalOptions,jqXHR);if(typeof selection==="string"){if(!executeOnly||inspected[selection]){selection=undefined}else{options.dataTypes.unshift(selection);selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,selection,inspected)}}}if((executeOnly||!selection)&&!inspected["*"]){selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,"*",inspected)}return selection}function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:(deep||(deep={})))[key]=src[key]}}if(deep){jQuery.extend(true,target,deep)}}jQuery.fn.extend({load:function(url,params,callback){if(typeof url!=="string"&&_load){return _load.apply(this,arguments)}else{if(!this.length){return this}}var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off)}var type="GET";if(params){if(jQuery.isFunction(params)){callback=params;params=undefined}else{if(typeof params==="object"){params=jQuery.param(params,jQuery.ajaxSettings.traditional);type="POST"}}}var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(jqXHR,status,responseText){responseText=jqXHR.responseText;if(jqXHR.isResolved()){jqXHR.done(function(r){responseText=r});self.html(selector?jQuery("<div>").append(responseText.replace(rscript,"")).find(selector):responseText)}if(callback){self.each(callback,[responseText,status,jqXHR])}}});return this},serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?jQuery.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||rselectTextarea.test(this.nodeName)||rinput.test(this.type))}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:jQuery.isArray(val)?jQuery.map(val,function(val,i){return{name:elem.name,value:val.replace(rCRLF,"\r\n")}}):{name:elem.name,value:val.replace(rCRLF,"\r\n")}}).get()}});jQuery.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),function(i,o){jQuery.fn[o]=function(f){return this.on(o,f)}});jQuery.each(["get","post"],function(i,method){jQuery[method]=function(url,data,callback,type){if(jQuery.isFunction(data)){type=type||callback;callback=data;data=undefined}return jQuery.ajax({type:method,url:url,data:data,success:callback,dataType:type})}});jQuery.extend({getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script")},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},ajaxSetup:function(target,settings){if(settings){ajaxExtend(target,jQuery.ajaxSettings)}else{settings=target;target=jQuery.ajaxSettings}ajaxExtend(target,settings);return target},ajaxSettings:{url:ajaxLocation,isLocal:rlocalProtocol.test(ajaxLocParts[1]),global:true,type:"GET",contentType:"application/x-www-form-urlencoded; charset=UTF-8",processData:true,async:true,accepts:{xml:"application/xml, text/xml",html:"text/html",text:"text/plain",json:"application/json, text/javascript","*":allTypes},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText"},converters:{"* text":window.String,"text html":true,"text json":jQuery.parseJSON,"text xml":jQuery.parseXML},flatOptions:{context:true,url:true}},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined}options=options||{};var s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=callbackContext!==s&&(callbackContext.nodeType||callbackContext instanceof jQuery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},ifModifiedKey,requestHeaders={},requestHeadersNames={},responseHeadersString,responseHeaders,transport,timeoutTimer,parts,state=0,fireGlobals,i,jqXHR={readyState:0,setRequestHeader:function(name,value){if(!state){var lname=name.toLowerCase();name=requestHeadersNames[lname]=requestHeadersNames[lname]||name;requestHeaders[name]=value}return this},getAllResponseHeaders:function(){return state===2?responseHeadersString:null},getResponseHeader:function(key){var match;if(state===2){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()]=match[2]}}match=responseHeaders[key.toLowerCase()]}return match===undefined?null:match},overrideMimeType:function(type){if(!state){s.mimeType=type}return this},abort:function(statusText){statusText=statusText||"abort";if(transport){transport.abort(statusText)}done(0,statusText);return this}};function done(status,nativeStatusText,responses,headers){if(state===2){return }state=2;if(timeoutTimer){clearTimeout(timeoutTimer)}transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;var isSuccess,success,error,statusText=nativeStatusText,response=responses?ajaxHandleResponses(s,jqXHR,responses):undefined,lastModified,etag;if(status>=200&&status<300||status===304){if(s.ifModified){if((lastModified=jqXHR.getResponseHeader("Last-Modified"))){jQuery.lastModified[ifModifiedKey]=lastModified}if((etag=jqXHR.getResponseHeader("Etag"))){jQuery.etag[ifModifiedKey]=etag}}if(status===304){statusText="notmodified";isSuccess=true}else{try{success=ajaxConvert(s,response);statusText="success";isSuccess=true}catch(e){statusText="parsererror";error=e}}}else{error=statusText;if(!statusText||status){statusText="error";if(status<0){status=0}}}jqXHR.status=status;jqXHR.statusText=""+(nativeStatusText||statusText);if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR])}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error])}jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger("ajax"+(isSuccess?"Success":"Error"),[jqXHR,s,isSuccess?success:error])}completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!(--jQuery.active)){jQuery.event.trigger("ajaxStop")}}}deferred.promise(jqXHR);jqXHR.success=jqXHR.done;jqXHR.error=jqXHR.fail;jqXHR.complete=completeDeferred.add;jqXHR.statusCode=function(map){if(map){var tmp;if(state<2){for(tmp in map){statusCode[tmp]=[statusCode[tmp],map[tmp]]}}else{tmp=map[jqXHR.status];jqXHR.then(tmp,tmp)}}return this};s.url=((url||s.url)+"").replace(rhash,"").replace(rprotocol,ajaxLocParts[1]+"//");s.dataTypes=jQuery.trim(s.dataType||"*").toLowerCase().split(rspacesAjax);if(s.crossDomain==null){parts=rurl.exec(s.url.toLowerCase());s.crossDomain=!!(parts&&(parts[1]!=ajaxLocParts[1]||parts[2]!=ajaxLocParts[2]||(parts[3]||(parts[1]==="http:"?80:443))!=(ajaxLocParts[3]||(ajaxLocParts[1]==="http:"?80:443))))}if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional)}inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(state===2){return false}fireGlobals=s.global;s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart")}if(!s.hasContent){if(s.data){s.url+=(rquery.test(s.url)?"&":"?")+s.data;delete s.data}ifModifiedKey=s.url;if(s.cache===false){var ts=jQuery.now(),ret=s.url.replace(rts,"$1_="+ts);s.url=ret+((ret===s.url)?(rquery.test(s.url)?"&":"?")+"_="+ts:"")}}if(s.data&&s.hasContent&&s.contentType!==false||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType)}if(s.ifModified){ifModifiedKey=ifModifiedKey||s.url;if(jQuery.lastModified[ifModifiedKey]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[ifModifiedKey])}if(jQuery.etag[ifModifiedKey]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[ifModifiedKey])}}jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i])}if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===false||state===2)){jqXHR.abort();return false}for(i in {success:1,error:1,complete:1}){jqXHR[i](s[i])}transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport")}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s])}if(s.async&&s.timeout>0){timeoutTimer=setTimeout(function(){jqXHR.abort("timeout")},s.timeout)}try{state=1;transport.send(requestHeaders,done)}catch(e){if(state<2){done(-1,e)}else{throw e}}}return jqXHR},param:function(a,traditional){var s=[],add=function(key,value){value=jQuery.isFunction(value)?value():value;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value)};if(traditional===undefined){traditional=jQuery.ajaxSettings.traditional}if(jQuery.isArray(a)||(a.jquery&&!jQuery.isPlainObject(a))){jQuery.each(a,function(){add(this.name,this.value)})}else{for(var prefix in a){buildParams(prefix,a[prefix],traditional,add)}}return s.join("&").replace(r20,"+")}});function buildParams(prefix,obj,traditional,add){if(jQuery.isArray(obj)){jQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v)}else{buildParams(prefix+"["+(typeof v==="object"?i:"")+"]",v,traditional,add)}})}else{if(!traditional&&jQuery.type(obj)==="object"){for(var name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add)}}else{add(prefix,obj)}}}jQuery.extend({active:0,lastModified:{},etag:{}});function ajaxHandleResponses(s,jqXHR,responses){var contents=s.contents,dataTypes=s.dataTypes,responseFields=s.responseFields,ct,type,finalDataType,firstDataType;for(type in responseFields){if(type in responses){jqXHR[responseFields[type]]=responses[type]}}while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("content-type")}}if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break}}}if(dataTypes[0] in responses){finalDataType=dataTypes[0]}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break}if(!firstDataType){firstDataType=type}}finalDataType=finalDataType||firstDataType}if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType)}return responses[finalDataType]}}function ajaxConvert(s,response){if(s.dataFilter){response=s.dataFilter(response,s.dataType)}var dataTypes=s.dataTypes,converters={},i,key,length=dataTypes.length,tmp,current=dataTypes[0],prev,conversion,conv,conv1,conv2;for(i=1;i<length;i++){if(i===1){for(key in s.converters){if(typeof key==="string"){converters[key.toLowerCase()]=s.converters[key]}}}prev=current;current=dataTypes[i];if(current==="*"){current=prev}else{if(prev!=="*"&&prev!==current){conversion=prev+" "+current;conv=converters[conversion]||converters["* "+current];if(!conv){conv2=undefined;for(conv1 in converters){tmp=conv1.split(" ");if(tmp[0]===prev||tmp[0]==="*"){conv2=converters[tmp[1]+" "+current];if(conv2){conv1=converters[conv1];if(conv1===true){conv=conv2}else{if(conv2===true){conv=conv1}}break}}}}if(!(conv||conv2)){jQuery.error("No conversion from "+conversion.replace(" "," to "))}if(conv!==true){response=conv?conv(response):conv2(conv1(response))}}}}return response}var jsc=jQuery.now(),jsre=/(\=)\?(&|$)|\?\?/i;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){return jQuery.expando+"_"+(jsc++)}});jQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,jqXHR){var inspectData=(typeof s.data==="string")&&/^application\/x\-www\-form\-urlencoded/.test(s.contentType);if(s.dataTypes[0]==="jsonp"||s.jsonp!==false&&(jsre.test(s.url)||inspectData&&jsre.test(s.data))){var responseContainer,jsonpCallback=s.jsonpCallback=jQuery.isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback,previous=window[jsonpCallback],url=s.url,data=s.data,replace="$1"+jsonpCallback+"$2";if(s.jsonp!==false){url=url.replace(jsre,replace);if(s.url===url){if(inspectData){data=data.replace(jsre,replace)}if(s.data===data){url+=(/\?/.test(url)?"&":"?")+s.jsonp+"="+jsonpCallback}}}s.url=url;s.data=data;window[jsonpCallback]=function(response){responseContainer=[response]};jqXHR.always(function(){window[jsonpCallback]=previous;if(responseContainer&&jQuery.isFunction(previous)){window[jsonpCallback](responseContainer[0])}});s.converters["script json"]=function(){if(!responseContainer){jQuery.error(jsonpCallback+" was not called")}return responseContainer[0]};s.dataTypes[0]="json";return"script"}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/javascript|ecmascript/},converters:{"text script":function(text){jQuery.globalEval(text);return text}}});jQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=false}if(s.crossDomain){s.type="GET";s.global=false}});jQuery.ajaxTransport("script",function(s){if(s.crossDomain){var script,head=document.head||document.getElementsByTagName("head")[0]||document.documentElement;return{send:function(_,callback){script=document.createElement("script");script.async="async";if(s.scriptCharset){script.charset=s.scriptCharset}script.src=s.url;script.onload=script.onreadystatechange=function(_,isAbort){if(isAbort||!script.readyState||/loaded|complete/.test(script.readyState)){script.onload=script.onreadystatechange=null;if(head&&script.parentNode){head.removeChild(script)}script=undefined;if(!isAbort){callback(200,"success")}}};head.insertBefore(script,head.firstChild)},abort:function(){if(script){script.onload(0,1)}}}}});var xhrOnUnloadAbort=window.ActiveXObject?function(){for(var key in xhrCallbacks){xhrCallbacks[key](0,1)}}:false,xhrId=0,xhrCallbacks;function createStandardXHR(){try{return new window.XMLHttpRequest()}catch(e){}}function createActiveXHR(){try{return new window.ActiveXObject("Microsoft.XMLHTTP")}catch(e){}}jQuery.ajaxSettings.xhr=window.ActiveXObject?function(){return !this.isLocal&&createStandardXHR()||createActiveXHR()}:createStandardXHR;(function(xhr){jQuery.extend(jQuery.support,{ajax:!!xhr,cors:!!xhr&&("withCredentials" in xhr)})})(jQuery.ajaxSettings.xhr());if(jQuery.support.ajax){jQuery.ajaxTransport(function(s){if(!s.crossDomain||jQuery.support.cors){var callback;return{send:function(headers,complete){var xhr=s.xhr(),handle,i;if(s.username){xhr.open(s.type,s.url,s.async,s.username,s.password)}else{xhr.open(s.type,s.url,s.async)}if(s.xhrFields){for(i in s.xhrFields){xhr[i]=s.xhrFields[i]}}if(s.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(s.mimeType)}if(!s.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest"}try{for(i in headers){xhr.setRequestHeader(i,headers[i])}}catch(_){}xhr.send((s.hasContent&&s.data)||null);callback=function(_,isAbort){var status,statusText,responseHeaders,responses,xml;try{if(callback&&(isAbort||xhr.readyState===4)){callback=undefined;if(handle){xhr.onreadystatechange=jQuery.noop;if(xhrOnUnloadAbort){delete xhrCallbacks[handle]}}if(isAbort){if(xhr.readyState!==4){xhr.abort()}}else{status=xhr.status;responseHeaders=xhr.getAllResponseHeaders();responses={};xml=xhr.responseXML;if(xml&&xml.documentElement){responses.xml=xml}try{responses.text=xhr.responseText}catch(_){}try{statusText=xhr.statusText}catch(e){statusText=""}if(!status&&s.isLocal&&!s.crossDomain){status=responses.text?200:404}else{if(status===1223){status=204}}}}}catch(firefoxAccessException){if(!isAbort){complete(-1,firefoxAccessException)}}if(responses){complete(status,statusText,responses,responseHeaders)}};if(!s.async||xhr.readyState===4){callback()}else{handle=++xhrId;if(xhrOnUnloadAbort){if(!xhrCallbacks){xhrCallbacks={};jQuery(window).unload(xhrOnUnloadAbort)}xhrCallbacks[handle]=callback}xhr.onreadystatechange=callback}},abort:function(){if(callback){callback(0,1)}}}}})}var elemdisplay={},iframe,iframeDoc,rfxtypes=/^(?:toggle|show|hide)$/,rfxnum=/^([+\-]=)?([\d+.\-]+)([a-z%]*)$/i,timerId,fxAttrs=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]],fxNow;jQuery.fn.extend({show:function(speed,easing,callback){var elem,display;if(speed||speed===0){return this.animate(genFx("show",3),speed,easing,callback)}else{for(var i=0,j=this.length;i<j;i++){elem=this[i];if(elem.style){display=elem.style.display;if(!jQuery._data(elem,"olddisplay")&&display==="none"){display=elem.style.display=""}if((display===""&&jQuery.css(elem,"display")==="none")||!jQuery.contains(elem.ownerDocument.documentElement,elem)){jQuery._data(elem,"olddisplay",defaultDisplay(elem.nodeName))}}}for(i=0;i<j;i++){elem=this[i];if(elem.style){display=elem.style.display;if(display===""||display==="none"){elem.style.display=jQuery._data(elem,"olddisplay")||""}}}return this}},hide:function(speed,easing,callback){if(speed||speed===0){return this.animate(genFx("hide",3),speed,easing,callback)}else{var elem,display,i=0,j=this.length;for(;i<j;i++){elem=this[i];if(elem.style){display=jQuery.css(elem,"display");if(display!=="none"&&!jQuery._data(elem,"olddisplay")){jQuery._data(elem,"olddisplay",display)}}}for(i=0;i<j;i++){if(this[i].style){this[i].style.display="none"}}return this}},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2,callback){var bool=typeof fn==="boolean";if(jQuery.isFunction(fn)&&jQuery.isFunction(fn2)){this._toggle.apply(this,arguments)}else{if(fn==null||bool){this.each(function(){var state=bool?fn:jQuery(this).is(":hidden");jQuery(this)[state?"show":"hide"]()})}else{this.animate(genFx("toggle",3),fn,fn2,callback)}}return this},fadeTo:function(speed,to,easing,callback){return this.filter(":hidden").css("opacity",0).show().end().animate({opacity:to},speed,easing,callback)},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);if(jQuery.isEmptyObject(prop)){return this.each(optall.complete,[false])}prop=jQuery.extend({},prop);function doAnimation(){if(optall.queue===false){jQuery._mark(this)}var opt=jQuery.extend({},optall),isElement=this.nodeType===1,hidden=isElement&&jQuery(this).is(":hidden"),name,val,p,e,hooks,replace,parts,start,end,unit,method;opt.animatedProperties={};for(p in prop){name=jQuery.camelCase(p);if(p!==name){prop[name]=prop[p];delete prop[p]}if((hooks=jQuery.cssHooks[name])&&"expand" in hooks){replace=hooks.expand(prop[name]);delete prop[name];for(p in replace){if(!(p in prop)){prop[p]=replace[p]}}}}for(name in prop){val=prop[name];if(jQuery.isArray(val)){opt.animatedProperties[name]=val[1];val=prop[name]=val[0]}else{opt.animatedProperties[name]=opt.specialEasing&&opt.specialEasing[name]||opt.easing||"swing"}if(val==="hide"&&hidden||val==="show"&&!hidden){return opt.complete.call(this)}if(isElement&&(name==="height"||name==="width")){opt.overflow=[this.style.overflow,this.style.overflowX,this.style.overflowY];if(jQuery.css(this,"display")==="inline"&&jQuery.css(this,"float")==="none"){if(!jQuery.support.inlineBlockNeedsLayout||defaultDisplay(this.nodeName)==="inline"){this.style.display="inline-block"}else{this.style.zoom=1}}}}if(opt.overflow!=null){this.style.overflow="hidden"}for(p in prop){e=new jQuery.fx(this,opt,p);val=prop[p];if(rfxtypes.test(val)){method=jQuery._data(this,"toggle"+p)||(val==="toggle"?hidden?"show":"hide":0);if(method){jQuery._data(this,"toggle"+p,method==="show"?"hide":"show");e[method]()}else{e[val]()}}else{parts=rfxnum.exec(val);start=e.cur();if(parts){end=parseFloat(parts[2]);unit=parts[3]||(jQuery.cssNumber[p]?"":"px");if(unit!=="px"){jQuery.style(this,p,(end||1)+unit);start=((end||1)/e.cur())*start;jQuery.style(this,p,start+unit)}if(parts[1]){end=((parts[1]==="-="?-1:1)*end)+start}e.custom(start,end,unit)}else{e.custom(start,val,"")}}}return true}return optall.queue===false?this.each(doAnimation):this.queue(optall.queue,doAnimation)},stop:function(type,clearQueue,gotoEnd){if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined}if(clearQueue&&type!==false){this.queue(type||"fx",[])}return this.each(function(){var index,hadTimers=false,timers=jQuery.timers,data=jQuery._data(this);if(!gotoEnd){jQuery._unmark(true,this)}function stopQueue(elem,data,index){var hooks=data[index];jQuery.removeData(elem,index,true);hooks.stop(gotoEnd)}if(type==null){for(index in data){if(data[index]&&data[index].stop&&index.indexOf(".run")===index.length-4){stopQueue(this,data,index)}}}else{if(data[index=type+".run"]&&data[index].stop){stopQueue(this,data,index)}}for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){if(gotoEnd){timers[index](true)}else{timers[index].saveState()}hadTimers=true;timers.splice(index,1)}}if(!(gotoEnd&&hadTimers)){jQuery.dequeue(this,type)}})}});function createFxNow(){setTimeout(clearFxNow,0);return(fxNow=jQuery.now())}function clearFxNow(){fxNow=undefined}function genFx(type,num){var obj={};jQuery.each(fxAttrs.concat.apply([],fxAttrs.slice(0,num)),function(){obj[this]=type});return obj}jQuery.each({slideDown:genFx("show",1),slideUp:genFx("hide",1),slideToggle:genFx("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback)}});jQuery.extend({speed:function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!jQuery.isFunction(easing)&&easing};opt.duration=jQuery.fx.off?0:typeof opt.duration==="number"?opt.duration:opt.duration in jQuery.fx.speeds?jQuery.fx.speeds[opt.duration]:jQuery.fx.speeds._default;if(opt.queue==null||opt.queue===true){opt.queue="fx"}opt.old=opt.complete;opt.complete=function(noUnmark){if(jQuery.isFunction(opt.old)){opt.old.call(this)}if(opt.queue){jQuery.dequeue(this,opt.queue)}else{if(noUnmark!==false){jQuery._unmark(this)}}};return opt},easing:{linear:function(p){return p},swing:function(p){return(-Math.cos(p*Math.PI)/2)+0.5}},timers:[],fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;options.orig=options.orig||{}}});jQuery.fx.prototype={update:function(){if(this.options.step){this.options.step.call(this.elem,this.now,this)}(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this)},cur:function(){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null)){return this.elem[this.prop]}var parsed,r=jQuery.css(this.elem,this.prop);return isNaN(parsed=parseFloat(r))?!r||r==="auto"?0:r:parsed},custom:function(from,to,unit){var self=this,fx=jQuery.fx;this.startTime=fxNow||createFxNow();this.end=to;this.now=this.start=from;this.pos=this.state=0;this.unit=unit||this.unit||(jQuery.cssNumber[this.prop]?"":"px");function t(gotoEnd){return self.step(gotoEnd)}t.queue=this.options.queue;t.elem=this.elem;t.saveState=function(){if(jQuery._data(self.elem,"fxshow"+self.prop)===undefined){if(self.options.hide){jQuery._data(self.elem,"fxshow"+self.prop,self.start)}else{if(self.options.show){jQuery._data(self.elem,"fxshow"+self.prop,self.end)}}}};if(t()&&jQuery.timers.push(t)&&!timerId){timerId=setInterval(fx.tick,fx.interval)}},show:function(){var dataShow=jQuery._data(this.elem,"fxshow"+this.prop);this.options.orig[this.prop]=dataShow||jQuery.style(this.elem,this.prop);this.options.show=true;if(dataShow!==undefined){this.custom(this.cur(),dataShow)}else{this.custom(this.prop==="width"||this.prop==="height"?1:0,this.cur())}jQuery(this.elem).show()},hide:function(){this.options.orig[this.prop]=jQuery._data(this.elem,"fxshow"+this.prop)||jQuery.style(this.elem,this.prop);this.options.hide=true;this.custom(this.cur(),0)},step:function(gotoEnd){var p,n,complete,t=fxNow||createFxNow(),done=true,elem=this.elem,options=this.options;if(gotoEnd||t>=options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();options.animatedProperties[this.prop]=true;for(p in options.animatedProperties){if(options.animatedProperties[p]!==true){done=false}}if(done){if(options.overflow!=null&&!jQuery.support.shrinkWrapBlocks){jQuery.each(["","X","Y"],function(index,value){elem.style["overflow"+value]=options.overflow[index]})}if(options.hide){jQuery(elem).hide()}if(options.hide||options.show){for(p in options.animatedProperties){jQuery.style(elem,p,options.orig[p]);jQuery.removeData(elem,"fxshow"+p,true);jQuery.removeData(elem,"toggle"+p,true)}}complete=options.complete;if(complete){options.complete=false;complete.call(elem)}}return false}else{if(options.duration==Infinity){this.now=t}else{n=t-this.startTime;this.state=n/options.duration;this.pos=jQuery.easing[options.animatedProperties[this.prop]](this.state,n,0,1,options.duration);this.now=this.start+((this.end-this.start)*this.pos)}this.update()}return true}};jQuery.extend(jQuery.fx,{tick:function(){var timer,timers=jQuery.timers,i=0;for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1)}}if(!timers.length){jQuery.fx.stop()}},interval:13,stop:function(){clearInterval(timerId);timerId=null},speeds:{slow:600,fast:200,_default:400},step:{opacity:function(fx){jQuery.style(fx.elem,"opacity",fx.now)},_default:function(fx){if(fx.elem.style&&fx.elem.style[fx.prop]!=null){fx.elem.style[fx.prop]=fx.now+fx.unit}else{fx.elem[fx.prop]=fx.now}}}});jQuery.each(fxAttrs.concat.apply([],fxAttrs),function(i,prop){if(prop.indexOf("margin")){jQuery.fx.step[prop]=function(fx){jQuery.style(fx.elem,prop,Math.max(0,fx.now)+fx.unit)}}});if(jQuery.expr&&jQuery.expr.filters){jQuery.expr.filters.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem}).length}}function defaultDisplay(nodeName){if(!elemdisplay[nodeName]){var body=document.body,elem=jQuery("<"+nodeName+">").appendTo(body),display=elem.css("display");elem.remove();if(display==="none"||display===""){if(!iframe){iframe=document.createElement("iframe");iframe.frameBorder=iframe.width=iframe.height=0}body.appendChild(iframe);if(!iframeDoc||!iframe.createElement){iframeDoc=(iframe.contentWindow||iframe.contentDocument).document;iframeDoc.write((jQuery.support.boxModel?"<!doctype html>":"")+"<html><body>");iframeDoc.close()}elem=iframeDoc.createElement(nodeName);iframeDoc.body.appendChild(elem);display=jQuery.css(elem,"display");body.removeChild(iframe)}elemdisplay[nodeName]=display}return elemdisplay[nodeName]}var getOffset,rtable=/^t(?:able|d|h)$/i,rroot=/^(?:body|html)$/i;if("getBoundingClientRect" in document.documentElement){getOffset=function(elem,doc,docElem,box){try{box=elem.getBoundingClientRect()}catch(e){}if(!box||!jQuery.contains(docElem,elem)){return box?{top:box.top,left:box.left}:{top:0,left:0}}var body=doc.body,win=getWindow(doc),clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,scrollTop=win.pageYOffset||jQuery.support.boxModel&&docElem.scrollTop||body.scrollTop,scrollLeft=win.pageXOffset||jQuery.support.boxModel&&docElem.scrollLeft||body.scrollLeft,top=box.top+scrollTop-clientTop,left=box.left+scrollLeft-clientLeft;return{top:top,left:left}}}else{getOffset=function(elem,doc,docElem){var computedStyle,offsetParent=elem.offsetParent,prevOffsetParent=elem,body=doc.body,defaultView=doc.defaultView,prevComputedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle,top=elem.offsetTop,left=elem.offsetLeft;while((elem=elem.parentNode)&&elem!==body&&elem!==docElem){if(jQuery.support.fixedPosition&&prevComputedStyle.position==="fixed"){break}computedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle;top-=elem.scrollTop;left-=elem.scrollLeft;if(elem===offsetParent){top+=elem.offsetTop;left+=elem.offsetLeft;if(jQuery.support.doesNotAddBorder&&!(jQuery.support.doesAddBorderForTableAndCells&&rtable.test(elem.nodeName))){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0}prevOffsetParent=offsetParent;offsetParent=elem.offsetParent}if(jQuery.support.subtractsBorderForOverflowNotVisible&&computedStyle.overflow!=="visible"){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0}prevComputedStyle=computedStyle}if(prevComputedStyle.position==="relative"||prevComputedStyle.position==="static"){top+=body.offsetTop;left+=body.offsetLeft}if(jQuery.support.fixedPosition&&prevComputedStyle.position==="fixed"){top+=Math.max(docElem.scrollTop,body.scrollTop);left+=Math.max(docElem.scrollLeft,body.scrollLeft)}return{top:top,left:left}}}jQuery.fn.offset=function(options){if(arguments.length){return options===undefined?this:this.each(function(i){jQuery.offset.setOffset(this,options,i)})}var elem=this[0],doc=elem&&elem.ownerDocument;if(!doc){return null}if(elem===doc.body){return jQuery.offset.bodyOffset(elem)}return getOffset(elem,doc,doc.documentElement)};jQuery.offset={bodyOffset:function(body){var top=body.offsetTop,left=body.offsetLeft;if(jQuery.support.doesNotIncludeMarginInBodyOffset){top+=parseFloat(jQuery.css(body,"marginTop"))||0;left+=parseFloat(jQuery.css(body,"marginLeft"))||0}return{top:top,left:left}},setOffset:function(elem,options,i){var position=jQuery.css(elem,"position");if(position==="static"){elem.style.position="relative"}var curElem=jQuery(elem),curOffset=curElem.offset(),curCSSTop=jQuery.css(elem,"top"),curCSSLeft=jQuery.css(elem,"left"),calculatePosition=(position==="absolute"||position==="fixed")&&jQuery.inArray("auto",[curCSSTop,curCSSLeft])>-1,props={},curPosition={},curTop,curLeft;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0}if(jQuery.isFunction(options)){options=options.call(elem,i,curOffset)}if(options.top!=null){props.top=(options.top-curOffset.top)+curTop}if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft}if("using" in options){options.using.call(elem,props)}else{curElem.css(props)}}};jQuery.fn.extend({position:function(){if(!this[0]){return null}var elem=this[0],offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=rroot.test(offsetParent[0].nodeName)?{top:0,left:0}:offsetParent.offset();offset.top-=parseFloat(jQuery.css(elem,"marginTop"))||0;offset.left-=parseFloat(jQuery.css(elem,"marginLeft"))||0;parentOffset.top+=parseFloat(jQuery.css(offsetParent[0],"borderTopWidth"))||0;parentOffset.left+=parseFloat(jQuery.css(offsetParent[0],"borderLeftWidth"))||0;return{top:offset.top-parentOffset.top,left:offset.left-parentOffset.left}},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent||document.body;while(offsetParent&&(!rroot.test(offsetParent.nodeName)&&jQuery.css(offsetParent,"position")==="static")){offsetParent=offsetParent.offsetParent}return offsetParent})}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(method,prop){var top=/Y/.test(prop);jQuery.fn[method]=function(val){return jQuery.access(this,function(elem,method,val){var win=getWindow(elem);if(val===undefined){return win?(prop in win)?win[prop]:jQuery.support.boxModel&&win.document.documentElement[method]||win.document.body[method]:elem[method]}if(win){win.scrollTo(!top?val:jQuery(win).scrollLeft(),top?val:jQuery(win).scrollTop())}else{elem[method]=val}},method,val,arguments.length,null)}});function getWindow(elem){return jQuery.isWindow(elem)?elem:elem.nodeType===9?elem.defaultView||elem.parentWindow:false}jQuery.each({Height:"height",Width:"width"},function(name,type){var clientProp="client"+name,scrollProp="scroll"+name,offsetProp="offset"+name;jQuery.fn["inner"+name]=function(){var elem=this[0];return elem?elem.style?parseFloat(jQuery.css(elem,type,"padding")):this[type]():null};jQuery.fn["outer"+name]=function(margin){var elem=this[0];return elem?elem.style?parseFloat(jQuery.css(elem,type,margin?"margin":"border")):this[type]():null};jQuery.fn[type]=function(value){return jQuery.access(this,function(elem,type,value){var doc,docElemProp,orig,ret;if(jQuery.isWindow(elem)){doc=elem.document;docElemProp=doc.documentElement[clientProp];return jQuery.support.boxModel&&docElemProp||doc.body&&doc.body[clientProp]||docElemProp}if(elem.nodeType===9){doc=elem.documentElement;if(doc[clientProp]>=doc[scrollProp]){return doc[clientProp]}return Math.max(elem.body[scrollProp],doc[scrollProp],elem.body[offsetProp],doc[offsetProp])}if(value===undefined){orig=jQuery.css(elem,type);ret=parseFloat(orig);return jQuery.isNumeric(ret)?ret:orig}jQuery(elem).css(type,value)},type,value,arguments.length,null)}});window.jQuery=window.$=jQuery;if(typeof define==="function"&&define.amd&&define.amd.jQuery){define("jquery",[],function(){return jQuery})}})(window);/*
 * jQuery UI @VERSION
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI
 */
(function($,undefined){$.ui=$.ui||{};if($.ui.version){return }$.extend($.ui,{version:"@VERSION",keyCode:{ALT:18,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,COMMAND:91,COMMAND_LEFT:91,COMMAND_RIGHT:93,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,INSERT:45,LEFT:37,MENU:93,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SHIFT:16,SPACE:32,TAB:9,UP:38,WINDOWS:91}});$.fn.extend({propAttr:$.fn.prop||$.fn.attr,_focus:$.fn.focus,focus:function(delay,fn){return typeof delay==="number"?this.each(function(){var elem=this;setTimeout(function(){$(elem).focus();if(fn){fn.call(elem)}},delay)}):this._focus.apply(this,arguments)},scrollParent:function(){var scrollParent;if(($.browser.msie&&(/(static|relative)/).test(this.css("position")))||(/absolute/).test(this.css("position"))){scrollParent=this.parents().filter(function(){return(/(relative|absolute|fixed)/).test($.curCSS(this,"position",1))&&(/(auto|scroll)/).test($.curCSS(this,"overflow",1)+$.curCSS(this,"overflow-y",1)+$.curCSS(this,"overflow-x",1))}).eq(0)}else{scrollParent=this.parents().filter(function(){return(/(auto|scroll)/).test($.curCSS(this,"overflow",1)+$.curCSS(this,"overflow-y",1)+$.curCSS(this,"overflow-x",1))}).eq(0)}return(/fixed/).test(this.css("position"))||!scrollParent.length?$(document):scrollParent},zIndex:function(zIndex){if(zIndex!==undefined){return this.css("zIndex",zIndex)}if(this.length){var elem=$(this[0]),position,value;while(elem.length&&elem[0]!==document){position=elem.css("position");if(position==="absolute"||position==="relative"||position==="fixed"){value=parseInt(elem.css("zIndex"),10);if(!isNaN(value)&&value!==0){return value}}elem=elem.parent()}}return 0},disableSelection:function(){return this.bind(($.support.selectstart?"selectstart":"mousedown")+".ui-disableSelection",function(event){event.preventDefault()})},enableSelection:function(){return this.unbind(".ui-disableSelection")}});$.each(["Width","Height"],function(i,name){var side=name==="Width"?["Left","Right"]:["Top","Bottom"],type=name.toLowerCase(),orig={innerWidth:$.fn.innerWidth,innerHeight:$.fn.innerHeight,outerWidth:$.fn.outerWidth,outerHeight:$.fn.outerHeight};function reduce(elem,size,border,margin){$.each(side,function(){size-=parseFloat($.curCSS(elem,"padding"+this,true))||0;if(border){size-=parseFloat($.curCSS(elem,"border"+this+"Width",true))||0}if(margin){size-=parseFloat($.curCSS(elem,"margin"+this,true))||0}});return size}$.fn["inner"+name]=function(size){if(size===undefined){return orig["inner"+name].call(this)}return this.each(function(){$(this).css(type,reduce(this,size)+"px")})};$.fn["outer"+name]=function(size,margin){if(typeof size!=="number"){return orig["outer"+name].call(this,size)}return this.each(function(){$(this).css(type,reduce(this,size,true,margin)+"px")})}});function focusable(element,isTabIndexNotNaN){var nodeName=element.nodeName.toLowerCase();if("area"===nodeName){var map=element.parentNode,mapName=map.name,img;if(!element.href||!mapName||map.nodeName.toLowerCase()!=="map"){return false}img=$("img[usemap=#"+mapName+"]")[0];return !!img&&visible(img)}return(/input|select|textarea|button|object/.test(nodeName)?!element.disabled:"a"==nodeName?element.href||isTabIndexNotNaN:isTabIndexNotNaN)&&visible(element)}function visible(element){return !$(element).parents().andSelf().filter(function(){return $.curCSS(this,"visibility")==="hidden"||$.expr.filters.hidden(this)}).length}$.extend($.expr[":"],{data:function(elem,i,match){return !!$.data(elem,match[3])},focusable:function(element){return focusable(element,!isNaN($.attr(element,"tabindex")))},tabbable:function(element){var tabIndex=$.attr(element,"tabindex"),isTabIndexNaN=isNaN(tabIndex);return(isTabIndexNaN||tabIndex>=0)&&focusable(element,!isTabIndexNaN)}});$(function(){var body=document.body,div=body.appendChild(div=document.createElement("div"));div.offsetHeight;$.extend(div.style,{minHeight:"100px",height:"auto",padding:0,borderWidth:0});$.support.minHeight=div.offsetHeight===100;$.support.selectstart="onselectstart" in div;body.removeChild(div).style.display="none"});$.extend($.ui,{plugin:{add:function(module,option,set){var proto=$.ui[module].prototype;for(var i in set){proto.plugins[i]=proto.plugins[i]||[];proto.plugins[i].push([option,set[i]])}},call:function(instance,name,args){var set=instance.plugins[name];if(!set||!instance.element[0].parentNode){return }for(var i=0;i<set.length;i++){if(instance.options[set[i][0]]){set[i][1].apply(instance.element,args)}}}},contains:function(a,b){return document.compareDocumentPosition?a.compareDocumentPosition(b)&16:a!==b&&a.contains(b)},hasScroll:function(el,a){if($(el).css("overflow")==="hidden"){return false}var scroll=(a&&a==="left")?"scrollLeft":"scrollTop",has=false;if(el[scroll]>0){return true}el[scroll]=1;has=(el[scroll]>0);el[scroll]=0;return has},isOverAxis:function(x,reference,size){return(x>reference)&&(x<(reference+size))},isOver:function(y,x,top,left,height,width){return $.ui.isOverAxis(y,top,height)&&$.ui.isOverAxis(x,left,width)}})})(jQuery);/*
 * jQuery UI Widget @VERSION
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Widget
 */
(function($,undefined){if($.cleanData){var _cleanData=$.cleanData;$.cleanData=function(elems){for(var i=0,elem;(elem=elems[i])!=null;i++){try{$(elem).triggerHandler("remove")}catch(e){}}_cleanData(elems)}}else{var _remove=$.fn.remove;$.fn.remove=function(selector,keepData){return this.each(function(){if(!keepData){if(!selector||$.filter(selector,[this]).length){$("*",this).add([this]).each(function(){try{$(this).triggerHandler("remove")}catch(e){}})}}return _remove.call($(this),selector,keepData)})}}$.widget=function(name,base,prototype){var namespace=name.split(".")[0],fullName;name=name.split(".")[1];fullName=namespace+"-"+name;if(!prototype){prototype=base;base=$.Widget}$.expr[":"][fullName]=function(elem){return !!$.data(elem,name)};$[namespace]=$[namespace]||{};$[namespace][name]=function(options,element){if(arguments.length){this._createWidget(options,element)}};var basePrototype=new base();basePrototype.options=$.extend(true,{},basePrototype.options);$[namespace][name].prototype=$.extend(true,basePrototype,{namespace:namespace,widgetName:name,widgetEventPrefix:$[namespace][name].prototype.widgetEventPrefix||name,widgetBaseClass:fullName},prototype);$.widget.bridge(name,$[namespace][name])};$.widget.bridge=function(name,object){$.fn[name]=function(options){var isMethodCall=typeof options==="string",args=Array.prototype.slice.call(arguments,1),returnValue=this;options=!isMethodCall&&args.length?$.extend.apply(null,[true,options].concat(args)):options;if(isMethodCall&&options.charAt(0)==="_"){return returnValue}if(isMethodCall){this.each(function(){var instance=$.data(this,name),methodValue=instance&&$.isFunction(instance[options])?instance[options].apply(instance,args):instance;if(methodValue!==instance&&methodValue!==undefined){returnValue=methodValue;return false}})}else{this.each(function(){var instance=$.data(this,name);if(instance){instance.option(options||{})._init()}else{$.data(this,name,new object(options,this))}})}return returnValue}};$.Widget=function(options,element){if(arguments.length){this._createWidget(options,element)}};$.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",options:{disabled:false},_createWidget:function(options,element){$.data(element,this.widgetName,this);this.element=$(element);this.options=$.extend(true,{},this.options,this._getCreateOptions(),options);var self=this;this.element.bind("remove."+this.widgetName,function(){self.destroy()});this._create();this._trigger("create");this._init()},_getCreateOptions:function(){return $.metadata&&$.metadata.get(this.element[0])[this.widgetName]},_create:function(){},_init:function(){},destroy:function(){this.element.unbind("."+this.widgetName).removeData(this.widgetName);this.widget().unbind("."+this.widgetName).removeAttr("aria-disabled").removeClass(this.widgetBaseClass+"-disabled ui-state-disabled")},widget:function(){return this.element},option:function(key,value){var options=key;if(arguments.length===0){return $.extend({},this.options)}if(typeof key==="string"){if(value===undefined){return this.options[key]}options={};options[key]=value}this._setOptions(options);return this},_setOptions:function(options){var self=this;$.each(options,function(key,value){self._setOption(key,value)});return this},_setOption:function(key,value){this.options[key]=value;if(key==="disabled"){this.widget()[value?"addClass":"removeClass"](this.widgetBaseClass+"-disabled ui-state-disabled").attr("aria-disabled",value)}return this},enable:function(){return this._setOption("disabled",false)},disable:function(){return this._setOption("disabled",true)},_trigger:function(type,event,data){var prop,orig,callback=this.options[type];data=data||{};event=$.Event(event);event.type=(type===this.widgetEventPrefix?type:this.widgetEventPrefix+type).toLowerCase();event.target=this.element[0];orig=event.originalEvent;if(orig){for(prop in orig){if(!(prop in event)){event[prop]=orig[prop]}}}this.element.trigger(event,data);return !($.isFunction(callback)&&callback.call(this.element[0],event,data)===false||event.isDefaultPrevented())}}})(jQuery);/*
 * jQuery UI Mouse @VERSION
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Mouse
 *
 * Depends:
 *	jquery.ui.widget.js
 */
(function($,undefined){var mouseHandled=false;$(document).mouseup(function(e){mouseHandled=false});$.widget("ui.mouse",{options:{cancel:":input,option",distance:1,delay:0},_mouseInit:function(){var self=this;this.element.bind("mousedown."+this.widgetName,function(event){return self._mouseDown(event)}).bind("click."+this.widgetName,function(event){if(true===$.data(event.target,self.widgetName+".preventClickEvent")){$.removeData(event.target,self.widgetName+".preventClickEvent");event.stopImmediatePropagation();return false}});this.started=false},_mouseDestroy:function(){this.element.unbind("."+this.widgetName)},_mouseDown:function(event){if(mouseHandled){return }(this._mouseStarted&&this._mouseUp(event));this._mouseDownEvent=event;var self=this,btnIsLeft=(event.which==1),elIsCancel=(typeof this.options.cancel=="string"&&event.target.nodeName?$(event.target).closest(this.options.cancel).length:false);if(!btnIsLeft||elIsCancel||!this._mouseCapture(event)){return true}this.mouseDelayMet=!this.options.delay;if(!this.mouseDelayMet){this._mouseDelayTimer=setTimeout(function(){self.mouseDelayMet=true},this.options.delay)}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(event)!==false);if(!this._mouseStarted){event.preventDefault();return true}}if(true===$.data(event.target,this.widgetName+".preventClickEvent")){$.removeData(event.target,this.widgetName+".preventClickEvent")}this._mouseMoveDelegate=function(event){return self._mouseMove(event)};this._mouseUpDelegate=function(event){return self._mouseUp(event)};$(document).bind("mousemove."+this.widgetName,this._mouseMoveDelegate).bind("mouseup."+this.widgetName,this._mouseUpDelegate);event.preventDefault();mouseHandled=true;return true},_mouseMove:function(event){if($.browser.msie&&!(document.documentMode>=9)&&!event.button){return this._mouseUp(event)}if(this._mouseStarted){this._mouseDrag(event);return event.preventDefault()}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(this._mouseDownEvent,event)!==false);(this._mouseStarted?this._mouseDrag(event):this._mouseUp(event))}return !this._mouseStarted},_mouseUp:function(event){$(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate);if(this._mouseStarted){this._mouseStarted=false;if(event.target==this._mouseDownEvent.target){$.data(event.target,this.widgetName+".preventClickEvent",true)}this._mouseStop(event)}return false},_mouseDistanceMet:function(event){return(Math.max(Math.abs(this._mouseDownEvent.pageX-event.pageX),Math.abs(this._mouseDownEvent.pageY-event.pageY))>=this.options.distance)},_mouseDelayMet:function(event){return this.mouseDelayMet},_mouseStart:function(event){},_mouseDrag:function(event){},_mouseStop:function(event){},_mouseCapture:function(event){return true}})})(jQuery);(function($,undefined){$.ui=$.ui||{};var horizontalPositions=/left|center|right/,verticalPositions=/top|center|bottom/,center="center",support={},_position=$.fn.position,_offset=$.fn.offset;$.fn.position=function(options){if(!options||!options.of){return _position.apply(this,arguments)}options=$.extend({},options);var target=$(options.of),targetElem=target[0],collision=(options.collision||"flip").split(" "),offset=options.offset?options.offset.split(" "):[0,0],targetWidth,targetHeight,basePosition;if(targetElem.nodeType===9){targetWidth=target.width();targetHeight=target.height();basePosition={top:0,left:0}}else{if(targetElem.setTimeout){targetWidth=target.width();targetHeight=target.height();basePosition={top:target.scrollTop(),left:target.scrollLeft()}}else{if(targetElem.preventDefault){options.at="left top";targetWidth=targetHeight=0;basePosition={top:options.of.pageY,left:options.of.pageX}}else{targetWidth=target.outerWidth();targetHeight=target.outerHeight();basePosition=target.offset()}}}$.each(["my","at"],function(){var pos=(options[this]||"").split(" ");if(pos.length===1){pos=horizontalPositions.test(pos[0])?pos.concat([center]):verticalPositions.test(pos[0])?[center].concat(pos):[center,center]}pos[0]=horizontalPositions.test(pos[0])?pos[0]:center;pos[1]=verticalPositions.test(pos[1])?pos[1]:center;options[this]=pos});if(collision.length===1){collision[1]=collision[0]}offset[0]=parseInt(offset[0],10)||0;if(offset.length===1){offset[1]=offset[0]}offset[1]=parseInt(offset[1],10)||0;if(options.at[0]==="right"){basePosition.left+=targetWidth}else{if(options.at[0]===center){basePosition.left+=targetWidth/2}}if(options.at[1]==="bottom"){basePosition.top+=targetHeight}else{if(options.at[1]===center){basePosition.top+=targetHeight/2}}basePosition.left+=offset[0];basePosition.top+=offset[1];return this.each(function(){var elem=$(this),elemWidth=elem.outerWidth(),elemHeight=elem.outerHeight(),marginLeft=parseInt($.curCSS(this,"marginLeft",true))||0,marginTop=parseInt($.curCSS(this,"marginTop",true))||0,collisionWidth=elemWidth+marginLeft+(parseInt($.curCSS(this,"marginRight",true))||0),collisionHeight=elemHeight+marginTop+(parseInt($.curCSS(this,"marginBottom",true))||0),position=$.extend({},basePosition),collisionPosition;if(options.my[0]==="right"){position.left-=elemWidth}else{if(options.my[0]===center){position.left-=elemWidth/2}}if(options.my[1]==="bottom"){position.top-=elemHeight}else{if(options.my[1]===center){position.top-=elemHeight/2}}if(!support.fractions){position.left=Math.round(position.left);position.top=Math.round(position.top)}collisionPosition={left:position.left-marginLeft,top:position.top-marginTop};$.each(["left","top"],function(i,dir){if($.ui.position[collision[i]]){$.ui.position[collision[i]][dir](position,{targetWidth:targetWidth,targetHeight:targetHeight,elemWidth:elemWidth,elemHeight:elemHeight,collisionPosition:collisionPosition,collisionWidth:collisionWidth,collisionHeight:collisionHeight,offset:offset,my:options.my,at:options.at})}});if($.fn.bgiframe){elem.bgiframe()}elem.offset($.extend(position,{using:options.using}))})};$.ui.position={fit:{left:function(position,data){var win=$(window),over=data.collisionPosition.left+data.collisionWidth-win.width()-win.scrollLeft();position.left=over>0?position.left-over:Math.max(position.left-data.collisionPosition.left,position.left)},top:function(position,data){var win=$(window),over=data.collisionPosition.top+data.collisionHeight-win.height()-win.scrollTop();position.top=over>0?position.top-over:Math.max(position.top-data.collisionPosition.top,position.top)}},flip:{left:function(position,data){if(data.at[0]===center){return }var win=$(window),over=data.collisionPosition.left+data.collisionWidth-win.width()-win.scrollLeft(),myOffset=data.my[0]==="left"?-data.elemWidth:data.my[0]==="right"?data.elemWidth:0,atOffset=data.at[0]==="left"?data.targetWidth:-data.targetWidth,offset=-2*data.offset[0];position.left+=data.collisionPosition.left<0?myOffset+atOffset+offset:over>0?myOffset+atOffset+offset:0},top:function(position,data){if(data.at[1]===center){return }var win=$(window),over=data.collisionPosition.top+data.collisionHeight-win.height()-win.scrollTop(),myOffset=data.my[1]==="top"?-data.elemHeight:data.my[1]==="bottom"?data.elemHeight:0,atOffset=data.at[1]==="top"?data.targetHeight:-data.targetHeight,offset=-2*data.offset[1];position.top+=data.collisionPosition.top<0?myOffset+atOffset+offset:over>0?myOffset+atOffset+offset:0}}};if(!$.offset.setOffset){$.offset.setOffset=function(elem,options){if(/static/.test($.curCSS(elem,"position"))){elem.style.position="relative"}var curElem=$(elem),curOffset=curElem.offset(),curTop=parseInt($.curCSS(elem,"top",true),10)||0,curLeft=parseInt($.curCSS(elem,"left",true),10)||0,props={top:(options.top-curOffset.top)+curTop,left:(options.left-curOffset.left)+curLeft};if("using" in options){options.using.call(elem,props)}else{curElem.css(props)}};$.fn.offset=function(options){var elem=this[0];if(!elem||!elem.ownerDocument){return null}if(options){return this.each(function(){$.offset.setOffset(this,options)})}return _offset.call(this)}}(function(){var body=document.getElementsByTagName("body")[0],div=document.createElement("div"),testElement,testElementParent,testElementStyle,offset,offsetTotal;testElement=document.createElement(body?"div":"body");testElementStyle={visibility:"hidden",width:0,height:0,border:0,margin:0,background:"none"};if(body){$.extend(testElementStyle,{position:"absolute",left:"-1000px",top:"-1000px"})}for(var i in testElementStyle){testElement.style[i]=testElementStyle[i]}testElement.appendChild(div);testElementParent=body||document.documentElement;testElementParent.insertBefore(testElement,testElementParent.firstChild);div.style.cssText="position: absolute; left: 10.7432222px; top: 10.432325px; height: 30px; width: 201px;";offset=$(div).offset(function(_,offset){return offset}).offset();testElement.innerHTML="";testElementParent.removeChild(testElement);offsetTotal=offset.top+offset.left+(body?2000:0);support.fractions=offsetTotal>21&&offsetTotal<22})()}(jQuery));/*
 * Fluid Infusion v1.5
 *
 * Infusion is distributed under the Educational Community License 2.0 and new BSD licenses: 
 * http://wiki.fluidproject.org/display/fluid/Fluid+Licensing
 *
 * For information on copyright, see the individual Infusion source code files: 
 * https://github.com/fluid-project/infusion/
 */
var fluid_1_5=fluid_1_5||{};var fluid=fluid||fluid_1_5;(function($,fluid){fluid.version="Infusion 1.5";fluid.Error=Error;fluid.environment={fluid:fluid};var globalObject=window||{};fluid.singleThreadLocal=function(initFunc){var value=initFunc();return function(){return value}};fluid.threadLocal=fluid.singleThreadLocal;var softFailure=[false];fluid.describeActivity=function(){return[]};fluid.fail=function(message){var args=fluid.makeArray(arguments);var activity=fluid.describeActivity();var topFailure=softFailure[0];if(typeof (topFailure)==="boolean"){fluid.setLogging(true);fluid.log.apply(null,["ASSERTION FAILED: "].concat(args).concat(activity));if(topFailure){throw new Error(message)}else{message.fail()}}else{if(typeof (topFailure)==="function"){topFailure(args,activity)}}};fluid.pushSoftFailure=function(condition){if(typeof (condition)==="boolean"||typeof (condition)==="function"){softFailure.unshift(condition)}else{if(condition===-1){softFailure.shift()}}};fluid.notrycatch=false;fluid.tryCatch=function(tryfun,catchfun,finallyfun){finallyfun=finallyfun||fluid.identity;if(fluid.notrycatch){var togo=tryfun();finallyfun();return togo}else{try{return tryfun()}catch(e){if(catchfun){catchfun(e)}else{throw (e)}}finally{finallyfun()}}};fluid.expect=function(name,members,target){fluid.transform(fluid.makeArray(members),function(key){if(typeof target[key]==="undefined"){fluid.fail(name+" missing required parameter "+key)}})};var logging;fluid.isLogging=function(){return logging};fluid.setLogging=function(enabled){if(typeof enabled==="boolean"){logging=enabled}else{logging=false}};fluid.applyHostFunction=function(obj,func,args){if(func.apply){func.apply(obj,args)}else{var applier=Function.prototype.bind.call(func,obj);applier.apply(obj,args)}};fluid.log=function(message){if(logging){var arg0=fluid.renderTimestamp(new Date())+":  ";var args=[arg0].concat(fluid.makeArray(arguments));var str=args.join("");if(typeof (console)!=="undefined"){if(console.debug){fluid.applyHostFunction(console,console.debug,args)}else{if(typeof (console.log)==="function"){fluid.applyHostFunction(console,console.log,args)}else{console.log(str)}}}else{if(typeof (YAHOO)!=="undefined"){YAHOO.log(str)}else{if(typeof (opera)!=="undefined"){opera.postError(str)}}}}};fluid.identity=function(arg){return arg};fluid.isValue=function(value){return value!==undefined&&value!==null};fluid.isPrimitive=function(value){var valueType=typeof (value);return !value||valueType==="string"||valueType==="boolean"||valueType==="number"||valueType==="function"};fluid.isArrayable=function(totest){return totest&&(totest.jquery||Object.prototype.toString.call(totest)==="[object Array]")};fluid.isDOMNode=function(obj){return obj&&typeof (obj.nodeType)==="number"};fluid.freshContainer=function(tocopy){return fluid.isArrayable(tocopy)?[]:{}};fluid.copy=function(tocopy){if(fluid.isPrimitive(tocopy)){return tocopy}return $.extend(true,fluid.freshContainer(tocopy),tocopy)};fluid.makeArray=function(arg){var togo=[];if(arg!==null&&arg!==undefined){if(fluid.isPrimitive(arg)||typeof (arg.length)!=="number"){togo.push(arg)}else{for(var i=0;i<arg.length;++i){togo[i]=arg[i]}}}return togo};function transformInternal(source,togo,key,args){var transit=source[key];for(var j=0;j<args.length-1;++j){transit=args[j+1](transit,key)}togo[key]=transit}fluid.transform=function(source){var togo=fluid.freshContainer(source);if(fluid.isArrayable(source)){for(var i=0;i<source.length;++i){transformInternal(source,togo,i,arguments)}}else{for(var key in source){transformInternal(source,togo,key,arguments)}}return togo};fluid.each=function(source,func){if(fluid.isArrayable(source)){for(var i=0;i<source.length;++i){func(source[i],i)}}else{for(var key in source){func(source[key],key)}}};fluid.find=function(source,func,deflt){var disp;if(fluid.isArrayable(source)){for(var i=0;i<source.length;++i){disp=func(source[i],i);if(disp!==undefined){return disp}}}else{for(var key in source){disp=func(source[key],key);if(disp!==undefined){return disp}}}return deflt};fluid.accumulate=function(list,fn,arg){for(var i=0;i<list.length;++i){arg=fn(list[i],arg,i)}return arg};fluid.remove_if=function(source,fn){if(fluid.isArrayable(source)){for(var i=0;i<source.length;++i){if(fn(source[i],i)){source.splice(i,1);--i}}}else{for(var key in source){if(fn(source[key],key)){delete source[key]}}}return source};fluid.filterKeys=function(toFilter,keys,exclude){return fluid.remove_if($.extend({},toFilter),function(value,key){return exclude^($.inArray(key,keys)===-1)})};fluid.censorKeys=function(toCensor,keys){return fluid.filterKeys(toCensor,keys,true)};fluid.makeFlatten=function(index){return function(obj){var togo=[];fluid.each(obj,function(value,key){togo.push(arguments[index])});return togo}};fluid.keys=fluid.makeFlatten(1);fluid.values=fluid.makeFlatten(0);fluid.contains=function(obj,value){return obj?fluid.find(obj,function(thisValue,key){if(value===thisValue){return true}}):undefined};fluid.keyForValue=function(obj,value){return fluid.find(obj,function(thisValue,key){if(value===thisValue){return key}})};fluid.findKeyInObject=fluid.keyForValue;fluid.arrayToHash=function(array){var togo={};fluid.each(array,function(el){togo[el]=true});return togo};fluid.clear=function(target){if(fluid.isArrayable(target)){target.length=0}else{for(var i in target){delete target[i]}}};fluid.compareStringLength=function(ascending){return ascending?function(a,b){return a.length-b.length}:function(a,b){return b.length-a.length}};fluid.model={};fluid.VALUE={type:"fluid.marker",value:"VALUE"};fluid.NO_VALUE={type:"fluid.marker",value:"NO_VALUE"};fluid.EXPAND={type:"fluid.marker",value:"EXPAND"};fluid.EXPAND_NOW={type:"fluid.marker",value:"EXPAND_NOW"};fluid.isMarker=function(totest,type){if(!totest||typeof (totest)!=="object"||totest.type!=="fluid.marker"){return false}if(!type){return true}return totest===type};fluid.model.copyModel=function(target,source){fluid.clear(target);$.extend(true,target,source)};fluid.model.parseEL=function(EL){return EL===""?[]:String(EL).split(".")};fluid.model.composePath=function(prefix,suffix){return prefix===""?suffix:(suffix===""?prefix:prefix+"."+suffix)};fluid.model.composeSegments=function(){return fluid.makeArray(arguments).join(".")};fluid.path=fluid.model.composeSegments;fluid.composePath=fluid.model.composePath;fluid.requireDataBinding=function(){fluid.fail("Please include DataBinding.js in order to operate complex model accessor configuration")};fluid.model.setWithStrategy=fluid.model.getWithStrategy=fluid.requireDataBinding;fluid.model.resolvePathSegment=function(root,segment,create,origEnv){if(!origEnv&&root.resolvePathSegment){return root.resolvePathSegment(segment)}if(create&&root[segment]===undefined){return root[segment]={}}return root[segment]};fluid.model.pathToSegments=function(EL,config){var parser=config&&config.parser?config.parser.parse:fluid.model.parseEL;var segs=typeof (EL)==="number"||typeof (EL)==="string"?parser(EL):EL;return segs};fluid.model.accessImpl=function(root,EL,newValue,config,initSegs,returnSegs,traverser){var segs=fluid.model.pathToSegments(EL,config);var initPos=0;if(initSegs){initPos=initSegs.length;segs=initSegs.concat(segs)}var uncess=newValue===fluid.NO_VALUE?0:1;var root=traverser(root,segs,initPos,config,uncess);if(newValue===fluid.NO_VALUE||newValue===fluid.VALUE){return returnSegs?{root:root,segs:segs}:root}else{root[segs[segs.length-1]]=newValue}};fluid.model.accessSimple=function(root,EL,newValue,environment,initSegs,returnSegs){return fluid.model.accessImpl(root,EL,newValue,environment,initSegs,returnSegs,fluid.model.traverseSimple)};fluid.model.traverseSimple=function(root,segs,initPos,environment,uncess){var origEnv=environment;var limit=segs.length-uncess;for(var i=0;i<limit;++i){if(!root){return root}var segment=segs[i];if(environment&&environment[segment]){root=environment[segment]}else{root=fluid.model.resolvePathSegment(root,segment,uncess===1,origEnv)}environment=null}return root};fluid.model.setSimple=function(root,EL,newValue,environment,initSegs){fluid.model.accessSimple(root,EL,newValue,environment,initSegs,false)};fluid.model.getSimple=function(root,EL,environment,initSegs){if(EL===null||EL===undefined||EL.length===0){return root}return fluid.model.accessSimple(root,EL,fluid.NO_VALUE,environment,initSegs,false)};fluid.decodeAccessorArg=function(arg3){return(!arg3||arg3===fluid.model.defaultGetConfig||arg3===fluid.model.defaultSetConfig)?null:(arg3.type==="environment"?arg3.value:undefined)};fluid.set=function(root,EL,newValue,config,initSegs){var env=fluid.decodeAccessorArg(config);if(env===undefined){fluid.model.setWithStrategy(root,EL,newValue,config,initSegs)}else{fluid.model.setSimple(root,EL,newValue,env,initSegs)}};fluid.get=function(root,EL,config,initSegs){var env=fluid.decodeAccessorArg(config);return env===undefined?fluid.model.getWithStrategy(root,EL,config,initSegs):fluid.model.accessImpl(root,EL,fluid.NO_VALUE,env,null,false,fluid.model.traverseSimple)};fluid.model.setBeanValue=fluid.set;fluid.model.getBeanValue=fluid.get;fluid.getGlobalValue=function(path,env){if(path){env=env||fluid.environment;return fluid.get(globalObject,path,{type:"environment",value:env})}};fluid.invokeGlobalFunction=function(functionPath,args,environment){var func=fluid.getGlobalValue(functionPath,environment);if(!func){fluid.fail("Error invoking global function: "+functionPath+" could not be located")}else{return func.apply(null,args||[])}};fluid.registerGlobalFunction=function(functionPath,func,env){env=env||fluid.environment;fluid.set(globalObject,functionPath,func,{type:"environment",value:env})};fluid.setGlobalValue=fluid.registerGlobalFunction;fluid.registerNamespace=function(naimspace,env){env=env||fluid.environment;var existing=fluid.getGlobalValue(naimspace,env);if(!existing){existing={};fluid.setGlobalValue(naimspace,existing,env)}return existing};fluid.dumpEl=fluid.identity;fluid.renderTimestamp=fluid.identity;fluid.registerNamespace("fluid.event");fluid.generateUniquePrefix=function(){return(Math.floor(Math.random()*1000000000000)).toString(36)+"-"};var fluid_prefix=fluid.generateUniquePrefix();var fluid_guid=1;fluid.allocateGuid=function(){return fluid_prefix+(fluid_guid++)};fluid.event.identifyListener=function(listener){if(!listener.$$fluid_guid){listener.$$fluid_guid=fluid.allocateGuid()}return listener.$$fluid_guid};fluid.event.impersonateListener=function(origListener,newListener){fluid.event.identifyListener(origListener);newListener.$$fluid_guid=origListener.$$fluid_guid};fluid.event.mapPriority=function(priority,count){return(priority===null||priority===undefined?-count:(priority==="last"?-Number.MAX_VALUE:(priority==="first"?Number.MAX_VALUE:priority)))};fluid.event.listenerComparator=function(recA,recB){return recB.priority-recA.priority};fluid.event.sortListeners=function(listeners){var togo=[];fluid.each(listeners,function(listener){togo.push(listener)});return togo.sort(fluid.event.listenerComparator)};fluid.event.resolveListener=function(listener){if(listener.globalName){var listenerFunc=fluid.getGlobalValue(listener.globalName);if(!listenerFunc){fluid.fail("Unable to look up name "+listener.globalName+" as a global function")}else{listener=listenerFunc}}return listener};fluid.event.nameEvent=function(that,eventName){return eventName+" of "+fluid.nameComponent(that)};fluid.event.getEventFirer=function(unicast,preventable,name){var listeners;var byId;var sortedListeners;function fireToListeners(listeners,args,wrapper){if(!listeners){return }fluid.log("Firing event "+name+" to list of "+listeners.length+" listeners");for(var i=0;i<listeners.length;++i){var lisrec=listeners[i];lisrec.listener=fluid.event.resolveListener(lisrec.listener);var listener=lisrec.listener;if(lisrec.predicate&&!lisrec.predicate(listener,args)){continue}var value=fluid.tryCatch(function(){var ret=(wrapper?wrapper(listener):listener).apply(null,args);if(preventable&&ret===false){return false}if(unicast){return ret}},function(e){fluid.log("FireEvent received exception "+e.message+" e "+e+" firing to listener "+i);throw (e)});if(value!==undefined){return value}}}var identify=fluid.event.identifyListener;var that;var lazyInit=function(){listeners={};byId={};sortedListeners=[];that.addListener=function(listener,namespace,predicate,priority){if(!listener){return }if(unicast){namespace="unicast"}if(typeof (listener)==="string"){listener={globalName:listener}}var id=identify(listener);namespace=namespace||id;var record={listener:listener,predicate:predicate,namespace:namespace,priority:fluid.event.mapPriority(priority,sortedListeners.length)};listeners[namespace]=byId[id]=record;sortedListeners=fluid.event.sortListeners(listeners)};that.addListener.apply(null,arguments)};that={name:name,typeName:"fluid.event.firer",addListener:function(){lazyInit.apply(null,arguments)},removeListener:function(listener){if(!listeners){return }var namespace;if(typeof (listener)==="string"){namespace=listener;var record=listeners[listener];if(!record){return }listener=record.listener}var id=identify(listener);if(!id){fluid.fail("Cannot remove unregistered listener function ",listener," from event "+that.name)}namespace=namespace||(byId[id]&&byId[id].namespace)||id;delete byId[id];delete listeners[namespace];sortedListeners=fluid.event.sortListeners(listeners)},fireToListeners:function(listeners,args,wrapper){return fireToListeners(listeners,args,wrapper)},fire:function(){return fireToListeners(sortedListeners,arguments)}};return that};fluid.makeEventFirer=fluid.event.getEventFirer;fluid.fireEvent=function(component,path,args){var firer=fluid.get(component,path);if(firer){firer.fire.apply(null,fluid.makeArray(args))}};fluid.event.addListenerToFirer=function(firer,value,namespace,wrapper){wrapper=wrapper||fluid.identity;if(fluid.isArrayable(value)){for(var i=0;i<value.length;++i){fluid.event.addListenerToFirer(firer,value[i],namespace,wrapper)}}else{if(typeof (value)==="function"||typeof (value)==="string"){wrapper(firer).addListener(value,namespace)}else{if(value&&typeof (value)==="object"){wrapper(firer).addListener(value.listener,namespace||value.namespace,value.predicate,value.priority)}}}};fluid.event.resolveListenerRecord=function(records){return{records:records}};fluid.mergeListeners=function(that,events,listeners){fluid.each(listeners,function(value,key){var firer,namespace;if(key.charAt(0)==="{"){if(!fluid.expandOptions){fluid.fail("fluid.expandOptions could not be loaded - please include FluidIoC.js in order to operate IoC-driven event with descriptor "+key)}firer=fluid.expandOptions(key,that)}else{var keydot=key.indexOf(".");if(keydot!==-1){namespace=key.substring(keydot+1);key=key.substring(0,keydot)}if(!events[key]){fluid.fail("Listener registered for event "+key+" which is not defined for this component");events[key]=fluid.makeEventFirer(null,null,fluid.event.nameEvent(that,key))}firer=events[key]}record=fluid.event.resolveListenerRecord(value,that,key);fluid.event.addListenerToFirer(firer,record.records,namespace,record.adderWrapper)})};function initEvents(that,events,pass){fluid.each(events,function(eventSpec,eventKey){var isIoCEvent=eventSpec&&(typeof (eventSpec)!=="string"||eventSpec.charAt(0)==="{");var event;if(isIoCEvent&&pass==="IoC"){if(!fluid.event.resolveEvent){fluid.fail("fluid.event.resolveEvent could not be loaded - please include FluidIoC.js in order to operate IoC-driven event with descriptor ",eventSpec)}else{event=fluid.event.resolveEvent(that,eventKey,eventSpec)}}else{if(pass==="flat"){event=fluid.makeEventFirer(eventSpec==="unicast",eventSpec==="preventable",fluid.event.nameEvent(that,eventKey))}}if(event){that.events[eventKey]=event}})}fluid.instantiateFirers=function(that,options){that.events={};initEvents(that,options.events,"flat");initEvents(that,options.events,"IoC");fluid.mergeListeners(that,that.events,options.listeners)};fluid.mergeListenerPolicy=function(target,source,key){var hasNamespace=key.charAt(0)!=="{"&&key.indexOf(".")!==-1;return hasNamespace?(source?source:target):fluid.makeArray(target).concat(fluid.makeArray(source))};fluid.mergeListenersPolicy=function(target,source){target=target||{};fluid.each(source,function(listeners,key){target[key]=fluid.mergeListenerPolicy(target[key],listeners,key)});return target};var defaultsStore={};var resolveGradesImpl=function(gs,gradeNames){gradeNames=fluid.makeArray(gradeNames);fluid.each(gradeNames,function(gradeName){var options=fluid.rawDefaults(gradeName)||{};gs.gradeHash[gradeName]=true;gs.gradeChain.push(gradeName);gs.optionsChain.push(options);var oGradeNames=fluid.makeArray(options.gradeNames);fluid.each(oGradeNames,function(parent){if(!gs.gradeHash[parent]){resolveGradesImpl(gs,parent)}})});return gs};fluid.resolveGradeStructure=function(defaultName,gradeNames){var gradeStruct={gradeChain:[defaultName],gradeHash:{},optionsChain:[]};return resolveGradesImpl(gradeStruct,gradeNames)};var mergedDefaultsCache={};fluid.gradeNamesToKey=function(gradeNames,defaultName){return defaultName+"|"+fluid.makeArray(gradeNames).sort().join("|")};fluid.resolveGrade=function(defaults,defaultName,gradeNames){var mergeArgs=[defaults];if(gradeNames){var gradeStruct=fluid.resolveGradeStructure(defaultName,gradeNames);mergeArgs=gradeStruct.optionsChain.reverse().concat(mergeArgs).concat({gradeNames:gradeStruct.gradeChain})}var mergePolicy={};for(var i=0;i<mergeArgs.length;++i){mergePolicy=$.extend(true,mergePolicy,mergeArgs[i].mergePolicy)}mergeArgs=[mergePolicy,{}].concat(mergeArgs);var mergedDefaults=fluid.merge.apply(null,mergeArgs);return mergedDefaults};fluid.getGradedDefaults=function(defaults,defaultName,gradeNames){var key=fluid.gradeNamesToKey(gradeNames,defaultName);var mergedDefaults=mergedDefaultsCache[key];if(!mergedDefaults){mergedDefaults=mergedDefaultsCache[key]=fluid.resolveGrade(defaults,defaultName,gradeNames)}return mergedDefaults};fluid.resolveGradedOptions=function(componentName){var defaults=fluid.rawDefaults(componentName);if(!defaults){return defaults}else{return fluid.getGradedDefaults(defaults,componentName,defaults.gradeNames)}};fluid.rawDefaults=function(componentName,options){if(options===undefined){return defaultsStore[componentName]}else{defaultsStore[componentName]=options}};fluid.hasGrade=function(options,gradeName){return !options||!options.gradeNames?false:fluid.contains(options.gradeNames,gradeName)};fluid.defaults=function(){var offset=0;if(typeof arguments[0]==="boolean"){offset=1}var componentName=(offset===0?"":"*.global-")+arguments[offset];var options=arguments[offset+1];if(options===undefined){return fluid.resolveGradedOptions(componentName)}else{if(options&&options.options){fluid.fail("Probable error in options structure for "+componentName+' with option named "options" - perhaps you meant to write these options at top level in fluid.defaults? - ',options)}fluid.rawDefaults(componentName,options);if(fluid.hasGrade(options,"autoInit")){fluid.makeComponent(componentName,fluid.resolveGradedOptions(componentName))}}};fluid.makeComponent=function(componentName,options){if(!options.initFunction||!options.gradeNames){fluid.fail("Cannot autoInit component "+componentName+" which does not have an initFunction and gradeName defined")}var creator=function(){return fluid.initComponent(componentName,arguments)};var existing=fluid.getGlobalValue(componentName);if(existing){$.extend(creator,existing)}fluid.setGlobalValue(componentName,creator)};fluid.makeComponents=function(components,env){fluid.each(components,function(value,key){var options={gradeNames:fluid.makeArray(value).concat(["autoInit"])};fluid.defaults(key,options)})};fluid.defaults("fluid.function",{});fluid.lifecycleFunctions={preInitFunction:true,postInitFunction:true,finalInitFunction:true};fluid.rootMergePolicy=fluid.transform(fluid.lifecycleFunctions,function(){return fluid.mergeListenerPolicy});fluid.defaults("fluid.littleComponent",{initFunction:"fluid.initLittleComponent",mergePolicy:fluid.rootMergePolicy,argumentMap:{options:0}});fluid.defaults("fluid.eventedComponent",{gradeNames:["fluid.littleComponent"],events:{onCreate:null,onAttach:null,onClear:null,onDestroy:null},mergePolicy:{listeners:fluid.mergeListenersPolicy}});fluid.preInitModelComponent=function(that){that.model=that.options.model||{};that.applier=that.options.applier||(fluid.makeChangeApplier?fluid.makeChangeApplier(that.model,that.options.changeApplierOptions):null)};fluid.defaults("fluid.modelComponent",{gradeNames:["fluid.littleComponent"],preInitFunction:{namespace:"preInitModelComponent",listener:"fluid.preInitModelComponent"},mergePolicy:{model:"preserve",applier:"nomerge"}});fluid.nameComponent=function(that){return that?"component with typename "+that.typeName+" and id "+that.id:"[unknown component]"};fluid.guardCircularity=function(seenIds,source,message1,message2){if(source&&source.id){if(!seenIds[source.id]){seenIds[source.id]=source}else{if(seenIds[source.id]===source){fluid.fail("Circularity in options "+message1+" - "+fluid.nameComponent(source)+" has already been seen"+message2)}}}};fluid.mergePolicyIs=function(policy,test){return typeof (policy)==="string"&&$.inArray(test,policy.split(/\s*,\s*/))!==-1};fluid.model.mergeModel=function(target,source,applier){if(!fluid.isPrimitive(target)){var copySource=fluid.copy(source);$.extend(true,source,target);$.extend(true,source,copySource)}return source};function mergeImpl(policy,basePath,target,source,thisPolicy,rec){if(fluid.isTracing){fluid.tracing.pathCount.push(basePath)}if(fluid.mergePolicyIs(thisPolicy,"replace")){fluid.clear(target)}fluid.guardCircularity(rec.seenIds,source,"merging"," when evaluating path "+basePath+' - please protect components from merging using the "nomerge" merge policy');for(var name in source){var path=(basePath?basePath+".":"")+name;var newPolicy=policy&&typeof (policy)!=="string"?policy[path]:policy;var funcPolicy=typeof (newPolicy)==="function";var thisTarget=target[name];var thisSource=source[name];var primitiveTarget=fluid.isPrimitive(thisTarget);if(thisSource!==undefined){if(!funcPolicy&&thisSource!==null&&typeof (thisSource)==="object"&&!fluid.isDOMNode(thisSource)&&!thisSource.jquery&&thisSource!==fluid.VALUE&&!fluid.mergePolicyIs(newPolicy,"preserve")&&!fluid.mergePolicyIs(newPolicy,"nomerge")){if(primitiveTarget){target[name]=thisTarget=fluid.freshContainer(thisSource)}mergeImpl(policy,path,thisTarget,thisSource,newPolicy,rec)}else{if(funcPolicy){target[name]=newPolicy.call(null,thisTarget,thisSource,name)}else{if(!fluid.isValue(thisTarget)||!fluid.mergePolicyIs(newPolicy,"reverse")){target[name]=fluid.isValue(thisTarget)&&fluid.mergePolicyIs(newPolicy,"preserve")?fluid.model.mergeModel(thisTarget,thisSource):thisSource}}}}}return target}fluid.isDefaultValueMergePolicy=function(policy){return typeof (policy)==="string"&&(policy.indexOf(",")===-1&&!/replace|preserve|nomerge|noexpand|reverse/.test(policy))};fluid.applyDefaultValueMergePolicy=function(defaults,merged){var policy=merged.mergePolicy;if(policy&&typeof (policy)!=="string"){for(var key in policy){var elrh=policy[key];if(fluid.isDefaultValueMergePolicy(elrh)){var defaultTarget=fluid.get(defaults,key);var mergedTarget=fluid.get(merged,key);if(defaultTarget===mergedTarget){var defaultSource=fluid.get(defaults,elrh);var mergedSource=fluid.get(merged,elrh);if(defaultSource!==mergedSource){fluid.set(merged,key,mergedSource)}}}}}return merged};fluid.merge=function(policy,target){var path="";for(var i=2;i<arguments.length;++i){var source=arguments[i];if(source!==null&&source!==undefined){mergeImpl(policy,path,target,source,policy?policy[""]:null,{seenIds:{}})}}return target};fluid.transformOptions=function(mergeArgs,transRec){fluid.expect("Options transformation record",["transformer","config"],transRec);var transFunc=fluid.getGlobalValue(transRec.transformer);var togo=fluid.transform(mergeArgs,function(value,key){return key===0?value:transFunc.call(null,value,transRec.config)});return togo};fluid.lastTransformationRecord=function(extraArgs){for(var i=extraArgs.length-1;i>=0;--i){if(extraArgs[i]&&extraArgs[i].transformOptions){return extraArgs[i].transformOptions}}};fluid.mergeComponentOptions=function(that,componentName,userOptions,localOptions){var defaults=fluid.defaults(componentName)||{};var mergePolicy=$.extend({},fluid.rootMergePolicy,defaults.mergePolicy);var defaultGrades=defaults.gradeNames;localOptions=defaultGrades?{}:fluid.copy(fluid.getGradedDefaults({},"",localOptions.gradeNames));var mergeArgs=[mergePolicy,localOptions];var extraArgs;if(fluid.expandComponentOptions){extraArgs=fluid.expandComponentOptions(defaults,userOptions,that)}else{extraArgs=[defaults,userOptions]}var transRec=fluid.lastTransformationRecord(extraArgs);if(transRec){extraArgs=fluid.transformOptions(extraArgs,transRec)}mergeArgs=mergeArgs.concat(extraArgs);var merged=fluid.merge.apply(null,mergeArgs);merged=fluid.applyDefaultValueMergePolicy(defaults,merged);that.options=merged};fluid.COMPONENT_OPTIONS={type:"fluid.marker",value:"COMPONENT_OPTIONS"};fluid.emptySubcomponent=function(options){var that={};options=fluid.makeArray(options);for(var i=0;i<options.length;++i){that[options[i]]=fluid.identity}return that};fluid.computeNickName=function(typeName){var segs=fluid.model.parseEL(typeName);return segs[segs.length-1]};fluid.typeTag=function(name){return name?{typeName:name,id:fluid.allocateGuid()}:null};fluid.typeFount=function(options){var that=fluid.initLittleComponent("fluid.typeFount",options);return fluid.typeTag(that.options.targetTypeName)};fluid.initLittleComponent=function(name,options,localOptions){var that=fluid.typeTag(name);that.nickName=options&&options.nickName?options.nickName:fluid.computeNickName(that.typeName);localOptions=localOptions||{gradeNames:"fluid.littleComponent"};fluid.mergeComponentOptions(that,name,options,localOptions);fluid.initLifecycleFunctions(that);fluid.fireEvent(that.options,"preInitFunction",that);if(fluid.hasGrade(that.options,"fluid.eventedComponent")){fluid.instantiateFirers(that,that.options)}if(!fluid.hasGrade(that.options,"autoInit")){fluid.clearLifecycleFunctions(that.options)}return that};fluid.updateWithDefaultLifecycle=function(key,value,typeName){var funcName=typeName+"."+key.substring(0,key.length-"function".length);var funcVal=fluid.getGlobalValue(funcName);if(typeof (funcVal)==="function"){value=fluid.makeArray(value);var existing=fluid.find(value,function(el){var listener=el.listener||el;if(listener==funcVal||listener==funcName){return true}});if(!existing){value.push(funcVal)}}return value};fluid.initLifecycleFunctions=function(that){var gradeNames=that.options.gradeNames;fluid.each(fluid.lifecycleFunctions,function(func,key){var value=that.options[key];for(var i=gradeNames.length-1;i>=0;--i){if(gradeNames[i]!=="autoInit"){value=fluid.updateWithDefaultLifecycle(key,value,gradeNames[i])}}if(value){that.options[key]=fluid.makeEventFirer(null,null,key);fluid.event.addListenerToFirer(that.options[key],value)}})};fluid.clearLifecycleFunctions=function(options){fluid.each(fluid.lifecycleFunctions,function(value,key){delete options[key]});delete options.initFunction};fluid.diagnoseFailedView=fluid.identity;fluid.makeRootDestroy=function(that){return function(){fluid.fireEvent(that,"events.onClear",[that,"",null]);fluid.fireEvent(that,"events.onDestroy",[that,"",null])}};fluid.initComponent=function(componentName,initArgs){var options=fluid.defaults(componentName);if(!options.gradeNames){fluid.fail("Cannot initialise component "+componentName+" which has no gradeName registered")}var args=[componentName].concat(fluid.makeArray(initArgs));var that=fluid.invokeGlobalFunction(options.initFunction,args);fluid.diagnoseFailedView(componentName,that,options,args);fluid.fireEvent(that.options,"postInitFunction",that);if(fluid.initDependents){fluid.initDependents(that)}fluid.fireEvent(that.options,"finalInitFunction",that);fluid.clearLifecycleFunctions(that.options);that.destroy=fluid.makeRootDestroy(that);fluid.fireEvent(that,"events.onCreate",that);return that.options.returnedPath?fluid.get(that,that.options.returnedPath):that};fluid.initSubcomponentImpl=function(that,entry,args){var togo;if(typeof (entry)!=="function"){var entryType=typeof (entry)==="string"?entry:entry.type;var globDef=fluid.defaults(true,entryType);fluid.merge("reverse",that.options,globDef);togo=entryType==="fluid.emptySubcomponent"?fluid.emptySubcomponent(entry.options):fluid.invokeGlobalFunction(entryType,args)}else{togo=entry.apply(null,args)}var returnedOptions=togo?togo.returnedOptions:null;if(returnedOptions){fluid.merge(that.options.mergePolicy,that.options,returnedOptions);if(returnedOptions.listeners){fluid.mergeListeners(that,that.events,returnedOptions.listeners)}}return togo};fluid.initSubcomponents=function(that,className,args){var entry=that.options[className];if(!entry){return }var entries=$.makeArray(entry);var optindex=-1;var togo=[];args=$.makeArray(args);for(var i=0;i<args.length;++i){if(args[i]===fluid.COMPONENT_OPTIONS){optindex=i}}for(i=0;i<entries.length;++i){entry=entries[i];if(optindex!==-1){args[optindex]=entry.options}togo[i]=fluid.initSubcomponentImpl(that,entry,args)}return togo};fluid.initSubcomponent=function(that,className,args){return fluid.initSubcomponents(that,className,args)[0]};fluid.stringToRegExp=function(str,flags){return new RegExp(str.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),flags)};fluid.stringTemplate=function(template,values){var keys=fluid.keys(values);keys=keys.sort(fluid.compareStringLength());for(var i=0;i<keys.length;++i){var key=keys[i];var re=fluid.stringToRegExp("%"+key,"g");template=template.replace(re,values[key])}return template};fluid.messageResolver=function(options){var that=fluid.initLittleComponent("fluid.messageResolver",options);that.messageBase=that.options.parseFunc(that.options.messageBase);that.lookup=function(messagecodes){var resolved=fluid.messageResolver.resolveOne(that.messageBase,messagecodes);if(resolved===undefined){return fluid.find(that.options.parents,function(parent){return parent.lookup(messagecodes)})}else{return{template:resolved,resolveFunc:that.options.resolveFunc}}};that.resolve=function(messagecodes,args){if(!messagecodes){return"[No messagecodes provided]"}messagecodes=fluid.makeArray(messagecodes);var looked=that.lookup(messagecodes);return looked?looked.resolveFunc(looked.template,args):"[Message string for key "+messagecodes[0]+" not found]"};return that};fluid.defaults("fluid.messageResolver",{mergePolicy:{messageBase:"preserve",parents:"nomerge"},resolveFunc:fluid.stringTemplate,parseFunc:fluid.identity,messageBase:{},parents:[]});fluid.messageResolver.resolveOne=function(messageBase,messagecodes){for(var i=0;i<messagecodes.length;++i){var code=messagecodes[i];var message=messageBase[code];if(message!==undefined){return message}}};fluid.messageLocator=function(messageBase,resolveFunc){var resolver=fluid.messageResolver({messageBase:messageBase,resolveFunc:resolveFunc});return function(messagecodes,args){return resolver.resolve(messagecodes,args)}}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){var NAMESPACE_KEY="fluid-scoped-data";fluid.getScopedData=function(target,key){var data=$(target).data(NAMESPACE_KEY);return data?data[key]:undefined};fluid.setScopedData=function(target,key,value){$(target).each(function(){var data=$.data(this,NAMESPACE_KEY)||{};data[key]=value;$.data(this,NAMESPACE_KEY,data)})};var lastFocusedElement=null;$(document).bind("focusin",function(event){lastFocusedElement=event.target});fluid.getLastFocusedElement=function(){return lastFocusedElement};var ENABLEMENT_KEY="enablement";fluid.enabled=function(target,state){target=$(target);if(state===undefined){return fluid.getScopedData(target,ENABLEMENT_KEY)!==false}else{$("*",target).add(target).each(function(){if(fluid.getScopedData(this,ENABLEMENT_KEY)!==undefined){fluid.setScopedData(this,ENABLEMENT_KEY,state)}else{if(/select|textarea|input/i.test(this.nodeName)){$(this).prop("disabled",!state)}}});fluid.setScopedData(target,ENABLEMENT_KEY,state)}};fluid.initEnablement=function(target){fluid.setScopedData(target,ENABLEMENT_KEY,true)};function applyOp(node,func){node=$(node);node.trigger("fluid-"+func);node[func]()}$.each(["focus","blur"],function(i,name){fluid[name]=function(elem){applyOp(elem,name)}})})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.dom=fluid.dom||{};var getNextNode=function(iterator){if(iterator.node.firstChild){iterator.node=iterator.node.firstChild;iterator.depth+=1;return iterator}while(iterator.node){if(iterator.node.nextSibling){iterator.node=iterator.node.nextSibling;return iterator}iterator.node=iterator.node.parentNode;iterator.depth-=1}return iterator};fluid.dom.iterateDom=function(node,acceptor,allNodes){var currentNode={node:node,depth:0};var prevNode=node;var condition;while(currentNode.node!==null&&currentNode.depth>=0&&currentNode.depth<fluid.dom.iterateDom.DOM_BAIL_DEPTH){condition=null;if(currentNode.node.nodeType===1||allNodes){condition=acceptor(currentNode.node,currentNode.depth)}if(condition){if(condition==="delete"){currentNode.node.parentNode.removeChild(currentNode.node);currentNode.node=prevNode}else{if(condition==="stop"){return currentNode.node}}}prevNode=currentNode.node;currentNode=getNextNode(currentNode)}};fluid.dom.iterateDom.DOM_BAIL_DEPTH=256;fluid.dom.isContainer=function(container,containee){for(;containee;containee=containee.parentNode){if(container===containee){return true}}return false};fluid.dom.getElementText=function(element){var nodes=element.childNodes;var text="";for(var i=0;i<nodes.length;++i){var child=nodes[i];if(child.nodeType===3){text=text+child.nodeValue}}return text}})(jQuery,fluid_1_5);fluid_1_5=fluid_1_5||{};(function($,fluid){var unUnicode=/(\\u[\dabcdef]{4}|\\x[\dabcdef]{2})/g;fluid.unescapeProperties=function(string){string=string.replace(unUnicode,function(match){var code=match.substring(2);var parsed=parseInt(code,16);return String.fromCharCode(parsed)});var pos=0;while(true){var backpos=string.indexOf("\\",pos);if(backpos===-1){break}if(backpos===string.length-1){return[string.substring(0,string.length-1),true]}var replace=string.charAt(backpos+1);if(replace==="n"){replace="\n"}if(replace==="r"){replace="\r"}if(replace==="t"){replace="\t"}string=string.substring(0,backpos)+replace+string.substring(backpos+2);pos=backpos+1}return[string,false]};var breakPos=/[^\\][\s:=]/;fluid.parseJavaProperties=function(text){var togo={};text=text.replace(/\r\n/g,"\n");text=text.replace(/\r/g,"\n");lines=text.split("\n");var contin,key,valueComp,valueRaw,valueEsc;for(var i=0;i<lines.length;++i){var line=$.trim(lines[i]);if(!line||line.charAt(0)==="#"||line.charAt(0)==="!"){continue}if(!contin){valueComp="";var breakpos=line.search(breakPos);if(breakpos===-1){key=line;valueRaw=""}else{key=$.trim(line.substring(0,breakpos+1));valueRaw=$.trim(line.substring(breakpos+2));if(valueRaw.charAt(0)===":"||valueRaw.charAt(0)==="="){valueRaw=$.trim(valueRaw.substring(1))}}key=fluid.unescapeProperties(key)[0];valueEsc=fluid.unescapeProperties(valueRaw)}else{valueEsc=fluid.unescapeProperties(line)}contin=valueEsc[1];if(!valueEsc[1]){togo[key]=valueComp+valueEsc[0]}else{valueComp+=valueEsc[0]}}return togo};fluid.formatMessage=function(messageString,args){if(!args){return messageString}if(typeof (args)==="string"){args=[args]}for(var i=0;i<args.length;++i){messageString=messageString.replace("{"+i+"}",args[i])}return messageString}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};var fluid=fluid||fluid_1_5;(function($,fluid){fluid.renderTimestamp=function(date){var zeropad=function(num,width){if(!width){width=2}var numstr=(num==undefined?"":num.toString());return"00000".substring(5-width+numstr.length)+numstr};return zeropad(date.getHours())+":"+zeropad(date.getMinutes())+":"+zeropad(date.getSeconds())+"."+zeropad(date.getMilliseconds(),3)};fluid.isTracing=false;fluid.registerNamespace("fluid.tracing");fluid.tracing.pathCount=[];fluid.tracing.summarisePathCount=function(pathCount){pathCount=pathCount||fluid.tracing.pathCount;var togo={};for(var i=0;i<pathCount.length;++i){var path=pathCount[i];if(!togo[path]){togo[path]=1}else{++togo[path]}}var toReallyGo=[];fluid.each(togo,function(el,path){toReallyGo.push({path:path,count:el})});toReallyGo.sort(function(a,b){return b.count-a.count});return toReallyGo};fluid.tracing.condensePathCount=function(prefixes,pathCount){prefixes=fluid.makeArray(prefixes);var prefixCount={};fluid.each(prefixes,function(prefix){prefixCount[prefix]=0});var togo=[];fluid.each(pathCount,function(el){var path=el.path;if(!fluid.find(prefixes,function(prefix){if(path.indexOf(prefix)===0){prefixCount[prefix]+=el.count;return true}})){togo.push(el)}});fluid.each(prefixCount,function(count,path){togo.unshift({path:path,count:count})});return togo};fluid.detectStackStyle=function(e){var style="other";var stackStyle={offset:0};if(e.arguments){style="chrome"}else{if(typeof window!=="undefined"&&window.opera&&e.stacktrace){style="opera10"}else{if(e.stack){style="firefox";stackStyle.offset=e.stack.indexOf("Trace exception")===-1?1:0}else{if(typeof window!=="undefined"&&window.opera&&!("stacktrace" in e)){style="opera"}}}}stackStyle.style=style;return stackStyle};fluid.obtainException=function(){try{throw new Error("Trace exception")}catch(e){return e}};var stackStyle=fluid.detectStackStyle(fluid.obtainException());fluid.registerNamespace("fluid.exceptionDecoders");fluid.decodeStack=function(){if(stackStyle.style!=="firefox"){return null}var e=fluid.obtainException();return fluid.exceptionDecoders[stackStyle.style](e)};fluid.exceptionDecoders.firefox=function(e){var lines=e.stack.replace(/(?:\n@:0)?\s+$/m,"").replace(/^\(/gm,"{anonymous}(").split("\n");return fluid.transform(lines,function(line){var atind=line.indexOf("@");return atind===-1?[line]:[line.substring(atind+1),line.substring(0,atind)]})};fluid.getCallerInfo=function(atDepth){atDepth=(atDepth||3)-stackStyle.offset;var stack=fluid.decodeStack();return stack?stack[atDepth][0]:null};function generate(c,count){var togo="";for(var i=0;i<count;++i){togo+=c}return togo}function printImpl(obj,small,options){var big=small+options.indentChars;if(obj===null){return"null"}else{if(fluid.isPrimitive(obj)){return JSON.stringify(obj)}else{var j=[];if(fluid.isArrayable(obj)){if(obj.length===0){return"[]"}for(var i=0;i<obj.length;++i){j[i]=printImpl(obj[i],big,options)}return"[\n"+big+j.join(",\n"+big)+"\n"+small+"]"}else{var i=0;fluid.each(obj,function(value,key){j[i++]=JSON.stringify(key)+": "+printImpl(value,big,options)});return"{\n"+big+j.join(",\n"+big)+"\n"+small+"}"}}}}fluid.prettyPrintJSON=function(obj,options){options=$.extend({indent:4},options);options.indentChars=generate(" ",options.indent);return printImpl(obj,"",options)};fluid.dumpEl=function(element){var togo;if(!element){return"null"}if(element.nodeType===3||element.nodeType===8){return"[data: "+element.data+"]"}if(element.nodeType===9){return"[document: location "+element.location+"]"}if(!element.nodeType&&fluid.isArrayable(element)){togo="[";for(var i=0;i<element.length;++i){togo+=fluid.dumpEl(element[i]);if(i<element.length-1){togo+=", "}}return togo+"]"}element=$(element);togo=element.get(0).tagName;if(element.id){togo+="#"+element.id}if(element.attr("class")){togo+="."+element.attr("class")}return togo}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.BINDING_ROOT_KEY="fluid-binding-root";fluid.findData=function(elem,name){while(elem){var data=$.data(elem,name);if(data){return data}elem=elem.parentNode}};fluid.bindFossils=function(node,data,fossils){$.data(node,fluid.BINDING_ROOT_KEY,{data:data,fossils:fossils})};fluid.boundPathForNode=function(node,fossils){node=fluid.unwrap(node);var key=node.name||node.id;var record=fossils[key];return record?record.EL:null};fluid.applyBoundChange=function(node,newValue,applier){node=fluid.unwrap(node);if(newValue===undefined){newValue=fluid.value(node)}if(node.nodeType===undefined&&node.length>0){node=node[0]}var root=fluid.findData(node,fluid.BINDING_ROOT_KEY);if(!root){fluid.fail("Bound data could not be discovered in any node above "+fluid.dumpEl(node))}var name=node.name;var fossil=root.fossils[name];if(!fossil){fluid.fail("No fossil discovered for name "+name+" in fossil record above "+fluid.dumpEl(node))}if(typeof (fossil.oldvalue)==="boolean"){newValue=newValue[0]?true:false}var EL=root.fossils[name].EL;if(applier){applier.fireChangeRequest({path:EL,value:newValue,source:node.id})}else{fluid.set(root.data,EL,newValue)}};fluid.model.makeEnvironmentStrategy=function(environment){return function(root,segment,index){return index===0&&environment[segment]?environment[segment]:undefined}};fluid.model.defaultCreatorStrategy=function(root,segment){if(root[segment]===undefined){root[segment]={};return root[segment]}};fluid.model.defaultFetchStrategy=function(root,segment){return segment===""?root:root[segment]};fluid.model.funcResolverStrategy=function(root,segment){if(root.resolvePathSegment){return root.resolvePathSegment(segment)}};fluid.model.defaultGetConfig={strategies:[fluid.model.funcResolverStrategy,fluid.model.defaultFetchStrategy]};fluid.model.defaultSetConfig={strategies:[fluid.model.funcResolverStrategy,fluid.model.defaultFetchStrategy,fluid.model.defaultCreatorStrategy]};fluid.model.traverseWithStrategy=function(root,segs,initPos,config,uncess){var strategies=config.strategies;var limit=segs.length-uncess;for(var i=initPos;i<limit;++i){if(!root){return root}var accepted=undefined;for(var j=0;j<strategies.length;++j){var value=strategies[j](root,segs[i],i+1,segs);if(accepted===undefined){accepted=value}}if(accepted===fluid.NO_VALUE){accepted=undefined}root=accepted}return root};fluid.model.getValueAndSegments=function(root,EL,config,initSegs){return fluid.model.accessWithStrategy(root,EL,fluid.NO_VALUE,config,initSegs,true)};fluid.model.makeTrundler=function(config){return function(valueSeg,EL){return fluid.model.getValueAndSegments(valueSeg.root,EL,config,valueSeg.segs)}};fluid.model.getWithStrategy=function(root,EL,config,initSegs){return fluid.model.accessWithStrategy(root,EL,fluid.NO_VALUE,config,initSegs)};fluid.model.setWithStrategy=function(root,EL,newValue,config,initSegs){fluid.model.accessWithStrategy(root,EL,newValue,config,initSegs)};fluid.model.accessWithStrategy=function(root,EL,newValue,config,initSegs,returnSegs){if(!fluid.isPrimitive(EL)&&!fluid.isArrayable(EL)){var key=EL.type||"default";var resolver=config.resolvers[key];if(!resolver){fluid.fail("Unable to find resolver of type "+key)}var trundler=fluid.model.makeTrundler(config);var valueSeg={root:root,segs:initSegs};valueSeg=resolver(valueSeg,EL,trundler);if(EL.path&&valueSeg){valueSeg=trundler(valueSeg,EL.path)}return returnSegs?valueSeg:(valueSeg?valueSeg.root:undefined)}else{return fluid.model.accessImpl(root,EL,newValue,config,initSegs,returnSegs,fluid.model.traverseWithStrategy)}};fluid.pathUtil={};var getPathSegmentImpl=function(accept,path,i){var segment=null;if(accept){segment=""}var escaped=false;var limit=path.length;for(;i<limit;++i){var c=path.charAt(i);if(!escaped){if(c==="."){break}else{if(c==="\\"){escaped=true}else{if(segment!==null){segment+=c}}}}else{escaped=false;if(segment!==null){segment+=c}}}if(segment!==null){accept[0]=segment}return i};var globalAccept=[];fluid.pathUtil.getPathSegment=function(path,i){getPathSegmentImpl(globalAccept,path,i);return globalAccept[0]};fluid.pathUtil.getHeadPath=function(path){return fluid.pathUtil.getPathSegment(path,0)};fluid.pathUtil.getFromHeadPath=function(path){var firstdot=getPathSegmentImpl(null,path,0);return firstdot===path.length?"":path.substring(firstdot+1)};function lastDotIndex(path){return path.lastIndexOf(".")}fluid.pathUtil.getToTailPath=function(path){var lastdot=lastDotIndex(path);return lastdot===-1?"":path.substring(0,lastdot)};fluid.pathUtil.getTailPath=function(path){var lastdot=lastDotIndex(path);return fluid.pathUtil.getPathSegment(path,lastdot+1)};fluid.pathUtil.parseEL=function(path){var togo=[];var index=0;var limit=path.length;while(index<limit){var firstdot=getPathSegmentImpl(globalAccept,path,index);togo.push(globalAccept[0]);index=firstdot+1}return togo};var composeSegment=function(prefix,toappend){for(var i=0;i<toappend.length;++i){var c=toappend.charAt(i);if(c==="."||c==="\\"||c==="}"){prefix+="\\"}prefix+=c}return prefix};fluid.pathUtil.escapeSegment=function(segment){return composeSegment("",segment)};fluid.pathUtil.composePath=function(prefix,suffix){if(prefix.length!==0){prefix+="."}return composeSegment(prefix,suffix)};fluid.pathUtil.matchSegments=function(toMatch,segs,start,end){if(end-start!==toMatch.length){return false}for(var i=start;i<end;++i){if(segs[i]!==toMatch[i-start]){return false}}return true};fluid.pathUtil.getExcessPath=function(base,longer){var index=longer.indexOf(base);if(index!==0){fluid.fail("Path "+base+" is not a prefix of path "+longer)}if(base.length===longer.length){return""}if(longer[base.length]!=="."){fluid.fail("Path "+base+" is not properly nested in path "+longer)}return longer.substring(base.length+1)};fluid.pathUtil.matchPath=function(spec,path,exact){var togo="";while(true){if(((path==="")^(spec===""))&&exact){return null}if(!spec||!path){break}var spechead=fluid.pathUtil.getHeadPath(spec);var pathhead=fluid.pathUtil.getHeadPath(path);if(spechead!=="*"&&spechead!==pathhead){return null}togo=fluid.pathUtil.composePath(togo,pathhead);spec=fluid.pathUtil.getFromHeadPath(spec);path=fluid.pathUtil.getFromHeadPath(path)}return togo};fluid.model.isNullChange=function(model,request,resolverGetConfig){if(request.type==="ADD"){var existing=fluid.get(model,request.path,resolverGetConfig);if(existing===request.value){return true}}};fluid.model.applyChangeRequest=function(model,request,resolverSetConfig){var pen=fluid.model.accessWithStrategy(model,request.path,fluid.VALUE,resolverSetConfig||fluid.model.defaultSetConfig,null,true);var last=pen.segs[pen.segs.length-1];if(request.type==="ADD"||request.type==="MERGE"){if(request.path===""||request.type==="MERGE"){if(request.type==="ADD"){fluid.clear(pen.root)}$.extend(true,request.path===""?pen.root:pen.root[last],request.value)}else{pen.root[last]=request.value}}else{if(request.type==="DELETE"){if(request.path===""){fluid.clear(pen.root)}else{delete pen.root[last]}}}};fluid.addSourceGuardedListener=function(applier,path,source,func,eventName){eventName=eventName||"modelChanged";applier[eventName].addListener(path,function(){if(!applier.hasChangeSource(source)){func.apply(null,arguments)}})};fluid.fireSourcedChange=function(applier,path,value,source){applier.fireChangeRequest({path:path,value:value,source:source})};fluid.requestChanges=function(applier,changes){for(var i=0;i<changes.length;++i){applier.fireChangeRequest(changes[i])}};function bindRequestChange(that){that.requestChange=function(path,value,type){var changeRequest={path:path,value:value,type:type};that.fireChangeRequest(changeRequest)}}function sourceWrapModelChanged(modelChanged,threadLocal){return function(changeRequest){var sources=threadLocal().sources;var args=arguments;var source=changeRequest.source||"";fluid.tryCatch(function(){if(sources[source]===undefined){sources[source]=0}++sources[source];modelChanged.apply(null,args)},null,function(){--sources[source]})}}fluid.makeChangeApplier=function(model,options){options=options||{};var baseEvents={guards:fluid.event.getEventFirer(false,true,"guard event"),postGuards:fluid.event.getEventFirer(false,true,"postGuard event"),modelChanged:fluid.event.getEventFirer(false,false,"modelChanged event")};var threadLocal=fluid.threadLocal(function(){return{sources:{}}});var that={changeid:fluid.allocateGuid(),model:model};function makeGuardWrapper(cullUnchanged){if(!cullUnchanged){return null}var togo=function(guard){return function(model,changeRequest,internalApplier){var oldRet=guard(model,changeRequest,internalApplier);if(oldRet===false){return false}else{if(fluid.model.isNullChange(model,changeRequest)){togo.culled=true;return false}}}};return togo}function wrapListener(listener,spec){var pathSpec=spec;var transactional=false;var priority=Number.MAX_VALUE;if(typeof (spec)!=="string"){pathSpec=spec.path;transactional=spec.transactional;if(spec.priority!==undefined){priority=spec.priority}}else{if(pathSpec.charAt(0)==="!"){transactional=true;pathSpec=pathSpec.substring(1)}}var wrapped=function(changePath,fireSpec,accum){var guid=fluid.event.identifyListener(listener);var exist=fireSpec.guids[guid];if(!exist){var match=fluid.pathUtil.matchPath(pathSpec,changePath);if(match!==null){var record={changePath:changePath,pathSpec:pathSpec,listener:listener,priority:priority,transactional:transactional};if(accum){record.accumulate=[accum]}fireSpec.guids[guid]=record;var collection=transactional?"transListeners":"listeners";fireSpec[collection].push(record);fireSpec.all.push(record)}}else{if(accum){if(!exist.accumulate){exist.accumulate=[]}exist.accumulate.push(accum)}}};fluid.event.impersonateListener(listener,wrapped);return wrapped}function fireFromSpec(name,fireSpec,args,category,wrapper){return baseEvents[name].fireToListeners(fireSpec[category],args,wrapper)}function fireComparator(recA,recB){return recA.priority-recB.priority}function prepareFireEvent(name,changePath,fireSpec,accum){baseEvents[name].fire(changePath,fireSpec,accum);fireSpec.all.sort(fireComparator);fireSpec.listeners.sort(fireComparator);fireSpec.transListeners.sort(fireComparator)}function makeFireSpec(){return{guids:{},all:[],listeners:[],transListeners:[]}}function getFireSpec(name,changePath){var fireSpec=makeFireSpec();prepareFireEvent(name,changePath,fireSpec);return fireSpec}function fireEvent(name,changePath,args,wrapper){var fireSpec=getFireSpec(name,changePath);return fireFromSpec(name,fireSpec,args,"all",wrapper)}function adaptListener(that,name){that[name]={addListener:function(spec,listener,namespace){baseEvents[name].addListener(wrapListener(listener,spec),namespace)},removeListener:function(listener){baseEvents[name].removeListener(listener)}}}adaptListener(that,"guards");adaptListener(that,"postGuards");adaptListener(that,"modelChanged");function preFireChangeRequest(changeRequest){if(!changeRequest.type){changeRequest.type="ADD"}}var bareApplier={fireChangeRequest:function(changeRequest){that.fireChangeRequest(changeRequest,true)}};bindRequestChange(bareApplier);that.fireChangeRequest=function(changeRequest,defeatGuards){preFireChangeRequest(changeRequest);var guardFireSpec=defeatGuards?null:getFireSpec("guards",changeRequest.path);if(guardFireSpec&&guardFireSpec.transListeners.length>0){var ation=that.initiate();ation.fireChangeRequest(changeRequest,guardFireSpec);ation.commit()}else{if(!defeatGuards){var prevent=fireFromSpec("guards",guardFireSpec,[model,changeRequest,bareApplier],"listeners");if(prevent===false){return false}}var oldModel=model;if(!options.thin){oldModel={};fluid.model.copyModel(oldModel,model)}fluid.model.applyChangeRequest(model,changeRequest,options.resolverSetConfig);fireEvent("modelChanged",changeRequest.path,[model,oldModel,[changeRequest]])}};that.fireChangeRequest=sourceWrapModelChanged(that.fireChangeRequest,threadLocal);bindRequestChange(that);function fireAgglomerated(eventName,formName,changes,args,accpos){var fireSpec=makeFireSpec();for(var i=0;i<changes.length;++i){prepareFireEvent(eventName,changes[i].path,fireSpec,changes[i])}for(var j=0;j<fireSpec[formName].length;++j){var spec=fireSpec[formName][j];if(accpos){args[accpos]=spec.accumulate}var ret=spec.listener.apply(null,args);if(ret===false){return false}}}that.initiate=function(newModel){var cancelled=false;var changes=[];if(options.thin){newModel=model}else{newModel=newModel||{};fluid.model.copyModel(newModel,model)}var internalApplier={fireChangeRequest:function(changeRequest){preFireChangeRequest(changeRequest);fluid.model.applyChangeRequest(newModel,changeRequest,options.resolverSetConfig);changes.push(changeRequest)}};bindRequestChange(internalApplier);var ation={commit:function(){var oldModel;if(cancelled){return false}var ret=fireAgglomerated("postGuards","transListeners",changes,[newModel,null,internalApplier],1);if(ret===false){return false}if(options.thin){oldModel=model}else{oldModel={};fluid.model.copyModel(oldModel,model);fluid.clear(model);fluid.model.copyModel(model,newModel)}fireAgglomerated("modelChanged","all",changes,[model,oldModel,null],2)},fireChangeRequest:function(changeRequest){preFireChangeRequest(changeRequest);if(options.cullUnchanged&&fluid.model.isNullChange(model,changeRequest,options.resolverGetConfig)){return }var wrapper=makeGuardWrapper(options.cullUnchanged);var prevent=fireEvent("guards",changeRequest.path,[newModel,changeRequest,internalApplier],wrapper);if(prevent===false&&!(wrapper&&wrapper.culled)){cancelled=true}if(!cancelled){if(!(wrapper&&wrapper.culled)){fluid.model.applyChangeRequest(newModel,changeRequest,options.resolverSetConfig);changes.push(changeRequest)}}}};ation.fireChangeRequest=sourceWrapModelChanged(ation.fireChangeRequest,threadLocal);bindRequestChange(ation);return ation};that.hasChangeSource=function(source){return threadLocal().sources[source]>0};return that};fluid.makeSuperApplier=function(){var subAppliers=[];var that={};that.addSubApplier=function(path,subApplier){subAppliers.push({path:path,subApplier:subApplier})};that.fireChangeRequest=function(request){for(var i=0;i<subAppliers.length;++i){var path=subAppliers[i].path;if(request.path.indexOf(path)===0){var subpath=request.path.substring(path.length+1);var subRequest=fluid.copy(request);subRequest.path=subpath;subAppliers[i].subApplier.fireChangeRequest(subRequest)}}};bindRequestChange(that);return that};fluid.attachModel=function(baseModel,path,model){var segs=fluid.model.parseEL(path);for(var i=0;i<segs.length-1;++i){var seg=segs[i];var subModel=baseModel[seg];if(!subModel){baseModel[seg]=subModel={}}baseModel=subModel}baseModel[segs[segs.length-1]]=model};fluid.assembleModel=function(modelSpec){var model={};var superApplier=fluid.makeSuperApplier();var togo={model:model,applier:superApplier};for(var path in modelSpec){var rec=modelSpec[path];fluid.attachModel(model,path,rec.model);if(rec.applier){superApplier.addSubApplier(path,rec.applier)}}return togo}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};var fluid=fluid||fluid_1_5;(function($){fluid.registerNamespace("fluid.model.transform");fluid.defaults("fluid.transformFunction",{gradeNames:"fluid.function"});fluid.defaults("fluid.standardInputTransformFunction",{gradeNames:"fluid.transformFunction"});fluid.defaults("fluid.standardOutputTransformFunction",{gradeNames:"fluid.transformFunction"});fluid.defaults("fluid.standardTransformFunction",{gradeNames:["fluid.standardInputTransformFunction","fluid.standardOutputTransformFunction"]});fluid.defaults("fluid.lens",{gradeNames:"fluid.transformFunction",invertConfiguration:null});fluid.model.transform.pathToRule=function(inputPath){return{expander:{type:"fluid.model.transform.value",inputPath:inputPath}}};fluid.model.transform.valueToRule=function(value){return{expander:{type:"fluid.model.transform.literalValue",value:value}}};fluid.model.composePaths=function(prefix,suffix){prefix=prefix||"";suffix=suffix||"";return !prefix?suffix:(!suffix?prefix:prefix+"."+suffix)};fluid.model.transform.accumulateInputPath=function(inputPath,expander,paths){if(inputPath!==undefined){paths.push(fluid.model.composePaths(expander.inputPrefix,inputPath))}};fluid.model.transform.getValue=function(inputPath,value,expander){var togo;if(inputPath!==undefined){togo=fluid.get(expander.source,fluid.model.composePaths(expander.inputPrefix,inputPath),expander.resolverGetConfig)}if(togo===undefined){togo=fluid.isPrimitive(value)?value:expander.expand(value)}return togo};fluid.model.transform.NONDEFAULT_OUTPUT_PATH_RETURN={};fluid.model.transform.setValue=function(userOutputPath,value,expander){var toset=fluid.copy(value);var outputPath=fluid.model.composePaths(expander.outputPrefix,userOutputPath);if(toset!==undefined){expander.applier.requestChange(outputPath,toset)}return userOutputPath?fluid.model.transform.NONDEFAULT_OUTPUT_PATH_RETURN:toset};fluid.model.transform.value=fluid.identity;fluid.defaults("fluid.model.transform.value",{gradeNames:"fluid.standardTransformFunction",invertConfiguration:"fluid.model.transform.invertValue"});fluid.model.transform.invertValue=function(expandSpec,expander){var togo=fluid.copy(expandSpec);togo.inputPath=fluid.model.composePaths(expander.outputPrefix,expandSpec.outputPath);togo.outputPath=fluid.model.composePaths(expander.inputPrefix,expandSpec.inputPath);return togo};fluid.model.transform.literalValue=function(expanderSpec){return expanderSpec.value};fluid.defaults("fluid.model.transform.literalValue",{gradeNames:"fluid.standardOutputTransformFunction"});fluid.model.transform.arrayValue=fluid.makeArray;fluid.defaults("fluid.model.transform.arrayValue",{gradeNames:"fluid.standardTransformFunction"});fluid.model.transform.count=function(value){return fluid.makeArray(value).length};fluid.defaults("fluid.model.transform.count",{gradeNames:"fluid.standardTransformFunction"});fluid.model.transform.firstValue=function(expandSpec,expander){if(!expandSpec.values||!expandSpec.values.length){fluid.fail('firstValue transformer requires an array of values at path named "values", supplied',expandSpec)}for(var i=0;i<expandSpec.values.length;i++){var value=expandSpec.values[i];var expanded=expander.expand(value);if(expanded!==undefined){return expanded}}};fluid.defaults("fluid.model.transform.firstValue",{gradeNames:"fluid.transformFunction"});fluid.deepEquals=function(expected,actual,stats){if(fluid.isPrimitive(expected)){if(expected===actual){++stats.matchCount}else{++stats.mismatchCount;stats.messages.push("Value mismatch at path "+stats.path+": expected "+expected+" actual "+actual)}}else{if(typeof (expected)!==typeof (actual)){++stats.mismatchCount;stats.messages.push("Type mismatch at path "+stats.path+": expected "+typeof (expected)+" actual "+typeof (actual))}else{fluid.each(expected,function(value,key){stats.pathOps.push(key);fluid.deepEquals(expected[key],actual[key],stats);stats.pathOps.pop(key)})}}};fluid.model.transform.matchValue=function(expected,actual){if(fluid.isPrimitive(expected)){return expected===actual?1:0}else{var stats={matchCount:0,mismatchCount:0,messages:[]};fluid.model.makePathStack(stats,"path");fluid.deepEquals(expected,actual,stats);return stats.matchCount}};fluid.model.transform.compareMatches=function(speca,specb){return specb.matchCount-speca.matchCount};fluid.firstDefined=function(a,b){return a===undefined?b:a};fluid.model.transform.matchValueMapperFull=function(outerValue,expander,expandSpec){var o=expandSpec.options;if(o.length===0){fluid.fail("valueMapper supplied empty list of options: ",expandSpec)}if(o.length===1){return 0}var matchPower=[];for(var i=0;i<o.length;++i){var option=o[i];var value=fluid.firstDefined(fluid.model.transform.getValue(option.inputPath,undefined,expander),outerValue);var matchCount=fluid.model.transform.matchValue(option.undefinedInputValue?undefined:option.inputValue,value);matchPower[i]={index:i,matchCount:matchCount}}matchPower.sort(fluid.model.transform.compareMatches);return matchPower[0].matchCount===matchPower[1].matchCount?-1:matchPower[0].index};fluid.model.transform.valueMapper=function(expandSpec,expander){if(!expandSpec.options){fluid.fail('demultiplexValue requires a list or hash of options at path named "options", supplied ',expandSpec)}var value=fluid.model.transform.getValue(expandSpec.inputPath,undefined,expander);var deref=fluid.isArrayable(expandSpec.options)?function(testVal){var index=fluid.model.transform.matchValueMapperFull(testVal,expander,expandSpec);return index===-1?null:expandSpec.options[index]}:function(testVal){return expandSpec.options[testVal]};var indexed=deref(value);if(!indexed){indexed=deref(expandSpec.defaultInputValue)}if(!indexed){return }var outputValue=fluid.isPrimitive(indexed)?indexed:(indexed.undefinedOutputValue?undefined:(indexed.outputValue===undefined?expandSpec.defaultOutputValue:indexed.outputValue));var outputPath=indexed.outputPath===undefined?expandSpec.outputPath:indexed.outputPath;return fluid.model.transform.setValue(outputPath,outputValue,expander)};fluid.model.transform.valueMapper.invert=function(expandSpec,expander){var options=[];var togo={type:"fluid.model.transform.valueMapper",options:options};var isArray=fluid.isArrayable(expandSpec.options);var findCustom=function(name){return fluid.find(expandSpec.options,function(option){if(option[name]){return true}})};var anyCustomOutput=findCustom("outputPath");var anyCustomInput=findCustom("inputPath");if(!anyCustomOutput){togo.inputPath=fluid.model.composePaths(expander.outputPrefix,expandSpec.outputPath)}if(!anyCustomInput){togo.outputPath=fluid.model.composePaths(expander.inputPrefix,expandSpec.inputPath)}var def=fluid.firstDefined;fluid.each(expandSpec.options,function(option,key){var outOption={};var origInputValue=def(isArray?option.inputValue:key,expandSpec.defaultInputValue);if(origInputValue===undefined){fluid.fail("Failure inverting configuration for valueMapper - inputValue could not be resolved for record "+key+": ",expandSpec)}outOption.outputValue=origInputValue;var origOutputValue=def(option.outputValue,expandSpec.defaultOutputValue);outOption.inputValue=origOutputValue;if(anyCustomOutput){outOption.inputPath=fluid.model.composePaths(expander.outputPrefix,def(option.outputPath,expandSpec.outputPath))}if(anyCustomInput){outOption.outputPath=fluid.model.composePaths(expander.inputPrefix,def(option.inputPath,expandSpec.inputPath))}options.push(outOption)});return togo};fluid.model.transform.valueMapper.collect=function(expandSpec,expander){var togo=[];fluid.model.transform.accumulateInputPath(expandSpec.inputPath,expander,togo);fluid.each(expandSpec.options,function(option){fluid.model.transform.accumulateInputPath(option.inputPath,expander,togo)});return togo};fluid.defaults("fluid.model.transform.valueMapper",{gradeNames:["fluid.transformFunction","fluid.lens"],invertConfiguration:"fluid.model.transform.valueMapper.invert",collectInputPaths:"fluid.model.transform.valueMapper.collect"});fluid.model.transform.prefixApplier=function(expandSpec,expander){if(expandSpec.inputPrefix){expander.inputPrefixOp.push(expandSpec.inputPrefix)}if(expandSpec.outputPrefix){expander.outputPrefixOp.push(expandSpec.outputPrefix)}expander.expand(expandSpec.value);if(expandSpec.inputPrefix){expander.inputPrefixOp.pop()}if(expandSpec.outputPrefix){expander.outputPrefixOp.pop()}};fluid.defaults("fluid.model.transform.prefixApplier",{gradeNames:["fluid.transformFunction"]});fluid.model.makePathStack=function(expander,prefixName){var stack=expander[prefixName+"Stack"]=[];expander[prefixName]="";return{push:function(prefix){var newPath=fluid.model.composePaths(expander[prefixName],prefix);stack.push(expander[prefixName]);expander[prefixName]=newPath},pop:function(){expander[prefixName]=stack.pop()}}};fluid.model.transform.expandExpander=function(expandSpec,expander){var typeName=expandSpec.type;if(!typeName){fluid.fail("Transformation record is missing a type name: ",expandSpec)}if(typeName.indexOf(".")===-1){typeName="fluid.model.transform."+typeName}var expanderFn=fluid.getGlobalValue(typeName);var expdef=fluid.defaults(typeName);if(typeof (expanderFn)!=="function"){fluid.fail("Transformation record specifies transformation function with name "+expandSpec.type+" which is not a function - ",expanderFn)}if(!fluid.hasGrade(expdef,"fluid.transformFunction")){expdef=fluid.defaults("fluid.standardTransformFunction")}var expanderArgs=[expandSpec,expander];if(fluid.hasGrade(expdef,"fluid.standardInputTransformFunction")){var expanded=fluid.model.transform.getValue(expandSpec.inputPath,expandSpec.value,expander);expanderArgs[0]=expanded;expanderArgs[2]=expandSpec}var transformed=expanderFn.apply(null,expanderArgs);if(fluid.hasGrade(expdef,"fluid.standardOutputTransformFunction")){transformed=fluid.model.transform.setValue(expandSpec.outputPath,transformed,expander)}return transformed};fluid.model.transform.expandWildcards=function(expander,source){fluid.each(source,function(value,key){var q=expander.queued;expander.pathOp.push(fluid.pathUtil.escapeSegment(key.toString()));for(var i=0;i<q.length;++i){if(fluid.pathUtil.matchPath(q[i].matchPath,expander.path,true)){var esCopy=fluid.copy(q[i].expandSpec);if(esCopy.inputPath===undefined||fluid.model.transform.hasWildcard(esCopy.inputPath)){esCopy.inputPath=""}expander.inputPrefixOp.push(expander.path);expander.outputPrefixOp.push(expander.path);fluid.model.transform.expandExpander(esCopy,expander);expander.outputPrefixOp.pop();expander.inputPrefixOp.pop()}}if(!fluid.isPrimitive(value)){fluid.model.transform.expandWildcards(expander,value)}expander.pathOp.pop()})};fluid.model.transform.hasWildcard=function(path){return typeof (path)==="string"&&path.indexOf("*")!==-1};fluid.model.transform.maybePushWildcard=function(expander,expandSpec){var hw=fluid.model.transform.hasWildcard;var matchPath;if(hw(expandSpec.inputPath)){matchPath=fluid.model.composePaths(expander.inputPrefix,expandSpec.inputPath)}else{if(hw(expander.outputPrefix)||hw(expandSpec.outputPath)){matchPath=fluid.model.composePaths(expander.outputPrefix,expandSpec.outputPath)}}if(matchPath){expander.queued.push({expandSpec:expandSpec,outputPrefix:expander.outputPrefix,inputPrefix:expander.inputPrefix,matchPath:matchPath});return true}return false};fluid.model.sortByKeyLength=function(inObject){var keys=fluid.keys(inObject);return keys.sort(fluid.compareStringLength(true))};fluid.model.transform.handleExpandExpander=function(expander,expandSpec){if(fluid.model.transform.maybePushWildcard(expander,expandSpec)){return }else{return fluid.model.transform.expandExpander(expandSpec,expander)}};fluid.model.transform.handleInvertExpander=function(expander,expandSpec,expdef){var invertor=expdef.invertConfiguration;if(invertor){var inverted=fluid.invokeGlobalFunction(invertor,[expandSpec,expander]);expander.inverted.push(inverted)}};fluid.model.transform.handlerCollectExpander=function(expander,expandSpec,expdef){var standardInput=fluid.hasGrade(expdef,"fluid.standardInputTransformFunction");if(standardInput){fluid.model.transform.accumulateInputPath(expandSpec.inputPath,expander,expander.inputPaths)}else{var collector=expdef.collectInputPaths;if(collector){var collected=fluid.makeArray(fluid.invokeGlobalFunction(collector,[expandSpec,expander]));expander.inputPaths=expander.inputPaths.concat(collected)}}};fluid.model.transform.expandValue=function(rule,expander){if(typeof (rule)==="string"){rule=fluid.model.transform.pathToRule(rule)}else{if(rule.value&&expander.outputPrefix!==""){rule=fluid.model.transform.valueToRule(rule.value)}}var togo;if(rule.expander){var expanders=fluid.makeArray(rule.expander);for(var i=0;i<expanders.length;++i){var expandSpec=expanders[i];var expdef=fluid.defaults(expandSpec.type);var returned=expander.expanderHandler(expander,expandSpec,expdef);if(returned!==undefined){togo=returned}}}var keys=fluid.model.sortByKeyLength(rule);for(var i=0;i<keys.length;++i){var key=keys[i];if(key!=="expander"){var value=rule[key];expander.outputPrefixOp.push(key);expander.expand(value,expander);expander.outputPrefixOp.pop()}}togo=fluid.get(expander.target,expander.outputPrefix);return togo};fluid.model.transform.makeExpander=function(expander,handleFn,expandFn){expandFn=expandFn||fluid.model.transform.expandValue;expander.expand=function(rules){return expandFn(rules,expander)};expander.outputPrefixOp=fluid.model.makePathStack(expander,"outputPrefix");expander.inputPrefixOp=fluid.model.makePathStack(expander,"inputPrefix");expander.expanderHandler=handleFn};fluid.model.transform.invertConfiguration=function(rules){var expander={inverted:[]};fluid.model.transform.makeExpander(expander,fluid.model.transform.handleInvertExpander);expander.expand(rules);return{expander:expander.inverted}};fluid.model.transform.collectInputPaths=function(rules){var expander={inputPaths:[]};fluid.model.transform.makeExpander(expander,fluid.model.transform.handlerCollectExpander);expander.expand(rules);return expander.inputPaths};fluid.model.transform.flatSchemaStrategy=function(flatSchema){var keys=fluid.model.sortByKeyLength(flatSchema);return function(root,segment,index,segs){var path=fluid.path.apply(null,segs.slice(0,index));for(var i=0;i<keys.length;++i){var key=keys[i];if(fluid.pathUtil.matchPath(key,path,true)!==null){return flatSchema[key]}}}};fluid.model.transform.defaultSchemaValue=function(schemaValue){var type=fluid.isPrimitive(schemaValue)?schemaValue:schemaValue.type;return type==="array"?[]:{}};fluid.model.transform.isomorphicSchemaStrategy=function(source,getConfig){return function(root,segment,index,segs){var existing=fluid.get(source,segs.slice(0,index),getConfig);return fluid.isArrayable(existing)?"array":"object"}};fluid.model.transform.decodeStrategy=function(source,options,getConfig){if(options.isomorphic){return fluid.model.transform.isomorphicSchemaStrategy(source,getConfig)}else{if(options.flatSchema){return fluid.model.transform.flatSchemaStrategy(options.flatSchema,getConfig)}}};fluid.model.transform.schemaToCreatorStrategy=function(strategy){return function(root,segment,index,segs){if(root[segment]===undefined){var schemaValue=strategy(root,segment,index,segs);return root[segment]=fluid.model.transform.defaultSchemaValue(schemaValue)}}};fluid.model.transform.sequence=function(source,rules,options){for(var i=0;i<rules.length;++i){source=fluid.model.transform(source,rules[i],options)}return source};fluid.model.transformWithRules=function(source,rules,options){options=options||{};var parser={parse:fluid.pathUtil.parseEL,compose:fluid.pathUtil.composePath};var getConfig={parser:parser,strategies:[fluid.model.defaultFetchStrategy]};var schemaStrategy=fluid.model.transform.decodeStrategy(source,options,getConfig);var setConfig={parser:parser,strategies:[fluid.model.defaultFetchStrategy,schemaStrategy?fluid.model.transform.schemaToCreatorStrategy(schemaStrategy):fluid.model.defaultCreatorStrategy]};var expander={source:source,target:schemaStrategy?fluid.model.transform.defaultSchemaValue(schemaStrategy(null,"",0,[""])):{},resolverGetConfig:getConfig,queued:[]};fluid.model.transform.makeExpander(expander,fluid.model.transform.handleExpandExpander);expander.applier=fluid.makeChangeApplier(expander.target,{resolverSetConfig:setConfig});expander.expand(rules);if(expander.queued.length>0){expander.typeStack=[];expander.pathOp=fluid.model.makePathStack(expander,"path");fluid.model.transform.expandWildcards(expander,source)}return expander.target};$.extend(fluid.model.transformWithRules,fluid.model.transform);fluid.model.transform=fluid.model.transformWithRules})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};var fluid=fluid||fluid_1_5;(function($,fluid){fluid.thatistBridge=function(name,peer){var togo=function(funcname){var segs=funcname.split(".");var move=peer;for(var i=0;i<segs.length;++i){move=move[segs[i]]}var args=[this];if(arguments.length===2){args=args.concat($.makeArray(arguments[1]))}var ret=move.apply(null,args);this.that=function(){return ret};var type=typeof (ret);return !ret||type==="string"||type==="number"||type==="boolean"||(ret&&ret.length!==undefined)?ret:this};$.fn[name]=togo;return togo};fluid.thatistBridge("fluid",fluid);fluid.thatistBridge("fluid_1_5",fluid_1_5);var normalizeTabindexName=function(){return $.browser.msie?"tabIndex":"tabindex"};var canHaveDefaultTabindex=function(elements){if(elements.length<=0){return false}return $(elements[0]).is("a, input, button, select, area, textarea, object")};var getValue=function(elements){if(elements.length<=0){return undefined}if(!fluid.tabindex.hasAttr(elements)){return canHaveDefaultTabindex(elements)?Number(0):undefined}var value=elements.attr(normalizeTabindexName());return Number(value)};var setValue=function(elements,toIndex){return elements.each(function(i,item){$(item).attr(normalizeTabindexName(),toIndex)})};fluid.tabindex=function(target,toIndex){target=$(target);if(toIndex!==null&&toIndex!==undefined){return setValue(target,toIndex)}else{return getValue(target)}};fluid.tabindex.remove=function(target){target=$(target);return target.each(function(i,item){$(item).removeAttr(normalizeTabindexName())})};fluid.tabindex.hasAttr=function(target){target=$(target);if(target.length<=0){return false}var togo=target.map(function(){var attributeNode=this.getAttributeNode(normalizeTabindexName());return attributeNode?attributeNode.specified:false});return togo.length===1?togo[0]:togo};fluid.tabindex.has=function(target){target=$(target);return fluid.tabindex.hasAttr(target)||canHaveDefaultTabindex(target)};fluid.a11y=$.a11y||{};fluid.a11y.orientation={HORIZONTAL:0,VERTICAL:1,BOTH:2};var UP_DOWN_KEYMAP={next:$.ui.keyCode.DOWN,previous:$.ui.keyCode.UP};var LEFT_RIGHT_KEYMAP={next:$.ui.keyCode.RIGHT,previous:$.ui.keyCode.LEFT};var unwrap=function(element){return element.jquery?element[0]:element};var makeElementsTabFocussable=function(elements){elements.each(function(idx,item){item=$(item);if(!item.fluid("tabindex.has")||item.fluid("tabindex")<0){item.fluid("tabindex",0)}})};fluid.tabbable=function(target){target=$(target);makeElementsTabFocussable(target)};var CONTEXT_KEY="selectionContext";var NO_SELECTION=-32768;var cleanUpWhenLeavingContainer=function(selectionContext){if(selectionContext.activeItemIndex!==NO_SELECTION){if(selectionContext.options.onLeaveContainer){selectionContext.options.onLeaveContainer(selectionContext.selectables[selectionContext.activeItemIndex])}else{if(selectionContext.options.onUnselect){selectionContext.options.onUnselect(selectionContext.selectables[selectionContext.activeItemIndex])}}}if(!selectionContext.options.rememberSelectionState){selectionContext.activeItemIndex=NO_SELECTION}};var drawSelection=function(elementToSelect,handler){if(handler){handler(elementToSelect)}};var eraseSelection=function(selectedElement,handler){if(handler&&selectedElement){handler(selectedElement)}};var unselectElement=function(selectedElement,selectionContext){eraseSelection(selectedElement,selectionContext.options.onUnselect)};var selectElement=function(elementToSelect,selectionContext){unselectElement(selectionContext.selectedElement(),selectionContext);elementToSelect=unwrap(elementToSelect);var newIndex=selectionContext.selectables.index(elementToSelect);if(newIndex===-1){return }selectionContext.activeItemIndex=newIndex;drawSelection(elementToSelect,selectionContext.options.onSelect)};var selectableFocusHandler=function(selectionContext){return function(evt){$(evt.target).fluid("tabindex",0);selectElement(evt.target,selectionContext);return evt.stopPropagation()}};var selectableBlurHandler=function(selectionContext){return function(evt){$(evt.target).fluid("tabindex",selectionContext.options.selectablesTabindex);unselectElement(evt.target,selectionContext);return evt.stopPropagation()}};var reifyIndex=function(sc_that){var elements=sc_that.selectables;if(sc_that.activeItemIndex>=elements.length){sc_that.activeItemIndex=(sc_that.options.noWrap?elements.length-1:0)}if(sc_that.activeItemIndex<0&&sc_that.activeItemIndex!==NO_SELECTION){sc_that.activeItemIndex=(sc_that.options.noWrap?0:elements.length-1)}if(sc_that.activeItemIndex>=0){fluid.focus(elements[sc_that.activeItemIndex])}};var prepareShift=function(selectionContext){var selElm=selectionContext.selectedElement();if(selElm){fluid.blur(selElm)}unselectElement(selectionContext.selectedElement(),selectionContext);if(selectionContext.activeItemIndex===NO_SELECTION){selectionContext.activeItemIndex=-1}};var focusNextElement=function(selectionContext){prepareShift(selectionContext);++selectionContext.activeItemIndex;reifyIndex(selectionContext)};var focusPreviousElement=function(selectionContext){prepareShift(selectionContext);--selectionContext.activeItemIndex;reifyIndex(selectionContext)};var arrowKeyHandler=function(selectionContext,keyMap,userHandlers){return function(evt){if(evt.which===keyMap.next){focusNextElement(selectionContext);evt.preventDefault()}else{if(evt.which===keyMap.previous){focusPreviousElement(selectionContext);evt.preventDefault()}}}};var getKeyMapForDirection=function(direction){var keyMap;if(direction===fluid.a11y.orientation.HORIZONTAL){keyMap=LEFT_RIGHT_KEYMAP}else{if(direction===fluid.a11y.orientation.VERTICAL){keyMap=UP_DOWN_KEYMAP}}return keyMap};var tabKeyHandler=function(selectionContext){return function(evt){if(evt.which!==$.ui.keyCode.TAB){return }cleanUpWhenLeavingContainer(selectionContext);if(evt.shiftKey){selectionContext.focusIsLeavingContainer=true}}};var containerFocusHandler=function(selectionContext){return function(evt){var shouldOrig=selectionContext.options.autoSelectFirstItem;var shouldSelect=typeof (shouldOrig)==="function"?shouldOrig():shouldOrig;if(selectionContext.focusIsLeavingContainer){shouldSelect=false}if(shouldSelect&&evt.target===selectionContext.container.get(0)){if(selectionContext.activeItemIndex===NO_SELECTION){selectionContext.activeItemIndex=0}fluid.focus(selectionContext.selectables[selectionContext.activeItemIndex])}return evt.stopPropagation()}};var containerBlurHandler=function(selectionContext){return function(evt){selectionContext.focusIsLeavingContainer=false;return evt.stopPropagation()}};var makeElementsSelectable=function(container,defaults,userOptions){var options=$.extend(true,{},defaults,userOptions);var keyMap=getKeyMapForDirection(options.direction);var selectableElements=options.selectableElements?options.selectableElements:container.find(options.selectableSelector);var that={container:container,activeItemIndex:NO_SELECTION,selectables:selectableElements,focusIsLeavingContainer:false,options:options};that.selectablesUpdated=function(focusedItem){if(typeof (that.options.selectablesTabindex)==="number"){that.selectables.fluid("tabindex",that.options.selectablesTabindex)}that.selectables.unbind("focus."+CONTEXT_KEY);that.selectables.unbind("blur."+CONTEXT_KEY);that.selectables.bind("focus."+CONTEXT_KEY,selectableFocusHandler(that));that.selectables.bind("blur."+CONTEXT_KEY,selectableBlurHandler(that));if(keyMap&&that.options.noBubbleListeners){that.selectables.unbind("keydown."+CONTEXT_KEY);that.selectables.bind("keydown."+CONTEXT_KEY,arrowKeyHandler(that,keyMap))}if(focusedItem){selectElement(focusedItem,that)}else{reifyIndex(that)}};that.refresh=function(){if(!that.options.selectableSelector){fluid.fail("Cannot refresh selectable context which was not initialised by a selector")}that.selectables=container.find(options.selectableSelector);that.selectablesUpdated()};that.selectedElement=function(){return that.activeItemIndex<0?null:that.selectables[that.activeItemIndex]};if(keyMap&&!that.options.noBubbleListeners){container.keydown(arrowKeyHandler(that,keyMap))}container.keydown(tabKeyHandler(that));container.focus(containerFocusHandler(that));container.blur(containerBlurHandler(that));that.selectablesUpdated();return that};fluid.selectable=function(target,options){target=$(target);var that=makeElementsSelectable(target,fluid.selectable.defaults,options);fluid.setScopedData(target,CONTEXT_KEY,that);return that};fluid.selectable.select=function(target,toSelect){fluid.focus(toSelect)};fluid.selectable.selectNext=function(target){target=$(target);focusNextElement(fluid.getScopedData(target,CONTEXT_KEY))};fluid.selectable.selectPrevious=function(target){target=$(target);focusPreviousElement(fluid.getScopedData(target,CONTEXT_KEY))};fluid.selectable.currentSelection=function(target){target=$(target);var that=fluid.getScopedData(target,CONTEXT_KEY);return $(that.selectedElement())};fluid.selectable.defaults={direction:fluid.a11y.orientation.VERTICAL,selectablesTabindex:-1,autoSelectFirstItem:true,rememberSelectionState:true,selectableSelector:".selectable",selectableElements:null,onSelect:null,onUnselect:null,onLeaveContainer:null,noWrap:false};var checkForModifier=function(binding,evt){if(!binding.modifier){return true}var modifierKey=binding.modifier;var isCtrlKeyPresent=modifierKey&&evt.ctrlKey;var isAltKeyPresent=modifierKey&&evt.altKey;var isShiftKeyPresent=modifierKey&&evt.shiftKey;return isCtrlKeyPresent||isAltKeyPresent||isShiftKeyPresent};var makeActivationHandler=function(binding){return function(evt){var target=evt.target;if(!fluid.enabled(target)){return }var code=evt.which?evt.which:evt.keyCode;if(code===binding.key&&binding.activateHandler&&checkForModifier(binding,evt)){var event=$.Event("fluid-activate");$(target).trigger(event,[binding.activateHandler]);if(event.isDefaultPrevented()){evt.preventDefault()}}}};var makeElementsActivatable=function(elements,onActivateHandler,defaultKeys,options){var bindings=[];$(defaultKeys).each(function(index,key){bindings.push({modifier:null,key:key,activateHandler:onActivateHandler})});if(options&&options.additionalBindings){bindings=bindings.concat(options.additionalBindings)}fluid.initEnablement(elements);for(var i=0;i<bindings.length;++i){var binding=bindings[i];elements.keydown(makeActivationHandler(binding))}elements.bind("fluid-activate",function(evt,handler){handler=handler||onActivateHandler;return handler?handler(evt):null})};fluid.activatable=function(target,fn,options){target=$(target);makeElementsActivatable(target,fn,fluid.activatable.defaults.keys,options)};fluid.activate=function(target){$(target).trigger("fluid-activate")};fluid.activatable.defaults={keys:[$.ui.keyCode.ENTER,$.ui.keyCode.SPACE]}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.viewComponent",{gradeNames:["fluid.littleComponent","fluid.modelComponent","fluid.eventedComponent"],initFunction:"fluid.initView",argumentMap:{container:0,options:1}});fluid.diagnoseFailedView=function(componentName,that,options,args){if(!that&&fluid.hasGrade(options,"fluid.viewComponent")){var container=fluid.wrap(args[1]);var message1="Instantiation of autoInit component with type "+componentName+" failed, since ";if(container.length===0){fluid.fail(message1+'selector "',args[1],'" did not match any markup in the document')}else{fluid.fail(message1+" component creator function did not return a value")}}};fluid.checkTryCatchParameter=function(){var location=window.location||{search:"",protocol:"file:"};var GETParams=location.search.slice(1).split("&");return fluid.contains(GETParams,"notrycatch")};fluid.notrycatch=fluid.checkTryCatchParameter();fluid.wrap=function(obj,userJQuery){userJQuery=userJQuery||$;return((!obj||obj.jquery)?obj:userJQuery(obj))};fluid.unwrap=function(obj){return obj&&obj.jquery&&obj.length===1?obj[0]:obj};fluid.container=function(containerSpec,fallible,userJQuery){if(userJQuery){containerSpec=fluid.unwrap(containerSpec)}var container=fluid.wrap(containerSpec,userJQuery);if(fallible&&(!container||container.length===0)){return null}if(!container||!container.jquery||container.length!==1){if(typeof (containerSpec)!=="string"){containerSpec=container.selector}var count=container.length!==undefined?container.length:0;fluid.fail((count>1?"More than one ("+count+") container elements were":"No container element was")+" found for selector "+containerSpec)}if(!fluid.isDOMNode(container[0])){fluid.fail("fluid.container was supplied a non-jQueryable element")}return container};fluid.createDomBinder=function(container,selectors){var cache={},that={};var userJQuery=container.constructor;function cacheKey(name,thisContainer){return fluid.allocateSimpleId(thisContainer)+"-"+name}function record(name,thisContainer,result){cache[cacheKey(name,thisContainer)]=result}that.locate=function(name,localContainer){var selector,thisContainer,togo;selector=selectors[name];thisContainer=localContainer?localContainer:container;if(!thisContainer){fluid.fail("DOM binder invoked for selector "+name+" without container")}if(!selector){return thisContainer}if(typeof (selector)==="function"){togo=userJQuery(selector.call(null,fluid.unwrap(thisContainer)))}else{togo=userJQuery(selector,thisContainer)}if(togo.get(0)===document){togo=[]}if(!togo.selector){togo.selector=selector;togo.context=thisContainer}togo.selectorName=name;record(name,thisContainer,togo);return togo};that.fastLocate=function(name,localContainer){var thisContainer=localContainer?localContainer:container;var key=cacheKey(name,thisContainer);var togo=cache[key];return togo?togo:that.locate(name,localContainer)};that.clear=function(){cache={}};that.refresh=function(names,localContainer){var thisContainer=localContainer?localContainer:container;if(typeof names==="string"){names=[names]}if(thisContainer.length===undefined){thisContainer=[thisContainer]}for(var i=0;i<names.length;++i){for(var j=0;j<thisContainer.length;++j){that.locate(names[i],thisContainer[j])}}};that.resolvePathSegment=that.locate;return that};fluid.expectFilledSelector=function(result,message){if(result&&result.length===0&&result.jquery){fluid.fail(message+': selector "'+result.selector+'" with name '+result.selectorName+" returned no results in context "+fluid.dumpEl(result.context))}};fluid.initView=function(componentName,containerSpec,userOptions,localOptions){var container=fluid.container(containerSpec,true);fluid.expectFilledSelector(container,'Error instantiating component with name "'+componentName);if(!container){return null}var that=fluid.initLittleComponent(componentName,userOptions,localOptions||{gradeNames:["fluid.viewComponent"]});var userJQuery=that.options.jQuery;if(userJQuery){container=fluid.container(containerSpec,true,userJQuery)}fluid.log("Constructing view component "+componentName+" with container "+container.constructor.expando+(userJQuery?" user jQuery "+userJQuery.expando:"")+" env: "+$.expando);that.container=container;fluid.initDomBinder(that);return that};fluid.initDomBinder=function(that){that.dom=fluid.createDomBinder(that.container,that.options.selectors);that.locate=that.dom.locate};fluid.findAncestor=function(element,test){element=fluid.unwrap(element);while(element){if(test(element)){return element}element=element.parentNode}};fluid.findForm=function(node){return fluid.findAncestor(node,function(element){return element.nodeName.toLowerCase()==="form"})};fluid.each(["text","html"],function(method){fluid[method]=function(node,newValue){node=$(node);return newValue===undefined?node[method]():node[method](newValue)}});fluid.value=function(nodeIn,newValue){var node=fluid.unwrap(nodeIn);var multiple=false;if(node.nodeType===undefined&&node.length>1){node=node[0];multiple=true}if("input"!==node.nodeName.toLowerCase()||!/radio|checkbox/.test(node.type)){return newValue===undefined?$(node).val():$(node).val(newValue)}var name=node.name;if(name===undefined){fluid.fail("Cannot acquire value from node "+fluid.dumpEl(node)+" which does not have name attribute set")}var elements;if(multiple){elements=nodeIn}else{elements=node.ownerDocument.getElementsByName(name);var scope=fluid.findForm(node);elements=$.grep(elements,function(element){if(element.name!==name){return false}return !scope||fluid.dom.isContainer(scope,element)})}if(newValue!==undefined){if(typeof (newValue)==="boolean"){newValue=(newValue?"true":"false")}$.each(elements,function(){this.checked=(newValue instanceof Array?$.inArray(this.value,newValue)!==-1:newValue===this.value)})}else{var checked=$.map(elements,function(element){return element.checked?element.value:null});return node.type==="radio"?checked[0]:checked}};fluid.jById=function(id,dokkument){dokkument=dokkument&&dokkument.nodeType===9?dokkument:document;var element=fluid.byId(id,dokkument);var togo=element?$(element):[];togo.selector="#"+id;togo.context=dokkument;return togo};fluid.byId=function(id,dokkument){dokkument=dokkument&&dokkument.nodeType===9?dokkument:document;var el=dokkument.getElementById(id);if(el){if(el.id!==id){fluid.fail("Problem in document structure - picked up element "+fluid.dumpEl(el)+" for id "+id+" without this id - most likely the element has a name which conflicts with this id")}return el}else{return null}};fluid.getId=function(element){return fluid.unwrap(element).id};fluid.allocateSimpleId=function(element){var simpleId="fluid-id-"+fluid.allocateGuid();if(!element){return simpleId}element=fluid.unwrap(element);if(!element.id){element.id=simpleId}return element.id};fluid.defaults("fluid.ariaLabeller",{labelAttribute:"aria-label",liveRegionMarkup:'<div class="liveRegion fl-offScreen-hidden" aria-live="polite"></div>',liveRegionId:"fluid-ariaLabeller-liveRegion",events:{generateLiveElement:"unicast"},listeners:{generateLiveElement:"fluid.ariaLabeller.generateLiveElement"}});fluid.ariaLabeller=function(element,options){var that=fluid.initView("fluid.ariaLabeller",element,options);that.update=function(newOptions){newOptions=newOptions||that.options;that.container.attr(that.options.labelAttribute,newOptions.text);if(newOptions.dynamicLabel){var live=fluid.jById(that.options.liveRegionId);if(live.length===0){live=that.events.generateLiveElement.fire(that)}live.text(newOptions.text)}};that.update();return that};fluid.ariaLabeller.generateLiveElement=function(that){var liveEl=$(that.options.liveRegionMarkup);liveEl.prop("id",that.options.liveRegionId);$("body").append(liveEl);return liveEl};var LABEL_KEY="aria-labelling";fluid.getAriaLabeller=function(element){element=$(element);var that=fluid.getScopedData(element,LABEL_KEY);return that};fluid.updateAriaLabel=function(element,text,options){options=$.extend({},options||{},{text:text});var that=fluid.getAriaLabeller(element);if(!that){that=fluid.ariaLabeller(element,options);fluid.setScopedData(element,LABEL_KEY,that)}else{that.update(options)}return that};var dismissList={};$(document).click(function(event){var target=event.target;while(target){if(dismissList[target.id]){return }target=target.parentNode}fluid.each(dismissList,function(dismissFunc,key){dismissFunc(event);delete dismissList[key]})});fluid.globalDismissal=function(nodes,dismissFunc){fluid.each(nodes,function(node){var id=fluid.unwrap(node).ownerDocument===document?fluid.allocateSimpleId(node):fluid.allocateGuid();if(dismissFunc){dismissList[id]=dismissFunc}else{delete dismissList[id]}})};fluid.now=function(){return Date.now?Date.now():(new Date()).getTime()};fluid.deadMansBlur=function(control,options){var that=fluid.initLittleComponent("fluid.deadMansBlur",options);that.blurPending=false;that.lastCancel=0;that.canceller=function(event){fluid.log("Cancellation through "+event.type+" on "+fluid.dumpEl(event.target));that.lastCancel=fluid.now();that.blurPending=false};that.noteProceeded=function(){fluid.globalDismissal(that.options.exclusions)};that.reArm=function(){fluid.globalDismissal(that.options.exclusions,that.proceed)};that.addExclusion=function(exclusions){fluid.globalDismissal(exclusions,that.proceed)};that.proceed=function(event){fluid.log("Direct proceed through "+event.type+" on "+fluid.dumpEl(event.target));that.blurPending=false;that.options.handler(control)};fluid.each(that.options.exclusions,function(exclusion){exclusion=$(exclusion);fluid.each(exclusion,function(excludeEl){$(excludeEl).bind("focusin",that.canceller).bind("fluid-focus",that.canceller).click(that.canceller).mousedown(that.canceller)})});if(!that.options.cancelByDefault){$(control).bind("focusout",function(event){fluid.log("Starting blur timer for element "+fluid.dumpEl(event.target));var now=fluid.now();fluid.log("back delay: "+(now-that.lastCancel));if(now-that.lastCancel>that.options.backDelay){that.blurPending=true}setTimeout(function(){if(that.blurPending){that.options.handler(control)}},that.options.delay)})}else{that.reArm()}return that};fluid.defaults("fluid.deadMansBlur",{delay:150,backDelay:100})})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){var inCreationMarker="__CURRENTLY_IN_CREATION__";fluid.isFireBreak=function(component){return component.options&&component.options["fluid.visitComponents.fireBreak"]};fluid.visitComponentChildren=function(that,visitor,options,path){for(var name in that){var newPath=options.instantiator.composePath(path,name);var component=that[name];if(!component||!component.typeName||(component.id&&options.visited&&options.visited[component.id])){continue}if(options.visited){options.visited[component.id]=true}if(visitor(component,name,newPath,path)){return true}if(!fluid.isFireBreak(component)&&!options.flat){fluid.visitComponentChildren(component,visitor,options,newPath)}}};var visitComponents=function(instantiator,thatStack,visitor,options){options=options||{visited:{},flat:true,instantiator:instantiator};for(var i=thatStack.length-1;i>=0;--i){var that=thatStack[i];if(fluid.isFireBreak(that)){return }var path=instantiator.idToPath[that.id]||"";if(that.typeName){options.visited[that.id]=true;var memberName=fluid.pathUtil.getTailPath(path);if(visitor(that,memberName,path)){return }}if(fluid.visitComponentChildren(that,visitor,options,path)){return }}};function makeGingerStrategy(instantiator,that,thatStack){return function(component,thisSeg){var atval=component[thisSeg];if(atval===undefined){var parentPath=instantiator.idToPath[component.id];var childPath=fluid.composePath(parentPath,thisSeg);atval=instantiator.pathToComponent[childPath];if(atval){atval[inCreationMarker]=true}}if(atval!==undefined){if(atval[inCreationMarker]){fluid.fail("Component "+fluid.dumpThat(atval)+' at path "'+thisSeg+'" of parent '+fluid.dumpThat(component)+" cannot be used for lookup since it is still in creation. Please reorganise your dependencies so that they no longer contain circular references")}}else{if(fluid.get(component,fluid.path("options","components",thisSeg,"type"))){fluid.initDependent(component,thisSeg);atval=component[thisSeg]}}return atval}}fluid.dumpThat=function(that){return'{ typeName: "'+that.typeName+'" id: '+that.id+"}"};fluid.dumpThatStack=function(thatStack,instantiator){var togo=fluid.transform(thatStack,function(that){var path=instantiator.idToPath[that.id];return fluid.dumpThat(that)+(path?(" - path: "+path):"")});return togo.join("\n")};fluid.describeActivity=function(){return fluid.globalThreadLocal().activityStack||[]};fluid.pushActivity=function(func,message){if(!message||fluid.notrycatch){return func()}var root=fluid.globalThreadLocal();if(!root.activityStack){root.activityStack=[]}var frames=fluid.makeArray(message);frames.push("\n");frames.unshift("\n");root.activityStack=frames.concat(root.activityStack);return fluid.tryCatch(func,null,function(){root.activityStack=root.activityStack.slice(frames.length)})};fluid.wrapActivity=fluid.notrycatch?fluid.identity:function(func,messageSpec){return function(){var args=fluid.makeArray(arguments);var message=fluid.transform(fluid.makeArray(messageSpec),function(specEl){if(typeof (specEl)==="string"&&specEl.indexOf("arguments.")===0){var el=specEl.substring("arguments.".length);return fluid.get(args,el)}else{return specEl}});return fluid.pushActivity(function(){return func.apply(null,args)},message)}};var localRecordExpected=/arguments|options|container/;function makeStackFetcher(instantiator,parentThat,localRecord,expandOptions){expandOptions=expandOptions||{};var thatStack=instantiator.getFullStack(parentThat);var fetchStrategies=[fluid.model.funcResolverStrategy,makeGingerStrategy(instantiator,parentThat,thatStack)];var fetcher=function(parsed){var context=parsed.context;var foundComponent;if(context==="instantiator"){return instantiator}else{if(context==="that"){foundComponent=parentThat}else{if(localRecord&&localRecordExpected.test(context)){var fetched=fluid.get(localRecord[context],parsed.path);return(context==="arguments"||expandOptions.direct)?fetched:{marker:context==="options"?fluid.EXPAND:fluid.EXPAND_NOW,value:fetched}}}}if(!foundComponent){visitComponents(instantiator,thatStack,function(component,name){if(context===name||context===component.typeName||context===component.nickName){foundComponent=component;return true}if(fluid.get(component,fluid.path("options","components",context,"type"))&&!component[context]){foundComponent=fluid.get(component,context,{strategies:fetchStrategies});return true}})}if(!foundComponent&&parsed.path!==""){var ref=fluid.renderContextReference(parsed);fluid.log("Failed to resolve reference "+ref+": thatStack contains\n"+fluid.dumpThatStack(thatStack,instantiator));fluid.fail("Failed to resolve reference "+ref+" - could not match context with name "+context+" from component leaf of type "+parentThat.typeName,"\ninstantiator contents: ",instantiator)}return fluid.get(foundComponent,parsed.path,{strategies:fetchStrategies})};return fetcher}function makeStackResolverOptions(instantiator,parentThat,localRecord,expandOptions){return $.extend(true,{},fluid.defaults("fluid.resolveEnvironment"),{fetcher:makeStackFetcher(instantiator,parentThat,localRecord,expandOptions)})}fluid.clearListeners=function(idToListeners,key){fluid.each(idToListeners[key],function(rec){rec.event.removeListener(rec.listener)});delete idToListeners[key]};fluid.instantiator=function(freeInstantiator){var preThat={options:{"fluid.visitComponents.fireBreak":true},idToPath:{},pathToComponent:{},idToListeners:{},nickName:"instantiator",composePath:fluid.composePath};var that=fluid.typeTag("fluid.instantiator");that=$.extend(that,preThat);that.recordListener=function(event,listener,source){var listeners=that.idToListeners[source.id];if(!listeners){listeners=that.idToListeners[source.id]=[]}listeners.push({event:event,listener:listener})};that.getThatStack=function(component){var path=that.idToPath[component.id]||"";var parsed=fluid.model.parseEL(path);var togo=fluid.transform(parsed,function(value,i){var parentPath=fluid.model.composeSegments.apply(null,parsed.slice(0,i+1));return that.pathToComponent[parentPath]});var root=that.pathToComponent[""];if(root){togo.unshift(root)}return togo};that.getEnvironmentalStack=function(){var togo=[fluid.staticEnvironment];if(!freeInstantiator){togo.push(fluid.globalThreadLocal())}return togo};that.getFullStack=function(component){var thatStack=component?that.getThatStack(component):[];return that.getEnvironmentalStack().concat(thatStack)};function recordComponent(component,path,created){if(created){that.idToPath[component.id]=path}if(that.pathToComponent[path]){fluid.fail("Error during instantiation - path "+path+" which has just created component "+fluid.dumpThat(component)+" has already been used for component "+fluid.dumpThat(that.pathToComponent[path])+" - this is a circular instantiation or other oversight. Please clear the component using instantiator.clearComponent() before reusing the path.")}that.pathToComponent[path]=component}that.recordRoot=function(component){if(component&&component.id&&!that.pathToComponent[""]){recordComponent(component,"",true)}};that.pushUpcomingInstantiation=function(parent,name){that.expectedParent=parent;that.expectedName=name};that.recordComponent=function(component){if(that.expectedName){that.recordKnownComponent(that.expectedParent,component,that.expectedName,true);delete that.expectedName;delete that.expectedParent}else{that.recordRoot(component)}};that.clearComponent=function(component,name,child,options,noModTree,path){var record=that.idToPath[component.id];options=options||{flat:true,instantiator:that};child=child||component[name];path=path||record;if(path===undefined){fluid.fail("Cannot clear component "+name+" from component ",component," which was not created by this instantiator")}fluid.fireEvent(child,"events.onClear",[child,name,component]);var childPath=that.composePath(path,name);var childRecord=that.idToPath[child.id];if(childRecord===childPath){fluid.fireEvent(child,"events.onDestroy",[child,name,component]);fluid.clearListeners(that.idToListeners,child.id);fluid.visitComponentChildren(child,function(gchild,gchildname,newPath,parentPath){that.clearComponent(child,gchildname,null,options,true,parentPath)},options,childPath)}delete that.idToPath[child.id];delete that.pathToComponent[childPath];if(!noModTree){delete component[name]}};that.recordKnownComponent=function(parent,component,name,created){var parentPath=that.idToPath[parent.id]||"";var path=that.composePath(parentPath,name);recordComponent(component,path,created)};return that};fluid.freeInstantiator=fluid.instantiator(true);fluid.argMapToDemands=function(argMap){var togo=[];fluid.each(argMap,function(value,key){togo[value]="{"+key+"}"});return togo};fluid.makePassArgsSpec=function(initArgs){return fluid.transform(initArgs,function(arg,index){return"{arguments}."+index})};function mergeToMergeAll(options){if(options&&options.mergeOptions){options.mergeAllOptions=["{options}"].concat(fluid.makeArray(options.mergeOptions))}}function upgradeMergeOptions(demandspec){mergeToMergeAll(demandspec);if(demandspec.mergeAllOptions){if(demandspec.options){fluid.fail("demandspec ",demandspec," is invalid - cannot specify literal options together with mergeOptions or mergeAllOptions")}demandspec.options={mergeAllOptions:demandspec.mergeAllOptions}}if(demandspec.options){delete demandspec.options.mergeOptions}}fluid.embodyDemands=function(instantiator,parentThat,demandspec,initArgs,options){options=options||{};upgradeMergeOptions(demandspec);var oldOptions=fluid.get(options,"componentRecord.options");options.componentRecord=$.extend(true,{},options.componentRecord,fluid.censorKeys(demandspec,["args","funcName","registeredFrom"]));var mergeAllZero=fluid.get(options,"componentRecord.options.mergeAllOptions.0");if(mergeAllZero==="{options}"){fluid.set(options,"componentRecord.options.mergeAllOptions.0",oldOptions)}var demands=fluid.makeArray(demandspec.args);var upDefaults=fluid.defaults(demandspec.funcName);var argMap=upDefaults?upDefaults.argumentMap:null;var inferMap=false;if(!argMap&&(upDefaults||(options&&options.componentRecord))&&!options.passArgs){inferMap=true;if(demands.length<2){argMap=fluid.rawDefaults("fluid.littleComponent").argumentMap}else{argMap={options:demands.length-1}}}options=options||{};if(demands.length===0){if(options.componentRecord&&argMap){demands=fluid.argMapToDemands(argMap)}else{if(options.passArgs){demands=fluid.makePassArgsSpec(initArgs)}}}var localRecord=$.extend({arguments:initArgs},fluid.censorKeys(options.componentRecord,["type"]));fluid.each(argMap,function(index,name){if(initArgs.length>0){localRecord[name]=localRecord.arguments[index]}if(demandspec[name]!==undefined&&localRecord[name]===undefined){localRecord[name]=demandspec[name]}});mergeToMergeAll(localRecord.options);mergeToMergeAll(argMap&&demands[argMap.options]);var upstreamLocalRecord=$.extend({},localRecord);if(options.componentRecord.options!==undefined){upstreamLocalRecord.options=options.componentRecord.options}var expandOptions=makeStackResolverOptions(instantiator,parentThat,localRecord);var args=[];if(demands){for(var i=0;i<demands.length;++i){var arg=demands[i];if(fluid.isMarker(arg)&&arg.value===fluid.COMPONENT_OPTIONS.value){arg="{options}";if(inferMap){argMap={options:i}}}if(typeof (arg)==="string"){if(arg.charAt(0)==="@"){var argpos=arg.substring(1);arg="{arguments}."+argpos}}if(!argMap||argMap.options!==i){args[i]=fluid.expander.expandLight(arg,expandOptions)}else{if(arg&&typeof (arg)==="object"&&!arg.targetTypeName){arg.targetTypeName=demandspec.funcName}args[i]={marker:fluid.EXPAND,value:fluid.copy(arg),localRecord:upstreamLocalRecord}}if(args[i]&&fluid.isMarker(args[i].marker,fluid.EXPAND_NOW)){args[i]=fluid.expander.expandLight(args[i].value,expandOptions)}}}else{args=initArgs?initArgs:[]}var togo={args:args,funcName:demandspec.funcName};return togo};var aliasTable={};fluid.alias=function(demandingName,aliasName){if(aliasName){aliasTable[demandingName]=aliasName}else{return aliasTable[demandingName]}};var dependentStore={};function searchDemands(demandingName,contextNames){var exist=dependentStore[demandingName]||[];outer:for(var i=0;i<exist.length;++i){var rec=exist[i];for(var j=0;j<contextNames.length;++j){if(rec.contexts[j]!==contextNames[j]){continue outer}}return rec.spec}}var isDemandLogging=false;fluid.setDemandLogging=function(set){isDemandLogging=set};fluid.isDemandLogging=function(demandingNames){return isDemandLogging&&fluid.isLogging()};fluid.demands=function(demandingName,contextName,spec){var contextNames=fluid.makeArray(contextName).sort();if(!spec){return searchDemands(demandingName,contextNames)}else{if(spec.length){spec={args:spec}}}if(fluid.getCallerInfo&&fluid.isDemandLogging()){var callerInfo=fluid.getCallerInfo(5);if(callerInfo){spec.registeredFrom=callerInfo}}var exist=dependentStore[demandingName];if(!exist){exist=[];dependentStore[demandingName]=exist}exist.push({contexts:contextNames,spec:spec})};fluid.compareDemands=function(speca,specb){var p1=speca.uncess-specb.uncess;return p1===0?specb.intersect-speca.intersect:p1};fluid.locateAllDemands=function(instantiator,parentThat,demandingNames){var demandLogging=fluid.isDemandLogging(demandingNames);if(demandLogging){fluid.log("Resolving demands for function names ",demandingNames," in context of "+(parentThat?"component "+parentThat.typeName:"no component"))}var contextNames={};var visited=[];var thatStack=instantiator.getFullStack(parentThat);visitComponents(instantiator,thatStack,function(component,xname,path){contextNames[component.typeName]=true;visited.push(component)});if(demandLogging){fluid.log("Components in scope for resolution:\n"+fluid.dumpThatStack(visited,instantiator))}var matches=[];for(var i=0;i<demandingNames.length;++i){var rec=dependentStore[demandingNames[i]]||[];for(var j=0;j<rec.length;++j){var spec=rec[j];var record={spec:spec,intersect:0,uncess:0};for(var k=0;k<spec.contexts.length;++k){record[contextNames[spec.contexts[k]]?"intersect":"uncess"]+=2}if(spec.contexts.length===0){record.intersect++}matches.push(record)}}matches.sort(fluid.compareDemands);return matches};fluid.locateDemands=function(instantiator,parentThat,demandingNames){var matches=fluid.locateAllDemands(instantiator,parentThat,demandingNames);var demandspec=matches.length===0||matches[0].intersect===0?null:matches[0].spec.spec;if(fluid.isDemandLogging(demandingNames)){if(demandspec){fluid.log("Located "+matches.length+" potential match"+(matches.length===1?"":"es")+", selected best match with "+matches[0].intersect+" matched context names: ",demandspec)}else{fluid.log("No matches found for demands, using direct implementation")}}return demandspec};fluid.determineDemands=function(instantiator,parentThat,funcNames){funcNames=fluid.makeArray(funcNames);var newFuncName=funcNames[0];var demandspec=fluid.locateDemands(instantiator,parentThat,funcNames)||{};if(demandspec.funcName){newFuncName=demandspec.funcName}var aliasTo=fluid.alias(newFuncName);if(aliasTo){newFuncName=aliasTo;fluid.log("Following redirect from function name "+newFuncName+" to "+aliasTo);var demandspec2=fluid.locateDemands(instantiator,parentThat,[aliasTo]);if(demandspec2){fluid.each(demandspec2,function(value,key){if(localRecordExpected.test(key)){fluid.fail("Error in demands block ",demandspec2,' - content with key "'+key+'" is not supported since this demands block was resolved via an alias from "'+newFuncName+'"')}});if(demandspec2.funcName){newFuncName=demandspec2.funcName;fluid.log('Followed final inner demands to function name "'+newFuncName+'"')}}}return fluid.merge(null,{funcName:newFuncName,args:fluid.makeArray(demandspec.args)},fluid.censorKeys(demandspec,["funcName","args"]))};fluid.resolveDemands=function(instantiator,parentThat,funcNames,initArgs,options){var demandspec=fluid.determineDemands(instantiator,parentThat,funcNames);return fluid.embodyDemands(instantiator,parentThat,demandspec,initArgs,options)};fluid.invoke=function(functionName,args,that,environment){args=fluid.makeArray(args);return fluid.withInstantiator(that,function(instantiator){var invokeSpec=fluid.resolveDemands(instantiator,that,functionName,args,{passArgs:true});return fluid.invokeGlobalFunction(invokeSpec.funcName,invokeSpec.args,environment)})};fluid.invoke=fluid.wrapActivity(fluid.invoke,['    while invoking function with name "',"arguments.0",'" from component',"arguments.2"]);fluid.makeFreeInvoker=function(functionName,environment){var demandSpec=fluid.determineDemands(fluid.freeInstantiator,null,functionName);return function(){var invokeSpec=fluid.embodyDemands(fluid.freeInstantiator,null,demandSpec,fluid.makeArray(arguments),{passArgs:true});return fluid.invokeGlobalFunction(invokeSpec.funcName,invokeSpec.args,environment)}};fluid.makeInvoker=function(userInstantiator,that,demandspec,functionName,environment){demandspec=demandspec||fluid.determineDemands(userInstantiator,that,functionName);return function(){var args=fluid.makeArray(arguments);return fluid.withInstantiator(that,function(instantiator){var invokeSpec=fluid.embodyDemands(instantiator,that,demandspec,args,{passArgs:true});return fluid.invokeGlobalFunction(invokeSpec.funcName,invokeSpec.args,environment)},["    while invoking invoker with name "+functionName+" on component",that],userInstantiator)}};fluid.event.makeTrackedListenerAdder=function(instantiator,source){return function(event){return{addListener:function(listener){instantiator.recordListener(event,listener,source);event.addListener.apply(null,arguments)}}}};fluid.event.listenerEngine=function(eventSpec,callback,adder){var argstruc={};function checkFire(){var notall=fluid.find(eventSpec,function(value,key){if(argstruc[key]===undefined){return true}});if(!notall){callback(argstruc);fluid.clear(argstruc)}}fluid.each(eventSpec,function(event,eventName){adder(event).addListener(function(){argstruc[eventName]=fluid.makeArray(arguments);checkFire()})})};fluid.event.dispatchListener=function(instantiator,that,listener,eventName,eventSpec,indirectArgs){return fluid.wrapActivity(function(){if(typeof (listener)==="string"){listener=fluid.event.resolveListener({globalName:listener})}var args=indirectArgs?arguments[0]:fluid.makeArray(arguments);var demandspec=fluid.determineDemands(instantiator,that,eventName);if(demandspec.args.length===0&&eventSpec.args){demandspec.args=eventSpec.args}var resolved=fluid.embodyDemands(instantiator,that,demandspec,args,{passArgs:true,componentOptions:eventSpec});return listener.apply(null,resolved.args)},[" firing to listener to event named "+eventName+" of component ",that])};fluid.event.resolveListenerRecord=function(lisrec,that,eventName){return fluid.withInstantiator(that,function(instantiator){var records=fluid.makeArray(lisrec);var transRecs=fluid.transform(records,function(record){if(fluid.isPrimitive(record)){record={listener:record}}else{if(!record.listener){fluid.fail("Error in listener record ",record,' required field "listener" not found')}}var listener=fluid.expandOptions(record.listener,that);if(!listener){fluid.fail("Error in listener record - could not resolve reference "+record.listener+' to a listener or firer. Did you miss out "events." when referring to an event firer?')}if(listener.typeName==="fluid.event.firer"){listener=listener.fire}record.listener=fluid.event.dispatchListener(instantiator,that,listener,eventName,record);return record});return{records:transRecs,adderWrapper:fluid.event.makeTrackedListenerAdder(instantiator,that)}},["    while resolving listener record for event named "+eventName+" for component ",that])};fluid.event.expandOneEvent=function(event,that){var origin;if(typeof (event)==="string"&&event.charAt(0)!=="{"){origin=that.events[event]}else{origin=fluid.expandOptions(event,that)}if(!origin||origin.typeName!=="fluid.event.firer"){fluid.fail("Error in event specification - could not resolve base event reference ",event," to an event firer: got ",origin)}return origin};fluid.event.expandEvents=function(event,that){return typeof (event)==="string"?fluid.event.expandOneEvent(event,that):fluid.transform(event,function(oneEvent){return fluid.event.expandOneEvent(oneEvent,that)})};fluid.event.resolveEvent=function(that,eventName,eventSpec){return fluid.withInstantiator(that,function(instantiator){var adder=fluid.event.makeTrackedListenerAdder(instantiator,that);if(typeof (eventSpec)==="string"){eventSpec={event:eventSpec}}var event=eventSpec.event||eventSpec.events;if(!event){fluid.fail("Event specification for event with name "+eventName+" does not include a base event specification: ",eventSpec)}var origin=fluid.event.expandEvents(event,that);var isMultiple=origin.typeName!=="fluid.event.firer";var isComposite=eventSpec.args||isMultiple;var firer;if(isComposite){firer=fluid.event.getEventFirer(null,null," [composite] "+fluid.event.nameEvent(that,eventName));var dispatcher=fluid.event.dispatchListener(instantiator,that,firer.fire,eventName,eventSpec,isMultiple);if(isMultiple){fluid.event.listenerEngine(origin,dispatcher,adder)}else{adder(origin).addListener(dispatcher)}}else{firer={typeName:"fluid.event.firer"};firer.fire=function(){var outerArgs=fluid.makeArray(arguments);return fluid.withInstantiator(that,function(){return origin.fire.apply(null,outerArgs)}," firing synthetic event "+eventName,instantiator)};firer.addListener=function(listener,namespace,predicate,priority){var dispatcher=fluid.event.dispatchListener(instantiator,that,listener,eventName,eventSpec);adder(origin).addListener(dispatcher,namespace,predicate,priority)};firer.removeListener=function(listener){origin.removeListener(listener)}}return firer},["    while resolving event with name "+eventName+" attached to component ",that])};fluid.registerNamespace("fluid.expander");fluid.expander.preserveFromExpansion=function(options){var preserve={};var preserveList=fluid.arrayToHash(["mergePolicy","mergeAllOptions","components","invokers","events","listeners","transformOptions"]);fluid.each(options.mergePolicy,function(value,key){if(fluid.mergePolicyIs(value,"noexpand")){preserveList[key]=true}});fluid.each(preserveList,function(xvalue,path){var pen=fluid.model.accessWithStrategy(options,path,fluid.VALUE,fluid.model.defaultGetConfig,null,true);var last=pen.segs[pen.segs.length-1];var value=pen.root[last];delete pen.root[last];fluid.set(preserve,path,value)});return{restore:function(target){fluid.each(preserveList,function(xvalue,path){var preserved=fluid.get(preserve,path);if(preserved!==undefined){fluid.set(target,path,preserved)}})}}};fluid.expandOptions=function(args,that,localRecord,outerExpandOptions){if(!args){return args}return fluid.withInstantiator(that,function(instantiator){var expandOptions=makeStackResolverOptions(instantiator,that,localRecord,outerExpandOptions);expandOptions.noCopy=true;var pres;if(!fluid.isArrayable(args)&&!fluid.isPrimitive(args)){pres=fluid.expander.preserveFromExpansion(args)}var expanded=fluid.expander.expandLight(args,expandOptions);if(pres){pres.restore(expanded)}return expanded},["    while expanding options for component of type "+(that?that.typeName:"null")+": ",that])};fluid.locateTransformationRecord=function(that){return fluid.withInstantiator(that,function(instantiator){var matches=fluid.locateAllDemands(instantiator,that,["fluid.transformOptions"]);return fluid.find(matches,function(match){return match.uncess===0&&fluid.contains(match.spec.contexts,that.typeName)?match.spec.spec:undefined})})};fluid.hashToArray=function(hash){var togo=[];fluid.each(hash,function(value,key){togo.push(key)});return togo};fluid.localRecordExpected=["type","options","arguments","mergeOptions","mergeAllOptions","createOnEvent","priority"];fluid.checkComponentRecord=function(defaults,localRecord){var expected=fluid.arrayToHash(fluid.localRecordExpected);fluid.each(defaults.argumentMap,function(value,key){expected[key]=true});fluid.each(localRecord,function(value,key){if(!expected[key]){fluid.fail('Probable error in subcomponent record - key "'+key+'" found, where the only legal options are '+fluid.hashToArray(expected).join(", "))}})};fluid.expandComponentOptions=function(defaults,userOptions,that){if(userOptions&&userOptions.localRecord){fluid.checkComponentRecord(defaults,userOptions.localRecord)}defaults=fluid.expandOptions(fluid.copy(defaults),that);var localRecord={};if(userOptions&&userOptions.marker===fluid.EXPAND){var localOptions=fluid.get(userOptions,"localRecord.options");if(localOptions){if(defaults&&defaults.mergePolicy){localOptions.mergePolicy=defaults.mergePolicy}localRecord.options=fluid.expandOptions(localOptions,that)}localRecord.arguments=fluid.get(userOptions,"localRecord.arguments");var toExpand=userOptions.value;userOptions=fluid.expandOptions(toExpand,that,localRecord,{direct:true})}localRecord.directOptions=userOptions;if(!localRecord.options){localRecord.options=userOptions}var mergeOptions=(userOptions&&userOptions.mergeAllOptions)||["{directOptions}"];var togo=fluid.transform(mergeOptions,function(path){return path==="{directOptions}"?localRecord.directOptions:fluid.expandOptions(path,that,localRecord,{direct:true})});var transRec=fluid.locateTransformationRecord(that);if(transRec){togo[0].transformOptions=transRec.options}return[defaults].concat(togo)};fluid.expandComponentOptions=fluid.wrapActivity(fluid.expandComponentOptions,["    while expanding component options ","arguments.1.value"," with record ","arguments.1"," for component ","arguments.2"]);fluid.getInstantiators=function(){var root=fluid.globalThreadLocal();var ins=root["fluid.instantiator"];if(!ins){ins=root["fluid.instantiator"]=[]}return ins};fluid.withInstantiator=function(that,func,message,userInstantiator){var ins=fluid.getInstantiators();var oldLength;var instantiator=userInstantiator;return fluid.pushActivity(function(){return fluid.tryCatch(function(){if(!instantiator){if(ins.length===0){instantiator=fluid.instantiator();fluid.log("Created new instantiator with id "+instantiator.id+" in order to operate on component "+(that?that.typeName:"[none]"))}else{instantiator=ins[ins.length-1]}}ins.push(instantiator);oldLength=ins.length;if(that){instantiator.recordComponent(that)}return func(instantiator)},null,function(){if(ins.length!==oldLength){fluid.fail("Instantiator stack corrupted - old length "+oldLength+" new length "+ins.length)}if(ins[ins.length-1]!=instantiator){fluid.fail("Instantiator stack corrupted at stack top - old id "+instantiator.id+" new id "+ins[ins.length-1].id)}ins.length--;if(ins.length===0){fluid.log("Cleared instantiators (last id "+instantiator.id+") from threadLocal for end of "+(that?that.typeName:"[none]"))}})},message)};fluid.fabricateDestroyMethod=function(that,name,instantiator,child){return function(){instantiator.clearComponent(that,name,child)}};fluid.initDependent=function(that,name,userInstantiator,directArgs){if(!that||that[name]){return }fluid.log('Beginning instantiation of component with name "'+name+'" as child of '+fluid.dumpThat(that));directArgs=directArgs||[];var component=that.options.components[name];var instance;fluid.withInstantiator(that,function(instantiator){if(typeof (component)==="string"){var instance=fluid.expandOptions([component],that)[0];instantiator.recordKnownComponent(that,instance,name,false)}else{if(component.type){var invokeSpec=fluid.resolveDemands(instantiator,that,[component.type,name],directArgs,{componentRecord:component});instantiator.pushUpcomingInstantiation(that,name);fluid.tryCatch(function(){that[inCreationMarker]=true;instance=fluid.initSubcomponentImpl(that,{type:invokeSpec.funcName},invokeSpec.args);var path=instantiator.composePath(instantiator.idToPath[that.id]||"",name);var existing=instantiator.pathToComponent[path];if(existing&&existing!==instance){instantiator.clearComponent(that,name,existing)}if(instance&&instance.typeName&&instance.id&&instance!==existing){instantiator.recordKnownComponent(that,instance,name,true)}instance.destroy=fluid.fabricateDestroyMethod(that,name,instantiator,instance)},null,function(){delete that[inCreationMarker];instantiator.pushUpcomingInstantiation()})}else{fluid.fail("Unrecognised material in place of subcomponent "+name+' - no "type" field found')}}that[name]=instance;fluid.fireEvent(instance,"events.onAttach",[instance,name,that])},['    while instantiating dependent component with name "'+name+'" with record ',component," as child of ",that],userInstantiator);if(instance){fluid.log('Finished instantiation of component with name "'+name+'" and id '+instance.id+" as child of "+fluid.dumpThat(that))}};fluid.bindDeferredComponent=function(that,componentName,component,instantiator){var events=fluid.makeArray(component.createOnEvent);fluid.each(events,function(eventName){that.events[eventName].addListener(function(){fluid.log("Beginning instantiation of deferred component "+componentName+" due to event "+eventName);if(that[componentName]){instantiator.clearComponent(that,componentName)}fluid.initDependent(that,componentName,instantiator)},null,null,component.priority)})};fluid.priorityForComponent=function(component){return component.priority?component.priority:(component.type==="fluid.typeFount"||fluid.hasGrade(fluid.defaults(component.type),"fluid.typeFount"))?"first":undefined};fluid.initDependents=function(that){var options=that.options;var components=options.components||{};var componentSort={};fluid.withInstantiator(that,function(instantiator){fluid.each(components,function(component,name){if(!component.createOnEvent){var priority=fluid.priorityForComponent(component);componentSort[name]={key:name,priority:fluid.event.mapPriority(priority,0)}}else{fluid.bindDeferredComponent(that,name,component,instantiator)}});var componentList=fluid.event.sortListeners(componentSort);fluid.each(componentList,function(entry){fluid.initDependent(that,entry.key)});var invokers=options.invokers||{};for(var name in invokers){var invokerec=invokers[name];var funcName=typeof (invokerec)==="string"?invokerec:null;that[name]=fluid.withInstantiator(that,function(instantiator){fluid.log('Beginning instantiation of invoker with name "'+name+'" as child of '+fluid.dumpThat(that));return fluid.makeInvoker(instantiator,that,funcName?null:invokerec,funcName)},['    while instantiating invoker with name "'+name+'" with record ',invokerec," as child of ",that]);fluid.log('Finished instantiation of invoker with name "'+name+'" as child of '+fluid.dumpThat(that))}},["    while instantiating dependent components for component "+that.typeName])};fluid.staticEnvironment=fluid.typeTag("fluid.staticEnvironment");fluid.globalThreadLocal=fluid.threadLocal(function(){return fluid.typeTag("fluid.dynamicEnvironment")});fluid.withEnvironment=function(envAdd,func,root){root=root||fluid.globalThreadLocal();return fluid.tryCatch(function(){for(var key in envAdd){root[key]=envAdd[key]}$.extend(root,envAdd);return func()},null,function(){for(var key in envAdd){delete root[key]}})};fluid.makeEnvironmentFetcher=function(directModel,elResolver,envGetter){envGetter=envGetter||fluid.globalThreadLocal;return function(parsed){var env=envGetter();return fluid.fetchContextReference(parsed,directModel,env,elResolver)}};fluid.extractEL=function(string,options){if(options.ELstyle==="ALL"){return string}else{if(options.ELstyle.length===1){if(string.charAt(0)===options.ELstyle){return string.substring(1)}}else{if(options.ELstyle==="${}"){var i1=string.indexOf("${");var i2=string.lastIndexOf("}");if(i1===0&&i2!==-1){return string.substring(2,i2)}}}}};fluid.extractELWithContext=function(string,options){var EL=fluid.extractEL(string,options);if(EL&&EL.charAt(0)==="{"){return fluid.parseContextReference(EL,0)}return EL?{path:EL}:EL};fluid.parseContextReference=function(reference,index,delimiter){var endcpos=reference.indexOf("}",index+1);if(endcpos===-1){fluid.fail('Cannot parse context reference "'+reference+'": Malformed context reference without }')}var context=reference.substring(index+1,endcpos);var endpos=delimiter?reference.indexOf(delimiter,endcpos+1):reference.length;var path=reference.substring(endcpos+1,endpos);if(path.charAt(0)==="."){path=path.substring(1)}return{context:context,path:path,endpos:endpos}};fluid.renderContextReference=function(parsed){return"{"+parsed.context+"}."+parsed.path};fluid.fetchContextReference=function(parsed,directModel,env,elResolver){if(elResolver){parsed=elResolver(parsed,env)}var base=parsed.context?env[parsed.context]:directModel;if(!base){return base}return parsed.noDereference?parsed.path:fluid.get(base,parsed.path)};fluid.resolveContextValue=function(string,options){if(options.bareContextRefs&&string.charAt(0)==="{"){var parsed=fluid.parseContextReference(string,0);return options.fetcher(parsed)}else{if(options.ELstyle&&options.ELstyle!=="${}"){var parsed=fluid.extractELWithContext(string,options);if(parsed){return options.fetcher(parsed)}}}while(typeof (string)==="string"){var i1=string.indexOf("${");var i2=string.indexOf("}",i1+2);if(i1!==-1&&i2!==-1){var parsed;if(string.charAt(i1+2)==="{"){parsed=fluid.parseContextReference(string,i1+2,"}");i2=parsed.endpos}else{parsed={path:string.substring(i1+2,i2)}}var subs=options.fetcher(parsed);var all=(i1===0&&i2===string.length-1);if(subs===undefined||subs===null){return subs}string=all?subs:string.substring(0,i1)+subs+string.substring(i2+1)}else{break}}return string};fluid.resolveContextValue=fluid.wrapActivity(fluid.resolveContextValue,["    while resolving context value ","arguments.0"]);function resolveEnvironmentImpl(obj,options){fluid.guardCircularity(options.seenIds,obj,"expansion",' - please ensure options are not circularly connected, or protect from expansion using the "noexpand" policy or expander');function recurse(arg){return resolveEnvironmentImpl(arg,options)}if(typeof (obj)==="string"&&!options.noValue){return fluid.resolveContextValue(obj,options)}else{if(fluid.isPrimitive(obj)||obj.nodeType!==undefined||obj.jquery){return obj}else{if(options.filter){return options.filter(obj,recurse,options)}else{return(options.noCopy?fluid.each:fluid.transform)(obj,function(value,key){return resolveEnvironmentImpl(value,options)})}}}}fluid.defaults("fluid.resolveEnvironment",{ELstyle:"${}",seenIds:{},bareContextRefs:true});fluid.resolveEnvironment=function(obj,options){options=$.extend({},fluid.rawDefaults("fluid.resolveEnvironment"),options);options.seenIds={};return resolveEnvironmentImpl(obj,options)};fluid.expander.deferredCall=function(target,source,recurse){var expander=source.expander;var args=(!expander.args||fluid.isArrayable(expander.args))?expander.args:fluid.makeArray(expander.args);args=recurse(args);return fluid.invokeGlobalFunction(expander.func,args)};fluid.deferredCall=fluid.expander.deferredCall;fluid.deferredInvokeCall=function(target,source,recurse){var expander=source.expander;var args=(!expander.args||fluid.isArrayable(expander.args))?expander.args:fluid.makeArray(expander.args);args=recurse(args);return fluid.invoke(expander.func,args)};fluid.expander.noexpand=function(target,source){return $.extend(target,source.expander.tree)};fluid.noexpand=fluid.expander.noexpand;fluid.expander.lightFilter=function(obj,recurse,options){var togo;if(fluid.isArrayable(obj)){togo=options.noCopy?obj:[];fluid.each(obj,function(value,key){togo[key]=recurse(value)})}else{togo=options.noCopy?obj:{};for(var key in obj){var value=obj[key];var expander;if(key==="expander"&&!(options.expandOnly&&options.expandOnly[value.type])){expander=fluid.getGlobalValue(value.type);if(expander){return expander.call(null,togo,obj,recurse,options)}}if(key!=="expander"||!expander){togo[key]=recurse(value)}}}return options.noCopy?obj:togo};fluid.expander.expandLight=function(source,expandOptions){var options=$.extend({},expandOptions);options.filter=fluid.expander.lightFilter;return fluid.resolveEnvironment(source,options)}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){var resourceCache={};var pendingClass={};fluid.fetchResources=function(resourceSpecs,callback,options){var that=fluid.initLittleComponent("fluid.fetchResources",options);that.resourceSpecs=resourceSpecs;that.callback=callback;that.operate=function(){fluid.fetchResources.fetchResourcesImpl(that)};fluid.each(resourceSpecs,function(resourceSpec,key){resourceSpec.recurseFirer=fluid.event.getEventFirer(null,null,'I/O completion for resource "'+key+'"');resourceSpec.recurseFirer.addListener(that.operate);if(resourceSpec.url&&!resourceSpec.href){resourceSpec.href=resourceSpec.url}});if(that.options.amalgamateClasses){fluid.fetchResources.amalgamateClasses(resourceSpecs,that.options.amalgamateClasses,that.operate)}that.operate();return that};fluid.fetchResources.amalgamateClasses=function(specs,classes,operator){fluid.each(classes,function(clazz){var pending=pendingClass[clazz];fluid.each(pending,function(pendingrec,canon){specs[clazz+"!"+canon]=pendingrec;pendingrec.recurseFirer.addListener(operator)})})};fluid.fetchResources.timeSuccessCallback=function(resourceSpec){if(resourceSpec.timeSuccess&&resourceSpec.options&&resourceSpec.options.success){var success=resourceSpec.options.success;resourceSpec.options.success=function(){var startTime=new Date();var ret=success.apply(null,arguments);fluid.log("External callback for URL "+resourceSpec.href+" completed - callback time: "+(new Date().getTime()-startTime.getTime())+"ms");return ret}}};function canonUrl(url){return url}fluid.fetchResources.clearResourceCache=function(url){if(url){delete resourceCache[canonUrl(url)]}else{fluid.clear(resourceCache)}};fluid.fetchResources.handleCachedRequest=function(resourceSpec,response){var canon=canonUrl(resourceSpec.href);var cached=resourceCache[canon];if(cached.$$firer$$){fluid.log("Handling request for "+canon+" from cache");var fetchClass=resourceSpec.fetchClass;if(fetchClass&&pendingClass[fetchClass]){fluid.log("Clearing pendingClass entry for class "+fetchClass);delete pendingClass[fetchClass][canon]}resourceCache[canon]=response;cached.fire(response)}};fluid.fetchResources.completeRequest=function(thisSpec,recurseCall){thisSpec.queued=false;thisSpec.completeTime=new Date();fluid.log("Request to URL "+thisSpec.href+" completed - total elapsed time: "+(thisSpec.completeTime.getTime()-thisSpec.initTime.getTime())+"ms");thisSpec.recurseFirer.fire()};fluid.fetchResources.makeResourceCallback=function(thisSpec){return{success:function(response){thisSpec.resourceText=response;thisSpec.resourceKey=thisSpec.href;if(thisSpec.forceCache){fluid.fetchResources.handleCachedRequest(thisSpec,response)}fluid.fetchResources.completeRequest(thisSpec)},error:function(response,textStatus,errorThrown){thisSpec.fetchError={status:response.status,textStatus:response.textStatus,errorThrown:errorThrown};fluid.fetchResources.completeRequest(thisSpec)}}};fluid.fetchResources.issueCachedRequest=function(resourceSpec,options){var canon=canonUrl(resourceSpec.href);var cached=resourceCache[canon];if(!cached){fluid.log("First request for cached resource with url "+canon);cached=fluid.event.getEventFirer(null,null,"cache notifier for resource URL "+canon);cached.$$firer$$=true;resourceCache[canon]=cached;var fetchClass=resourceSpec.fetchClass;if(fetchClass){if(!pendingClass[fetchClass]){pendingClass[fetchClass]={}}pendingClass[fetchClass][canon]=resourceSpec}options.cache=false;$.ajax(options)}else{if(!cached.$$firer$$){options.success(cached)}else{fluid.log("Request for cached resource which is in flight: url "+canon);cached.addListener(function(response){options.success(response)})}}};fluid.fetchResources.composeCallbacks=function(internal,external){return external?function(){try{external.apply(null,arguments)}catch(e){fluid.log("Exception applying external fetchResources callback: "+e)}internal.apply(null,arguments)}:internal};fluid.fetchResources.composePolicy=function(target,source,key){return fluid.fetchResources.composeCallbacks(target,source)};fluid.defaults("fluid.fetchResources.issueRequest",{mergePolicy:{success:fluid.fetchResources.composePolicy,error:fluid.fetchResources.composePolicy,url:"reverse"}});fluid.fetchResources.issueRequest=function(resourceSpec,key){var thisCallback=fluid.fetchResources.makeResourceCallback(resourceSpec);var options={url:resourceSpec.href,success:thisCallback.success,error:thisCallback.error,dataType:"text"};fluid.fetchResources.timeSuccessCallback(resourceSpec);fluid.merge(fluid.defaults("fluid.fetchResources.issueRequest").mergePolicy,options,resourceSpec.options);resourceSpec.queued=true;resourceSpec.initTime=new Date();fluid.log("Request with key "+key+" queued for "+resourceSpec.href);if(resourceSpec.forceCache){fluid.fetchResources.issueCachedRequest(resourceSpec,options)}else{$.ajax(options)}};fluid.fetchResources.fetchResourcesImpl=function(that){var complete=true;var allSync=true;var resourceSpecs=that.resourceSpecs;for(var key in resourceSpecs){var resourceSpec=resourceSpecs[key];if(!resourceSpec.options||resourceSpec.options.async){allSync=false}if(resourceSpec.href&&!resourceSpec.completeTime){if(!resourceSpec.queued){fluid.fetchResources.issueRequest(resourceSpec,key)}if(resourceSpec.queued){complete=false}}else{if(resourceSpec.nodeId&&!resourceSpec.resourceText){var node=document.getElementById(resourceSpec.nodeId);resourceSpec.resourceText=fluid.dom.getElementText(node);resourceSpec.resourceKey=resourceSpec.nodeId}}}if(complete&&that.callback&&!that.callbackCalled){that.callbackCalled=true;if($.browser.mozilla&&!allSync){setTimeout(function(){that.callback(resourceSpecs)},1)}else{that.callback(resourceSpecs)}}};fluid.fetchResources.primeCacheFromResources=function(componentName){var resources=fluid.defaults(componentName).resources;var that={typeName:"fluid.fetchResources.primeCacheFromResources"};var expanded=(fluid.expandOptions?fluid.expandOptions:fluid.identity)(fluid.copy(resources),that);fluid.fetchResources(expanded)};fluid.registerNamespace("fluid.expander");fluid.expander.makeDefaultFetchOptions=function(successdisposer,failid,options){return $.extend(true,{dataType:"text"},options,{success:function(response,environmentdisposer){var json=JSON.parse(response);environmentdisposer(successdisposer(json))},error:function(response,textStatus){fluid.log("Error fetching "+failid+": "+textStatus)}})};fluid.expander.makeFetchExpander=function(options){return{expander:{type:"fluid.expander.deferredFetcher",href:options.url,options:fluid.expander.makeDefaultFetchOptions(options.disposer,options.url,options.options),resourceSpecCollector:"{resourceSpecCollector}",fetchKey:options.fetchKey}}};fluid.expander.deferredFetcher=function(target,source,recurse,expandOptions){var expander=source.expander;var spec=fluid.copy(expander);var collector=fluid.resolveEnvironment(expander.resourceSpecCollector,expandOptions);delete spec.type;delete spec.resourceSpecCollector;delete spec.fetchKey;var environmentdisposer=function(disposed){$.extend(target,disposed)};spec.options.success=function(response){expander.options.success(response,environmentdisposer)};var key=expander.fetchKey||fluid.allocateGuid();collector[key]=spec;return target}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.registerNamespace("fluid.enhance");fluid.enhance.isBrowser=function(){return typeof (window)!=="undefined"&&window.document};fluid.enhance.supportsBinaryXHR=function(){return window.FormData||(window.XMLHttpRequest&&window.XMLHttpRequest.prototype&&window.XMLHttpRequest.prototype.sendAsBinary)};fluid.enhance.supportsFormData=function(){return !!window.FormData};fluid.enhance.supportsFlash=function(){return(typeof (swfobject)!=="undefined")&&(swfobject.getFlashPlayerVersion().major>8)};fluid.enhance.checked={};fluid.enhance.sep="--";fluid.enhance.typeToKey=function(typeName){return typeName.replace(/[.]/gi,fluid.enhance.sep)};fluid.enhance.check=function(stuffToCheck){fluid.each(stuffToCheck,function(val,key){var staticKey=fluid.enhance.typeToKey(key);if(fluid.enhance.checked[staticKey]===undefined){var results=typeof (val)==="string"?fluid.invokeGlobalFunction(val):val();fluid.enhance.checked[staticKey]=results;if(results){fluid.staticEnvironment[staticKey]=fluid.typeTag(key)}}})};fluid.enhance.forget=function(typeName){var key=fluid.enhance.typeToKey(typeName);if(fluid.enhance.checked[key]!==undefined){delete fluid.staticEnvironment[key];delete fluid.enhance.checked[key]}};fluid.enhance.forgetAll=function(){fluid.each(fluid.enhance.checked,function(val,key){fluid.enhance.forget(key)})};fluid.progressiveChecker=function(options){var that=fluid.initLittleComponent("fluid.progressiveChecker",options);return fluid.typeTag(fluid.find(that.options.checks,function(check){if(check.feature){return check.contextName}},that.options.defaultContextName))};fluid.defaults("fluid.progressiveChecker",{gradeNames:"fluid.typeFount",checks:[],defaultContextName:undefined});fluid.progressiveCheckerForComponent=function(options){var that=fluid.initLittleComponent("fluid.progressiveCheckerForComponent",options);var defaults=fluid.defaults(that.options.componentName);return fluid.progressiveChecker(fluid.expandOptions(fluid.copy(defaults.progressiveCheckerOptions),that))};fluid.defaults("fluid.progressiveCheckerForComponent",{gradeNames:"fluid.typeFount"});if(fluid.enhance.isBrowser()){$("head").append("<style type='text/css'>.fl-progEnhance-basic, .fl-ProgEnhance-basic { display: none; } .fl-progEnhance-enhanced, .fl-ProgEnhance-enhanced { display: block; }</style>")}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.XMLP=function(strXML){return fluid.XMLP.XMLPImpl(strXML)};fluid.XMLP.closedTags={abbr:true,br:true,col:true,img:true,input:true,link:true,meta:true,param:true,hr:true,area:true,embed:true};fluid.XMLP._NONE=0;fluid.XMLP._ELM_B=1;fluid.XMLP._ELM_E=2;fluid.XMLP._ELM_EMP=3;fluid.XMLP._ATT=4;fluid.XMLP._TEXT=5;fluid.XMLP._ENTITY=6;fluid.XMLP._PI=7;fluid.XMLP._CDATA=8;fluid.XMLP._COMMENT=9;fluid.XMLP._DTD=10;fluid.XMLP._ERROR=11;fluid.XMLP._CONT_XML=0;fluid.XMLP._CONT_ALT=1;fluid.XMLP._ATT_NAME=0;fluid.XMLP._ATT_VAL=1;fluid.XMLP._STATE_PROLOG=1;fluid.XMLP._STATE_DOCUMENT=2;fluid.XMLP._STATE_MISC=3;fluid.XMLP._errs=[];fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_PI=0]="PI: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_DTD=1]="DTD: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_COMMENT=2]="Comment: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_CDATA=3]="CDATA: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_ELM=4]="Element: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_CLOSE_ENTITY=5]="Entity: missing closing sequence";fluid.XMLP._errs[fluid.XMLP.ERR_PI_TARGET=6]="PI: target is required";fluid.XMLP._errs[fluid.XMLP.ERR_ELM_EMPTY=7]="Element: cannot be both empty and closing";fluid.XMLP._errs[fluid.XMLP.ERR_ELM_NAME=8]='Element: name must immediatly follow "<"';fluid.XMLP._errs[fluid.XMLP.ERR_ELM_LT_NAME=9]='Element: "<" not allowed in element names';fluid.XMLP._errs[fluid.XMLP.ERR_ATT_VALUES=10]="Attribute: values are required and must be in quotes";fluid.XMLP._errs[fluid.XMLP.ERR_ATT_LT_NAME=11]='Element: "<" not allowed in attribute names';fluid.XMLP._errs[fluid.XMLP.ERR_ATT_LT_VALUE=12]='Attribute: "<" not allowed in attribute values';fluid.XMLP._errs[fluid.XMLP.ERR_ATT_DUP=13]="Attribute: duplicate attributes not allowed";fluid.XMLP._errs[fluid.XMLP.ERR_ENTITY_UNKNOWN=14]="Entity: unknown entity";fluid.XMLP._errs[fluid.XMLP.ERR_INFINITELOOP=15]="Infinite loop";fluid.XMLP._errs[fluid.XMLP.ERR_DOC_STRUCTURE=16]="Document: only comments, processing instructions, or whitespace allowed outside of document element";fluid.XMLP._errs[fluid.XMLP.ERR_ELM_NESTING=17]="Element: must be nested correctly";fluid.XMLP._checkStructure=function(that,iEvent){var stack=that.m_stack;if(fluid.XMLP._STATE_PROLOG==that.m_iState){that.m_iState=fluid.XMLP._STATE_DOCUMENT}if(fluid.XMLP._STATE_DOCUMENT===that.m_iState){if((fluid.XMLP._ELM_B==iEvent)||(fluid.XMLP._ELM_EMP==iEvent)){that.m_stack[stack.length]=that.getName()}if((fluid.XMLP._ELM_E==iEvent)||(fluid.XMLP._ELM_EMP==iEvent)){if(stack.length===0){return fluid.XMLP._NONE}var strTop=stack[stack.length-1];that.m_stack.length--;if(strTop===null||strTop!==that.getName()){return that._setErr(that,fluid.XMLP.ERR_ELM_NESTING)}}}return iEvent};fluid.XMLP._parseCDATA=function(that,iB){var iE=that.m_xml.indexOf("]]>",iB);if(iE==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_CLOSE_CDATA)}fluid.XMLP._setContent(that,fluid.XMLP._CONT_XML,iB,iE);that.m_iP=iE+3;return fluid.XMLP._CDATA};fluid.XMLP._parseComment=function(that,iB){var iE=that.m_xml.indexOf("-->",iB);if(iE==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_CLOSE_COMMENT)}fluid.XMLP._setContent(that,fluid.XMLP._CONT_XML,iB-4,iE+3);that.m_iP=iE+3;return fluid.XMLP._COMMENT};fluid.XMLP._parseDTD=function(that,iB){var iE,strClose,iInt,iLast;iE=that.m_xml.indexOf(">",iB);if(iE==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_CLOSE_DTD)}iInt=that.m_xml.indexOf("[",iB);strClose=((iInt!=-1)&&(iInt<iE))?"]>":">";while(true){if(iE==iLast){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_INFINITELOOP)}iLast=iE;iE=that.m_xml.indexOf(strClose,iB);if(iE==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_CLOSE_DTD)}if(that.m_xml.substring(iE-1,iE+2)!="]]>"){break}}that.m_iP=iE+strClose.length;return fluid.XMLP._DTD};fluid.XMLP._parsePI=function(that,iB){var iE,iTB,iTE,iCB,iCE;iE=that.m_xml.indexOf("?>",iB);if(iE==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_CLOSE_PI)}iTB=fluid.SAXStrings.indexOfNonWhitespace(that.m_xml,iB,iE);if(iTB==-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_PI_TARGET)}iTE=fluid.SAXStrings.indexOfWhitespace(that.m_xml,iTB,iE);if(iTE==-1){iTE=iE}iCB=fluid.SAXStrings.indexOfNonWhitespace(that.m_xml,iTE,iE);if(iCB==-1){iCB=iE}iCE=fluid.SAXStrings.lastIndexOfNonWhitespace(that.m_xml,iCB,iE);if(iCE==-1){iCE=iE-1}that.m_name=that.m_xml.substring(iTB,iTE);fluid.XMLP._setContent(that,fluid.XMLP._CONT_XML,iCB,iCE+1);that.m_iP=iE+2;return fluid.XMLP._PI};fluid.XMLP._parseText=function(that,iB){var iE=that.m_xml.indexOf("<",iB);if(iE==-1){iE=that.m_xml.length}fluid.XMLP._setContent(that,fluid.XMLP._CONT_XML,iB,iE);that.m_iP=iE;return fluid.XMLP._TEXT};fluid.XMLP._setContent=function(that,iSrc){var args=arguments;if(fluid.XMLP._CONT_XML==iSrc){that.m_cAlt=null;that.m_cB=args[2];that.m_cE=args[3]}else{that.m_cAlt=args[2];that.m_cB=0;that.m_cE=args[2].length}that.m_cSrc=iSrc};fluid.XMLP._setErr=function(that,iErr){var strErr=fluid.XMLP._errs[iErr];that.m_cAlt=strErr;that.m_cB=0;that.m_cE=strErr.length;that.m_cSrc=fluid.XMLP._CONT_ALT;return fluid.XMLP._ERROR};fluid.XMLP._parseElement=function(that,iB){var iE,iDE,iRet;var iType,strN,iLast;iDE=iE=that.m_xml.indexOf(">",iB);if(iE==-1){return that._setErr(that,fluid.XMLP.ERR_CLOSE_ELM)}if(that.m_xml.charAt(iB)=="/"){iType=fluid.XMLP._ELM_E;iB++}else{iType=fluid.XMLP._ELM_B}if(that.m_xml.charAt(iE-1)=="/"){if(iType==fluid.XMLP._ELM_E){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ELM_EMPTY)}iType=fluid.XMLP._ELM_EMP;iDE--}that.nameRegex.lastIndex=iB;var nameMatch=that.nameRegex.exec(that.m_xml);if(!nameMatch){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ELM_NAME)}strN=nameMatch[1].toLowerCase();if("li"===strN&&iType!==fluid.XMLP._ELM_E&&that.m_stack.length>0&&that.m_stack[that.m_stack.length-1]==="li"&&!that.m_emitSynthetic){that.m_name="li";that.m_emitSynthetic=true;return fluid.XMLP._ELM_E}that.m_attributes={};that.m_cAlt="";if(that.nameRegex.lastIndex<iDE){that.m_iP=that.nameRegex.lastIndex;while(that.m_iP<iDE){that.attrStartRegex.lastIndex=that.m_iP;var attrMatch=that.attrStartRegex.exec(that.m_xml);if(!attrMatch){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ATT_VALUES)}var attrname=attrMatch[1].toLowerCase();var attrval;if(that.m_xml.charCodeAt(that.attrStartRegex.lastIndex)===61){var valRegex=that.m_xml.charCodeAt(that.attrStartRegex.lastIndex+1)===34?that.attrValRegex:that.attrValIERegex;valRegex.lastIndex=that.attrStartRegex.lastIndex+1;attrMatch=valRegex.exec(that.m_xml);if(!attrMatch){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ATT_VALUES)}attrval=attrMatch[1]}else{attrval=attrname;valRegex=that.attrStartRegex}if(!that.m_attributes[attrname]){that.m_attributes[attrname]=attrval}else{return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ATT_DUP)}that.m_iP=valRegex.lastIndex}}if(strN.indexOf("<")!=-1){return fluid.XMLP._setErr(that,fluid.XMLP.ERR_ELM_LT_NAME)}that.m_name=strN;that.m_iP=iE+1;if(fluid.XMLP.closedTags[strN]){that.closeRegex.lastIndex=iE+1;var closeMatch=that.closeRegex.exec;if(closeMatch){var matchclose=that.m_xml.indexOf(strN,closeMatch.lastIndex);if(matchclose===closeMatch.lastIndex){return iType}else{return fluid.XMLP._ELM_EMP}}}that.m_emitSynthetic=false;return iType};fluid.XMLP._parse=function(that){var iP=that.m_iP;var xml=that.m_xml;if(iP===xml.length){return fluid.XMLP._NONE}var c=xml.charAt(iP);if(c==="<"){var c2=xml.charAt(iP+1);if(c2==="?"){return fluid.XMLP._parsePI(that,iP+2)}else{if(c2==="!"){if(iP===xml.indexOf("<!DOCTYPE",iP)){return fluid.XMLP._parseDTD(that,iP+9)}else{if(iP===xml.indexOf("<!--",iP)){return fluid.XMLP._parseComment(that,iP+4)}else{if(iP===xml.indexOf("<![CDATA[",iP)){return fluid.XMLP._parseCDATA(that,iP+9)}}}}else{return fluid.XMLP._parseElement(that,iP+1)}}}else{return fluid.XMLP._parseText(that,iP)}};fluid.XMLP.XMLPImpl=function(strXML){var that={};that.m_xml=strXML;that.m_iP=0;that.m_iState=fluid.XMLP._STATE_PROLOG;that.m_stack=[];that.m_attributes={};that.m_emitSynthetic=false;that.getColumnNumber=function(){return fluid.SAXStrings.getColumnNumber(that.m_xml,that.m_iP)};that.getContent=function(){return(that.m_cSrc==fluid.XMLP._CONT_XML)?that.m_xml:that.m_cAlt};that.getContentBegin=function(){return that.m_cB};that.getContentEnd=function(){return that.m_cE};that.getLineNumber=function(){return fluid.SAXStrings.getLineNumber(that.m_xml,that.m_iP)};that.getName=function(){return that.m_name};that.next=function(){return fluid.XMLP._checkStructure(that,fluid.XMLP._parse(that))};that.nameRegex=/([^\s\/>]+)/g;that.attrStartRegex=/\s*([\w:_][\w:_\-\.]*)/gm;that.attrValRegex=/\"([^\"]*)\"\s*/gm;that.attrValIERegex=/([^\>\s]+)\s*/gm;that.closeRegex=/\s*<\//g;return that};fluid.SAXStrings={};fluid.SAXStrings.WHITESPACE=" \t\n\r";fluid.SAXStrings.QUOTES="\"'";fluid.SAXStrings.getColumnNumber=function(strD,iP){if(!strD){return -1}iP=iP||strD.length;var arrD=strD.substring(0,iP).split("\n");arrD.length--;var iLinePos=arrD.join("\n").length;return iP-iLinePos};fluid.SAXStrings.getLineNumber=function(strD,iP){if(!strD){return -1}iP=iP||strD.length;return strD.substring(0,iP).split("\n").length};fluid.SAXStrings.indexOfNonWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iB;i<iE;++i){var c=strD.charAt(i);if(c!==" "&&c!=="\t"&&c!=="\n"&&c!=="\r"){return i}}return -1};fluid.SAXStrings.indexOfWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iB;i<iE;i++){if(fluid.SAXStrings.WHITESPACE.indexOf(strD.charAt(i))!=-1){return i}}return -1};fluid.SAXStrings.lastIndexOfNonWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iE-1;i>=iB;i--){if(fluid.SAXStrings.WHITESPACE.indexOf(strD.charAt(i))==-1){return i}}return -1};fluid.SAXStrings.replace=function(strD,iB,iE,strF,strR){if(!strD){return""}iB=iB||0;iE=iE||strD.length;return strD.substring(iB,iE).split(strF).join(strR)}})(jQuery,fluid_1_5);fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.parseTemplate=function(template,baseURL,scanStart,cutpoints_in,opts){opts=opts||{};if(!template){fluid.fail("empty template supplied to fluid.parseTemplate")}var t;var parser;var tagstack;var lumpindex=0;var nestingdepth=0;var justended=false;var defstart=-1;var defend=-1;var debugMode=false;var cutpoints=[];var simpleClassCutpoints={};var cutstatus=[];var XMLLump=function(lumpindex,nestingdepth){return{nestingdepth:nestingdepth,lumpindex:lumpindex,parent:t}};function isSimpleClassCutpoint(tree){return tree.length===1&&tree[0].predList.length===1&&tree[0].predList[0].clazz}function init(baseURLin,debugModeIn,cutpointsIn){t.rootlump=XMLLump(0,-1);tagstack=[t.rootlump];lumpindex=0;nestingdepth=0;justended=false;defstart=-1;defend=-1;baseURL=baseURLin;debugMode=debugModeIn;if(cutpointsIn){for(var i=0;i<cutpointsIn.length;++i){var tree=fluid.parseSelector(cutpointsIn[i].selector);var clazz=isSimpleClassCutpoint(tree);if(clazz){simpleClassCutpoints[clazz]=cutpointsIn[i].id}else{cutstatus.push([]);cutpoints.push($.extend({},cutpointsIn[i],{tree:tree}))}}}}function findTopContainer(){for(var i=tagstack.length-1;i>=0;--i){var lump=tagstack[i];if(lump.rsfID!==undefined){return lump}}return t.rootlump}function newLump(){var togo=XMLLump(lumpindex,nestingdepth);if(debugMode){togo.line=parser.getLineNumber();togo.column=parser.getColumnNumber()}t.lumps[lumpindex]=togo;++lumpindex;return togo}function addLump(mmap,ID,lump){var list=mmap[ID];if(!list){list=[];mmap[ID]=list}list[list.length]=lump}function checkContribute(ID,lump){if(ID.indexOf("scr=contribute-")!==-1){var scr=ID.substring("scr=contribute-".length);addLump(t.collectmap,scr,lump)}}function debugLump(lump){return"<"+lump.tagname+">"}function hasCssClass(clazz,totest){if(!totest){return false}return(" "+totest+" ").indexOf(" "+clazz+" ")!==-1}function matchNode(term,headlump,headclazz){if(term.predList){for(var i=0;i<term.predList.length;++i){var pred=term.predList[i];if(pred.id&&headlump.attributemap.id!==pred.id){return false}if(pred.clazz&&!hasCssClass(pred.clazz,headclazz)){return false}if(pred.tag&&headlump.tagname!==pred.tag){return false}}return true}}function tagStartCut(headlump){var togo;var headclazz=headlump.attributemap["class"];if(headclazz){var split=headclazz.split(" ");for(var i=0;i<split.length;++i){var simpleCut=simpleClassCutpoints[$.trim(split[i])];if(simpleCut){return simpleCut}}}for(var i=0;i<cutpoints.length;++i){var cut=cutpoints[i];var cutstat=cutstatus[i];var nextterm=cutstat.length;if(nextterm<cut.tree.length){var term=cut.tree[nextterm];if(nextterm>0){if(cut.tree[nextterm-1].child&&cutstat[nextterm-1]!==headlump.nestingdepth-1){continue}}var isMatch=matchNode(term,headlump,headclazz);if(isMatch){cutstat[cutstat.length]=headlump.nestingdepth;if(cutstat.length===cut.tree.length){if(togo!==undefined){fluid.fail("Cutpoint specification error - node "+debugLump(headlump)+" has already matched with rsf:id of "+togo)}if(cut.id===undefined||cut.id===null){fluid.fail("Error in cutpoints list - entry at position "+i+" does not have an id set")}togo=cut.id}}}}return togo}function tagEndCut(){if(cutpoints){for(var i=0;i<cutpoints.length;++i){var cutstat=cutstatus[i];if(cutstat.length>0&&cutstat[cutstat.length-1]===nestingdepth){cutstat.length--}}}}function processTagEnd(){tagEndCut();var endlump=newLump();--nestingdepth;endlump.text="</"+parser.getName()+">";var oldtop=tagstack[tagstack.length-1];oldtop.close_tag=t.lumps[lumpindex-1];tagstack.length--;justended=true}function processTagStart(isempty,text){++nestingdepth;if(justended){justended=false;var backlump=newLump();backlump.nestingdepth--}if(t.firstdocumentindex===-1){t.firstdocumentindex=lumpindex}var headlump=newLump();var stacktop=tagstack[tagstack.length-1];headlump.uplump=stacktop;var tagname=parser.getName();headlump.tagname=tagname;var attrs=headlump.attributemap=parser.m_attributes;var ID=attrs[fluid.ID_ATTRIBUTE];if(ID===undefined){ID=tagStartCut(headlump)}for(var attrname in attrs){if(ID===undefined){if(/href|src|codebase|action/.test(attrname)){ID="scr=rewrite-url"}else{if(ID===undefined&&/for|headers/.test(attrname)){ID="scr=null"}}}}if(ID){if(ID.charCodeAt(0)===126){ID=ID.substring(1);headlump.elide=true}checkContribute(ID,headlump);headlump.rsfID=ID;var downreg=findTopContainer();if(!downreg.downmap){downreg.downmap={}}while(downreg){if(downreg.downmap){addLump(downreg.downmap,ID,headlump)}downreg=downreg.uplump}addLump(t.globalmap,ID,headlump);var colpos=ID.indexOf(":");if(colpos!==-1){var prefix=ID.substring(0,colpos);if(!stacktop.finallump){stacktop.finallump={}}stacktop.finallump[prefix]=headlump}}headlump.text="<"+tagname+fluid.dumpAttributes(attrs)+(isempty&&!ID?"/>":">");tagstack[tagstack.length]=headlump;if(isempty){if(ID){processTagEnd()}else{--nestingdepth;tagstack.length--}}}function processDefaultTag(){if(defstart!==-1){if(t.firstdocumentindex===-1){t.firstdocumentindex=lumpindex}var text=parser.getContent().substr(defstart,defend-defstart);justended=false;var newlump=newLump();newlump.text=text;defstart=-1}}t=fluid.XMLViewTemplate();init(baseURL,opts.debugMode,cutpoints_in);var idpos=template.indexOf(fluid.ID_ATTRIBUTE);if(scanStart){var brackpos=template.indexOf(">",idpos);parser=fluid.XMLP(template.substring(brackpos+1))}else{parser=fluid.XMLP(template)}parseloop:while(true){var iEvent=parser.next();switch(iEvent){case fluid.XMLP._ELM_B:processDefaultTag();processTagStart(false,"");break;case fluid.XMLP._ELM_E:processDefaultTag();processTagEnd();break;case fluid.XMLP._ELM_EMP:processDefaultTag();processTagStart(true,"");break;case fluid.XMLP._PI:case fluid.XMLP._DTD:defstart=-1;continue;case fluid.XMLP._TEXT:case fluid.XMLP._ENTITY:case fluid.XMLP._CDATA:case fluid.XMLP._COMMENT:if(defstart===-1){defstart=parser.m_cB}defend=parser.m_cE;break;case fluid.XMLP._ERROR:fluid.setLogging(true);var message="Error parsing template: "+parser.m_cAlt+" at line "+parser.getLineNumber();fluid.log(message);fluid.log("Just read: "+parser.m_xml.substring(parser.m_iP-30,parser.m_iP));fluid.log("Still to read: "+parser.m_xml.substring(parser.m_iP,parser.m_iP+30));fluid.fail(message);break parseloop;case fluid.XMLP._NONE:break parseloop}}processDefaultTag();var excess=tagstack.length-1;if(excess){fluid.fail("Error parsing template - unclosed tag(s) of depth "+(excess)+": "+fluid.transform(tagstack.splice(1,excess),function(lump){return debugLump(lump)}).join(", "))}return t};fluid.debugLump=function(lump){var togo=lump.text;togo+=" at ";togo+="lump line "+lump.line+" column "+lump.column+" index "+lump.lumpindex;togo+=lump.parent.href===null?"":" in file "+lump.parent.href;return togo};fluid.ID_ATTRIBUTE="rsf:id";fluid.getPrefix=function(id){var colpos=id.indexOf(":");return colpos===-1?id:id.substring(0,colpos)};fluid.SplitID=function(id){var that={};var colpos=id.indexOf(":");if(colpos===-1){that.prefix=id}else{that.prefix=id.substring(0,colpos);that.suffix=id.substring(colpos+1)}return that};fluid.XMLViewTemplate=function(){return{globalmap:{},collectmap:{},lumps:[],firstdocumentindex:-1}};fluid.XMLEncode=function(text){return text.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;")};fluid.dumpAttributes=function(attrcopy){var togo="";for(var attrname in attrcopy){var attrvalue=attrcopy[attrname];if(attrvalue!==null&&attrvalue!==undefined){togo+=" "+attrname+'="'+attrvalue+'"'}}return togo};fluid.aggregateMMap=function(target,source){for(var key in source){var targhas=target[key];if(!targhas){target[key]=[]}target[key]=target[key].concat(source[key])}};fluid.parseTemplates=function(resourceSpec,templateList,opts){var togo=[];opts=opts||{};togo.globalmap={};for(var i=0;i<templateList.length;++i){var resource=resourceSpec[templateList[i]];var lastslash=resource.href.lastIndexOf("/");var baseURL=lastslash===-1?"":resource.href.substring(0,lastslash+1);var template=fluid.parseTemplate(resource.resourceText,baseURL,opts.scanStart&&i===0,resource.cutpoints,opts);if(i===0){fluid.aggregateMMap(togo.globalmap,template.globalmap)}template.href=resource.href;template.baseURL=baseURL;template.resourceKey=resource.resourceKey;togo[i]=template;fluid.aggregateMMap(togo.globalmap,template.rootlump.downmap)}return togo};var chars="(?:[\\w\u0128-\uFFFF*_-]|\\\\.)";var quickClass=new RegExp("([#.]?)("+chars+"+)","g");var childSeg=new RegExp("\\s*(>)?\\s*","g");fluid.parseSelector=function(selstring){var togo=[];selstring=$.trim(selstring);quickClass.lastIndex=0;var lastIndex=0;while(true){var atNode=[];while(true){var segMatch=quickClass.exec(selstring);if(!segMatch||segMatch.index!==lastIndex){break}var thisNode={};var text=segMatch[2];if(segMatch[1]===""){thisNode.tag=text}else{if(segMatch[1]==="#"){thisNode.id=text}else{if(segMatch[1]==="."){thisNode.clazz=text}}}atNode[atNode.length]=thisNode;lastIndex=quickClass.lastIndex}childSeg.lastIndex=lastIndex;var fullAtNode={predList:atNode};var childMatch=childSeg.exec(selstring);if(!childMatch||childMatch.index!==lastIndex){var remainder=selstring.substring(lastIndex);fluid.fail("Error in selector string - can not match child selector expression at "+remainder)}if(childMatch[1]===">"){fullAtNode.child=true}togo[togo.length]=fullAtNode;if(childSeg.lastIndex>=selstring.length){break}lastIndex=childSeg.lastIndex;quickClass.lastIndex=childSeg.lastIndex}return togo}})(jQuery,fluid_1_5);fluid_1_5=fluid_1_5||{};(function($,fluid){function debugPosition(component){return"as child of "+(component.parent.fullID?"component with full ID "+component.parent.fullID:"root")}function computeFullID(component){var togo="";var move=component;if(component.children===undefined){togo=component.ID+(component.localID!==undefined?component.localID:"");move=component.parent}while(move.parent){var parent=move.parent;if(move.fullID!==undefined){togo=move.fullID+togo;return togo}if(move.noID===undefined){var ID=move.ID;if(ID===undefined){fluid.fail("Error in component tree - component found with no ID "+debugPosition(parent)+": please check structure")}var colpos=ID.indexOf(":");var prefix=colpos===-1?ID:ID.substring(0,colpos);togo=prefix+":"+(move.localID===undefined?"":move.localID)+":"+togo}move=parent}return togo}var renderer={};renderer.isBoundPrimitive=function(value){return fluid.isPrimitive(value)||fluid.isArrayable(value)&&(value.length===0||typeof (value[0])==="string")};var unzipComponent;function processChild(value,key){if(renderer.isBoundPrimitive(value)){return{componentType:"UIBound",value:value,ID:key}}else{var unzip=unzipComponent(value);if(unzip.ID){return{ID:key,componentType:"UIContainer",children:[unzip]}}else{unzip.ID=key;return unzip}}}function fixChildren(children){if(!fluid.isArrayable(children)){var togo=[];for(var key in children){var value=children[key];if(fluid.isArrayable(value)){for(var i=0;i<value.length;++i){var processed=processChild(value[i],key);togo[togo.length]=processed}}else{togo[togo.length]=processChild(value,key)}}return togo}else{return children}}function fixupValue(uibound,model,resolverGetConfig){if(uibound.value===undefined&&uibound.valuebinding!==undefined){if(!model){fluid.fail("Cannot perform value fixup for valuebinding "+uibound.valuebinding+" since no model was supplied to rendering")}uibound.value=fluid.get(model,uibound.valuebinding,resolverGetConfig)}}function upgradeBound(holder,property,model,resolverGetConfig){if(holder[property]!==undefined){if(renderer.isBoundPrimitive(holder[property])){holder[property]={value:holder[property]}}else{if(holder[property].messagekey){holder[property].componentType="UIMessage"}}}else{holder[property]={value:null}}fixupValue(holder[property],model,resolverGetConfig)}renderer.duckMap={children:"UIContainer",value:"UIBound",valuebinding:"UIBound",messagekey:"UIMessage",markup:"UIVerbatim",selection:"UISelect",target:"UILink",choiceindex:"UISelectChoice",functionname:"UIInitBlock"};var boundMap={UISelect:["selection","optionlist","optionnames"],UILink:["target","linktext"],UIVerbatim:["markup"],UIMessage:["messagekey"]};renderer.boundMap=fluid.transform(boundMap,fluid.arrayToHash);renderer.inferComponentType=function(component){for(var key in renderer.duckMap){if(component[key]!==undefined){return renderer.duckMap[key]}}};renderer.applyComponentType=function(component){component.componentType=renderer.inferComponentType(component);if(component.componentType===undefined&&component.ID!==undefined){component.componentType="UIBound"}};unzipComponent=function(component,model,resolverGetConfig){if(component){renderer.applyComponentType(component)}if(!component||component.componentType===undefined){var decorators=component.decorators;if(decorators){delete component.decorators}component={componentType:"UIContainer",children:component};component.decorators=decorators}var cType=component.componentType;if(cType==="UIContainer"){component.children=fixChildren(component.children)}else{var map=renderer.boundMap[cType];if(map){fluid.each(map,function(value,key){upgradeBound(component,key,model,resolverGetConfig)})}}return component};function fixupTree(tree,model,resolverGetConfig){if(tree.componentType===undefined){tree=unzipComponent(tree,model,resolverGetConfig)}if(tree.componentType!=="UIContainer"&&!tree.parent){tree={children:[tree]}}if(tree.children){tree.childmap={};for(var i=0;i<tree.children.length;++i){var child=tree.children[i];if(child.componentType===undefined){child=unzipComponent(child,model,resolverGetConfig);tree.children[i]=child}child.parent=tree;if(child.ID===undefined){fluid.fail("Error in component tree: component found with no ID "+debugPosition(child))}tree.childmap[child.ID]=child;var colpos=child.ID.indexOf(":");if(colpos===-1){}else{var prefix=child.ID.substring(0,colpos);var childlist=tree.childmap[prefix];if(!childlist){childlist=[];tree.childmap[prefix]=childlist}if(child.localID===undefined&&childlist.length!==0){child.localID=childlist.length}childlist[childlist.length]=child}child.fullID=computeFullID(child);var componentType=child.componentType;if(componentType==="UISelect"){child.selection.fullID=child.fullID+"-selection"}else{if(componentType==="UIInitBlock"){var call=child.functionname+"(";for(var j=0;j<child.arguments.length;++j){if(child.arguments[j] instanceof fluid.ComponentReference){child.arguments[j]=child.parent.fullID+child.arguments[j].reference}call+=JSON.stringify(child.arguments[j]);if(j<child.arguments.length-1){call+=", "}}child.markup={value:call+")\n"};child.componentType="UIVerbatim"}else{if(componentType==="UIBound"){fixupValue(child,model,resolverGetConfig)}}}fixupTree(child,model,resolverGetConfig)}}return tree}fluid.NULL_STRING="\u25a9null\u25a9";var LINK_ATTRIBUTES={a:"href",link:"href",img:"src",frame:"src",script:"src",style:"src",input:"src",embed:"src",form:"action",applet:"codebase",object:"codebase"};renderer.decoratorComponentPrefix="**-renderer-";renderer.IDtoComponentName=function(ID,num){return renderer.decoratorComponentPrefix+ID.replace(/\./g,"")+"-"+num};renderer.invokeFluidDecorator=function(func,args,ID,num,options){var that;if(options.instantiator&&options.parentComponent){var parent=options.parentComponent;var name=renderer.IDtoComponentName(ID,num);fluid.set(parent,fluid.path("options","components",name),{type:func});that=fluid.initDependent(options.parentComponent,name,options.instantiator,args)}else{that=fluid.invokeGlobalFunction(func,args)}return that};fluid.renderer=function(templates,tree,options,fossilsIn){options=options||{};tree=tree||{};var debugMode=options.debugMode;if(!options.messageLocator&&options.messageSource){options.messageLocator=fluid.resolveMessageSource(options.messageSource)}options.document=options.document||document;options.jQuery=options.jQuery||$;options.fossils=options.fossils||fossilsIn||{};var globalmap={};var branchmap={};var rewritemap={};var seenset={};var collected={};var out="";var renderOptions=options;var decoratorQueue=[];var renderedbindings={};var usedIDs={};var that={options:options};function getRewriteKey(template,parent,id){return template.resourceKey+parent.fullID+id}function resolveInScope(searchID,defprefix,scope,child){var deflump;var scopelook=scope?scope[searchID]:null;if(scopelook){for(var i=0;i<scopelook.length;++i){var scopelump=scopelook[i];if(!deflump&&scopelump.rsfID===defprefix){deflump=scopelump}if(scopelump.rsfID===searchID){return scopelump}}}return deflump}function resolveCall(sourcescope,child){var searchID=child.jointID?child.jointID:child.ID;var split=fluid.SplitID(searchID);var defprefix=split.prefix+":";var match=resolveInScope(searchID,defprefix,sourcescope.downmap,child);if(match){return match}if(child.children){match=resolveInScope(searchID,defprefix,globalmap,child);if(match){return match}}return null}function noteCollected(template){if(!seenset[template.href]){fluid.aggregateMMap(collected,template.collectmap);seenset[template.href]=true}}var fetchComponent;function resolveRecurse(basecontainer,parentlump){for(var i=0;i<basecontainer.children.length;++i){var branch=basecontainer.children[i];if(branch.children){var resolved=resolveCall(parentlump,branch);if(resolved){branchmap[branch.fullID]=resolved;var id=resolved.attributemap.id;if(id!==undefined){rewritemap[getRewriteKey(parentlump.parent,basecontainer,id)]=branch.fullID}noteCollected(resolved.parent);resolveRecurse(branch,resolved)}}}if(parentlump.downmap){for(var id in parentlump.downmap){var lumps=parentlump.downmap[id];for(var i=0;i<lumps.length;++i){var lump=lumps[i];var lumpid=lump.attributemap.id;if(lumpid!==undefined&&lump.rsfID!==undefined){var resolved=fetchComponent(basecontainer,lump.rsfID);if(resolved!==null){var resolveID=resolved.fullID;if(resolved.componentType==="UISelect"){resolveID=resolveID+"-selection"}rewritemap[getRewriteKey(parentlump.parent,basecontainer,lumpid)]=resolveID}}}}}}function resolveBranches(globalmapp,basecontainer,parentlump){branchmap={};rewritemap={};seenset={};collected={};globalmap=globalmapp;branchmap[basecontainer.fullID]=parentlump;resolveRecurse(basecontainer,parentlump)}function dumpTillLump(lumps,start,limit){for(;start<limit;++start){var text=lumps[start].text;if(text){out+=lumps[start].text}}}function dumpScan(lumps,renderindex,basedepth,closeparent,insideleaf){var start=renderindex;while(true){if(renderindex===lumps.length){break}var lump=lumps[renderindex];if(lump.nestingdepth<basedepth){break}if(lump.rsfID!==undefined){if(!insideleaf){break}if(insideleaf&&lump.nestingdepth>basedepth+(closeparent?0:1)){fluid.log("Error in component tree - leaf component found to contain further components - at "+lump.toString())}else{break}}++renderindex}if(!closeparent&&(renderindex===lumps.length||!lumps[renderindex].rsfID)){--renderindex}dumpTillLump(lumps,start,renderindex);return renderindex}function isPlaceholder(value){return false}function isValue(value){return value!==null&&value!==undefined&&!isPlaceholder(value)}var trc={};function openTag(){if(!trc.iselide){out+="<"+trc.uselump.tagname}}function closeTag(){if(!trc.iselide){out+="</"+trc.uselump.tagname+">"}}function renderUnchanged(){dumpTillLump(trc.uselump.parent.lumps,trc.uselump.lumpindex+1,trc.close.lumpindex+(trc.iselide?0:1))}function isSelfClose(){return trc.endopen.lumpindex===trc.close.lumpindex&&fluid.XMLP.closedTags[trc.uselump.tagname]}function dumpTemplateBody(){if(isSelfClose()){if(!trc.iselide){out+="/>"}}else{if(!trc.iselide){out+=">"}dumpTillLump(trc.uselump.parent.lumps,trc.endopen.lumpindex,trc.close.lumpindex+(trc.iselide?0:1))}}function replaceAttributes(){if(!trc.iselide){out+=fluid.dumpAttributes(trc.attrcopy)}dumpTemplateBody()}function replaceAttributesOpen(){if(trc.iselide){replaceAttributes()}else{out+=fluid.dumpAttributes(trc.attrcopy);var selfClose=isSelfClose();out+=selfClose?"/>":">";trc.nextpos=selfClose?trc.close.lumpindex+1:trc.endopen.lumpindex}}function replaceBody(value){out+=fluid.dumpAttributes(trc.attrcopy);if(!trc.iselide){out+=">"}out+=fluid.XMLEncode(value.toString());closeTag()}function rewriteLeaf(value){if(isValue(value)){replaceBody(value)}else{replaceAttributes()}}function rewriteLeafOpen(value){if(trc.iselide){rewriteLeaf(trc.value)}else{if(isValue(value)){replaceBody(value)}else{replaceAttributesOpen()}}}function rewriteUrl(template,url){if(renderOptions.urlRewriter){var rewritten=renderOptions.urlRewriter(url);if(rewritten){return rewritten}}if(!renderOptions.rebaseURLs){return url}var protpos=url.indexOf(":/");if(url.charAt(0)==="/"||protpos!==-1&&protpos<7){return url}else{return renderOptions.baseURL+url}}function dumpHiddenField(todump){out+='<input type="hidden" ';var isvirtual=todump.virtual;var outattrs={};outattrs[isvirtual?"id":"name"]=todump.name;outattrs.value=todump.value;out+=fluid.dumpAttributes(outattrs);out+=" />\n"}var outDecoratorsImpl;function applyAutoBind(torender,finalID){if(!finalID){return }var tagname=trc.uselump.tagname;var applier=renderOptions.applier;function applyFunc(){fluid.applyBoundChange(fluid.byId(finalID,renderOptions.document),undefined,applier)}if(renderOptions.autoBind&&/input|select|textarea/.test(tagname)&&!renderedbindings[finalID]){var decorators=[{jQuery:["change",applyFunc]}];if($.browser.msie&&tagname==="input"&&/radio|checkbox/.test(trc.attrcopy.type)){decorators.push({jQuery:["click",applyFunc]})}if($.browser.safari&&tagname==="input"&&trc.attrcopy.type==="radio"){decorators.push({jQuery:["keyup",applyFunc]})}outDecoratorsImpl(torender,decorators,trc.attrcopy,finalID)}}function dumpBoundFields(torender,parent){if(torender){var holder=parent?parent:torender;if(renderOptions.fossils&&holder.valuebinding){var fossilKey=holder.submittingname||torender.finalID;renderOptions.fossils[fossilKey]={name:fossilKey,EL:holder.valuebinding,oldvalue:holder.value};applyAutoBind(torender,torender.finalID)}if(torender.fossilizedbinding){dumpHiddenField(torender.fossilizedbinding)}if(torender.fossilizedshaper){dumpHiddenField(torender.fossilizedshaper)}}}function dumpSelectionBindings(uiselect){if(!renderedbindings[uiselect.selection.fullID]){renderedbindings[uiselect.selection.fullID]=true;dumpBoundFields(uiselect.selection);dumpBoundFields(uiselect.optionlist);dumpBoundFields(uiselect.optionnames)}}function isSelectedValue(torender,value){var selection=torender.selection;return selection.value&&typeof (selection.value)!=="string"&&typeof (selection.value.length)==="number"?$.inArray(value,selection.value)!==-1:selection.value===value}function getRelativeComponent(component,relativeID){component=component.parent;while(relativeID.indexOf("..::")===0){relativeID=relativeID.substring(4);component=component.parent}return component.childmap[relativeID]}function adjustForID(attrcopy,component,late,forceID){if(!late){delete attrcopy["rsf:id"]}if(component.finalID!==undefined){attrcopy.id=component.finalID}else{if(forceID!==undefined){attrcopy.id=forceID}else{if(attrcopy.id||late){attrcopy.id=component.fullID}}}var count=1;var baseid=attrcopy.id;while(renderOptions.document.getElementById(attrcopy.id)||usedIDs[attrcopy.id]){attrcopy.id=baseid+"-"+(count++)}component.finalID=attrcopy.id;return attrcopy.id}function assignSubmittingName(attrcopy,component,parent){var submitting=parent||component;adjustForID(attrcopy,component,true,component.fullID);if(submitting.submittingname===undefined&&submitting.willinput!==false){submitting.submittingname=submitting.finalID||submitting.fullID}return submitting.submittingname}function explodeDecorators(decorators){var togo=[];if(decorators.type){togo[0]=decorators}else{for(var key in decorators){if(key==="$"){key="jQuery"}var value=decorators[key];var decorator={type:key};if(key==="jQuery"){decorator.func=value[0];decorator.args=value.slice(1)}else{if(key==="addClass"||key==="removeClass"){decorator.classes=value}else{if(key==="attrs"){decorator.attributes=value}else{if(key==="identify"){decorator.key=value}}}}togo[togo.length]=decorator}}return togo}outDecoratorsImpl=function(torender,decorators,attrcopy,finalID){renderOptions.idMap=renderOptions.idMap||{};for(var i=0;i<decorators.length;++i){var decorator=decorators[i];var type=decorator.type;if(!type){var explodedDecorators=explodeDecorators(decorator);outDecoratorsImpl(torender,explodedDecorators,attrcopy,finalID);continue}if(type==="$"){type=decorator.type="jQuery"}if(type==="jQuery"||type==="event"||type==="fluid"){var id=adjustForID(attrcopy,torender,true,finalID);if(decorator.ids===undefined){decorator.ids=[];decoratorQueue[decoratorQueue.length]=decorator}decorator.ids.push(id)}else{if(type==="attrs"){fluid.each(decorator.attributes,function(value,key){if(value===null||value===undefined){delete attrcopy[key]}else{attrcopy[key]=fluid.XMLEncode(value)}})}else{if(type==="addClass"||type==="removeClass"){var fakeNode={nodeType:1,className:attrcopy["class"]||""};renderOptions.jQuery(fakeNode)[type](decorator.classes);attrcopy["class"]=fakeNode.className}else{if(type==="identify"){var id=adjustForID(attrcopy,torender,true,finalID);renderOptions.idMap[decorator.key]=id}else{if(type!=="null"){fluid.log("Unrecognised decorator of type "+type+" found at component of ID "+finalID)}}}}}}};function outDecorators(torender,attrcopy){if(!torender.decorators){return }if(torender.decorators.length===undefined){torender.decorators=explodeDecorators(torender.decorators)}outDecoratorsImpl(torender,torender.decorators,attrcopy)}function dumpBranchHead(branch,targetlump){if(targetlump.elide){return }var attrcopy={};$.extend(true,attrcopy,targetlump.attributemap);adjustForID(attrcopy,branch);outDecorators(branch,attrcopy);out+="<"+targetlump.tagname+" ";out+=fluid.dumpAttributes(attrcopy);out+=">"}function resolveArgs(args){if(!args){return args}args=fluid.copy(args);return fluid.transform(args,function(arg,index){upgradeBound(args,index,renderOptions.model,renderOptions.resolverGetConfig);return args[index].value})}function degradeMessage(torender){if(torender.componentType==="UIMessage"){torender.componentType="UIBound";if(!renderOptions.messageLocator){torender.value="[No messageLocator is configured in options - please consult documentation on options.messageSource]"}else{upgradeBound(torender,"messagekey",renderOptions.model,renderOptions.resolverGetConfig);var resArgs=resolveArgs(torender.args);torender.value=renderOptions.messageLocator(torender.messagekey.value,resArgs)}}}function renderComponent(torender){var attrcopy=trc.attrcopy;degradeMessage(torender);var componentType=torender.componentType;var tagname=trc.uselump.tagname;outDecorators(torender,attrcopy);function makeFail(torender,end){fluid.fail("Error in component tree - UISelectChoice with id "+torender.fullID+end)}if(componentType==="UIBound"||componentType==="UISelectChoice"){var parent;if(torender.choiceindex!==undefined){if(torender.parentRelativeID!==undefined){parent=getRelativeComponent(torender,torender.parentRelativeID);if(!parent){makeFail(torender," has parentRelativeID of "+torender.parentRelativeID+" which cannot be resolved")}}else{makeFail(torender," does not have parentRelativeID set")}assignSubmittingName(attrcopy,torender,parent.selection);dumpSelectionBindings(parent)}var submittingname=parent?parent.selection.submittingname:torender.submittingname;if(!parent&&torender.valuebinding){submittingname=assignSubmittingName(attrcopy,torender)}if(tagname==="input"||tagname==="textarea"){if(submittingname!==undefined){attrcopy.name=submittingname}}dumpBoundFields(torender,parent?parent.selection:null);if(typeof (torender.value)==="boolean"||attrcopy.type==="radio"||attrcopy.type==="checkbox"){var underlyingValue;var directValue=torender.value;if(torender.choiceindex!==undefined){if(!parent.optionlist.value){fluid.fail("Error in component tree - selection control with full ID "+parent.fullID+" has no values")}underlyingValue=parent.optionlist.value[torender.choiceindex];directValue=isSelectedValue(parent,underlyingValue)}if(isValue(directValue)){if(directValue){attrcopy.checked="checked"}else{delete attrcopy.checked}}attrcopy.value=fluid.XMLEncode(underlyingValue?underlyingValue:"true");rewriteLeaf(null)}else{if(fluid.isArrayable(torender.value)){renderUnchanged()}else{var value=parent?parent[tagname==="textarea"||tagname==="input"?"optionlist":"optionnames"].value[torender.choiceindex]:torender.value;if(tagname==="textarea"){if(isPlaceholder(value)&&torender.willinput){value=""}rewriteLeaf(value)}else{if(tagname==="input"){if(torender.willinput||isValue(value)){attrcopy.value=fluid.XMLEncode(String(value))}rewriteLeaf(null)}else{delete attrcopy.name;rewriteLeafOpen(value)}}}}}else{if(componentType==="UISelect"){var ishtmlselect=tagname==="select";var ismultiple=false;if(fluid.isArrayable(torender.selection.value)){ismultiple=true;if(ishtmlselect){attrcopy.multiple="multiple"}}var oldid=attrcopy.id;assignSubmittingName(attrcopy,torender.selection);if(oldid!==undefined){attrcopy.id=oldid}if(ishtmlselect){if(torender.selection.willinput!==false){attrcopy.name=torender.selection.submittingname}applyAutoBind(torender,attrcopy.id)}out+=fluid.dumpAttributes(attrcopy);if(ishtmlselect){out+=">";var values=torender.optionlist.value;var names=torender.optionnames===null||torender.optionnames===undefined||!torender.optionnames.value?values:torender.optionnames.value;if(!names||!names.length){fluid.fail("Error in component tree - UISelect component with fullID "+torender.fullID+" does not have optionnames set")}for(var i=0;i<names.length;++i){out+='<option value="';var value=values[i];if(value===null){value=fluid.NULL_STRING}out+=fluid.XMLEncode(value);if(isSelectedValue(torender,value)){out+='" selected="selected'}out+='">';out+=fluid.XMLEncode(names[i]);out+="</option>\n"}closeTag()}else{dumpTemplateBody()}dumpSelectionBindings(torender)}else{if(componentType==="UILink"){var attrname=LINK_ATTRIBUTES[tagname];if(attrname){degradeMessage(torender.target);var target=torender.target.value;if(!isValue(target)){target=attrcopy[attrname]}target=rewriteUrl(trc.uselump.parent,target);attrcopy[attrname]=fluid.XMLEncode(target)}var value;if(torender.linktext){degradeMessage(torender.linktext);value=torender.linktext.value}if(!isValue(value)){replaceAttributesOpen()}else{rewriteLeaf(value)}}else{if(torender.markup!==undefined){degradeMessage(torender.markup);var rendered=torender.markup.value;if(rendered===null){out+=fluid.dumpAttributes(attrcopy);out+=">";renderUnchanged()}else{if(!trc.iselide){out+=fluid.dumpAttributes(attrcopy);out+=">"}out+=rendered;closeTag()}}}}}if(attrcopy.id!==undefined){usedIDs[attrcopy.id]=true}}function rewriteIDRelation(context){var attrname;var attrval=trc.attrcopy["for"];if(attrval!==undefined){attrname="for"}else{attrval=trc.attrcopy.headers;if(attrval!==undefined){attrname="headers"}}if(!attrname){return }var tagname=trc.uselump.tagname;if(attrname==="for"&&tagname!=="label"){return }if(attrname==="headers"&&tagname!=="td"&&tagname!=="th"){return }var rewritten=rewritemap[getRewriteKey(trc.uselump.parent,context,attrval)];if(rewritten!==undefined){trc.attrcopy[attrname]=rewritten}}function renderComment(message){out+=("<!-- "+fluid.XMLEncode(message)+"-->")}function renderDebugMessage(message){out+='<span style="background-color:#FF466B;color:white;padding:1px;">';out+=message;out+="</span><br/>"}function reportPath(branch){var path=branch.fullID;return !path?"component tree root":"full path "+path}function renderComponentSystem(context,torendero,lump){var lumpindex=lump.lumpindex;var lumps=lump.parent.lumps;var nextpos=-1;var outerendopen=lumps[lumpindex+1];var outerclose=lump.close_tag;nextpos=outerclose.lumpindex+1;var payloadlist=lump.downmap?lump.downmap["payload-component"]:null;var payload=payloadlist?payloadlist[0]:null;var iselide=lump.rsfID.charCodeAt(0)===126;var endopen=outerendopen;var close=outerclose;var uselump=lump;var attrcopy={};$.extend(true,attrcopy,(payload===null?lump:payload).attributemap);trc.attrcopy=attrcopy;trc.uselump=uselump;trc.endopen=endopen;trc.close=close;trc.nextpos=nextpos;trc.iselide=iselide;rewriteIDRelation(context);if(torendero===null){if(lump.rsfID.indexOf("scr=")===(iselide?1:0)){var scrname=lump.rsfID.substring(4+(iselide?1:0));if(scrname==="ignore"){nextpos=trc.close.lumpindex+1}else{if(scrname==="rewrite-url"){torendero={componentType:"UILink",target:{}}}else{openTag();replaceAttributesOpen();nextpos=trc.endopen.lumpindex}}}}if(torendero!==null){if(payload){trc.endopen=lumps[payload.lumpindex+1];trc.close=payload.close_tag;trc.uselump=payload;dumpTillLump(lumps,lumpindex,payload.lumpindex);lumpindex=payload.lumpindex}adjustForID(attrcopy,torendero);openTag();renderComponent(torendero);if(payload!==null){if(trc.nextpos===nextpos){dumpTillLump(lumps,trc.close.lumpindex+1,outerclose.lumpindex+1)}}nextpos=trc.nextpos}return nextpos}var renderRecurse;function renderContainer(child,targetlump){var t2=targetlump.parent;var firstchild=t2.lumps[targetlump.lumpindex+1];if(child.children!==undefined){dumpBranchHead(child,targetlump)}else{renderComponentSystem(child.parent,child,targetlump)}renderRecurse(child,targetlump,firstchild)}fetchComponent=function(basecontainer,id,lump){if(id.indexOf("msg=")===0){var key=id.substring(4);return{componentType:"UIMessage",messagekey:key}}while(basecontainer){var togo=basecontainer.childmap[id];if(togo){return togo}basecontainer=basecontainer.parent}return null};function fetchComponents(basecontainer,id){var togo;while(basecontainer){togo=basecontainer.childmap[id];if(togo){break}basecontainer=basecontainer.parent}return togo}function findChild(sourcescope,child){var split=fluid.SplitID(child.ID);var headlumps=sourcescope.downmap[child.ID];if(!headlumps){headlumps=sourcescope.downmap[split.prefix+":"]}return headlumps?headlumps[0]:null}renderRecurse=function(basecontainer,parentlump,baselump){var renderindex=baselump.lumpindex;var basedepth=parentlump.nestingdepth;var t1=parentlump.parent;var rendered;if(debugMode){rendered={}}while(true){renderindex=dumpScan(t1.lumps,renderindex,basedepth,!parentlump.elide,false);if(renderindex===t1.lumps.length){break}var lump=t1.lumps[renderindex];var id=lump.rsfID;if(lump.nestingdepth<basedepth||id===undefined){break}if(id.charCodeAt(0)===126){id=id.substring(1)}if(id.indexOf(":")!==-1){var prefix=fluid.getPrefix(id);var children=fetchComponents(basecontainer,prefix);var finallump=lump.uplump.finallump[prefix];var closefinal=finallump.close_tag;if(children){for(var i=0;i<children.length;++i){var child=children[i];if(child.children){if(debugMode){rendered[child.fullID]=true}var targetlump=branchmap[child.fullID];if(targetlump){if(debugMode){renderComment("Branching for "+child.fullID+" from "+fluid.debugLump(lump)+" to "+fluid.debugLump(targetlump))}renderContainer(child,targetlump);if(debugMode){renderComment("Branch returned for "+child.fullID+fluid.debugLump(lump)+" to "+fluid.debugLump(targetlump))}}else{if(debugMode){renderDebugMessage("No matching template branch found for branch container with full ID "+child.fullID+" rendering from parent template branch "+fluid.debugLump(baselump))}}}else{var targetlump=findChild(parentlump,child);if(!targetlump){if(debugMode){renderDebugMessage("Repetitive leaf with full ID "+child.fullID+" could not be rendered from parent template branch "+fluid.debugLump(baselump))}continue}var renderend=renderComponentSystem(basecontainer,child,targetlump);var wasopentag=renderend<t1.lumps.lengtn&&t1.lumps[renderend].nestingdepth>=targetlump.nestingdepth;var newbase=child.children?child:basecontainer;if(wasopentag){renderRecurse(newbase,targetlump,t1.lumps[renderend]);renderend=targetlump.close_tag.lumpindex+1}if(i!==children.length-1){if(renderend<closefinal.lumpindex){dumpScan(t1.lumps,renderend,targetlump.nestingdepth-1,false,false)}}else{dumpScan(t1.lumps,renderend,targetlump.nestingdepth,true,false)}}}}else{if(debugMode){renderDebugMessage("No branch container with prefix "+prefix+": found in container "+reportPath(basecontainer)+" rendering at template position "+fluid.debugLump(baselump)+", skipping")}}renderindex=closefinal.lumpindex+1;if(debugMode){renderComment("Stack returned from branch for ID "+id+" to "+fluid.debugLump(baselump)+": skipping from "+fluid.debugLump(lump)+" to "+fluid.debugLump(closefinal))}}else{var component;if(id){component=fetchComponent(basecontainer,id,lump);if(debugMode&&component){rendered[component.fullID]=true}}if(component&&component.children!==undefined){renderContainer(component);renderindex=lump.close_tag.lumpindex+1}else{renderindex=renderComponentSystem(basecontainer,component,lump)}}if(renderindex===t1.lumps.length){break}}if(debugMode){var children=basecontainer.children;for(var key=0;key<children.length;++key){var child=children[key];if(!rendered[child.fullID]){renderDebugMessage("Component "+child.componentType+" with full ID "+child.fullID+" could not be found within template "+fluid.debugLump(baselump))}}}};function renderCollect(collump){dumpTillLump(collump.parent.lumps,collump.lumpindex,collump.close_tag.lumpindex+1)}function renderCollects(){for(var key in collected){var collist=collected[key];for(var i=0;i<collist.length;++i){renderCollect(collist[i])}}}function processDecoratorQueue(){for(var i=0;i<decoratorQueue.length;++i){var decorator=decoratorQueue[i];for(var j=0;j<decorator.ids.length;++j){var id=decorator.ids[j];var node=fluid.byId(id,renderOptions.document);if(!node){fluid.fail("Error during rendering - component with id "+id+" which has a queued decorator was not found in the output markup")}if(decorator.type==="jQuery"){var jnode=renderOptions.jQuery(node);jnode[decorator.func].apply(jnode,fluid.makeArray(decorator.args))}else{if(decorator.type==="fluid"){var args=decorator.args;if(!args){var thisContainer=renderOptions.jQuery(node);if(!decorator.container){decorator.container=thisContainer}else{decorator.container.push(node)}args=[thisContainer,decorator.options]}var that=renderer.invokeFluidDecorator(decorator.func,args,id,i,options);decorator.that=that}else{if(decorator.type==="event"){node[decorator.event]=decorator.handler}}}}}}that.renderTemplates=function(){tree=fixupTree(tree,options.model,options.resolverGetConfig);var template=templates[0];resolveBranches(templates.globalmap,tree,template.rootlump);renderedbindings={};renderCollects();renderRecurse(tree,template.rootlump,template.lumps[template.firstdocumentindex]);return out};that.processDecoratorQueue=function(){processDecoratorQueue()};return that};jQuery.extend(true,fluid.renderer,renderer);fluid.ComponentReference=function(reference){this.reference=reference};fluid.explode=function(hash,basepath){var togo=[];for(var key in hash){var binding=basepath===undefined?key:basepath+"."+key;togo[togo.length]={ID:key,value:hash[key],valuebinding:binding}}return togo};fluid.explodeSelectionToInputs=function(optionlist,opts){return fluid.transform(optionlist,function(option,index){return{ID:opts.rowID,children:[{ID:opts.inputID,parentRelativeID:"..::"+opts.selectID,choiceindex:index},{ID:opts.labelID,parentRelativeID:"..::"+opts.selectID,choiceindex:index}]}})};fluid.resolveMessageSource=function(messageSource){if(messageSource.type==="data"){if(messageSource.url===undefined){return fluid.messageLocator(messageSource.messages,messageSource.resolveFunc)}else{}}else{if(messageSource.type==="resolver"){return messageSource.resolver.resolve}}};fluid.renderTemplates=function(templates,tree,options,fossilsIn){var renderer=fluid.renderer(templates,tree,options,fossilsIn);var rendered=renderer.renderTemplates();return rendered};fluid.reRender=function(templates,node,tree,options){options=options||{};var renderer=fluid.renderer(templates,tree,options,options.fossils);options=renderer.options;node=fluid.unwrap(node);var lastFocusedElement=fluid.getLastFocusedElement?fluid.getLastFocusedElement():null;var lastId;if(lastFocusedElement&&fluid.dom.isContainer(node,lastFocusedElement)){lastId=lastFocusedElement.id}if($.browser.msie){options.jQuery(node).empty()}else{node.innerHTML=""}var rendered=renderer.renderTemplates();if(options.renderRaw){rendered=fluid.XMLEncode(rendered);rendered=rendered.replace(/\n/g,"<br/>")}if(options.model){fluid.bindFossils(node,options.model,options.fossils)}if($.browser.msie){options.jQuery(node).html(rendered)}else{node.innerHTML=rendered}renderer.processDecoratorQueue();if(lastId){var element=fluid.byId(lastId,options.document);if(element){options.jQuery(element).focus()}}return templates};function findNodeValue(rootNode){var node=fluid.dom.iterateDom(rootNode,function(node){return node.nodeType===8||node.nodeType===4?"stop":null},true);var value=node.nodeValue;if(value.indexOf("[CDATA[")===0){return value.substring(6,value.length-2)}else{return value}}fluid.extractTemplate=function(node,armouring){if(!armouring){return node.innerHTML}else{return findNodeValue(node)}};fluid.render=function(source,target,tree,options){options=options||{};var template=source;if(typeof (source)==="object"){template=fluid.extractTemplate(fluid.unwrap(source.node),source.armouring)}target=fluid.unwrap(target);var resourceSpec={base:{resourceText:template,href:".",resourceKey:".",cutpoints:options.cutpoints}};var templates=fluid.parseTemplates(resourceSpec,["base"],options);return fluid.reRender(templates,target,tree,options)};fluid.selfRender=function(node,tree,options){options=options||{};return fluid.render({node:node,armouring:options.armouring},node,tree,options)}})(jQuery,fluid_1_5);fluid_1_5=fluid_1_5||{};(function($,fluid){if(!fluid.renderer){fluid.fail("fluidRenderer.js is a necessary dependency of RendererUtilities")}fluid.iota=function(count,first){first=first||0;var togo=[];for(var i=0;i<count;++i){togo[togo.length]=first++}return togo};fluid.renderer.visitDecorators=function(that,visitor,instantiator){fluid.visitComponentChildren(that,function(component,name){if(name.indexOf(fluid.renderer.decoratorComponentPrefix)===0){visitor(component,name)}},{flat:true,instantiator:instantiator})};fluid.renderer.clearDecorators=function(instantiator,that){fluid.renderer.visitDecorators(that,function(component,name){instantiator.clearComponent(that,name)},instantiator)};fluid.renderer.getDecoratorComponents=function(that,instantiator){var togo={};fluid.renderer.visitDecorators(that,function(component,name){togo[name]=component},instantiator);return togo};fluid.renderer.modeliseOptions=function(options,defaults,baseOptions){return $.extend({},defaults,options,fluid.filterKeys(baseOptions,["model","applier"]))};fluid.renderer.reverseMerge=function(target,source,names){names=fluid.makeArray(names);fluid.each(names,function(name){if(target[name]===undefined&&source[name]!==undefined){target[name]=source[name]}})};fluid.renderer.createRendererSubcomponent=function(container,selectors,options,baseObject,fossils){options=options||{};var source=options.templateSource?options.templateSource:{node:$(container)};var rendererOptions=fluid.renderer.modeliseOptions(options.rendererOptions,null,baseObject);rendererOptions.fossils=fossils||{};if(container.jquery){var cascadeOptions={document:container[0].ownerDocument,jQuery:container.constructor};fluid.renderer.reverseMerge(rendererOptions,cascadeOptions,fluid.keys(cascadeOptions))}var expanderOptions=fluid.renderer.modeliseOptions(options.expanderOptions,{ELstyle:"${}"},baseObject);fluid.renderer.reverseMerge(expanderOptions,options,["resolverGetConfig","resolverSetConfig"]);var that={};if(!options.noexpand){that.expander=fluid.renderer.makeProtoExpander(expanderOptions)}var templates=null;that.render=function(tree){var cutpointFn=options.cutpointGenerator||"fluid.renderer.selectorsToCutpoints";rendererOptions.cutpoints=rendererOptions.cutpoints||fluid.invokeGlobalFunction(cutpointFn,[selectors,options]);container=typeof (container)==="function"?container():$(container);if(templates){fluid.clear(rendererOptions.fossils);fluid.reRender(templates,container,tree,rendererOptions)}else{if(typeof (source)==="function"){source=source()}templates=fluid.render(source,container,tree,rendererOptions)}};return that};fluid.defaults("fluid.rendererComponent",{gradeNames:["fluid.viewComponent"],initFunction:"fluid.initRendererComponent",mergePolicy:{protoTree:"noexpand, replace",parentBundle:"nomerge"},rendererOptions:{autoBind:true},events:{prepareModelForRender:null,onRenderTree:null,afterRender:null,produceTree:"unicast"}});fluid.initRendererComponent=function(componentName,container,options){var that=fluid.initView(componentName,container,options,{gradeNames:["fluid.rendererComponent"]});fluid.fetchResources(that.options.resources);var rendererOptions=fluid.renderer.modeliseOptions(that.options.rendererOptions,null,that);if(!that.options.noUpgradeDecorators){fluid.withInstantiator(that,function(currentInst){rendererOptions.instantiator=currentInst;rendererOptions.parentComponent=that})}var messageResolver;if(!rendererOptions.messageSource&&that.options.strings){messageResolver=fluid.messageResolver({messageBase:that.options.strings,resolveFunc:that.options.messageResolverFunction,parents:fluid.makeArray(that.options.parentBundle)});rendererOptions.messageSource={type:"resolver",resolver:messageResolver}}fluid.renderer.reverseMerge(rendererOptions,that.options,["resolverGetConfig","resolverSetConfig"]);var rendererFnOptions=$.extend({},that.options.rendererFnOptions,{rendererOptions:rendererOptions,repeatingSelectors:that.options.repeatingSelectors,selectorsToIgnore:that.options.selectorsToIgnore,expanderOptions:{envAdd:{styles:that.options.styles}}});if(that.options.resources&&that.options.resources.template){rendererFnOptions.templateSource=function(){return that.options.resources.template.resourceText}}var produceTree=that.events.produceTree;produceTree.addListener(function(){return that.options.protoTree});if(that.options.produceTree){produceTree.addListener(that.options.produceTree)}fluid.renderer.reverseMerge(rendererFnOptions,that.options,["resolverGetConfig","resolverSetConfig"]);if(rendererFnOptions.rendererTargetSelector){container=function(){return that.dom.locate(rendererFnOptions.rendererTargetSelector)}}var renderer={fossils:{},boundPathForNode:function(node){return fluid.boundPathForNode(node,renderer.fossils)}};var rendererSub=fluid.renderer.createRendererSubcomponent(container,that.options.selectors,rendererFnOptions,that,renderer.fossils);that.renderer=$.extend(renderer,rendererSub);if(messageResolver){that.messageResolver=messageResolver}that.refreshView=renderer.refreshView=function(){if(rendererOptions.instantiator&&rendererOptions.parentComponent){fluid.renderer.clearDecorators(rendererOptions.instantiator,rendererOptions.parentComponent)}that.events.prepareModelForRender.fire(that.model,that.applier,that);var tree=produceTree.fire(that);if(that.renderer.expander){tree=that.renderer.expander(tree)}that.events.onRenderTree.fire(that,tree);that.renderer.render(tree);that.events.afterRender.fire(that)};if(that.options.renderOnInit){that.refreshView()}return that};var removeSelectors=function(selectors,selectorsToIgnore){fluid.each(fluid.makeArray(selectorsToIgnore),function(selectorToIgnore){delete selectors[selectorToIgnore]});return selectors};var markRepeated=function(selectorKey,repeatingSelectors){if(repeatingSelectors){fluid.each(repeatingSelectors,function(repeatingSelector){if(selectorKey===repeatingSelector){selectorKey=selectorKey+":"}})}return selectorKey};fluid.renderer.selectorsToCutpoints=function(selectors,options){var togo=[];options=options||{};selectors=fluid.copy(selectors);if(options.selectorsToIgnore){selectors=removeSelectors(selectors,options.selectorsToIgnore)}for(var selectorKey in selectors){togo.push({id:markRepeated(selectorKey,options.repeatingSelectors),selector:selectors[selectorKey]})}return togo};fluid.renderer.NO_COMPONENT={};fluid.renderer.mergeComponents=function(target,source){for(var key in source){target[key]=source[key]}return target};fluid.registerNamespace("fluid.renderer.selection");fluid.renderer.selection.inputs=function(options,container,key,config){fluid.expect("Selection to inputs expander",["selectID","inputID","labelID","rowID"],options);var selection=config.expander(options.tree);var rows=fluid.transform(selection.optionlist.value,function(option,index){var togo={};var element={parentRelativeID:"..::"+options.selectID,choiceindex:index};togo[options.inputID]=element;togo[options.labelID]=fluid.copy(element);return togo});var togo={};togo[options.selectID]=selection;togo[options.rowID]={children:rows};togo=config.expander(togo);return togo};fluid.renderer.repeat=function(options,container,key,config){fluid.expect("Repetition expander",["controlledBy","tree"],options);var env=config.threadLocal();var path=fluid.extractContextualPath(options.controlledBy,{ELstyle:"ALL"},env);var list=fluid.get(config.model,path,config.resolverGetConfig);var togo={};if(!list||list.length===0){return options.ifEmpty?config.expander(options.ifEmpty):togo}var expanded=[];fluid.each(list,function(element,i){var EL=fluid.model.composePath(path,i);var envAdd={};if(options.pathAs){envAdd[options.pathAs]="${"+EL+"}"}if(options.valueAs){envAdd[options.valueAs]=fluid.get(config.model,EL,config.resolverGetConfig)}var expandrow=fluid.withEnvironment(envAdd,function(){return config.expander(options.tree)},env);if(fluid.isArrayable(expandrow)){if(expandrow.length>0){expanded.push({children:expandrow})}}else{if(expandrow!==fluid.renderer.NO_COMPONENT){expanded.push(expandrow)}}});var repeatID=options.repeatID;if(repeatID.indexOf(":")===-1){repeatID=repeatID+":"}fluid.each(expanded,function(entry){entry.ID=repeatID});return expanded};fluid.renderer.condition=function(options,container,key,config){fluid.expect("Selection to condition expander",["condition"],options);var condition;if(options.condition.funcName){var args=config.expandLight(options.condition.args);condition=fluid.invoke(options.condition.funcName,args)}else{if(options.condition.expander){condition=config.expander(options.condition)}else{condition=config.expandLight(options.condition)}}var tree=(condition?options.trueTree:options.falseTree);if(!tree){tree=fluid.renderer.NO_COMPONENT}return config.expander(tree)};fluid.extractContextualPath=function(string,options,env){var parsed=fluid.extractELWithContext(string,options);if(parsed){if(parsed.context){return fluid.transformContextPath(parsed,env).path}else{return parsed.path}}};fluid.transformContextPath=function(parsed,env){if(parsed.context){var fetched=env[parsed.context];var EL;if(typeof (fetched)==="string"){EL=fluid.extractEL(fetched,{ELstyle:"${}"})}if(EL){return{noDereference:parsed.path==="",path:fluid.model.composePath(EL,parsed.path)}}}return parsed};fluid.renderer.makeProtoExpander=function(expandOptions){var options=$.extend({ELstyle:"${}"},expandOptions);var threadLocal;function fetchEL(string){var env=threadLocal();return fluid.extractContextualPath(string,options,env)}var IDescape=options.IDescape||"\\";var expandLight=function(source){return fluid.resolveEnvironment(source,options)};var expandBound=function(value,concrete){if(value.messagekey!==undefined){return{componentType:"UIMessage",messagekey:expandBound(value.messagekey),args:expandLight(value.args)}}var proto;if(!fluid.isPrimitive(value)&&!fluid.isArrayable(value)){proto=$.extend({},value);if(proto.decorators){proto.decorators=expandLight(proto.decorators)}value=proto.value;delete proto.value}else{proto={}}var EL=typeof (value)==="string"?fetchEL(value):null;if(EL){proto.valuebinding=EL}else{if(value!==undefined){proto.value=value}}if(options.model&&proto.valuebinding&&proto.value===undefined){proto.value=fluid.get(options.model,proto.valuebinding,options.resolverGetConfig)}if(concrete){proto.componentType="UIBound"}return proto};options.filter=fluid.expander.lightFilter;var expandCond;var expandLeafOrCond;var expandEntry=function(entry){var comp=[];expandCond(entry,comp);return{children:comp}};var expandExternal=function(entry){if(entry===fluid.renderer.NO_COMPONENT){return entry}var singleTarget;var target=[];var pusher=function(comp){singleTarget=comp};expandLeafOrCond(entry,target,pusher);return singleTarget||target};var expandConfig={model:options.model,resolverGetConfig:options.resolverGetConfig,resolverSetConfig:options.resolverSetConfig,expander:expandExternal,expandLight:expandLight};var expandLeaf=function(leaf,componentType){var togo={componentType:componentType};var map=fluid.renderer.boundMap[componentType]||{};for(var key in leaf){if(/decorators|args/.test(key)){togo[key]=expandLight(leaf[key]);continue}else{if(map[key]){togo[key]=expandBound(leaf[key])}else{togo[key]=leaf[key]}}}return togo};var expandChildren=function(entry,pusher){var children=entry.children;for(var i=0;i<children.length;++i){var target=[];var comp={children:target};var child=children[i];var childPusher=function(comp){target[target.length]=comp};expandLeafOrCond(child,target,childPusher);if(comp.children.length===1&&!comp.children[0].ID){comp=comp.children[0]}pusher(comp)}};function detectBareBound(entry){return fluid.find(entry,function(value,key){return key==="decorators"})!==false}var expandLeafOrCond=function(entry,target,pusher){var componentType=fluid.renderer.inferComponentType(entry);if(!componentType&&(fluid.isPrimitive(entry)||detectBareBound(entry))){componentType="UIBound"}if(componentType){pusher(componentType==="UIBound"?expandBound(entry,true):expandLeaf(entry,componentType))}else{if(!target){fluid.fail("Illegal cond->cond transition")}expandCond(entry,target)}};expandCond=function(proto,target){for(var key in proto){var entry=proto[key];if(key.charAt(0)===IDescape){key=key.substring(1)}if(key==="expander"){var expanders=fluid.makeArray(entry);fluid.each(expanders,function(expander){var expanded=fluid.invokeGlobalFunction(expander.type,[expander,proto,key,expandConfig]);if(expanded!==fluid.renderer.NO_COMPONENT){fluid.each(expanded,function(el){target[target.length]=el})}})}else{if(entry){var condPusher=function(comp){comp.ID=key;target[target.length]=comp};if(entry.children){if(key.indexOf(":")===-1){key=key+":"}expandChildren(entry,condPusher)}else{if(fluid.renderer.isBoundPrimitive(entry)){condPusher(expandBound(entry,true))}else{expandLeafOrCond(entry,null,condPusher)}}}}}};return function(entry){threadLocal=fluid.threadLocal(function(){return $.extend({},options.envAdd)});options.fetcher=fluid.makeEnvironmentFetcher(options.model,fluid.transformContextPath,threadLocal);expandConfig.threadLocal=threadLocal;return expandEntry(entry)}}})(jQuery,fluid_1_5);(function($,undefined){$.widget("ui.draggable",$.ui.mouse,{widgetEventPrefix:"drag",options:{addClasses:true,appendTo:"parent",axis:false,connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false},_create:function(){if(this.options.helper=="original"&&!(/^(?:r|a|f)/).test(this.element.css("position"))){this.element[0].style.position="relative"}(this.options.addClasses&&this.element.addClass("ui-draggable"));(this.options.disabled&&this.element.addClass("ui-draggable-disabled"));this._mouseInit()},destroy:function(){if(!this.element.data("draggable")){return }this.element.removeData("draggable").unbind(".draggable").removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled");this._mouseDestroy();return this},_mouseCapture:function(event){var o=this.options;if(this.helper||o.disabled||$(event.target).is(".ui-resizable-handle")){return false}this.handle=this._getHandle(event);if(!this.handle){return false}if(o.iframeFix){$(o.iframeFix===true?"iframe":o.iframeFix).each(function(){$('<div class="ui-draggable-iframeFix" style="background: #fff;"></div>').css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1000}).css($(this).offset()).appendTo("body")})}return true},_mouseStart:function(event){var o=this.options;this.helper=this._createHelper(event);this._cacheHelperProportions();if($.ui.ddmanager){$.ui.ddmanager.current=this}this._cacheMargins();this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent();this.offset=this.positionAbs=this.element.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};$.extend(this.offset,{click:{left:event.pageX-this.offset.left,top:event.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.originalPosition=this.position=this._generatePosition(event);this.originalPageX=event.pageX;this.originalPageY=event.pageY;(o.cursorAt&&this._adjustOffsetFromHelper(o.cursorAt));if(o.containment){this._setContainment()}if(this._trigger("inTime",event)===false){this._clear();return false}this._cacheHelperProportions();if($.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(this,event)}this.helper.addClass("ui-draggable-dragging");this._mouseDrag(event,true);if($.ui.ddmanager){$.ui.ddmanager.dragStart(this,event)}return true},_mouseDrag:function(event,noPropagation){this.position=this._generatePosition(event);this.positionAbs=this._convertPositionTo("absolute");if(!noPropagation){var ui=this._uiHash();if(this._trigger("drag",event,ui)===false){this._mouseUp({});return false}this.position=ui.position}if(!this.options.axis||this.options.axis!="y"){this.helper[0].style.left=this.position.left+"px"}if(!this.options.axis||this.options.axis!="x"){this.helper[0].style.top=this.position.top+"px"}if($.ui.ddmanager){$.ui.ddmanager.drag(this,event)}return false},_mouseStop:function(event){var dropped=false;if($.ui.ddmanager&&!this.options.dropBehaviour){dropped=$.ui.ddmanager.drop(this,event)}if(this.dropped){dropped=this.dropped;this.dropped=false}if((!this.element[0]||!this.element[0].parentNode)&&this.options.helper=="original"){return false}if((this.options.revert=="invalid"&&!dropped)||(this.options.revert=="valid"&&dropped)||this.options.revert===true||($.isFunction(this.options.revert)&&this.options.revert.call(this.element,dropped))){var self=this;$(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){if(self._trigger("stop",event)!==false){self._clear()}})}else{if(this._trigger("stop",event)!==false){this._clear()}}return false},_mouseUp:function(event){if(this.options.iframeFix===true){$("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this)})}if($.ui.ddmanager){$.ui.ddmanager.dragStop(this,event)}return $.ui.mouse.prototype._mouseUp.call(this,event)},cancel:function(){if(this.helper.is(".ui-draggable-dragging")){this._mouseUp({})}else{this._clear()}return this},_getHandle:function(event){var handle=!this.options.handle||!$(this.options.handle,this.element).length?true:false;$(this.options.handle,this.element).find("*").andSelf().each(function(){if(this==event.target){handle=true}});return handle},_createHelper:function(event){var o=this.options;var helper=$.isFunction(o.helper)?$(o.helper.apply(this.element[0],[event])):(o.helper=="clone"?this.element.clone().removeAttr("id"):this.element);if(!helper.parents("body").length){helper.appendTo((o.appendTo=="parent"?this.element[0].parentNode:o.appendTo))}if(helper[0]!=this.element[0]&&!(/(fixed|absolute)/).test(helper.css("position"))){helper.css("position","absolute")}return helper},_adjustOffsetFromHelper:function(obj){if(typeof obj=="string"){obj=obj.split(" ")}if($.isArray(obj)){obj={left:+obj[0],top:+obj[1]||0}}if("left" in obj){this.offset.click.left=obj.left+this.margins.left}if("right" in obj){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left}if("top" in obj){this.offset.click.top=obj.top+this.margins.top}if("bottom" in obj){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();if(this.cssPosition=="absolute"&&this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop()}if((this.offsetParent[0]==document.body)||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()=="html"&&$.browser.msie)){po={top:0,left:0}}return{top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition=="relative"){var p=this.element.position();return{top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}else{return{top:0,left:0}}},_cacheMargins:function(){this.margins={left:(parseInt(this.element.css("marginLeft"),10)||0),top:(parseInt(this.element.css("marginTop"),10)||0),right:(parseInt(this.element.css("marginRight"),10)||0),bottom:(parseInt(this.element.css("marginBottom"),10)||0)}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var o=this.options;if(o.containment=="parent"){o.containment=this.helper[0].parentNode}if(o.containment=="document"||o.containment=="window"){this.containment=[o.containment=="document"?0:$(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,o.containment=="document"?0:$(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,(o.containment=="document"?0:$(window).scrollLeft())+$(o.containment=="document"?document:window).width()-this.helperProportions.width-this.margins.left,(o.containment=="document"?0:$(window).scrollTop())+($(o.containment=="document"?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]}if(!(/^(document|window|parent)$/).test(o.containment)&&o.containment.constructor!=Array){var c=$(o.containment);var ce=c[0];if(!ce){return }var co=c.offset();var over=($(ce).css("overflow")!="hidden");this.containment=[(parseInt($(ce).css("borderLeftWidth"),10)||0)+(parseInt($(ce).css("paddingLeft"),10)||0),(parseInt($(ce).css("borderTopWidth"),10)||0)+(parseInt($(ce).css("paddingTop"),10)||0),(over?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-(parseInt($(ce).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(over?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-(parseInt($(ce).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom];this.relative_container=c}else{if(o.containment.constructor==Array){this.containment=o.containment}}},_convertPositionTo:function(d,pos){if(!pos){pos=this.position}var mod=d=="absolute"?1:-1;var o=this.options,scroll=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);return{top:(pos.top+this.offset.relative.top*mod+this.offset.parent.top*mod-($.browser.safari&&$.browser.version<526&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop()))*mod)),left:(pos.left+this.offset.relative.left*mod+this.offset.parent.left*mod-($.browser.safari&&$.browser.version<526&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())*mod))}},_generatePosition:function(event){var o=this.options,scroll=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);var pageX=event.pageX;var pageY=event.pageY;if(this.originalPosition){var containment;if(this.containment){if(this.relative_container){var co=this.relative_container.offset();containment=[this.containment[0]+co.left,this.containment[1]+co.top,this.containment[2]+co.left,this.containment[3]+co.top]}else{containment=this.containment}if(event.pageX-this.offset.click.left<containment[0]){pageX=containment[0]+this.offset.click.left}if(event.pageY-this.offset.click.top<containment[1]){pageY=containment[1]+this.offset.click.top}if(event.pageX-this.offset.click.left>containment[2]){pageX=containment[2]+this.offset.click.left}if(event.pageY-this.offset.click.top>containment[3]){pageY=containment[3]+this.offset.click.top}}if(o.grid){var top=o.grid[1]?this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1]:this.originalPageY;pageY=containment?(!(top-this.offset.click.top<containment[1]||top-this.offset.click.top>containment[3])?top:(!(top-this.offset.click.top<containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=o.grid[0]?this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0]:this.originalPageX;pageX=containment?(!(left-this.offset.click.left<containment[0]||left-this.offset.click.left>containment[2])?left:(!(left-this.offset.click.left<containment[0])?left-o.grid[0]:left+o.grid[0])):left}}return{top:(pageY-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+($.browser.safari&&$.browser.version<526&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop())))),left:(pageX-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+($.browser.safari&&$.browser.version<526&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())))}},_clear:function(){this.helper.removeClass("ui-draggable-dragging");if(this.helper[0]!=this.element[0]&&!this.cancelHelperRemoval){this.helper.remove()}this.helper=null;this.cancelHelperRemoval=false},_trigger:function(type,event,ui){ui=ui||this._uiHash();$.ui.plugin.call(this,type,[event,ui]);if(type=="drag"){this.positionAbs=this._convertPositionTo("absolute")}return $.Widget.prototype._trigger.call(this,type,event,ui)},plugins:{},_uiHash:function(event){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}});$.extend($.ui.draggable,{version:"@VERSION"});$.ui.plugin.add("draggable","connectToSortable",{start:function(event,ui){var inst=$(this).data("draggable"),o=inst.options,uiSortable=$.extend({},ui,{item:inst.element});inst.sortables=[];$(o.connectToSortable).each(function(){var sortable=$.data(this,"sortable");if(sortable&&!sortable.options.disabled){inst.sortables.push({instance:sortable,shouldRevert:sortable.options.revert});sortable.refreshPositions();sortable._trigger("activate",event,uiSortable)}})},stop:function(event,ui){var inst=$(this).data("draggable"),uiSortable=$.extend({},ui,{item:inst.element});$.each(inst.sortables,function(){if(this.instance.isOver){this.instance.isOver=0;inst.cancelHelperRemoval=true;this.instance.cancelHelperRemoval=false;if(this.shouldRevert){this.instance.options.revert=true}this.instance._mouseStop(event);this.instance.options.helper=this.instance.options._helper;if(inst.options.helper=="original"){this.instance.currentItem.css({top:"auto",left:"auto"})}}else{this.instance.cancelHelperRemoval=false;this.instance._trigger("deactivate",event,uiSortable)}})},drag:function(event,ui){var inst=$(this).data("draggable"),self=this;var checkPos=function(o){var dyClick=this.offset.click.top,dxClick=this.offset.click.left;var helperTop=this.positionAbs.top,helperLeft=this.positionAbs.left;var itemHeight=o.height,itemWidth=o.width;var itemTop=o.top,itemLeft=o.left;return $.ui.isOver(helperTop+dyClick,helperLeft+dxClick,itemTop,itemLeft,itemHeight,itemWidth)};$.each(inst.sortables,function(i){this.instance.positionAbs=inst.positionAbs;this.instance.helperProportions=inst.helperProportions;this.instance.offset.click=inst.offset.click;if(this.instance._intersectsWith(this.instance.containerCache)){if(!this.instance.isOver){this.instance.isOver=1;this.instance.currentItem=$(self).clone().removeAttr("id").appendTo(this.instance.element).data("sortable-item",true);this.instance.options._helper=this.instance.options.helper;this.instance.options.helper=function(){return ui.helper[0]};event.target=this.instance.currentItem[0];this.instance._mouseCapture(event,true);this.instance._mouseStart(event,true,true);this.instance.offset.click.top=inst.offset.click.top;this.instance.offset.click.left=inst.offset.click.left;this.instance.offset.parent.left-=inst.offset.parent.left-this.instance.offset.parent.left;this.instance.offset.parent.top-=inst.offset.parent.top-this.instance.offset.parent.top;inst._trigger("toSortable",event);inst.dropped=this.instance.element;inst.currentItem=inst.element;this.instance.fromOutside=inst}if(this.instance.currentItem){this.instance._mouseDrag(event)}}else{if(this.instance.isOver){this.instance.isOver=0;this.instance.cancelHelperRemoval=true;this.instance.options.revert=false;this.instance._trigger("out",event,this.instance._uiHash(this.instance));this.instance._mouseStop(event,true);this.instance.options.helper=this.instance.options._helper;this.instance.currentItem.remove();if(this.instance.placeholder){this.instance.placeholder.remove()}inst._trigger("fromSortable",event);inst.dropped=false}}})}});$.ui.plugin.add("draggable","cursor",{start:function(event,ui){var t=$("body"),o=$(this).data("draggable").options;if(t.css("cursor")){o._cursor=t.css("cursor")}t.css("cursor",o.cursor)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._cursor){$("body").css("cursor",o._cursor)}}});$.ui.plugin.add("draggable","opacity",{start:function(event,ui){var t=$(ui.helper),o=$(this).data("draggable").options;if(t.css("opacity")){o._opacity=t.css("opacity")}t.css("opacity",o.opacity)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._opacity){$(ui.helper).css("opacity",o._opacity)}}});$.ui.plugin.add("draggable","scroll",{start:function(event,ui){var i=$(this).data("draggable");if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!="HTML"){i.overflowOffset=i.scrollParent.offset()}},drag:function(event,ui){var i=$(this).data("draggable"),o=i.options,scrolled=false;if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!="HTML"){if(!o.axis||o.axis!="x"){if((i.overflowOffset.top+i.scrollParent[0].offsetHeight)-event.pageY<o.scrollSensitivity){i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop+o.scrollSpeed}else{if(event.pageY-i.overflowOffset.top<o.scrollSensitivity){i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop-o.scrollSpeed}}}if(!o.axis||o.axis!="y"){if((i.overflowOffset.left+i.scrollParent[0].offsetWidth)-event.pageX<o.scrollSensitivity){i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft+o.scrollSpeed}else{if(event.pageX-i.overflowOffset.left<o.scrollSensitivity){i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft-o.scrollSpeed}}}}else{if(!o.axis||o.axis!="x"){if(event.pageY-$(document).scrollTop()<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()-o.scrollSpeed)}else{if($(window).height()-(event.pageY-$(document).scrollTop())<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()+o.scrollSpeed)}}}if(!o.axis||o.axis!="y"){if(event.pageX-$(document).scrollLeft()<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed)}else{if($(window).width()-(event.pageX-$(document).scrollLeft())<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed)}}}}if(scrolled!==false&&$.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(i,event)}}});$.ui.plugin.add("draggable","snap",{start:function(event,ui){var i=$(this).data("draggable"),o=i.options;i.snapElements=[];$(o.snap.constructor!=String?(o.snap.items||":data(draggable)"):o.snap).each(function(){var $t=$(this);var $o=$t.offset();if(this!=i.element[0]){i.snapElements.push({item:this,width:$t.outerWidth(),height:$t.outerHeight(),top:$o.top,left:$o.left})}})},drag:function(event,ui){var inst=$(this).data("draggable"),o=inst.options;var d=o.snapTolerance;var x1=ui.offset.left,x2=x1+inst.helperProportions.width,y1=ui.offset.top,y2=y1+inst.helperProportions.height;for(var i=inst.snapElements.length-1;i>=0;i--){var l=inst.snapElements[i].left,r=l+inst.snapElements[i].width,t=inst.snapElements[i].top,b=t+inst.snapElements[i].height;if(!((l-d<x1&&x1<r+d&&t-d<y1&&y1<b+d)||(l-d<x1&&x1<r+d&&t-d<y2&&y2<b+d)||(l-d<x2&&x2<r+d&&t-d<y1&&y1<b+d)||(l-d<x2&&x2<r+d&&t-d<y2&&y2<b+d))){if(inst.snapElements[i].snapping){(inst.options.snap.release&&inst.options.snap.release.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})))}inst.snapElements[i].snapping=false;continue}if(o.snapMode!="inner"){var ts=Math.abs(t-y2)<=d;var bs=Math.abs(b-y1)<=d;var ls=Math.abs(l-x2)<=d;var rs=Math.abs(r-x1)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t-inst.helperProportions.height,left:0}).top-inst.margins.top}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b,left:0}).top-inst.margins.top}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l-inst.helperProportions.width}).left-inst.margins.left}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r}).left-inst.margins.left}}var first=(ts||bs||ls||rs);if(o.snapMode!="outer"){var ts=Math.abs(t-y1)<=d;var bs=Math.abs(b-y2)<=d;var ls=Math.abs(l-x1)<=d;var rs=Math.abs(r-x2)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t,left:0}).top-inst.margins.top}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b-inst.helperProportions.height,left:0}).top-inst.margins.top}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l}).left-inst.margins.left}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r-inst.helperProportions.width}).left-inst.margins.left}}if(!inst.snapElements[i].snapping&&(ts||bs||ls||rs||first)){(inst.options.snap.snap&&inst.options.snap.snap.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})))}inst.snapElements[i].snapping=(ts||bs||ls||rs||first)}}});$.ui.plugin.add("draggable","stack",{start:function(event,ui){var o=$(this).data("draggable").options;var group=$.makeArray($(o.stack)).sort(function(a,b){return(parseInt($(a).css("zIndex"),10)||0)-(parseInt($(b).css("zIndex"),10)||0)});if(!group.length){return }var min=parseInt(group[0].style.zIndex)||0;$(group).each(function(i){this.style.zIndex=min+i});this[0].style.zIndex=min+group.length}});$.ui.plugin.add("draggable","zIndex",{start:function(event,ui){var t=$(ui.helper),o=$(this).data("draggable").options;if(t.css("zIndex")){o._zIndex=t.css("zIndex")}t.css("zIndex",o.zIndex)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._zIndex){$(ui.helper).css("zIndex",o._zIndex)}}})})(jQuery);(function($,undefined){var uiDialogClasses="ui-dialog ui-widget ui-widget-content ui-corner-all ",sizeRelatedOptions={buttons:true,height:true,maxHeight:true,maxWidth:true,minHeight:true,minWidth:true,width:true},resizableRelatedOptions={maxHeight:true,maxWidth:true,minHeight:true,minWidth:true},attrFn=$.attrFn||{val:true,css:true,html:true,text:true,data:true,width:true,height:true,offset:true,click:true};$.widget("ui.dialog",{options:{autoOpen:true,buttons:{},closeOnEscape:true,closeText:"close",dialogClass:"",draggable:true,hide:null,height:"auto",maxHeight:false,maxWidth:false,minHeight:150,minWidth:150,modal:false,position:{my:"center",at:"center",collision:"fit",using:function(pos){var topOffset=$(this).css(pos).offset().top;if(topOffset<0){$(this).css("top",pos.top-topOffset)}}},resizable:true,show:null,stack:true,title:"",width:300,zIndex:1000},_create:function(){this.originalTitle=this.element.attr("title");if(typeof this.originalTitle!=="string"){this.originalTitle=""}this.options.title=this.options.title||this.originalTitle;var self=this,options=self.options,title=options.title||"&#160;",titleId=$.ui.dialog.getTitleId(self.element),uiDialog=(self.uiDialog=$("<div></div>")).appendTo(document.body).hide().addClass(uiDialogClasses+options.dialogClass).css({zIndex:options.zIndex}).attr("tabIndex",-1).css("outline",0).keydown(function(event){if(options.closeOnEscape&&!event.isDefaultPrevented()&&event.keyCode&&event.keyCode===$.ui.keyCode.ESCAPE){self.close(event);event.preventDefault()}}).attr({role:"dialog","aria-labelledby":titleId}).mousedown(function(event){self.moveToTop(false,event)}),uiDialogContent=self.element.show().removeAttr("title").addClass("ui-dialog-content ui-widget-content").appendTo(uiDialog),uiDialogTitlebar=(self.uiDialogTitlebar=$("<div></div>")).addClass("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix").prependTo(uiDialog),uiDialogTitlebarClose=$('<a href="#"></a>').addClass("ui-dialog-titlebar-close ui-corner-all").attr("role","button").hover(function(){uiDialogTitlebarClose.addClass("ui-state-hover")},function(){uiDialogTitlebarClose.removeClass("ui-state-hover")}).focus(function(){uiDialogTitlebarClose.addClass("ui-state-focus")}).blur(function(){uiDialogTitlebarClose.removeClass("ui-state-focus")}).click(function(event){self.close(event);return false}).appendTo(uiDialogTitlebar),uiDialogTitlebarCloseText=(self.uiDialogTitlebarCloseText=$("<span></span>")).addClass("ui-icon ui-icon-closethick").text(options.closeText).appendTo(uiDialogTitlebarClose),uiDialogTitle=$("<span></span>").addClass("ui-dialog-title").attr("id",titleId).html(title).prependTo(uiDialogTitlebar);if($.isFunction(options.beforeclose)&&!$.isFunction(options.beforeClose)){options.beforeClose=options.beforeclose}uiDialogTitlebar.find("*").add(uiDialogTitlebar).disableSelection();if(options.draggable&&$.fn.draggable){self._makeDraggable()}if(options.resizable&&$.fn.resizable){self._makeResizable()}self._createButtons(options.buttons);self._isOpen=false;if($.fn.bgiframe){uiDialog.bgiframe()}},_init:function(){if(this.options.autoOpen){this.open()}},destroy:function(){var self=this;if(self.overlay){self.overlay.destroy()}self.uiDialog.hide();self.element.unbind(".dialog").removeData("dialog").removeClass("ui-dialog-content ui-widget-content").hide().appendTo("body");self.uiDialog.remove();if(self.originalTitle){self.element.attr("title",self.originalTitle)}return self},widget:function(){return this.uiDialog},close:function(event){var self=this,maxZ,thisZ;if(false===self._trigger("beforeClose",event)){return }if(self.overlay){self.overlay.destroy()}self.uiDialog.unbind("keypress.ui-dialog");self._isOpen=false;if(self.options.hide){self.uiDialog.hide(self.options.hide,function(){self._trigger("close",event)})}else{self.uiDialog.hide();self._trigger("close",event)}$.ui.dialog.overlay.resize();if(self.options.modal){maxZ=0;$(".ui-dialog").each(function(){if(this!==self.uiDialog[0]){thisZ=$(this).css("z-index");if(!isNaN(thisZ)){maxZ=Math.max(maxZ,thisZ)}}});$.ui.dialog.maxZ=maxZ}return self},isOpen:function(){return this._isOpen},moveToTop:function(force,event){var self=this,options=self.options,saveScroll;if((options.modal&&!force)||(!options.stack&&!options.modal)){return self._trigger("focus",event)}if(options.zIndex>$.ui.dialog.maxZ){$.ui.dialog.maxZ=options.zIndex}if(self.overlay){$.ui.dialog.maxZ+=1;self.overlay.$el.css("z-index",$.ui.dialog.overlay.maxZ=$.ui.dialog.maxZ)}saveScroll={scrollTop:self.element.scrollTop(),scrollLeft:self.element.scrollLeft()};$.ui.dialog.maxZ+=1;self.uiDialog.css("z-index",$.ui.dialog.maxZ);self.element.attr(saveScroll);self._trigger("focus",event);return self},open:function(){if(this._isOpen){return }var self=this,options=self.options,uiDialog=self.uiDialog;self.overlay=options.modal?new $.ui.dialog.overlay(self):null;self._size();self._position(options.position);uiDialog.show(options.show);self.moveToTop(true);if(options.modal){uiDialog.bind("keydown.ui-dialog",function(event){if(event.keyCode!==$.ui.keyCode.TAB){return }var tabbables=$(":tabbable",this),first=tabbables.filter(":first"),last=tabbables.filter(":last");if(event.target===last[0]&&!event.shiftKey){first.focus(1);return false}else{if(event.target===first[0]&&event.shiftKey){last.focus(1);return false}}})}$(self.element.find(":tabbable").get().concat(uiDialog.find(".ui-dialog-buttonpane :tabbable").get().concat(uiDialog.get()))).eq(0).focus();self._isOpen=true;self._trigger("open");return self},_createButtons:function(buttons){var self=this,hasButtons=false,uiDialogButtonPane=$("<div></div>").addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix"),uiButtonSet=$("<div></div>").addClass("ui-dialog-buttonset").appendTo(uiDialogButtonPane);self.uiDialog.find(".ui-dialog-buttonpane").remove();if(typeof buttons==="object"&&buttons!==null){$.each(buttons,function(){return !(hasButtons=true)})}if(hasButtons){$.each(buttons,function(name,props){props=$.isFunction(props)?{click:props,text:name}:props;var button=$('<button type="button"></button>').click(function(){props.click.apply(self.element[0],arguments)}).appendTo(uiButtonSet);$.each(props,function(key,value){if(key==="click"){return }if(key in attrFn){button[key](value)}else{button.attr(key,value)}});if($.fn.button){button.button()}});uiDialogButtonPane.appendTo(self.uiDialog)}},_makeDraggable:function(){var self=this,options=self.options,doc=$(document),heightBeforeDrag;function filteredUi(ui){return{position:ui.position,offset:ui.offset}}self.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(event,ui){heightBeforeDrag=options.height==="auto"?"auto":$(this).height();$(this).height($(this).height()).addClass("ui-dialog-dragging");self._trigger("dragStart",event,filteredUi(ui))},drag:function(event,ui){self._trigger("drag",event,filteredUi(ui))},stop:function(event,ui){options.position=[ui.position.left-doc.scrollLeft(),ui.position.top-doc.scrollTop()];$(this).removeClass("ui-dialog-dragging").height(heightBeforeDrag);self._trigger("dragStop",event,filteredUi(ui));$.ui.dialog.overlay.resize()}})},_makeResizable:function(handles){handles=(handles===undefined?this.options.resizable:handles);var self=this,options=self.options,position=self.uiDialog.css("position"),resizeHandles=(typeof handles==="string"?handles:"n,e,s,w,se,sw,ne,nw");function filteredUi(ui){return{originalPosition:ui.originalPosition,originalSize:ui.originalSize,position:ui.position,size:ui.size}}self.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:self.element,maxWidth:options.maxWidth,maxHeight:options.maxHeight,minWidth:options.minWidth,minHeight:self._minHeight(),handles:resizeHandles,start:function(event,ui){$(this).addClass("ui-dialog-resizing");self._trigger("resizeStart",event,filteredUi(ui))},resize:function(event,ui){self._trigger("resize",event,filteredUi(ui))},stop:function(event,ui){$(this).removeClass("ui-dialog-resizing");options.height=$(this).height();options.width=$(this).width();self._trigger("resizeStop",event,filteredUi(ui));$.ui.dialog.overlay.resize()}}).css("position",position).find(".ui-resizable-se").addClass("ui-icon ui-icon-grip-diagonal-se")},_minHeight:function(){var options=this.options;if(options.height==="auto"){return options.minHeight}else{return Math.min(options.minHeight,options.height)}},_position:function(position){var myAt=[],offset=[0,0],isVisible;if(position){if(typeof position==="string"||(typeof position==="object"&&"0" in position)){myAt=position.split?position.split(" "):[position[0],position[1]];if(myAt.length===1){myAt[1]=myAt[0]}$.each(["left","top"],function(i,offsetPosition){if(+myAt[i]===myAt[i]){offset[i]=myAt[i];myAt[i]=offsetPosition}});position={my:myAt.join(" "),at:myAt.join(" "),offset:offset.join(" ")}}position=$.extend({},$.ui.dialog.prototype.options.position,position)}else{position=$.ui.dialog.prototype.options.position}isVisible=this.uiDialog.is(":visible");if(!isVisible){this.uiDialog.show()}this.uiDialog.css({top:0,left:0}).position($.extend({of:window},position));if(!isVisible){this.uiDialog.hide()}},_setOptions:function(options){var self=this,resizableOptions={},resize=false;$.each(options,function(key,value){self._setOption(key,value);if(key in sizeRelatedOptions){resize=true}if(key in resizableRelatedOptions){resizableOptions[key]=value}});if(resize){this._size()}if(this.uiDialog.is(":data(resizable)")){this.uiDialog.resizable("option",resizableOptions)}},_setOption:function(key,value){var self=this,uiDialog=self.uiDialog;switch(key){case"beforeclose":key="beforeClose";break;case"buttons":self._createButtons(value);break;case"closeText":self.uiDialogTitlebarCloseText.text(""+value);break;case"dialogClass":uiDialog.removeClass(self.options.dialogClass).addClass(uiDialogClasses+value);break;case"disabled":if(value){uiDialog.addClass("ui-dialog-disabled")}else{uiDialog.removeClass("ui-dialog-disabled")}break;case"draggable":var isDraggable=uiDialog.is(":data(draggable)");if(isDraggable&&!value){uiDialog.draggable("destroy")}if(!isDraggable&&value){self._makeDraggable()}break;case"position":self._position(value);break;case"resizable":var isResizable=uiDialog.is(":data(resizable)");if(isResizable&&!value){uiDialog.resizable("destroy")}if(isResizable&&typeof value==="string"){uiDialog.resizable("option","handles",value)}if(!isResizable&&value!==false){self._makeResizable(value)}break;case"title":$(".ui-dialog-title",self.uiDialogTitlebar).html(""+(value||"&#160;"));break}$.Widget.prototype._setOption.apply(self,arguments)},_size:function(){var options=this.options,nonContentHeight,minContentHeight,isVisible=this.uiDialog.is(":visible");this.element.show().css({width:"auto",minHeight:0,height:0});if(options.minWidth>options.width){options.width=options.minWidth}nonContentHeight=this.uiDialog.css({height:"auto",width:options.width}).height();minContentHeight=Math.max(0,options.minHeight-nonContentHeight);if(options.height==="auto"){if($.support.minHeight){this.element.css({minHeight:minContentHeight,height:"auto"})}else{this.uiDialog.show();var autoHeight=this.element.css("height","auto").height();if(!isVisible){this.uiDialog.hide()}this.element.height(Math.max(autoHeight,minContentHeight))}}else{this.element.height(Math.max(options.height-nonContentHeight,0))}if(this.uiDialog.is(":data(resizable)")){this.uiDialog.resizable("option","minHeight",this._minHeight())}}});$.extend($.ui.dialog,{version:"@VERSION",uuid:0,maxZ:0,getTitleId:function($el){var id=$el.attr("id");if(!id){this.uuid+=1;id=this.uuid}return"ui-dialog-title-"+id},overlay:function(dialog){this.$el=$.ui.dialog.overlay.create(dialog)}});$.extend($.ui.dialog.overlay,{instances:[],oldInstances:[],maxZ:0,events:$.map("focus,mousedown,mouseup,keydown,keypress,click".split(","),function(event){return event+".dialog-overlay"}).join(" "),create:function(dialog){if(this.instances.length===0){setTimeout(function(){if($.ui.dialog.overlay.instances.length){$(document).bind($.ui.dialog.overlay.events,function(event){if($(event.target).zIndex()<$.ui.dialog.overlay.maxZ){return false}})}},1);$(document).bind("keydown.dialog-overlay",function(event){if(dialog.options.closeOnEscape&&!event.isDefaultPrevented()&&event.keyCode&&event.keyCode===$.ui.keyCode.ESCAPE){dialog.close(event);event.preventDefault()}});$(window).bind("resize.dialog-overlay",$.ui.dialog.overlay.resize)}var $el=(this.oldInstances.pop()||$("<div></div>").addClass("ui-widget-overlay")).appendTo(document.body).css({width:this.width(),height:this.height()});if($.fn.bgiframe){$el.bgiframe()}this.instances.push($el);return $el},destroy:function($el){var indexOf=$.inArray($el,this.instances);if(indexOf!=-1){this.oldInstances.push(this.instances.splice(indexOf,1)[0])}if(this.instances.length===0){$([document,window]).unbind(".dialog-overlay")}$el.remove();var maxZ=0;$.each(this.instances,function(){maxZ=Math.max(maxZ,this.css("z-index"))});this.maxZ=maxZ},height:function(){var scrollHeight,offsetHeight;if($.browser.msie&&$.browser.version<7){scrollHeight=Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);offsetHeight=Math.max(document.documentElement.offsetHeight,document.body.offsetHeight);if(scrollHeight<offsetHeight){return $(window).height()+"px"}else{return scrollHeight+"px"}}else{return $(document).height()+"px"}},width:function(){var scrollWidth,offsetWidth;if($.browser.msie){scrollWidth=Math.max(document.documentElement.scrollWidth,document.body.scrollWidth);offsetWidth=Math.max(document.documentElement.offsetWidth,document.body.offsetWidth);if(scrollWidth<offsetWidth){return $(window).width()+"px"}else{return scrollWidth+"px"}}else{return $(document).width()+"px"}},resize:function(){var $overlays=$([]);$.each($.ui.dialog.overlay.instances,function(){$overlays=$overlays.add(this)});$overlays.css({width:0,height:0}).css({width:$.ui.dialog.overlay.width(),height:$.ui.dialog.overlay.height()})}});$.extend($.ui.dialog.overlay.prototype,{destroy:function(){$.ui.dialog.overlay.destroy(this.$el)}})}(jQuery));(function($,undefined){var numPages=5;$.widget("ui.slider",$.ui.mouse,{widgetEventPrefix:"slide",options:{animate:false,distance:0,max:100,min:0,orientation:"horizontal",range:false,step:1,value:0,values:null},_create:function(){var self=this,o=this.options,existingHandles=this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"),handle="<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",handleCount=(o.values&&o.values.length)||1,handles=[];this._keySliding=false;this._mouseSliding=false;this._animateOff=true;this._handleIndex=null;this._detectOrientation();this._mouseInit();this.element.addClass("ui-slider ui-slider-"+this.orientation+" ui-widget ui-widget-content ui-corner-all"+(o.disabled?" ui-slider-disabled ui-disabled":""));this.range=$([]);if(o.range){if(o.range===true){if(!o.values){o.values=[this._valueMin(),this._valueMin()]}if(o.values.length&&o.values.length!==2){o.values=[o.values[0],o.values[0]]}}this.range=$("<div></div>").appendTo(this.element).addClass("ui-slider-range ui-widget-header"+((o.range==="min"||o.range==="max")?" ui-slider-range-"+o.range:""))}for(var i=existingHandles.length;i<handleCount;i+=1){handles.push(handle)}this.handles=existingHandles.add($(handles.join("")).appendTo(self.element));this.handle=this.handles.eq(0);this.handles.add(this.range).filter("a").click(function(event){event.preventDefault()}).hover(function(){if(!o.disabled){$(this).addClass("ui-state-hover")}},function(){$(this).removeClass("ui-state-hover")}).focus(function(){if(!o.disabled){$(".ui-slider .ui-state-focus").removeClass("ui-state-focus");$(this).addClass("ui-state-focus")}else{$(this).blur()}}).blur(function(){$(this).removeClass("ui-state-focus")});this.handles.each(function(i){$(this).data("index.ui-slider-handle",i)});this.handles.keydown(function(event){var index=$(this).data("index.ui-slider-handle"),allowed,curVal,newVal,step;if(self.options.disabled){return }switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.PAGE_UP:case $.ui.keyCode.PAGE_DOWN:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:event.preventDefault();if(!self._keySliding){self._keySliding=true;$(this).addClass("ui-state-active");allowed=self._start(event,index);if(allowed===false){return }}break}step=self.options.step;if(self.options.values&&self.options.values.length){curVal=newVal=self.values(index)}else{curVal=newVal=self.value()}switch(event.keyCode){case $.ui.keyCode.HOME:newVal=self._valueMin();break;case $.ui.keyCode.END:newVal=self._valueMax();break;case $.ui.keyCode.PAGE_UP:newVal=self._trimAlignValue(curVal+((self._valueMax()-self._valueMin())/numPages));break;case $.ui.keyCode.PAGE_DOWN:newVal=self._trimAlignValue(curVal-((self._valueMax()-self._valueMin())/numPages));break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal===self._valueMax()){return }newVal=self._trimAlignValue(curVal+step);break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal===self._valueMin()){return }newVal=self._trimAlignValue(curVal-step);break}self._slide(event,index,newVal)}).keyup(function(event){var index=$(this).data("index.ui-slider-handle");if(self._keySliding){self._keySliding=false;self._stop(event,index);self._change(event,index);$(this).removeClass("ui-state-active")}});this._refreshValue();this._animateOff=false},destroy:function(){this.handles.remove();this.range.remove();this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-slider-disabled ui-widget ui-widget-content ui-corner-all").removeData("slider").unbind(".slider");this._mouseDestroy();return this},_mouseCapture:function(event){var o=this.options,position,normValue,distance,closestHandle,self,index,allowed,offset,mouseOverHandle;if(o.disabled){return false}this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();position={x:event.pageX,y:event.pageY};normValue=this._normValueFromMouse(position);distance=this._valueMax()-this._valueMin()+1;self=this;this.handles.each(function(i){var thisDistance=Math.abs(normValue-self.values(i));if(distance>thisDistance){distance=thisDistance;closestHandle=$(this);index=i}});if(o.range===true&&this.values(1)===o.min){index+=1;closestHandle=$(this.handles[index])}allowed=this._start(event,index);if(allowed===false){return false}this._mouseSliding=true;self._handleIndex=index;closestHandle.addClass("ui-state-active").focus();offset=closestHandle.offset();mouseOverHandle=!$(event.target).parents().andSelf().is(".ui-slider-handle");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-(closestHandle.width()/2),top:event.pageY-offset.top-(closestHandle.height()/2)-(parseInt(closestHandle.css("borderTopWidth"),10)||0)-(parseInt(closestHandle.css("borderBottomWidth"),10)||0)+(parseInt(closestHandle.css("marginTop"),10)||0)};if(!this.handles.hasClass("ui-state-hover")){this._slide(event,index,normValue)}this._animateOff=true;return true},_mouseStart:function(event){return true},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY},normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false},_mouseStop:function(event){this.handles.removeClass("ui-state-active");this._mouseSliding=false;this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;this._animateOff=false;return false},_detectOrientation:function(){this.orientation=(this.options.orientation==="vertical")?"vertical":"horizontal"},_normValueFromMouse:function(position){var pixelTotal,pixelMouse,percentMouse,valueTotal,valueMouse;if(this.orientation==="horizontal"){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)}else{pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)}percentMouse=(pixelMouse/pixelTotal);if(percentMouse>1){percentMouse=1}if(percentMouse<0){percentMouse=0}if(this.orientation==="vertical"){percentMouse=1-percentMouse}valueTotal=this._valueMax()-this._valueMin();valueMouse=this._valueMin()+percentMouse*valueTotal;return this._trimAlignValue(valueMouse)},_start:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values()}return this._trigger("inTime",event,uiHash)},_slide:function(event,index,newVal){var otherVal,newValues,allowed;if(this.options.values&&this.options.values.length){otherVal=this.values(index?0:1);if((this.options.values.length===2&&this.options.range===true)&&((index===0&&newVal>otherVal)||(index===1&&newVal<otherVal))){newVal=otherVal}if(newVal!==this.values(index)){newValues=this.values();newValues[index]=newVal;allowed=this._trigger("slide",event,{handle:this.handles[index],value:newVal,values:newValues});otherVal=this.values(index?0:1);if(allowed!==false){this.values(index,newVal,true)}}}else{if(newVal!==this.value()){allowed=this._trigger("slide",event,{handle:this.handles[index],value:newVal});if(allowed!==false){this.value(newVal)}}}},_stop:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values()}this._trigger("stop",event,uiHash)},_change:function(event,index){if(!this._keySliding&&!this._mouseSliding){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values()}this._trigger("change",event,uiHash)}},value:function(newValue){if(arguments.length){this.options.value=this._trimAlignValue(newValue);this._refreshValue();this._change(null,0);return }return this._value()},values:function(index,newValue){var vals,newValues,i;if(arguments.length>1){this.options.values[index]=this._trimAlignValue(newValue);this._refreshValue();this._change(null,index);return }if(arguments.length){if($.isArray(arguments[0])){vals=this.options.values;newValues=arguments[0];for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(newValues[i]);this._change(null,i)}this._refreshValue()}else{if(this.options.values&&this.options.values.length){return this._values(index)}else{return this.value()}}}else{return this._values()}},_setOption:function(key,value){var i,valsLength=0;if($.isArray(this.options.values)){valsLength=this.options.values.length}$.Widget.prototype._setOption.apply(this,arguments);switch(key){case"disabled":if(value){this.handles.filter(".ui-state-focus").blur();this.handles.removeClass("ui-state-hover");this.handles.propAttr("disabled",true);this.element.addClass("ui-disabled")}else{this.handles.propAttr("disabled",false);this.element.removeClass("ui-disabled")}break;case"orientation":this._detectOrientation();this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+this.orientation);this._refreshValue();break;case"value":this._animateOff=true;this._refreshValue();this._change(null,0);this._animateOff=false;break;case"values":this._animateOff=true;this._refreshValue();for(i=0;i<valsLength;i+=1){this._change(null,i)}this._animateOff=false;break}},_value:function(){var val=this.options.value;val=this._trimAlignValue(val);return val},_values:function(index){var val,vals,i;if(arguments.length){val=this.options.values[index];val=this._trimAlignValue(val);return val}else{vals=this.options.values.slice();for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(vals[i])}return vals}},_trimAlignValue:function(val){if(val<=this._valueMin()){return this._valueMin()}if(val>=this._valueMax()){return this._valueMax()}var step=(this.options.step>0)?this.options.step:1,valModStep=(val-this._valueMin())%step,alignValue=val-valModStep;if(Math.abs(valModStep)*2>=step){alignValue+=(valModStep>0)?step:(-step)}return parseFloat(alignValue.toFixed(5))},_valueMin:function(){return this.options.min},_valueMax:function(){return this.options.max},_refreshValue:function(){var oRange=this.options.range,o=this.options,self=this,animate=(!this._animateOff)?o.animate:false,valPercent,_set={},lastValPercent,value,valueMin,valueMax;if(this.options.values&&this.options.values.length){this.handles.each(function(i,j){valPercent=(self.values(i)-self._valueMin())/(self._valueMax()-self._valueMin())*100;_set[self.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";$(this).stop(1,1)[animate?"animate":"css"](_set,o.animate);if(self.options.range===true){if(self.orientation==="horizontal"){if(i===0){self.range.stop(1,1)[animate?"animate":"css"]({left:valPercent+"%"},o.animate)}if(i===1){self.range[animate?"animate":"css"]({width:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate})}}else{if(i===0){self.range.stop(1,1)[animate?"animate":"css"]({bottom:(valPercent)+"%"},o.animate)}if(i===1){self.range[animate?"animate":"css"]({height:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate})}}}lastValPercent=valPercent})}else{value=this.value();valueMin=this._valueMin();valueMax=this._valueMax();valPercent=(valueMax!==valueMin)?(value-valueMin)/(valueMax-valueMin)*100:0;_set[self.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";this.handle.stop(1,1)[animate?"animate":"css"](_set,o.animate);if(oRange==="min"&&this.orientation==="horizontal"){this.range.stop(1,1)[animate?"animate":"css"]({width:valPercent+"%"},o.animate)}if(oRange==="max"&&this.orientation==="horizontal"){this.range[animate?"animate":"css"]({width:(100-valPercent)+"%"},{queue:false,duration:o.animate})}if(oRange==="min"&&this.orientation==="vertical"){this.range.stop(1,1)[animate?"animate":"css"]({height:valPercent+"%"},o.animate)}if(oRange==="max"&&this.orientation==="vertical"){this.range[animate?"animate":"css"]({height:(100-valPercent)+"%"},{queue:false,duration:o.animate})}}}});$.extend($.ui.slider,{version:"@VERSION"})}(jQuery));(function($,undefined){var tabId=0,listId=0;function getNextTabId(){return ++tabId}function getNextListId(){return ++listId}$.widget("ui.tabs",{options:{add:null,ajaxOptions:null,cache:false,cookie:null,collapsible:false,disable:null,disabled:[],enable:null,event:"click",fx:null,idPrefix:"ui-tabs-",load:null,panelTemplate:"<div></div>",remove:null,select:null,show:null,spinner:"<em>Loading&#8230;</em>",tabTemplate:"<li><a href='#{href}'><span>#{label}</span></a></li>"},_create:function(){this._tabify(true)},_setOption:function(key,value){if(key=="selected"){if(this.options.collapsible&&value==this.options.selected){return }this.select(value)}else{this.options[key]=value;this._tabify()}},_tabId:function(a){return a.title&&a.title.replace(/\s/g,"_").replace(/[^\w\u00c0-\uFFFF-]/g,"")||this.options.idPrefix+getNextTabId()},_sanitizeSelector:function(hash){return hash.replace(/:/g,"\\:")},_cookie:function(){var cookie=this.cookie||(this.cookie=this.options.cookie.name||"ui-tabs-"+getNextListId());return $.cookie.apply(null,[cookie].concat($.makeArray(arguments)))},_ui:function(tab,panel){return{tab:tab,panel:panel,index:this.anchors.index(tab)}},_cleanup:function(){this.lis.filter(".ui-state-processing").removeClass("ui-state-processing").find("span:data(label.tabs)").each(function(){var el=$(this);el.html(el.data("label.tabs")).removeData("label.tabs")})},_tabify:function(init){var self=this,o=this.options,fragmentId=/^#.+/;this.list=this.element.find("ol,ul").eq(0);this.lis=$(" > li:has(a[href])",this.list);this.anchors=this.lis.map(function(){return $("a",this)[0]});this.panels=$([]);this.anchors.each(function(i,a){var href=$(a).attr("href");var hrefBase=href.split("#")[0],baseEl;if(hrefBase&&(hrefBase===location.toString().split("#")[0]||(baseEl=$("base")[0])&&hrefBase===baseEl.href)){href=a.hash;a.href=href}if(fragmentId.test(href)){self.panels=self.panels.add(self.element.find(self._sanitizeSelector(href)))}else{if(href&&href!=="#"){$.data(a,"href.tabs",href);$.data(a,"load.tabs",href.replace(/#.*$/,""));var id=self._tabId(a);a.href="#"+id;var $panel=self.element.find("#"+id);if(!$panel.length){$panel=$(o.panelTemplate).attr("id",id).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").insertAfter(self.panels[i-1]||self.list);$panel.data("destroy.tabs",true)}self.panels=self.panels.add($panel)}else{o.disabled.push(i)}}});if(init){this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all");this.list.addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all");this.lis.addClass("ui-state-default ui-corner-top");this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom");if(o.selected===undefined){if(location.hash){this.anchors.each(function(i,a){if(a.hash==location.hash){o.selected=i;return false}})}if(typeof o.selected!=="number"&&o.cookie){o.selected=parseInt(self._cookie(),10)}if(typeof o.selected!=="number"&&this.lis.filter(".ui-tabs-selected").length){o.selected=this.lis.index(this.lis.filter(".ui-tabs-selected"))}o.selected=o.selected||(this.lis.length?0:-1)}else{if(o.selected===null){o.selected=-1}}o.selected=((o.selected>=0&&this.anchors[o.selected])||o.selected<0)?o.selected:0;o.disabled=$.unique(o.disabled.concat($.map(this.lis.filter(".ui-state-disabled"),function(n,i){return self.lis.index(n)}))).sort();if($.inArray(o.selected,o.disabled)!=-1){o.disabled.splice($.inArray(o.selected,o.disabled),1)}this.panels.addClass("ui-tabs-hide");this.lis.removeClass("ui-tabs-selected ui-state-active");if(o.selected>=0&&this.anchors.length){self.element.find(self._sanitizeSelector(self.anchors[o.selected].hash)).removeClass("ui-tabs-hide");this.lis.eq(o.selected).addClass("ui-tabs-selected ui-state-active");self.element.queue("tabs",function(){self._trigger("show",null,self._ui(self.anchors[o.selected],self.element.find(self._sanitizeSelector(self.anchors[o.selected].hash))[0]))});this.load(o.selected)}$(window).bind("unload",function(){self.lis.add(self.anchors).unbind(".tabs");self.lis=self.anchors=self.panels=null})}else{o.selected=this.lis.index(this.lis.filter(".ui-tabs-selected"))}this.element[o.collapsible?"addClass":"removeClass"]("ui-tabs-collapsible");if(o.cookie){this._cookie(o.selected,o.cookie)}for(var i=0,li;(li=this.lis[i]);i++){$(li)[$.inArray(i,o.disabled)!=-1&&!$(li).hasClass("ui-tabs-selected")?"addClass":"removeClass"]("ui-state-disabled")}if(o.cache===false){this.anchors.removeData("cache.tabs")}this.lis.add(this.anchors).unbind(".tabs");if(o.event!=="mouseover"){var addState=function(state,el){if(el.is(":not(.ui-state-disabled)")){el.addClass("ui-state-"+state)}};var removeState=function(state,el){el.removeClass("ui-state-"+state)};this.lis.bind("mouseover.tabs",function(){addState("hover",$(this))});this.lis.bind("mouseout.tabs",function(){removeState("hover",$(this))});this.anchors.bind("focus.tabs",function(){addState("focus",$(this).closest("li"))});this.anchors.bind("blur.tabs",function(){removeState("focus",$(this).closest("li"))})}var hideFx,showFx;if(o.fx){if($.isArray(o.fx)){hideFx=o.fx[0];showFx=o.fx[1]}else{hideFx=showFx=o.fx}}function resetStyle($el,fx){$el.css("display","");if(!$.support.opacity&&fx.opacity){$el[0].style.removeAttribute("filter")}}var showTab=showFx?function(clicked,$show){$(clicked).closest("li").addClass("ui-tabs-selected ui-state-active");$show.hide().removeClass("ui-tabs-hide").animate(showFx,showFx.duration||"normal",function(){resetStyle($show,showFx);self._trigger("show",null,self._ui(clicked,$show[0]))})}:function(clicked,$show){$(clicked).closest("li").addClass("ui-tabs-selected ui-state-active");$show.removeClass("ui-tabs-hide");self._trigger("show",null,self._ui(clicked,$show[0]))};var hideTab=hideFx?function(clicked,$hide){$hide.animate(hideFx,hideFx.duration||"normal",function(){self.lis.removeClass("ui-tabs-selected ui-state-active");$hide.addClass("ui-tabs-hide");resetStyle($hide,hideFx);self.element.dequeue("tabs")})}:function(clicked,$hide,$show){self.lis.removeClass("ui-tabs-selected ui-state-active");$hide.addClass("ui-tabs-hide");self.element.dequeue("tabs")};this.anchors.bind(o.event+".tabs",function(){var el=this,$li=$(el).closest("li"),$hide=self.panels.filter(":not(.ui-tabs-hide)"),$show=self.element.find(self._sanitizeSelector(el.hash));if(($li.hasClass("ui-tabs-selected")&&!o.collapsible)||$li.hasClass("ui-state-disabled")||$li.hasClass("ui-state-processing")||self.panels.filter(":animated").length||self._trigger("select",null,self._ui(this,$show[0]))===false){this.blur();return false}o.selected=self.anchors.index(this);self.abort();if(o.collapsible){if($li.hasClass("ui-tabs-selected")){o.selected=-1;if(o.cookie){self._cookie(o.selected,o.cookie)}self.element.queue("tabs",function(){hideTab(el,$hide)}).dequeue("tabs");this.blur();return false}else{if(!$hide.length){if(o.cookie){self._cookie(o.selected,o.cookie)}self.element.queue("tabs",function(){showTab(el,$show)});self.load(self.anchors.index(this));this.blur();return false}}}if(o.cookie){self._cookie(o.selected,o.cookie)}if($show.length){if($hide.length){self.element.queue("tabs",function(){hideTab(el,$hide)})}self.element.queue("tabs",function(){showTab(el,$show)});self.load(self.anchors.index(this))}else{throw"jQuery UI Tabs: Mismatching fragment identifier."}if($.browser.msie){this.blur()}});this.anchors.bind("click.tabs",function(){return false})},_getIndex:function(index){if(typeof index=="string"){index=this.anchors.index(this.anchors.filter("[href$="+index+"]"))}return index},destroy:function(){var o=this.options;this.abort();this.element.unbind(".tabs").removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible").removeData("tabs");this.list.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all");this.anchors.each(function(){var href=$.data(this,"href.tabs");if(href){this.href=href}var $this=$(this).unbind(".tabs");$.each(["href","load","cache"],function(i,prefix){$this.removeData(prefix+".tabs")})});this.lis.unbind(".tabs").add(this.panels).each(function(){if($.data(this,"destroy.tabs")){$(this).remove()}else{$(this).removeClass(["ui-state-default","ui-corner-top","ui-tabs-selected","ui-state-active","ui-state-hover","ui-state-focus","ui-state-disabled","ui-tabs-panel","ui-widget-content","ui-corner-bottom","ui-tabs-hide"].join(" "))}});if(o.cookie){this._cookie(null,o.cookie)}return this},add:function(url,label,index){if(index===undefined){index=this.anchors.length}var self=this,o=this.options,$li=$(o.tabTemplate.replace(/#\{href\}/g,url).replace(/#\{label\}/g,label)),id=!url.indexOf("#")?url.replace("#",""):this._tabId($("a",$li)[0]);$li.addClass("ui-state-default ui-corner-top").data("destroy.tabs",true);var $panel=self.element.find("#"+id);if(!$panel.length){$panel=$(o.panelTemplate).attr("id",id).data("destroy.tabs",true)}$panel.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide");if(index>=this.lis.length){$li.appendTo(this.list);$panel.appendTo(this.list[0].parentNode)}else{$li.insertBefore(this.lis[index]);$panel.insertBefore(this.panels[index])}o.disabled=$.map(o.disabled,function(n,i){return n>=index?++n:n});this._tabify();if(this.anchors.length==1){o.selected=0;$li.addClass("ui-tabs-selected ui-state-active");$panel.removeClass("ui-tabs-hide");this.element.queue("tabs",function(){self._trigger("show",null,self._ui(self.anchors[0],self.panels[0]))});this.load(0)}this._trigger("add",null,this._ui(this.anchors[index],this.panels[index]));return this},remove:function(index){index=this._getIndex(index);var o=this.options,$li=this.lis.eq(index).remove(),$panel=this.panels.eq(index).remove();if($li.hasClass("ui-tabs-selected")&&this.anchors.length>1){this.select(index+(index+1<this.anchors.length?1:-1))}o.disabled=$.map($.grep(o.disabled,function(n,i){return n!=index}),function(n,i){return n>=index?--n:n});this._tabify();this._trigger("remove",null,this._ui($li.find("a")[0],$panel[0]));return this},enable:function(index){index=this._getIndex(index);var o=this.options;if($.inArray(index,o.disabled)==-1){return }this.lis.eq(index).removeClass("ui-state-disabled");o.disabled=$.grep(o.disabled,function(n,i){return n!=index});this._trigger("enable",null,this._ui(this.anchors[index],this.panels[index]));return this},disable:function(index){index=this._getIndex(index);var self=this,o=this.options;if(index!=o.selected){this.lis.eq(index).addClass("ui-state-disabled");o.disabled.push(index);o.disabled.sort();this._trigger("disable",null,this._ui(this.anchors[index],this.panels[index]))}return this},select:function(index){index=this._getIndex(index);if(index==-1){if(this.options.collapsible&&this.options.selected!=-1){index=this.options.selected}else{return this}}this.anchors.eq(index).trigger(this.options.event+".tabs");return this},load:function(index){index=this._getIndex(index);var self=this,o=this.options,a=this.anchors.eq(index)[0],url=$.data(a,"load.tabs");this.abort();if(!url||this.element.queue("tabs").length!==0&&$.data(a,"cache.tabs")){this.element.dequeue("tabs");return }this.lis.eq(index).addClass("ui-state-processing");if(o.spinner){var span=$("span",a);span.data("label.tabs",span.html()).html(o.spinner)}this.xhr=$.ajax($.extend({},o.ajaxOptions,{url:url,success:function(r,s){self.element.find(self._sanitizeSelector(a.hash)).html(r);self._cleanup();if(o.cache){$.data(a,"cache.tabs",true)}self._trigger("load",null,self._ui(self.anchors[index],self.panels[index]));try{o.ajaxOptions.success(r,s)}catch(e){}},error:function(xhr,s,e){self._cleanup();self._trigger("load",null,self._ui(self.anchors[index],self.panels[index]));try{o.ajaxOptions.error(xhr,s,index,a)}catch(e){}}}));self.element.dequeue("tabs");return this},abort:function(){this.element.queue([]);this.panels.stop(false,true);this.element.queue("tabs",this.element.queue("tabs").splice(-2,2));if(this.xhr){this.xhr.abort();delete this.xhr}this._cleanup();return this},url:function(index,url){this.anchors.eq(index).removeData("cache.tabs").data("load.tabs",url);return this},length:function(){return this.anchors.length}});$.extend($.ui.tabs,{version:"@VERSION"});$.extend($.ui.tabs.prototype,{rotation:null,rotate:function(ms,continuing){var self=this,o=this.options;var rotate=self._rotate||(self._rotate=function(e){clearTimeout(self.rotation);self.rotation=setTimeout(function(){var t=o.selected;self.select(++t<self.anchors.length?t:0)},ms);if(e){e.stopPropagation()}});var stop=self._unrotate||(self._unrotate=!continuing?function(e){if(e.clientX){self.rotate(null)}}:function(e){t=o.selected;rotate()});if(ms){this.element.bind("tabsshow",rotate);this.anchors.bind(o.event+".tabs",stop);rotate()}else{clearTimeout(self.rotation);this.element.unbind("tabsshow",rotate);this.anchors.unbind(o.event+".tabs",stop);delete this._rotate;delete this._unrotate}return this}})})(jQuery);/*
 * jQuery UI AriaTabs (12.07.10)
 * http://github.com/fnagel/jQuery-Accessible-RIA
 *
 * Copyright (c) 2009 Felix Nagel for Namics (Deustchland) GmbH
 * Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 *
 * Depends: ui.core.js 1.8
 *   		ui.tabs.js
 */
(function($){$.fn.extend($.ui.tabs.prototype,{_create:function(){var self=this,options=this.options;if($.address){var jqAddressDefOpt={enable:true,title:{enable:true,split:" | "}};if(!$.isEmptyObject(options.jqAddress)){$.extend(true,jqAddressDefOpt,options.jqAddress)}else{options.jqAddress={}}$.extend(true,options.jqAddress,jqAddressDefOpt)}if($.address&&options.jqAddress.enable){var anchorId="#"+$.address.value().replace("/","")}self._tabify(true);this.anchors.bind(options.event+".tabs-accessibility",function(){this.focus()});self.list.attr("role","tablist");for(var x=0;x<self.anchors.length;x++){if($.address&&options.jqAddress.enable&&anchorId!="#"&&$(self.anchors[x]).attr("href")==anchorId){self.select(x)}self._ariaInit(x)}self.list.keydown(function(event){switch(event.keyCode){case $.ui.keyCode.RIGHT:self.select(options.selected+1);return false;break;case $.ui.keyCode.DOWN:self.select(options.selected+1);break;case $.ui.keyCode.UP:self.select(options.selected-1);return false;break;case $.ui.keyCode.LEFT:self.select(options.selected-1);return false;break;case $.ui.keyCode.END:self.select(self.anchors.length-1);return false;break;case $.ui.keyCode.HOME:self.select(0);return false;break}});if($.address&&this.options.jqAddress.enable){$.address.externalChange(function(event){var anchorId="#"+event.value.replace("/","");var x=0;while(x<self.anchors.length){if($(self.anchors[x]).attr("href")==anchorId){self.select(x);return }x++}})}},_original_load:$.ui.tabs.prototype.load,load:function(index){if($.address&&this.options.jqAddress.enable){if($(this.anchors[0]).attr("aria-selected")!==undefined){if(this.options.forceFirst===0&&index!==0){if($.address.value()==""){$.address.history(false)}$.address.value($(this.anchors[0]).attr("href").replace(/^#/,""));$.address.history(true);this.options.forceFirst=false}if(this.options.jqAddress.title.enable){$.address.title($.address.title().split(this.options.jqAddress.title.split)[0]+this.options.jqAddress.title.split+$(this.anchors[index]).text())}$.address.value($(this.anchors[index]).attr("href").replace(/^#/,""))}else{this.options.forceFirst=index}}for(var x=0;x<this.anchors.length;x++){this._ariaSet(x,false);if($.data(this.anchors[x],"href.tabs")){$(this.panels[x]).removeAttr("aria-live").removeAttr("aria-busy")}}if($.data(this.anchors[index],"href.tabs")){$(this.panels[index]).attr("aria-live","polite").attr("aria-busy","true")}this._original_load(index);if($.data(this.anchors[index],"href.tabs")){$(this.panels[index]).attr("aria-busy","false")}this._ariaSet(index,true)},_ariaSet:function(index,state){var tabindex=(state)?0:-1;var anchor=$(this.anchors[index]);anchor.attr("tabindex",tabindex).attr("aria-selected",state);if(state){if(!$.browser.msie){anchor.focus()}}else{anchor.closest("li").removeClass("ui-state-focus")}$(this.panels[index]).attr("aria-hidden",!state).attr("aria-expanded",state);if($.browser.msie){this.options.timeout=window.setTimeout(function(){anchor.focus()},100)}if(state){this._updateVirtualBuffer()}},_ariaInit:function(index){var self=this;var panelId=$(this.panels[index]).attr("id");$(this.anchors[index]).attr("role","tab").attr("aria-controls",panelId).attr("id",panelId+"-tab").parent().attr("role","presentation");$(this.panels[index]).attr("role","tabpanel").attr("tabindex",0).attr("aria-labelledby",panelId+"-tab");if(this.options.collapsible){$(this.anchors[index]).bind(this.options.event,function(event){self._ariaSet(index,!$(self.panels[index]).hasClass("ui-tabs-hide"))})}},_original_add:$.ui.tabs.prototype.add,add:function(url,label,index){this._original_add(url,label,index);this.element.attr("aria-live","polite").attr("aria-relevant","additions");if(index){this._ariaInit(index);this._ariaSet(index,false)}else{this._ariaInit(this.anchors.length-1);this._ariaSet(this.anchors.length-1,false)}},_original_remove:$.ui.tabs.prototype.remove,remove:function(index){this._original_remove(index);this.element.attr("aria-live","polite").attr("aria-relevant","removals")},_original_destroy:$.ui.tabs.prototype.destroy,destroy:function(){var self=this,options=this.options;self.element.removeAttr("role").removeAttr("aria-live").removeAttr("aria-relevant");self.list.removeAttr("role");for(var x=0;x<self.anchors.length;x++){$(self.anchors[x]).removeAttr("aria-selected").removeAttr("aria-controls").removeAttr("role").removeAttr("id").removeAttr("tabindex").parent().removeAttr("role");$(self.panels[x]).removeAttr("aria-hidden").removeAttr("aria-expanded").removeAttr("aria-labelledby").removeAttr("aria-live").removeAttr("aria-busy").removeAttr("aria-relevant").removeAttr("role")}$("body>form #virtualBufferForm").parent().remove();this._original_destroy()},_updateVirtualBuffer:function(){var form=$("body>form #virtualBufferForm");if(form.length){if(form.val()=="1"){form.val("0")}else{form.val("1")}if(form.hasClass("ui-accessibility-odd")){form.addClass("ui-accessibility-even").removeClass("ui-accessibility-odd")}else{form.addClass("ui-accessibility-odd").removeClass("ui-accessibility-even")}}else{$("body").append('<form><input id="virtualBufferForm" type="hidden" value="1" /></form>')}}})})(jQuery);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.tabs",{gradeNames:["fluid.viewComponent","autoInit"],tabOptions:{},events:{tabsselect:"preventable",tabsload:null,tabsshow:null},finalInitFunction:"fluid.tabs.finalInit"});fluid.tabs.finalInit=function(that){that.container.tabs(that.options.tabOptions);fluid.each(that.options.events,function(value,eventName){that.container.bind(eventName,function(event,ui){return that.events[eventName].fire(that,event,ui)})})}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.registerNamespace("fluid.tableOfContents");fluid.tableOfContents.insertAnchor=function(name,element){var anchor=$("<a></a>",element.ownerDocument);anchor.prop({name:name,id:name});anchor.insertBefore(element)};fluid.tableOfContents.generateGUID=function(){return fluid.allocateSimpleId()};fluid.tableOfContents.filterHeadings=function(headings){return headings.filter(":visible")};fluid.tableOfContents.finalInit=function(that){var headings=that.filterHeadings(that.locate("headings"));that.headingTextToAnchor=function(heading){var guid=that.generateGUID();var anchorInfo={id:guid,url:"#"+guid};that.insertAnchor(anchorInfo.id,heading);return anchorInfo};that.anchorInfo=fluid.transform(headings,function(heading){return that.headingTextToAnchor(heading)});that.hide=function(){that.locate("tocContainer").hide()};that.show=function(){that.locate("tocContainer").show()};that.model=that.modelBuilder.assembleModel(headings,that.anchorInfo);that.events.onReady.fire()};fluid.defaults("fluid.tableOfContents",{gradeNames:["fluid.viewComponent","autoInit"],finalInitFunction:"fluid.tableOfContents.finalInit",components:{levels:{type:"fluid.tableOfContents.levels",container:"{tableOfContents}.dom.tocContainer",createOnEvent:"onReady",options:{model:{headings:"{tableOfContents}.model"},events:{afterRender:"{tableOfContents}.events.afterRender"}}},modelBuilder:{type:"fluid.tableOfContents.modelBuilder"}},invokers:{insertAnchor:"fluid.tableOfContents.insertAnchor",generateGUID:"fluid.tableOfContents.generateGUID",filterHeadings:"fluid.tableOfContents.filterHeadings"},selectors:{headings:":header",tocContainer:".flc-toc-tocContainer"},events:{onReady:null,afterRender:null}});fluid.registerNamespace("fluid.tableOfContents.modelBuilder");fluid.tableOfContents.modelBuilder.toModel=function(headingInfo,modelLevelFn){var headings=fluid.copy(headingInfo);var buildModelLevel=function(headings,level){var modelLevel=[];while(headings.length>0){var heading=headings[0];if(heading.level<level){break}if(heading.level>level){var subHeadings=buildModelLevel(headings,level+1);if(modelLevel.length>0){modelLevel[modelLevel.length-1].headings=subHeadings}else{modelLevel=modelLevelFn(modelLevel,subHeadings)}}if(heading.level===level){modelLevel.push(heading);headings.shift()}}return modelLevel};return buildModelLevel(headings,1)};fluid.tableOfContents.modelBuilder.gradualModelLevelFn=function(modelLevel,subHeadings){var subHeadingsClone=fluid.copy(subHeadings);subHeadingsClone[0].level--;return subHeadingsClone};fluid.tableOfContents.modelBuilder.skippedModelLevelFn=function(modelLevel,subHeadings){modelLevel.push({headings:subHeadings});return modelLevel};fluid.tableOfContents.modelBuilder.finalInit=function(that){that.convertToHeadingObjects=function(headings,anchorInfo){headings=$(headings);return fluid.transform(headings,function(heading,index){return{level:that.headingCalculator.getHeadingLevel(heading),text:$(heading).text(),url:anchorInfo[index].url}})};that.assembleModel=function(headings,anchorInfo){var headingInfo=that.convertToHeadingObjects(headings,anchorInfo);return that.toModel(headingInfo)}};fluid.defaults("fluid.tableOfContents.modelBuilder",{gradeNames:["fluid.littleComponent","autoInit"],finalInitFunction:"fluid.tableOfContents.modelBuilder.finalInit",components:{headingCalculator:{type:"fluid.tableOfContents.modelBuilder.headingCalculator"}},invokers:{toModel:{funcName:"fluid.tableOfContents.modelBuilder.toModel",args:["{arguments}.0","{modelBuilder}.modelLevelFn"]},modelLevelFn:"fluid.tableOfContents.modelBuilder.gradualModelLevelFn"}});fluid.registerNamespace("fluid.tableOfContents.modelBuilder.headingCalculator");fluid.tableOfContents.modelBuilder.headingCalculator.finalInit=function(that){that.getHeadingLevel=function(heading){return $.inArray(heading.tagName,that.options.levels)+1}};fluid.defaults("fluid.tableOfContents.modelBuilder.headingCalculator",{gradeNames:["fluid.littleComponent","autoInit"],finalInitFunction:"fluid.tableOfContents.modelBuilder.headingCalculator.finalInit",levels:["H1","H2","H3","H4","H5","H6"]});fluid.registerNamespace("fluid.tableOfContents.levels");fluid.tableOfContents.levels.finalInit=function(that){fluid.fetchResources(that.options.resources,function(){that.container.append(that.options.resources.template.resourceText);that.refreshView()})};fluid.tableOfContents.levels.objModel=function(type,ID){var objModel={ID:type+ID+":",children:[]};return objModel};fluid.tableOfContents.levels.handleEmptyItemObj=function(itemObj){itemObj.decorators=[{type:"addClass",classes:"fl-tableOfContents-hide-bullet"}]};fluid.tableOfContents.levels.generateTree=function(headingsModel,currentLevel){currentLevel=currentLevel||0;var levelObj=fluid.tableOfContents.levels.objModel("level",currentLevel);if(headingsModel.headings.length===0){return[]}if(currentLevel===0){var tree={children:[fluid.tableOfContents.levels.generateTree(headingsModel,currentLevel+1)]};return tree}$.each(headingsModel.headings,function(index,model){var itemObj=fluid.tableOfContents.levels.objModel("items",currentLevel);var linkObj={ID:"link"+currentLevel,target:model.url,linktext:model.text};if(!model.level){fluid.tableOfContents.levels.handleEmptyItemObj(itemObj)}else{itemObj.children.push(linkObj)}if(model.headings){itemObj.children.push(fluid.tableOfContents.levels.generateTree(model,currentLevel+1))}levelObj.children.push(itemObj)});return levelObj};fluid.tableOfContents.levels.produceTree=function(that){return fluid.tableOfContents.levels.generateTree(that.model)};fluid.defaults("fluid.tableOfContents.levels",{gradeNames:["fluid.rendererComponent","autoInit"],finalInitFunction:"fluid.tableOfContents.levels.finalInit",produceTree:"fluid.tableOfContents.levels.produceTree",selectors:{level1:".flc-toc-levels-level1",level2:".flc-toc-levels-level2",level3:".flc-toc-levels-level3",level4:".flc-toc-levels-level4",level5:".flc-toc-levels-level5",level6:".flc-toc-levels-level6",items1:".flc-toc-levels-items1",items2:".flc-toc-levels-items2",items3:".flc-toc-levels-items3",items4:".flc-toc-levels-items4",items5:".flc-toc-levels-items5",items6:".flc-toc-levels-items6",link1:".flc-toc-levels-link1",link2:".flc-toc-levels-link2",link3:".flc-toc-levels-link3",link4:".flc-toc-levels-link4",link5:".flc-toc-levels-link5",link6:".flc-toc-levels-link6"},repeatingSelectors:["level1","level2","level3","level4","level5","level6","items1","items2","items3","items4","items5","items6"],model:{headings:[]},resources:{template:{forceCache:true,url:"../html/TableOfContents.html"}},rendererFnOptions:{noexpand:true},rendererOptions:{debugMode:false}})})(jQuery,fluid_1_5);if(!this.JSON){JSON=function(){function f(n){return n<10?"0"+n:n}Date.prototype.toJSON=function(){return this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z"};var m={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};function stringify(value,whitelist){var a,i,k,l,r=/["\\\x00-\x1f\x7f-\x9f]/g,v;switch(typeof value){case"string":return r.test(value)?'"'+value.replace(r,function(a){var c=m[a];if(c){return c}c=a.charCodeAt();return"\\u00"+Math.floor(c/16).toString(16)+(c%16).toString(16)})+'"':'"'+value+'"';case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}if(typeof value.toJSON==="function"){return stringify(value.toJSON())}a=[];if(typeof value.length==="number"&&!(value.propertyIsEnumerable("length"))){l=value.length;for(i=0;i<l;i+=1){a.push(stringify(value[i],whitelist)||"null")}return"["+a.join(",")+"]"}if(whitelist){l=whitelist.length;for(i=0;i<l;i+=1){k=whitelist[i];if(typeof k==="string"){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+":"+v)}}}}else{for(k in value){if(typeof k==="string"){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+":"+v)}}}}return"{"+a.join(",")+"}"}}return{stringify:stringify,parse:function(text,filter){var j;function walk(k,v){var i,n;if(v&&typeof v==="object"){for(i in v){if(Object.prototype.hasOwnProperty.apply(v,[i])){n=walk(i,v[i]);if(n!==undefined){v[i]=n}}}}return filter(k,v)}if(/^[\],:{}\s]*$/.test(text.replace(/\\./g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(:?[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof filter==="function"?walk("",j):j}throw new SyntaxError("parseJSON")}}}()};var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.generate=function(n,generator){var togo=[];for(var i=0;i<n;++i){togo[i]=typeof (generator)==="function"?generator.call(null,i):generator}return togo};fluid.registerNamespace("fluid.url");fluid.url.generateDepth=function(depth){return fluid.generate(depth,"../").join("")};fluid.url.parsePathInfo=function(pathInfo){var togo={};var segs=pathInfo.split("/");if(segs.length>0){var top=segs.length-1;var dotpos=segs[top].indexOf(".");if(dotpos!==-1){togo.extension=segs[top].substring(dotpos+1);segs[top]=segs[top].substring(0,dotpos)}}togo.pathInfo=segs;return togo};fluid.url.parsePathInfoTrim=function(pathInfo){var togo=fluid.url.parsePathInfo(pathInfo);if(togo.pathInfo[togo.pathInfo.length-1]===""){togo.pathInfo.length--}return togo};fluid.url.collapseSegs=function(segs,from,to){var togo="";if(from===undefined){from=0}if(to===undefined){to=segs.length}for(var i=from;i<to-1;++i){togo+=segs[i]+"/"}if(to>from){togo+=segs[to-1]}return togo};fluid.url.makeRelPath=function(parsed,index){var togo=fluid.kettle.collapseSegs(parsed.pathInfo,index);if(parsed.extension){togo+="."+parsed.extension}return togo};fluid.url.cononocolosePath=function(pathInfo){var consume=0;for(var i=0;i<pathInfo.length;++i){if(pathInfo[i]===".."){++consume}else{if(consume!==0){pathInfo.splice(i-consume*2,consume*2);i-=consume*2;consume=0}}}return pathInfo};fluid.url.parseUri=function(str){var o=fluid.url.parseUri.options,m=o.parser[o.strictMode?"strict":"loose"].exec(str),uri={},i=14;while(i--){uri[o.key[i]]=m[i]||""}uri[o.q.name]={};uri[o.key[12]].replace(o.q.parser,function($0,$1,$2){if($1){uri[o.q.name][$1]=$2}});return uri};fluid.url.parseUri.options={strictMode:true,key:["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],q:{name:"queryKey",parser:/(?:^|&)([^&=]*)=?([^&]*)/g},parser:{strict:/^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,loose:/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/}};fluid.url.parseSegs=function(url){var parsed=fluid.url.parseUri(url);var parsedSegs=fluid.url.parsePathInfoTrim(parsed.directory);return parsedSegs.pathInfo};fluid.url.isAbsoluteUrl=function(url){var parseRel=fluid.url.parseUri(url);return(parseRel.host||parseRel.protocol||parseRel.directory.charAt(0)==="/")};fluid.url.computeRelativePrefix=function(outerLocation,iframeLocation,relPath){if(fluid.url.isAbsoluteUrl(relPath)){return relPath}var relSegs=fluid.url.parsePathInfo(relPath).pathInfo;var parsedOuter=fluid.url.parseSegs(outerLocation);var parsedRel=parsedOuter.concat(relSegs);fluid.url.cononocolosePath(parsedRel);var parsedInner=fluid.url.parseSegs(iframeLocation);var seg=0;for(;seg<parsedRel.length;++seg){if(parsedRel[seg]!=parsedInner[seg]){break}}var excess=parsedInner.length-seg;var back=fluid.url.generateDepth(excess);var front=fluid.url.collapseSegs(parsedRel,seg);return back+front}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.uiOptions.store",{gradeNames:["fluid.littleComponent","autoInit"],defaultSiteSettings:{textFont:"default",theme:"default",textSize:1,lineSpacing:1,layout:false,toc:false,links:false,inputsLarger:false}});fluid.defaults("fluid.cookieStore",{gradeNames:["fluid.uiOptions.store","autoInit"],invokers:{fetch:{funcName:"fluid.cookieStore.fetch",args:["{cookieStore}.options.cookie.name","{cookieStore}.options.defaultSiteSettings"]},save:{funcName:"fluid.cookieStore.save",args:["{arguments}.0","{cookieStore}.options.cookie"]}},cookie:{name:"fluid-ui-settings",path:"/",expires:""}});fluid.cookieStore.fetch=function(cookieName,defaults){var cookie=document.cookie;var cookiePrefix=cookieName+"=";var retObj,startIndex,endIndex;if(cookie.length>0){startIndex=cookie.indexOf(cookiePrefix);if(startIndex>-1){startIndex=startIndex+cookiePrefix.length;endIndex=cookie.indexOf(";",startIndex);if(endIndex<startIndex){endIndex=cookie.length}retObj=JSON.parse(decodeURIComponent(cookie.substring(startIndex,endIndex)))}}return $.extend(true,{},defaults,retObj)};fluid.cookieStore.assembleCookie=function(cookieOptions){var cookieStr=cookieOptions.name+"="+cookieOptions.data;if(cookieOptions.expires){cookieStr+="; expires="+cookieOptions.expires}if(cookieOptions.path){cookieStr+="; path="+cookieOptions.path}return cookieStr};fluid.cookieStore.save=function(settings,cookieOptions){cookieOptions.data=encodeURIComponent(JSON.stringify(settings));document.cookie=fluid.cookieStore.assembleCookie(cookieOptions)};fluid.defaults("fluid.tempStore",{gradeNames:["fluid.uiOptions.store","autoInit"],invokers:{fetch:{funcName:"fluid.tempStore.fetch",args:["{tempStore}"]},save:{funcName:"fluid.tempStore.save",args:["{arguments}.0","{tempStore}"]}},defaultSiteSettings:{},finalInitFunction:"fluid.tempStore.finalInit"});fluid.tempStore.finalInit=function(that){that.model=that.options.defaultSiteSettings};fluid.tempStore.fetch=function(that){return that.model};fluid.tempStore.save=function(settings,that){that.model=settings}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.registerNamespace("fluid.browser.version");fluid.browser.msie=function(){var isIE=($.browser.msie);return isIE?fluid.typeTag("fluid.browser.msie"):undefined};fluid.browser.majorVersion=function(){var version=$.browser.version;var dotpos=version.indexOf(".");var majorVersion=version.substring(0,dotpos);return fluid.typeTag("fluid.browser.majorVersion."+majorVersion)};var features={browserIE:fluid.browser.msie(),browserMajorVersion:fluid.browser.majorVersion()};fluid.merge(null,fluid.staticEnvironment,features);fluid.hasFeature=function(tagName){return fluid.find(fluid.staticEnvironment,function(value){return value&&value.typeName===tagName?true:undefined})};fluid.defaults("fluid.uiEnhancer",{gradeNames:["fluid.viewComponent","autoInit"],components:{textSize:{type:"fluid.uiEnhancer.textSizer",container:"{uiEnhancer}.container",options:{invokers:{calcInitSize:{funcName:"fluid.uiEnhancer.textSizer.calcInitSize",args:["{that}.container","{uiEnhancer}.options.fontSizeMap"]}}}},tableOfContents:{type:"fluid.tableOfContents",container:"{uiEnhancer}.container",createOnEvent:"onCreateTOCReady",options:{components:{levels:{type:"fluid.tableOfContents.levels",options:{resources:{template:{forceCache:true,url:"{uiEnhancer}.options.tocTemplate"}}}}},listeners:{afterRender:"{uiEnhancer}.lateRefreshRelay"}}},textFont:{type:"fluid.uiEnhancer.classSwapper",container:"{uiEnhancer}.container",options:{classes:"{uiEnhancer}.options.classnameMap.textFont"}},lineSpacing:{type:"fluid.uiEnhancer.lineSpacer",container:"{uiEnhancer}.container",options:{invokers:{calcInitSize:{funcName:"fluid.uiEnhancer.lineSpacer.calcInitSize",args:["{that}.container","{uiEnhancer}.options.fontSizeMap"]}}}},theme:{type:"fluid.uiEnhancer.classSwapper",container:"{uiEnhancer}.container",options:{classes:"{uiEnhancer}.options.classnameMap.theme"}},settingsStore:{type:"fluid.uiOptions.store",options:{defaultSiteSettings:"{uiEnhancer}.options.defaultSiteSettings"}}},invokers:{updateModel:{funcName:"fluid.uiEnhancer.updateModel",args:["@0","{uiEnhancer}.applier"]},updateFromSettingsStore:{funcName:"fluid.uiEnhancer.updateFromSettingsStore",args:["{uiEnhancer}"]},refreshView:{funcName:"fluid.uiEnhancer.refreshView",args:["{uiEnhancer}"]},styleElements:"fluid.uiEnhancer.styleElements",setLayout:"fluid.uiEnhancer.setLayout",styleLinks:"fluid.uiEnhancer.styleLinks",styleInputs:"fluid.uiEnhancer.styleInputs",setIE6ColorInversion:"fluid.uiEnhancer.setIE6ColorInversion"},events:{onCreateTOCReady:null,lateRefreshView:null,modelChanged:null},listeners:{"lateRefreshView.domReading":"fluid.uiEnhancer.applyDomReadingSettings"},classnameMap:{textFont:{"default":"",times:"fl-font-uio-times",comic:"fl-font-uio-comic-sans",arial:"fl-font-uio-arial",verdana:"fl-font-uio-verdana"},theme:{"default":"fl-uio-default-theme",bw:"fl-theme-uio-bw fl-theme-bw",wb:"fl-theme-uio-wb fl-theme-wb",by:"fl-theme-uio-by fl-theme-by",yb:"fl-theme-uio-yb fl-theme-yb"},layout:"fl-layout-linear",links:"fl-link-enhanced",inputsLarger:"fl-text-larger"},fontSizeMap:{"xx-small":"9px","x-small":"11px",small:"13px",medium:"15px",large:"18px","x-large":"23px","xx-large":"30px"},selectors:{colorInversion:".fl-inverted-color"},styles:{colorInversionClass:"fl-inverted-color"},finalInitFunction:"fluid.uiEnhancer.finalInit"});fluid.uiEnhancer.finalInit=function(that){that.applier.modelChanged.addListener("",function(newModel,oldModel,changeRequest){that.events.modelChanged.fire(newModel,oldModel,changeRequest);that.refreshView()});that.lateRefreshRelay=function(){that.events.lateRefreshView.fire(that)};that.updateFromSettingsStore();return that};fluid.uiEnhancer.updateFromSettingsStore=function(that){that.updateModel(that.settingsStore.fetch())};fluid.uiEnhancer.updateModel=function(newModel,applier){applier.requestChange("",newModel)};fluid.uiEnhancer.applyTocSetting=function(that){var async=false;if(that.model.toc){if(that.tableOfContents){that.tableOfContents.show()}else{that.events.onCreateTOCReady.fire();async=true}}else{if(that.tableOfContents){that.tableOfContents.hide()}}if(!async){that.lateRefreshRelay()}};fluid.uiEnhancer.applyDomReadingSettings=function(that){that.setLayout(that);that.styleLinks(that);that.styleInputs(that);that.setIE6ColorInversion(that)};fluid.uiEnhancer.refreshView=function(that){that.textSize.set(that.model.textSize);that.textFont.swap(that.model.textFont);that.lineSpacing.set(that.model.lineSpacing);that.theme.swap(that.model.theme);$(document).ready(function(){fluid.uiEnhancer.applyTocSetting(that)})};fluid.uiEnhancer.styleElements=function(elements,setting,classname){if(setting){elements.addClass(classname)}else{$("."+classname,elements).andSelf().removeClass(classname)}};fluid.uiEnhancer.setLayout=function(that){that.styleElements(that.container,that.model.layout,that.options.classnameMap.layout)};fluid.uiEnhancer.styleLinks=function(that){var links=$("a",that.container);that.styleElements(links,that.model.links,that.options.classnameMap.links)};fluid.uiEnhancer.styleInputs=function(that){that.styleElements($("input, button",that.container),that.model.inputsLarger,that.options.classnameMap.inputsLarger)};fluid.uiEnhancer.setIE6ColorInversion=function(that){if(fluid.hasFeature("fluid.browser.msie")&&fluid.hasFeature("fluid.browser.majorVersion.6")&&that.model.theme==="default"){that.locate("colorInversion").removeClass(that.options.styles.colorInversionClass)}};fluid.uiEnhancer.getTextSizeInPx=function(container,fontSizeMap){var fontSize=container.css("font-size");if(fontSizeMap[fontSize]){fontSize=fontSizeMap[fontSize]}return parseFloat(fontSize)};fluid.uiEnhancer.getTextSizeInEm=function(container,fontSizeMap){var px2emFactor=fluid.uiEnhancer.getPx2EmFactor(container,fontSizeMap);return Math.round(fluid.uiEnhancer.getTextSizeInPx(container,fontSizeMap)/px2emFactor*10000)/10000};fluid.uiEnhancer.getPx2EmFactor=function(container,fontSizeMap){if(container.get(0).tagName!=="HTML"){container=container.parent()}return fluid.uiEnhancer.getTextSizeInPx(container,fontSizeMap)};fluid.uiEnhancer.getLineHeight=function(container){var lineHeight;if(container[0].currentStyle){lineHeight=container[0].currentStyle.lineHeight}else{lineHeight=container.css("line-height")}return lineHeight};fluid.uiEnhancer.numerizeLineHeight=function(lineHeight,fontSize){if(!lineHeight){return 0}if(lineHeight==="normal"){return 1.2}if(lineHeight.match(/[0-9]$/)){return lineHeight}return Math.round(parseFloat(lineHeight)/fontSize*100)/100};fluid.defaults("fluid.uiEnhancer.textSizer",{gradeNames:["fluid.viewComponent","autoInit"],invokers:{set:{funcName:"fluid.uiEnhancer.textSizer.set",args:["@0","{textSizer}"]}}});fluid.uiEnhancer.textSizer.set=function(times,that){if(!that.initialSize){that.initialSize=that.calcInitSize()}if(that.initialSize){var targetSize=times*that.initialSize;that.container.css("font-size",targetSize+"em")}};fluid.uiEnhancer.textSizer.calcInitSize=function(container,fontSizeMap){return fluid.uiEnhancer.getTextSizeInEm(container,fontSizeMap)};fluid.defaults("fluid.uiEnhancer.classSwapper",{gradeNames:["fluid.viewComponent","autoInit"],invokers:{clearClasses:{funcName:"fluid.uiEnhancer.classSwapper.clearClasses",args:["{classSwapper}"]},swap:{funcName:"fluid.uiEnhancer.classSwapper.swap",args:["@0","{classSwapper}"]}},classes:{},finalInitFunction:"fluid.uiEnhancer.classSwapper.finalInit"});fluid.uiEnhancer.classSwapper.finalInit=function(that){that.classSelector="";that.classStr="";fluid.each(that.options.classes,function(className){if(className){that.classSelector+=that.classSelector?", ."+className:"."+className;that.classStr+=that.classStr?" "+className:className}})};fluid.uiEnhancer.classSwapper.clearClasses=function(that){that.container.removeClass(that.classStr)};fluid.uiEnhancer.classSwapper.swap=function(classname,that){that.clearClasses(that);that.container.addClass(that.options.classes[classname])};fluid.defaults("fluid.uiEnhancer.lineSpacer",{gradeNames:["fluid.viewComponent","autoInit"],invokers:{set:{funcName:"fluid.uiEnhancer.lineSpacer.set",args:["@0","{lineSpacer}"]}}});fluid.uiEnhancer.lineSpacer.set=function(times,that){if(!that.initialSize){that.initialSize=that.calcInitSize()}if(that.initialSize){var targetLineSpacing=times*that.initialSize;that.container.css("line-height",targetLineSpacing)}};fluid.uiEnhancer.lineSpacer.calcInitSize=function(container,fontSizeMap){var lineHeight=fluid.uiEnhancer.getLineHeight(container);var fontSize=fluid.uiEnhancer.getTextSizeInPx(container,fontSizeMap);return fluid.uiEnhancer.numerizeLineHeight(lineHeight,fontSize)};fluid.pageEnhancer=function(uiEnhancerOptions){var that=fluid.initLittleComponent("fluid.pageEnhancer");uiEnhancerOptions=fluid.copy(uiEnhancerOptions);uiEnhancerOptions.originalUserOptions=fluid.copy(uiEnhancerOptions);that.uiEnhancerOptions=uiEnhancerOptions;fluid.initDependents(that);fluid.staticEnvironment.uiEnhancer=that.uiEnhancer;return that};fluid.defaults("fluid.pageEnhancer",{gradeNames:["fluid.littleComponent"],components:{uiEnhancer:{type:"fluid.uiEnhancer",container:"body",options:"{pageEnhancer}.uiEnhancerOptions"}}});fluid.demands("fluid.uiOptions.store",["fluid.uiEnhancer"],{funcName:"fluid.cookieStore"})})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.textfieldSlider",{gradeNames:["fluid.viewComponent","autoInit"],components:{textfield:{type:"fluid.textfieldSlider.textfield",container:"{textfieldSlider}.dom.textfield",options:{model:"{textfieldSlider}.model",applier:"{textfieldSlider}.applier"}},slider:{type:"fluid.textfieldSlider.slider",container:"{textfieldSlider}.dom.slider",options:{model:"{textfieldSlider}.model",applier:"{textfieldSlider}.applier",sliderOptions:"{textfieldSlider}.options.sliderOptions"}}},selectors:{textfield:".flc-textfieldSlider-field",slider:".flc-textfieldSlider-slider"},events:{modelChanged:null},model:{value:null,min:0,max:100},sliderOptions:{orientation:"horizontal",step:1},finalInitFunction:"fluid.textfieldSlider.finalInit"});fluid.textfieldSlider.finalInit=function(that){that.refreshView=function(){var val=that.model.value;that.textfield.container.val(val)};that.applier.modelChanged.addListener("value",function(newModel){that.events.modelChanged.fire(newModel.value)});that.events.modelChanged.addListener(that.refreshView);that.refreshView()};fluid.defaults("fluid.textfieldSlider.textfield",{gradeNames:["fluid.viewComponent","autoInit"],finalInitFunction:"fluid.textfieldSlider.textfield.finalInit"});fluid.textfieldSlider.validateValue=function(model,changeRequest,applier){var oldValue=model.value;var newValue=changeRequest.value;var isValidNum=!isNaN(parseInt(newValue,10));if(isValidNum){if(newValue<model.min){newValue=model.min}else{if(newValue>model.max){newValue=model.max}}changeRequest.value=newValue}else{changeRequest.value=oldValue}};fluid.textfieldSlider.textfield.finalInit=function(that){that.applier.guards.addListener({path:"value",transactional:true},fluid.textfieldSlider.validateValue);that.container.change(function(source){that.applier.requestChange("value",source.target.value)})};fluid.defaults("fluid.textfieldSlider.slider",{gradeNames:["fluid.viewComponent","autoInit"],finalInitFunction:"fluid.textfieldSlider.slider.finalInit",selectors:{thumb:".ui-slider-handle"},events:{modelChanged:null}});var initSliderAria=function(thumb,opts){var ariaDefaults={role:"slider","aria-valuenow":opts.value,"aria-valuemin":opts.min,"aria-valuemax":opts.max};thumb.attr(ariaDefaults)};fluid.textfieldSlider.slider.finalInit=function(that){var sliderOptions=$.extend(true,{},that.options.sliderOptions,that.model);that.slider=that.container.slider(sliderOptions);initSliderAria(that.locate("thumb"),sliderOptions);that.setSliderValue=function(value){that.slider.slider("value",value)};that.setSliderAria=function(value){that.locate("thumb").attr("aria-valuenow",value)};that.slider.bind("slide",function(e,ui){that.applier.requestChange("value",ui.value)});that.applier.modelChanged.addListener("value",function(newModel){that.setSliderValue(newModel.value);that.setSliderAria(newModel.value);that.events.modelChanged.fire(newModel.value)})}})(jQuery,fluid_1_5);(function($,fluid){fluid.registerNamespace("fluid.uiOptions.inline");fluid.defaults("fluid.uiOptions.inline",{gradeNames:["fluid.viewComponent"],mergePolicy:{uiOptionsTransform:"noexpand",derivedDefaults:"noexpand"},components:{uiOptionsLoader:{type:"fluid.uiOptions.loader"},templateLoader:{priority:"first",type:"fluid.uiOptions.templateLoader"}},uiOptionsTransform:{transformer:"fluid.uiOptions.mapOptions",config:{"*.templateLoader":"templateLoader","*.templateLoader.*.templatePath.options.value":"prefix","*.uiOptionsLoader":"uiOptionsLoader","*.uiOptionsLoader.container":"container","*.uiOptionsLoader.*.uiOptions":"uiOptions","*.uiOptionsLoader.*.uiOptions.*.textControls":"textControls","*.uiOptionsLoader.*.uiOptions.*.layoutControls":"layoutControls","*.uiOptionsLoader.*.uiOptions.*.linksControls":"linksControls","*.uiOptionsLoader.*.uiOptions.*.preview":"preview","*.uiOptionsLoader.*.uiOptions.*.preview.*.enhancer":"previewEnhancer"}},derivedDefaults:{uiOptions:{options:{components:{settingsStore:"{uiEnhancer}.settingsStore"},listeners:{onUIOptionsRefresh:"{uiEnhancer}.updateFromSettingsStore"}}}}});fluid.uiOptions.inline.makeCreator=function(componentName,processor){var creator=function(container,options){var defaults=fluid.defaults(componentName);options.container=container;options=processor(options);var mappedOptions=fluid.uiOptions.mapOptions(options,defaults.uiOptionsTransform.config,defaults.mergePolicy,fluid.copy(defaults.derivedDefaults));var that=fluid.initView(componentName,container,mappedOptions);fluid.diagnoseFailedView(componentName,that,fluid.defaults(componentName),[componentName,container,mappedOptions]);fluid.initDependents(that);return that};var existing=fluid.getGlobalValue(componentName);if(existing){$.extend(creator,existing)}fluid.setGlobalValue(componentName,creator)};fluid.uiOptions.sortByKeyLength=function(inObject){var keys=fluid.keys(inObject);return keys.sort(fluid.compareStringLength(true))};fluid.uiOptions.mapOptionsRecord=function(options,sortedConfigKeys,config){var opRecs=[{},{},options||{}];var appliers=fluid.transform(opRecs,function(opRec){return fluid.makeChangeApplier(opRec)});var toDelete=[];fluid.each(sortedConfigKeys,function(origDest){var source=config[origDest];var dest=fluid.uiOptions.expandShortPath(origDest);var applier=appliers[origDest.charAt(0)==="!"?0:1];var value=fluid.get(options,source);if(value){applier.requestChange(dest,value,"ADD");toDelete.push({source:source,value:value})}});fluid.each(toDelete,function(elem){appliers[2].requestChange(elem.source,elem.value,"DELETE")});return opRecs};fluid.uiOptions.mapOptions=function(options,config,mergePolicy,derivedDefaults){var sortedConfigKeys=fluid.uiOptions.sortByKeyLength(config);var optrecs=fluid.uiOptions.mapOptionsRecord(options,sortedConfigKeys,config);var devrecs=fluid.uiOptions.mapOptionsRecord(derivedDefaults,sortedConfigKeys,config);var mergeOpts=[mergePolicy].concat(devrecs).concat(optrecs);return fluid.merge.apply(null,mergeOpts)};fluid.uiOptions.expandShortPath=function(path){if(path.charAt(0)==="!"){path=path.substring(1)}var strToreplaceFirst="components";var strToreplaceRest="options.components";var newPath=(path.charAt(0)==="*")?path.replace("*",strToreplaceFirst):path;newPath=newPath.replace(/\*/g,strToreplaceRest);return newPath};fluid.defaults("fluid.uiOptions.templateLoader",{gradeNames:["fluid.eventedComponent","autoInit"],finalInitFunction:"fluid.uiOptions.templateLoader.resolveTemplates",templates:{uiOptions:"%prefix/FatPanelUIOptions.html",textControls:"%prefix/UIOptionsTemplate-text.html",layoutControls:"%prefix/UIOptionsTemplate-layout.html",linksControls:"%prefix/UIOptionsTemplate-links.html"},components:{templatePath:{type:"fluid.uiOptions.templatePath"}},invokers:{transformURL:{funcName:"fluid.stringTemplate",args:["{arguments}.0",{"prefix/":"{templateLoader}.templatePath.options.value"}]}}});fluid.uiOptions.templateLoader.resolveTemplates=function(that){var mapped=fluid.transform(that.options.templates,that.transformURL);that.resources=fluid.transform(mapped,function(url){return{url:url,forceCache:true}})};fluid.defaults("fluid.uiOptions.templatePath",{gradeNames:["fluid.littleComponent","autoInit"],value:"../html/"});fluid.defaults("fluid.uiOptions.loader",{gradeNames:["fluid.viewComponent","autoInit"],resources:"{templateLoader}.resources",finalInitFunction:"fluid.uiOptions.loader.finalInit",events:{onUIOptionsTemplateReady:null,onUIOptionsComponentReady:null,onReady:null},listeners:{onUIOptionsComponentReady:{listener:"{loader}.events.onReady",args:["{fluid.uiOptions.loader}","{arguments}.0"],priority:"last"}},components:{uiOptions:{type:"fluid.uiOptions",container:"{loader}.container",createOnEvent:"onUIOptionsTemplateReady",options:{events:{onUIOptionsComponentReady:"{loader}.events.onUIOptionsComponentReady"}}}}});fluid.uiOptions.loader.finalInit=function(that){fluid.fetchResources(that.options.resources,that.events.onUIOptionsTemplateReady.fire)};fluid.uiOptions.lateRefreshViewBinder=function(that){that.refreshView=function(){that.renderer.refreshView()}};fluid.uiOptions.defaultModelMerger=function(target,source){$.extend(true,target,source)};fluid.defaults("fluid.uiOptions.ant",{gradeNames:["fluid.rendererComponent"],model:"{uiOptions}.model",applier:"{uiOptions}.applier",events:{onUIOptionsRefresh:"{uiOptions}.events.onUIOptionsRefresh"},listeners:{onUIOptionsRefresh:"{that}.refreshView","{uiOptions}.events.contributeDefaultModel":{listener:"fluid.uiOptions.defaultModelMerger",args:["{arguments}.0","{that}.options.defaultModel"]}},preInitFunction:"fluid.uiOptions.lateRefreshViewBinder",finalInitFunction:"fluid.uiOptions.controlsFinalInit"});fluid.defaults("fluid.uiOptions",{gradeNames:["fluid.viewComponent","autoInit"],components:{textControls:{type:"fluid.uiOptions.textControls",container:"{uiOptions}.dom.textControls",createOnEvent:"onUIOptionsMarkupReady",options:{classnameMap:"{uiEnhancer}.options.classnameMap"}},layoutControls:{type:"fluid.uiOptions.layoutControls",container:"{uiOptions}.dom.layoutControls",createOnEvent:"onUIOptionsMarkupReady",options:{classnameMap:"{uiEnhancer}.options.classnameMap"}},linksControls:{type:"fluid.uiOptions.linksControls",container:"{uiOptions}.dom.linksControls",createOnEvent:"onUIOptionsMarkupReady",options:{classnameMap:"{uiEnhancer}.options.classnameMap"}},preview:{type:"fluid.uiOptions.preview",createOnEvent:"onUIOptionsComponentReady",container:"{uiOptions}.dom.previewFrame"},eventBinder:{type:"fluid.uiOptions.eventBinder"}},selectors:{textControls:".flc-uiOptions-text-controls",layoutControls:".flc-uiOptions-layout-controls",linksControls:".flc-uiOptions-links-controls",cancel:".flc-uiOptions-cancel",reset:".flc-uiOptions-reset",save:".flc-uiOptions-save",previewFrame:".flc-uiOptions-preview-frame"},events:{onSave:null,onCancel:null,onReset:null,onAutoSave:null,modelChanged:null,onUIOptionsRefresh:null,onUIOptionsMarkupReady:null,onUIOptionsComponentReady:null,contributeDefaultModel:null},listeners:{onAutoSave:"{that}.save"},preInitFunction:"fluid.uiOptions.preInit",finalInitFunction:"fluid.uiOptions.finalInit",resources:{template:"{templateLoader}.resources.uiOptions"},autoSave:false});fluid.uiOptions.finishInit=function(that){var bindHandlers=function(that){var saveButton=that.locate("save");if(saveButton.length>0){saveButton.click(that.saveAndApply);var form=fluid.findForm(saveButton);$(form).submit(function(){that.saveAndApply()})}that.locate("reset").click(that.reset);that.locate("cancel").click(that.cancel)};that.container.append(that.options.resources.template.resourceText);bindHandlers(that);that.events.onUIOptionsMarkupReady.fire(that);that.defaultModel={};that.events.contributeDefaultModel.fire(that.defaultModel);that.fetch();that.events.onUIOptionsComponentReady.fire(that)};fluid.uiOptions.preInit=function(that){that.fetch=function(){var initialModel=that.settingsStore.fetch();initialModel=$.extend(true,{},that.defaultModel,initialModel);that.updateModel(initialModel);that.events.onUIOptionsRefresh.fire()};that.save=function(){that.events.onSave.fire(that.model.selections);var savedSelections=fluid.copy(that.model.selections);that.settingsStore.save(savedSelections)};that.saveAndApply=function(){that.save();that.events.onUIOptionsRefresh.fire()};that.reset=function(){that.updateModel(fluid.copy(that.defaultModel));that.events.onReset.fire(that);that.events.onUIOptionsRefresh.fire()};that.cancel=function(){that.events.onCancel.fire();that.fetch()};that.updateModel=function(newModel){that.applier.requestChange("selections",newModel)};that.applier.modelChanged.addListener("selections",function(newModel,oldModel,changeRequest){that.events.modelChanged.fire(newModel,oldModel,changeRequest.source);if(that.options.autoSave){that.events.onAutoSave.fire()}})};fluid.uiOptions.finalInit=function(that){fluid.fetchResources(that.options.resources,function(){setTimeout(function(){fluid.uiOptions.finishInit(that)},1)})};fluid.defaults("fluid.uiOptions.eventBinder",{gradeNames:["fluid.eventedComponent","autoInit"]});var optionsToLabelMap=function(that){fluid.each(that.options.controlValues,function(item,key){that.applier.requestChange("labelMap."+key,{values:that.options.controlValues[key],names:that.options.strings[key],classes:fluid.get(that,"options.classnameMap."+key)})})};fluid.uiOptions.createSliderNode=function(that,item,type,options){return{decorators:{type:"fluid",func:type,options:{listeners:{modelChanged:function(value){that.applier.requestChange("selections."+item,value)}},model:{min:that.options[item].min,max:that.options[item].max,value:that.model.selections[item]},sliderOptions:that.options[item].sliderOptions}}}};fluid.uiOptions.controlsFinalInit=function(that){optionsToLabelMap(that)};fluid.demands("fluid.uiOptions.selectDecorator","fluid.uiOptions",{container:"{arguments}.0"});fluid.defaults("fluid.uiOptions.selectDecorator",{gradeNames:["fluid.viewComponent","autoInit"],finalInitFunction:"fluid.uiOptions.selectDecorator.finalInit",styles:{preview:"fl-preview-theme"}});fluid.uiOptions.selectDecorator.finalInit=function(that){fluid.each($("option",that.container),function(option){var styles=that.options.styles;$(option).addClass(styles.preview+" "+styles[fluid.value(option)])})};fluid.defaults("fluid.uiOptions.textControls",{gradeNames:["fluid.uiOptions.ant","autoInit"],defaultModel:{textFont:"default",theme:"default",textSize:1,lineSpacing:1},strings:{textFont:["Default","Times New Roman","Comic Sans","Arial","Verdana"],theme:["Default","Negro sobre blanco","Blanco sobre negro","Negro sobre amarillo","Amarillo sobre negro"]},controlValues:{textFont:["default","times","comic","arial","verdana"],theme:["default","bw","wb","by","yb"]},textSize:{min:1,max:2,sliderOptions:{orientation:"horizontal",step:0.1}},lineSpacing:{min:1,max:2,sliderOptions:{orientation:"horizontal",step:0.1}},selectors:{textFont:".flc-uiOptions-text-font",theme:".flc-uiOptions-theme",textSize:".flc-uiOptions-min-text-size",lineSpacing:".flc-uiOptions-line-spacing"},produceTree:"fluid.uiOptions.textControls.produceTree",resources:{template:"{templateLoader}.resources.textControls"}});fluid.uiOptions.textControls.produceTree=function(that){var tree={};for(var item in that.model.selections){if(item==="textFont"||item==="theme"){tree[item]={optionnames:"${labelMap."+item+".names}",optionlist:"${labelMap."+item+".values}",selection:"${selections."+item+"}",decorators:{type:"fluid",func:"fluid.uiOptions.selectDecorator",options:{styles:that.options.classnameMap[item]}}}}else{if(item==="textSize"||item==="lineSpacing"){tree[item]=fluid.uiOptions.createSliderNode(that,item,"fluid.textfieldSlider")}}}return tree};fluid.defaults("fluid.uiOptions.layoutControls",{gradeNames:["fluid.uiOptions.ant","autoInit"],defaultModel:{layout:false,toc:false},selectors:{layout:".flc-uiOptions-layout",toc:".flc-uiOptions-toc"},protoTree:{toc:"${selections.toc}",layout:"${selections.layout}"},resources:{template:"{templateLoader}.resources.layoutControls"}});fluid.defaults("fluid.uiOptions.linksControls",{gradeNames:["fluid.uiOptions.ant","autoInit"],defaultModel:{links:false,inputsLarger:false},selectors:{links:".flc-uiOptions-links",inputsLarger:".flc-uiOptions-inputs-larger"},protoTree:{links:"${selections.links}",inputsLarger:"${selections.inputsLarger}"},resources:{template:"{templateLoader}.resources.linksControls"}});fluid.defaults("fluid.uiOptions.preview",{gradeNames:["fluid.viewComponent","autoInit"],components:{enhancer:{type:"fluid.uiEnhancer",createOnEvent:"onReady",options:{settingsStore:{type:"fluid.uiEnhancer.tempStore"}}},eventBinder:{type:"fluid.uiOptions.preview.eventBinder",createOnEvent:"onReady"},templateLoader:"{templateLoader}"},invokers:{updateModel:{funcName:"fluid.uiOptions.preview.updateModel",args:["{preview}","{uiOptions}.model.selections"]}},finalInitFunction:"fluid.uiOptions.preview.finalInit",events:{onReady:null},templateUrl:"%prefix/UIOptionsPreview.html"});fluid.uiOptions.preview.updateModel=function(that,selections){setTimeout(function(){if(that.enhancer){that.enhancer.updateModel(selections)}},0)};fluid.uiOptions.preview.finalInit=function(that){var templateUrl=that.templateLoader.transformURL(that.options.templateUrl);that.container.load(function(){that.enhancerContainer=$("body",that.container.contents());that.events.onReady.fire()});that.container.attr("src",templateUrl)};fluid.demands("fluid.uiEnhancer","fluid.uiOptions.preview",{funcName:"fluid.uiEnhancer",args:["{preview}.enhancerContainer","{options}"]});fluid.defaults("fluid.uiOptions.preview.eventBinder",{gradeNames:["fluid.eventedComponent","autoInit"]});fluid.demands("fluid.uiOptions.preview.eventBinder",["fluid.uiOptions.preview","fluid.uiOptions"],{options:{listeners:{"{uiOptions}.events.modelChanged":"{preview}.updateModel"}}})})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.registerNamespace("fluid.dom");fluid.dom.getDocumentHeight=function(dokkument){var body=$("body",dokkument)[0];return body.offsetHeight};fluid.registerNamespace("fluid.uiOptions.fatPanel");fluid.defaults("fluid.uiOptions.fatPanel",{gradeNames:["fluid.uiOptions.inline"],events:{afterRender:null,onReady:null},listeners:{onReady:{listener:"fluid.uiOptions.fatPanel.bindEvents",args:["{arguments}.0.uiOptions","{uiEnhancer}","{iframeRenderer}.iframeEnhancer","{fatPanel}"]}},selectors:{iframe:".flc-uiOptions-iframe"},components:{pageEnhancer:"{uiEnhancer}",slidingPanel:{type:"fluid.slidingPanel",container:"{fatPanel}.container",options:{invokers:{operateShow:{funcName:"fluid.uiOptions.fatPanel.showPanel"},operateHide:{funcName:"fluid.uiOptions.fatPanel.hidePanel"}}},createOnEvent:"afterRender"},iframeRenderer:{type:"fluid.uiOptions.fatPanel.renderIframe",container:"{fatPanel}.dom.iframe",options:{markupProps:{src:"%prefix/FatPanelUIOptionsFrame.html"},events:{afterRender:"{fatPanel}.events.afterRender"},components:{iframeEnhancer:{type:"fluid.uiEnhancer",container:"{iframeRenderer}.renderUIOContainer",createOnEvent:"afterRender",options:{components:{settingsStore:"{pageEnhancer}.settingsStore"},jQuery:"{iframeRenderer}.jQuery",tocTemplate:"{pageEnhancer}.options.tocTemplate"}}}}}},derivedDefaults:{uiOptionsLoader:{options:{events:{templatesAndIframeReady:{events:{iframeReady:"{fatPanel}.events.afterRender",templateReady:"onUIOptionsTemplateReady"}},onReady:"{fatPanel}.events.onReady"}}},uiOptions:{createOnEvent:"templatesAndIframeReady",container:"{iframeRenderer}.renderUIOContainer",options:{model:"{fatPanel}.model",applier:"{fatPanel}.applier",events:{onSignificantDOMChange:null},components:{iframeRenderer:"{fatPanel}.iframeRenderer",settingsStore:"{uiEnhancer}.settingsStore",preview:{type:"fluid.emptySubcomponent"},tabs:{type:"fluid.tabs",container:"{uiOptions}.container",createOnEvent:"onUIOptionsComponentReady",options:{listeners:{tabsshow:{listener:"{uiOptions}.events.onSignificantDOMChange"}}}}}}}},uiOptionsTransform:{config:{"!*.iframeRenderer.*.iframeEnhancer.options":"outerEnhancerOptions","*.slidingPanel":"slidingPanel","*.iframeRenderer":"iframeRenderer","*.iframeRenderer.options.prefix":"prefix","selectors.iframe":"iframe"}}});fluid.uiOptions.fatPanel.optionsProcessor=function(options){var enhancerOptions=fluid.get(fluid,"staticEnvironment.uiEnhancer.options.originalUserOptions");options.outerEnhancerOptions=enhancerOptions;options.nickName="fatPanel";return options};fluid.uiOptions.inline.makeCreator("fluid.uiOptions.fatPanel",fluid.uiOptions.fatPanel.optionsProcessor);fluid.defaults("fluid.uiOptions.fatPanel.renderIframe",{gradeNames:["fluid.viewComponent","autoInit"],finalInitFunction:"fluid.uiOptions.fatPanel.renderIframe.finalInit",events:{afterRender:null},styles:{containerFlex:"fl-container-flex",container:"fl-uiOptions-fatPanel-iframe"},prefix:"./",markupProps:{style:"overflow-x:hidden; overflow-y:auto;","class":"flc-iframe",src:"%prefix/uiOptionsIframe.html"}});fluid.uiOptions.fatPanel.renderIframe.finalInit=function(that){var styles=that.options.styles;that.options.markupProps.src=fluid.stringTemplate(that.options.markupProps.src,{"prefix/":that.options.prefix});that.iframeSrc=that.options.markupProps.src;that.iframe=$("<iframe/>");that.iframe.load(function(){var iframeWindow=that.iframe[0].contentWindow;that.iframeDocument=iframeWindow.document;that.jQuery=iframeWindow.jQuery;that.renderUIOContainer=that.jQuery("body",that.iframeDocument);that.jQuery(that.iframeDocument).ready(that.events.afterRender.fire)});that.iframe.attr(that.options.markupProps);that.iframe.addClass(styles.containerFlex);that.iframe.addClass(styles.container);that.iframe.hide();that.iframe.appendTo(that.container)};fluid.uiOptions.fatPanel.updateView=function(uiOptions,uiEnhancer){uiEnhancer.updateFromSettingsStore();uiOptions.events.onSignificantDOMChange.fire()};fluid.uiOptions.fatPanel.bindEvents=function(uiOptions,uiEnhancer,iframeEnhancer,fatPanel){fatPanel.slidingPanel.events.afterPanelShow.addListener(function(){fluid.uiOptions.fatPanel.updateView(uiOptions,iframeEnhancer)});uiOptions.events.modelChanged.addListener(function(model){uiEnhancer.updateModel(model.selections);uiOptions.save()});uiOptions.events.onReset.addListener(function(uiOptions){fluid.uiOptions.fatPanel.updateView(uiOptions,iframeEnhancer)});uiOptions.events.onSignificantDOMChange.addListener(function(){var dokkument=uiOptions.container[0].ownerDocument;var height=fluid.dom.getDocumentHeight(dokkument);var iframe=fatPanel.iframeRenderer.iframe;var attrs={height:height+15};var panel=fatPanel.slidingPanel.locate("panel");panel.css({height:""});iframe.animate(attrs,400)});fatPanel.slidingPanel.events.afterPanelHide.addListener(function(){fatPanel.iframeRenderer.iframe.height(0);fatPanel.iframeRenderer.iframe.hide()});fatPanel.slidingPanel.events.onPanelShow.addListener(function(){fatPanel.iframeRenderer.iframe.show()})};fluid.uiOptions.fatPanel.hidePanel=function(panel,callback){$(panel).animate({height:0},{duration:400,complete:callback})};fluid.uiOptions.fatPanel.showPanel=function(panel,callback){setTimeout(callback,1)}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.uiOptions.fullNoPreview",{gradeNames:["fluid.uiOptions.inline"],container:"{fullNoPreview}.container",derivedDefaults:{templateLoader:{options:{templates:{uiOptions:"%prefix/FullNoPreviewUIOptions.html"}}},uiOptions:{options:{components:{preview:{type:"fluid.emptySubcomponent"}},listeners:{onReset:function(uiOptions){uiOptions.save()}}}}}});fluid.uiOptions.inline.makeCreator("fluid.uiOptions.fullNoPreview",fluid.identity)})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.uiOptions.fullPreview",{gradeNames:["fluid.uiOptions.inline"],container:"{fullPreview}.container",uiOptionsTransform:{config:{"!*.uiOptionsLoader.*.uiOptions.*.preview.*.enhancer.options":"outerPreviewEnhancerOptions"}},derivedDefaults:{templateLoader:{options:{templates:{uiOptions:"%prefix/FullPreviewUIOptions.html"}}}}});fluid.uiOptions.inline.makeCreator("fluid.uiOptions.fullPreview",function(options){var enhancerOptions=fluid.get(fluid,"staticEnvironment.uiEnhancer.options.originalUserOptions");options.outerPreviewEnhancerOptions=enhancerOptions;return options})})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){fluid.defaults("fluid.slidingPanel",{gradeNames:["fluid.viewComponent","autoInit"],selectors:{panel:".flc-slidingPanel-panel",toggleButton:".flc-slidingPanel-toggleButton"},strings:{showText:"+ Mostrar preferencias de pantalla",hideText:"- Esconder"},events:{onPanelHide:null,onPanelShow:null,afterPanelHide:null,afterPanelShow:null},finalInitFunction:"fluid.slidingPanel.finalInit",invokers:{operateHide:"fluid.slidingPanel.slideUp",operateShow:"fluid.slidingPanel.slideDown"},model:{isShowing:false},methods:{showPanel:{finalState:true,name:"Show"},hidePanel:{finalState:false,name:"Hide"}}});fluid.slidingPanel.slideUp=function(element,callback,duration){$(element).slideUp(duration||"400",callback)};fluid.slidingPanel.slideDown=function(element,callback,duration){$(element).slideDown(duration||"400",callback)};fluid.slidingPanel.finalInit=function(that){fluid.each(that.options.methods,function(method,methodName){that[methodName]=function(){that.events["onPanel"+method.name].fire(that);that.applier.requestChange("isShowing",method.finalState);that.refreshView();that["operate"+method.name](that.locate("panel"),that.events["afterPanel"+method.name].fire)}});that.togglePanel=function(){that[that.model.isShowing?"hidePanel":"showPanel"]()};that.setPanelHeight=function(newHeight){that.locate("panel").height(newHeight)};that.refreshView=function(){that.locate("toggleButton").text(that.options.strings[that.model.isShowing?"hideText":"showText"])};that.locate("toggleButton").click(that.togglePanel);that.refreshView()}})(jQuery,fluid_1_5);var fluid_1_5=fluid_1_5||{};(function($,fluid){var animateDisplay=function(elm,animation,defaultAnimation){animation=(animation)?animation:defaultAnimation;elm.animate(animation.params,animation.duration,animation.callback)};var animateProgress=function(elm,width,speed){elm.queue("fx",[]);elm.animate({width:width,queue:false},speed)};var showProgress=function(that,animation){if(animation===false){that.displayElement.show()}else{animateDisplay(that.displayElement,animation,that.options.showAnimation)}};var hideProgress=function(that,delay,animation){delay=(delay===null||isNaN(delay))?that.options.delay:delay;if(delay){var timeOut=setTimeout(function(){hideProgress(that,0,animation)},delay)}else{if(animation===false){that.displayElement.hide()}else{animateDisplay(that.displayElement,animation,that.options.hideAnimation)}}};var updateWidth=function(that,newWidth,dontAnimate){dontAnimate=dontAnimate||false;var currWidth=that.indicator.width();var direction=that.options.animate;if((newWidth>currWidth)&&(direction==="both"||direction==="forward")&&!dontAnimate){animateProgress(that.indicator,newWidth,that.options.speed)}else{if((newWidth<currWidth)&&(direction==="both"||direction==="backward")&&!dontAnimate){animateProgress(that.indicator,newWidth,that.options.speed)}else{that.indicator.width(newWidth)}}};var percentToPixels=function(that,percent){return Math.round((Math.min(percent,100)*that.progressBar.innerWidth())/100)};var refreshRelativeWidth=function(that){var pixels=Math.max(percentToPixels(that,parseFloat(that.storedPercent)),that.options.minWidth);updateWidth(that,pixels,true)};var initARIA=function(ariaElement,ariaBusyText){ariaElement.attr("role","progressbar");ariaElement.attr("aria-valuemin","0");ariaElement.attr("aria-valuemax","100");ariaElement.attr("aria-valuenow","0");if(ariaBusyText){ariaElement.attr("aria-valuetext","")}ariaElement.attr("aria-busy","false")};var updateARIA=function(that,percent){var str=that.options.strings;var busy=percent<100&&percent>0;that.ariaElement.attr("aria-busy",busy);that.ariaElement.attr("aria-valuenow",percent);if(str.ariaBusyText){if(busy){var busyString=fluid.stringTemplate(str.ariaBusyText,{percentComplete:percent});that.ariaElement.attr("aria-valuetext",busyString)}else{if(percent===100){that.ariaElement.attr("aria-valuetext",str.ariaDoneText)}}}};var updateText=function(label,value){label.html(value)};var repositionIndicator=function(that){that.indicator.css("top",that.progressBar.position().top).css("left",0).height(that.progressBar.height());refreshRelativeWidth(that)};var updateProgress=function(that,percent,labelText,animationForShow){showProgress(that,animationForShow);if(percent!==null){that.storedPercent=percent;var pixels=Math.max(percentToPixels(that,parseFloat(percent)),that.options.minWidth);updateWidth(that,pixels)}if(labelText!==null){updateText(that.label,labelText)}if(that.ariaElement){updateARIA(that,percent)}};var setupProgress=function(that){that.displayElement=that.locate("displayElement");if(that.options.initiallyHidden){that.displayElement.hide()}that.progressBar=that.locate("progressBar");that.label=that.locate("label");that.indicator=that.locate("indicator");that.ariaElement=that.locate("ariaElement");that.indicator.width(that.options.minWidth);that.storedPercent=0;if(that.ariaElement){initARIA(that.ariaElement,that.options.strings.ariaBusyText)}if(that.options.hideAnimation.callback){that.events.afterProgressHidden.addListener(that.options.hideAnimation.callback)}that.options.hideAnimation.callback=that.events.afterProgressHidden.fire;if(that.options.showAnimation.callback){that.events.onProgressBegin.addListener(that.options.showAnimation.callback)}that.options.showAnimation.callback=that.events.onProgressBegin.fire};fluid.progress=function(container,options){var that=fluid.initView("fluid.progress",container,options);setupProgress(that);that.show=function(animation){showProgress(that,animation)};that.hide=function(delay,animation){hideProgress(that,delay,animation)};that.update=function(percentage,labelValue,animationForShow){updateProgress(that,percentage,labelValue,animationForShow)};that.refreshView=function(){repositionIndicator(that)};return that};fluid.defaults("fluid.progress",{gradeNames:"fluid.viewComponent",selectors:{displayElement:".flc-progress",progressBar:".flc-progress-bar",indicator:".flc-progress-indicator",label:".flc-progress-label",ariaElement:".flc-progress-bar"},strings:{ariaBusyText:"Progress is %percentComplete percent complete",ariaDoneText:"Progress is complete."},showAnimation:{params:{opacity:"show"},duration:"slow",callback:null},hideAnimation:{params:{opacity:"hide"},duration:"slow",callback:null},events:{onProgressBegin:null,afterProgressHidden:null},minWidth:5,delay:0,speed:200,animate:"forward",initiallyHidden:true,updatePosition:false})})(jQuery,fluid_1_5);(function($){var increments=0;$.widget("ui.tooltip",{options:{items:"[title]",content:function(){return $(this).attr("title")},position:{my:"left center",at:"right center",offset:"15 0"}},_create:function(){var self=this;this.tooltip=$("<div></div>").attr("id","ui-tooltip-"+increments++).attr("role","tooltip").attr("aria-hidden","true").addClass("ui-tooltip ui-widget ui-corner-all ui-widget-content").appendTo(document.body).hide();this.tooltipContent=$("<div></div>").addClass("ui-tooltip-content").appendTo(this.tooltip);this.opacity=this.tooltip.css("opacity");this.element.bind("focus.tooltip mouseover.tooltip",function(event){self.open(event)}).bind("blur.tooltip mouseout.tooltip",function(event){self.close(event)})},enable:function(){this.options.disabled=false},disable:function(){this.options.disabled=true},destroy:function(){this.tooltip.remove();$.Widget.prototype.destroy.apply(this,arguments)},widget:function(){return this.element.pushStack(this.tooltip.get())},open:function(event){var target=$(event&&event.target||this.element).closest(this.options.items);if(this.current&&this.current[0]==target[0]){return }var self=this;this.current=target;this.currentTitle=target.attr("title");var content=this.options.content.call(target[0],function(response){setTimeout(function(){if(self.current==target){self._show(event,target,response)}},13)});if(content){self._show(event,target,content)}},_show:function(event,target,content){if(!content){return }target.attr("title","");if(this.options.disabled){return }this.tooltipContent.html(content);this.tooltip.css({top:0,left:0}).show().position($.extend({of:target},this.options.position)).hide();this.tooltip.attr("aria-hidden","false");target.attr("aria-describedby",this.tooltip.attr("id"));this.tooltip.stop(false,true).fadeIn();this._trigger("open",event)},close:function(event){if(!this.current){return }var current=this.current;this.current=null;current.attr("title",this.currentTitle);if(this.options.disabled){return }current.removeAttr("aria-describedby");this.tooltip.attr("aria-hidden","true");this.tooltip.stop(false,true).fadeOut();this._trigger("close",event)}})})(jQuery);var fluid_1_5=fluid_1_5||{};(function($,fluid){var createContentFunc=function(content){return typeof content==="function"?content:function(){return content}};var setup=function(that){that.container.tooltip({content:createContentFunc(that.options.content),position:that.options.position,items:that.options.items,open:function(event){var tt=$(event.target).tooltip("widget");tt.stop(false,true);tt.hide();if(that.options.delay){tt.delay(that.options.delay).fadeIn("default",that.events.afterOpen.fire())}else{tt.show();that.events.afterOpen.fire()}},close:function(event){var tt=$(event.target).tooltip("widget");tt.stop(false,true);tt.hide();tt.clearQueue();that.events.afterClose.fire()}});that.elm=that.container.tooltip("widget");that.elm.addClass(that.options.styles.tooltip)};fluid.tooltip=function(container,options){var that=fluid.initView("fluid.tooltip",container,options);that.updateContent=function(content){that.container.tooltip("option","content",createContentFunc(content));that.container.data("tooltip").tooltip.html(content)};that.destroy=function(){that.container.tooltip("destroy")};that.open=function(){that.container.tooltip("open")};that.close=function(){that.container.tooltip("close")};setup(that);return that};fluid.defaults("fluid.tooltip",{gradeNames:["fluid.viewComponent"],styles:{tooltip:""},events:{afterOpen:null,afterClose:null},content:"",position:{my:"left top",at:"left bottom",offset:"0 5"},items:"*",delay:300})})(jQuery,fluid_1_5);(function($){var $scrollTo=$.scrollTo=function(target,duration,settings){$(window).scrollTo(target,duration,settings)};$scrollTo.defaults={axis:"xy",duration:parseFloat($.fn.jquery)>=1.3?0:1};$scrollTo.window=function(scope){return $(window)._scrollable()};$.fn._scrollable=function(){return this.map(function(){var elem=this,isWin=!elem.nodeName||$.inArray(elem.nodeName.toLowerCase(),["iframe","#document","html","body"])!=-1;if(!isWin){return elem}var doc=(elem.contentWindow||elem).document||elem.ownerDocument||elem;return $.browser.safari||doc.compatMode=="BackCompat"?doc.body:doc.documentElement})};$.fn.scrollTo=function(target,duration,settings){if(typeof duration=="object"){settings=duration;duration=0}if(typeof settings=="function"){settings={onAfter:settings}}if(target=="max"){target=9000000000}settings=$.extend({},$scrollTo.defaults,settings);duration=duration||settings.speed||settings.duration;settings.queue=settings.queue&&settings.axis.length>1;if(settings.queue){duration/=2}settings.offset=both(settings.offset);settings.over=both(settings.over);return this._scrollable().each(function(){var elem=this,$elem=$(elem),targ=target,toff,attr={},win=$elem.is("html,body");switch(typeof targ){case"number":case"string":if(/^([+-]=)?\d+(\.\d+)?(px|%)?$/.test(targ)){targ=both(targ);break}targ=$(targ,this);case"object":if(targ.is||targ.style){toff=(targ=$(targ)).offset()}}$.each(settings.axis.split(""),function(i,axis){var Pos=axis=="x"?"Left":"Top",pos=Pos.toLowerCase(),key="scroll"+Pos,old=elem[key],max=$scrollTo.max(elem,axis);if(toff){attr[key]=toff[pos]+(win?0:old-$elem.offset()[pos]);if(settings.margin){attr[key]-=parseInt(targ.css("margin"+Pos))||0;attr[key]-=parseInt(targ.css("border"+Pos+"Width"))||0}attr[key]+=settings.offset[pos]||0;if(settings.over[pos]){attr[key]+=targ[axis=="x"?"width":"height"]()*settings.over[pos]}}else{var val=targ[pos];attr[key]=val.slice&&val.slice(-1)=="%"?parseFloat(val)/100*max:val}if(/^\d+$/.test(attr[key])){attr[key]=attr[key]<=0?0:Math.min(attr[key],max)}if(!i&&settings.queue){if(old!=attr[key]){animate(settings.onAfterFirst)}delete attr[key]}});animate(settings.onAfter);function animate(callback){$elem.animate(attr,duration,settings.easing,callback&&function(){callback.call(this,target,settings)})}}).end()};$scrollTo.max=function(elem,axis){var Dim=axis=="x"?"Width":"Height",scroll="scroll"+Dim;if(!$(elem).is("html,body")){return elem[scroll]-$(elem)[Dim.toLowerCase()]()}var size="client"+Dim,html=elem.ownerDocument.documentElement,body=elem.ownerDocument.body;return Math.max(html[scroll],body[scroll])-Math.min(html[size],body[size])};function both(val){return typeof val=="object"?val:{top:val,left:val}}})(jQuery);