//==========================================================================================================================
//Funciones que vamos a utilizar para inicializar elementos de nuestra aplicacion (Propio de Ordenar Palabras)
//==========================================================================================================================
   
//Extraemos del XML todos los datos necesarios para nuestra aplicacion

	function extraerDatos()
	{
		tipo_actividad = "OPalabras";
		
		try{
			origen_recursos = xmlDoc.getElementsByTagName("origen_recursos")[0].childNodes[0].nodeValue;
		}catch(e)
		{
			origen_recursos="";
		}
        
		if(origen_recursos){
			rutaRecursos = origen_recursos;
		}
		ocultar_reiniciar = xmlDoc.getElementsByTagName("ocultar_reiniciar")[0].childNodes[0].nodeValue;
		ocultar_respuestas = xmlDoc.getElementsByTagName("ocultar_respuestas")[0].childNodes[0].nodeValue;
		ocultar_redes = xmlDoc.getElementsByTagName("ocultar_redes")[0].childNodes[0].nodeValue;
        try{
        	colorFuente = xmlDoc.getElementsByTagName("color_fuente")[0].childNodes[0].nodeValue;
        	colorFuenteB = xmlDoc.getElementsByTagName("color_fuente_b")[0].childNodes[0].nodeValue;
        	colorFuenteInt = colorFuente.substring(2,colorFuente.length);
        	colorFuente = "#"+colorFuente.substring(2,colorFuente.length);
        	colorFuenteB = "#"+colorFuenteB.substring(2,colorFuenteB.length);
        }catch(e){
        	colorFuente = "#FFFFFF";
        	colorFuenteB = "#111111";
        }
        colorFondo = xmlDoc.getElementsByTagName("color_fondo_h")[0].childNodes[0].nodeValue;
				colorFondoInt = colorFondo.substring(2,colorFondo.length);
        colorFondo = "#"+colorFondo.substring(2,colorFondo.length);
				colorBotones = xmlDoc.getElementsByTagName("color_botones_h")[0].childNodes[0].nodeValue;
				colorBotones = colorBotones.substring(2,colorBotones.length);
        try{
        	logoPersonalizado = xmlDoc.getElementsByTagName("logoPersonalizado")[0].childNodes[0].nodeValue;
        }catch(e){
        	logoPersonalizado = "";
        }
        try{
        	franjaPersonalizada = xmlDoc.getElementsByTagName("franjaPersonalizada")[0].childNodes[0].nodeValue;
        }catch(e){
        	franjaPersonalizada = "";
        }
		
		forma_completar = xmlDoc.getElementsByTagName("forma_completar")[0].childNodes[0].nodeValue;
		
		if((is_touch_device())&&(forma_completar == "arrastrar")) forma_completar = "clickar";
		if((navigator.userAgent.toLowerCase().indexOf('msie 9.0') != -1)&&(forma_completar == "arrastrar")) forma_completar = "clickar";
		
		if(forma_completar == "escribir")
		{
			if((xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0] != null)) sensible_mayusculas = xmlDoc.getElementsByTagName("sensible_mayusculas")[0].childNodes[0].nodeValue;
			else sensible_mayusculas = "no";
			if((xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0] != null)) sensible_acentos = xmlDoc.getElementsByTagName("sensible_acentos")[0].childNodes[0].nodeValue;
			else sensible_acentos = "no";
			if(xmlDoc.getElementsByTagName("sensible_mayusculas_ocultar")[0].childNodes[0] != undefined)
			{
				sensible_mayusculas_ocultar = xmlDoc.getElementsByTagName("sensible_mayusculas_ocultar")[0].childNodes[0].nodeValue;
			}
			else
			{
				sensible_mayusculas_ocultar = "no";
			}
			
			if(xmlDoc.getElementsByTagName("sensible_acentos_ocultar")[0].childNodes[0] != undefined)
			{
				sensible_acentos_ocultar = xmlDoc.getElementsByTagName("sensible_acentos_ocultar")[0].childNodes[0].nodeValue;
			}
			else
			{
				sensible_acentos_ocultar = "no";
			}
		}
		else
		{
			sensible_mayusculas_ocultar = "si";
			sensible_acentos_ocultar = "si";
			sensible_mayusculas = "noDefinido";
			sensible_acentos = "noDefinido";
		}
		
		numero_intentos = xmlDoc.getElementsByTagName("numero_intentos")[0].childNodes[0].nodeValue;
		puntos_resta = xmlDoc.getElementsByTagName("puntos_resta")[0].childNodes[0].nodeValue;
		
		if (xmlDoc.getElementsByTagName("autor")[0].childNodes.length == 0) {
			autor = '';
		} else {
			autor = xmlDoc.getElementsByTagName("autor")[0].childNodes[0].nodeValue;
		}
		descripcionUsuario = xmlDoc.getElementsByTagName("descripcionUsuario")[0].childNodes[0].nodeValue;
		
		registro = xmlDoc.getElementsByTagName("registro")[0];
		
		tiempo = xmlDoc.getElementsByTagName("tiempo")[0].childNodes[0].nodeValue;
		if(tiempo == "si") tiempo = xmlDoc.getElementsByTagName("tiempo")[0].attributes.getNamedItem("maximo").value;
		else if (tiempo == "no") tiempo = 0;
				
		descripcion = xmlDoc.getElementsByTagName("descripcion")[0].childNodes[0].nodeValue;
		enunciado = xmlDoc.getElementsByTagName("enunciado")[0].childNodes[0].nodeValue;
		
		pregunta = xmlDoc.getElementsByTagName("pregunta")[0].childNodes[0].nodeValue;
		
		audio = xmlDoc.getElementsByTagName("pregunta")[0].attributes.getNamedItem("audio").value;
		
		if((xmlDoc.getElementsByTagName("imagen")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("imagen")[0].childNodes[0] != null)) imagen = xmlDoc.getElementsByTagName("imagen")[0].childNodes[0].nodeValue;
		else imagen = "";
		
		respuestaT = xmlDoc.getElementsByTagName("respuesta")[0].childNodes[0].nodeValue;
		respuestaCH = respuestaT.split(" ");
		
		var k = 0;
		respuesta = [];
		for(i=0;i<respuestaCH.length;i++)
		{
			if(respuestaCH[i] != "")
			{
				respuesta[k] = respuestaCH[i];
				k++;
			}
		}
		
		var idioma = xmlDoc.getElementsByTagName("idioma")[0];
		nIntentos = idioma.getElementsByTagName("nIntentos")[0].childNodes[0].nodeValue;
		txtPuntos = idioma.getElementsByTagName("txtPuntos")[0].childNodes[0].nodeValue;
		txtTiempo = idioma.getElementsByTagName("txtTiempo")[0].childNodes[0].nodeValue;
		txtTiempoRestante = idioma.getElementsByTagName("txtTiempoRestante")[0].childNodes[0].nodeValue;
		comprobar = idioma.getElementsByTagName("comprobar")[0].childNodes[0].nodeValue;
		txtRespuestaIncorrecta = idioma.getElementsByTagName("txtRespuestaIncorrecta")[0].childNodes[0].nodeValue;
		txtActNoSuperada = idioma.getElementsByTagName("txtActNoSuperada")[0].childNodes[0].nodeValue;
		txtTiempoSuperado = idioma.getElementsByTagName("txtTiempoSuperado")[0].childNodes[0].nodeValue;
		txtCerrar = idioma.getElementsByTagName("txtCerrar")[0].childNodes[0].nodeValue;
		txtRespuestaCorrecta = idioma.getElementsByTagName("txtRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtTituloRespuestaCorrecta = idioma.getElementsByTagName("txtTituloRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtSuperadoNumeroIntentos = idioma.getElementsByTagName("txtSuperadoNumeroIntentos")[0].childNodes[0].nodeValue;
		txtTituloSuperadoNumeroIntentos = idioma.getElementsByTagName("txtTituloSuperadoNumeroIntentos")[0].childNodes[0].nodeValue;
		txtBoxRespuestaCorrecta = idioma.getElementsByTagName("txtBoxRespuestaCorrecta")[0].childNodes[0].nodeValue;
		txtOpcionIncorrecta = idioma.getElementsByTagName("txtOpcionIncorrecta")[0].childNodes[0].nodeValue;
		txtAquiEstanLasPalabras = idioma.getElementsByTagName("txtAquiEstanLasPalabras")[0].childNodes[0].nodeValue;
		txtSensibleMayusculas = idioma.getElementsByTagName("txtSensibleMayusculas")[0].childNodes[0].nodeValue;
		txtNoSensibleMayusculas = idioma.getElementsByTagName("txtNoSensibleMayusculas")[0].childNodes[0].nodeValue;
		txtSensibleAcentos = idioma.getElementsByTagName("txtSensibleAcentos")[0].childNodes[0].nodeValue;
		txtNoSensibleAcentos = idioma.getElementsByTagName("txtNoSensibleAcentos")[0].childNodes[0].nodeValue;
		txtErrorAudio = idioma.getElementsByTagName("txtErrorAudioSoportado")[0].childNodes[0].nodeValue;
		
		txtAceptar = idioma.getElementsByTagName("txtAceptar")[0].childNodes[0].nodeValue;
		txtTiempoMaximo = idioma.getElementsByTagName("txtTiempoMaximo")[0].childNodes[0].nodeValue;
		txtSensible = idioma.getElementsByTagName("txtSensible")[0].childNodes[0].nodeValue;
		txtMayusculasMinusculas = idioma.getElementsByTagName("txtMayusculasMinusculas")[0].childNodes[0].nodeValue;
		txtAcentos = idioma.getElementsByTagName("txtAcentos")[0].childNodes[0].nodeValue;
		txtComenzar = idioma.getElementsByTagName("txtComenzar")[0].childNodes[0].nodeValue;
		txtAutor = idioma.getElementsByTagName("txtAutor")[0].childNodes[0].nodeValue;
		txtAyuda = idioma.getElementsByTagName("txtAyuda")[0].childNodes[0].nodeValue;
		txtMostrarMas = idioma.getElementsByTagName("txtMostrarMas")[0].childNodes[0].nodeValue;
		txtMostrarMenos = idioma.getElementsByTagName("txtMostrarMenos")[0].childNodes[0].nodeValue;
		txtReiniciar = idioma.getElementsByTagName("txtReiniciar")[0].childNodes[0].nodeValue;
		txtVolverJugar = idioma.getElementsByTagName("txtVolverJugar")[0].childNodes[0].nodeValue;
		txtResponder = idioma.getElementsByTagName("txtResponder")[0].childNodes[0].nodeValue;
		txtRegistrarse = idioma.getElementsByTagName("txtRegistrarse")[0].childNodes[0].nodeValue;
		txtAcceder = idioma.getElementsByTagName("txtAcceder")[0].childNodes[0].nodeValue;
		txtCompartirResultado = idioma.getElementsByTagName("txtCompartirResultado")[0].childNodes[0].nodeValue;
		txtAumentar = idioma.getElementsByTagName("txtAumentar")[0].childNodes[0].nodeValue;
		txtReducir = idioma.getElementsByTagName("txtReducir")[0].childNodes[0].nodeValue;
		txtImprimir = idioma.getElementsByTagName("txtImprimir")[0].childNodes[0].nodeValue;
		txtPantallaCompleta = idioma.getElementsByTagName("txtPantallaCompleta")[0].childNodes[0].nodeValue;
		txtSocial = idioma.getElementsByTagName("txtSocial")[0].childNodes[0].nodeValue;
	}
	
//Inicializamos los diferentes elementos de nuestra aplicacion
	
	function inicializarElementos()
	{
	    //Inicializamos los colores de la aplicacion
		inicializarColores();
		//Inicializamos eventos principales
		inicializarEventosPrincipales();
		//Inicializamos los valores para la pantalla inicial
		inicializarPantallaInicial();
		//Inicializamos los valores para la barra de la pista
		inicializarPista();
		//Inicializamos los parametros
		inicializarParametros();
		//Inicializamos el titulo de la propia aplicacion
		inicializarTituloAct();
		//Inicializamos el titulo para las palabras
		inicializarTituloPalabras();
		//Inicializamos el evento del boton comprobar
		inicializarBtnComprobar();
		//Inicializamos la alerta correcta
		inicializarAlertaCorrecta();
		//Inicializar alerta incorrecta
		inicializarAlertaIncorrecta();
		//Inicializamos enlaces reinicio
		inicializarRecargar();
		//Inicializamos enlaces ayuda
		inicializarAyuda();
		//Inicializamos el registro
		inicializarRegistro();	
	}

//Inicializamos los eventos principales

	function inicializarEventosPrincipales()
	{
		//Activamos la redimensión del crucigrama al cambiar el tamaño de la ventana 
		$(window).resize(function () {redimensionar();});
	}

//Inicializamos los elementos particulares de esta aplicación

//Inicializamos la pista de la palabra
	
	function inicializarPista()
	{
		$('#pTexto').html(pregunta);
		
		if(audio == "")
		{
			$("#pAudio").hide();
		} 
		else
		{	
			var rutaAudio = rutaRecursos+audio;
            var rutaAudioOgg = rutaRecursosInicio+audio;
			//var audioCadena = "<audio id='pistaAudio' src='"+rutaAudio+"' type='audio/mpeg' onError='errores(-1);'></audio>";
			var audioCadena = "<audio id='pistaAudio'><source src='"+rutaAudio+"' type='audio/mpeg'></source><source src='"+rutaAudio.substring(0,rutaAudio.length-3)+"ogg' type='audio/ogg'></source><source src='"+rutaAudioOgg.substring(0,rutaAudioOgg.length-3)+"ogg' onError='errores(-1);' type='audio/ogg'></source></audio>";
			$('#audioTag').html(audioCadena);
			$('#btnAudio').show();
			$('#btnAudio').click(function(e){e.preventDefault();$(".huecoPalabras").removeClass("foco");gestionReproducir("pistaAudio","iconoAudio");});
		}
		
		if(imagen == "")
		{
			$("#pImagen").hide();
		}
		else
		{
			$("#contenidoPista").addClass("conImagen");
			var rutaImagen = rutaRecursos+imagen;
			var imagenCadena = "<a href='"+rutaImagen+"' class='fancybox'><div class='image-overlay'><div class='image-overlay-zoom'></div></div><img id='pistaImagen' src='"+rutaImagen+"' width='40px' height='40px'></a>";
			$("#pImagen").html(imagenCadena);
			
			$(document).ready(function() {
				$('.fancybox').fancybox();
			});
		}
	}
	
//Inicializamos el titulo para las palabras disponibles	

	function inicializarTituloPalabras()
	{
		$('#tituloPalabras').text(txtAquiEstanLasPalabras);
	}
	
//Inicializamos el boton de comprobar
	
	function inicializarBtnComprobar()
	{
		$('#btnComprobar').text(comprobar);
		$('#btnComprobar').click(function(e){e.preventDefault();actualizaIds();compruebaFrase();});
	}
