//==========================================================================================================================
//Funciones que vamos a utilizar para la versión imprimible del mapa (Propio de Ordenar Palabras)
//==========================================================================================================================

//Cuando se carga la página imprimible, lanzamos la generación de la version para imprimir

window.onload = function(){
	//Esta variable será la ruta para los recursos necesarios
	rutaRecursos="/actividades/"+$(document).data("idActividad")+"/";rutaRecursosDownl="";
	//rutaRecursos = "";
	
	cargarDatosPrint();
	}

//Carga los datos necesarios desde el fichero XML de la actividad
  
    function cargarDatosPrint()
	{
		xmlDoc = cargarXMLJS();
		if ((xmlDoc != null)&&(xmlDoc != undefined))
		{
			//Extraemos los datos del XML para la versión de impresión
			try{extraerDatosPrint();}
			catch(e){
				errorXML();
				}
			//Creamos la versión de impresión
			crearPrint();
		}		
		else
		{
			errorXML();
		}					
	}
	
//Resgistra el error cuando no se puede leer el XML

	function errorXML()
	{
		$.get("/avisoEstructuraXml.php");
		$("#lienzo").html("<div id='errorXML'>"+$(document).data("loadingXmlError")+"</div>");
	}
				
//Carga el fichero XML
	
	function cargarXMLJS() {
		return jQuery.parseXML(DatosActividad);
	}

//Extraemos los datos necesarios de XML para la versión imprimible
	
	function extraerDatosPrint()
	{
	    try{
			origen_recursos = xmlDoc.getElementsByTagName("origen_recursos")[0].childNodes[0].nodeValue;
		}catch(e)
		{
			origen_recursos="";
		}
        
		if(origen_recursos){
			rutaRecursos = origen_recursos;
		}
		autor = xmlDoc.getElementsByTagName("autor")[0].childNodes[0].nodeValue;
		
		titulo = xmlDoc.getElementsByTagName("enunciado")[0].childNodes[0].nodeValue;
		
		pregunta = xmlDoc.getElementsByTagName("pregunta")[0].childNodes[0].nodeValue;
		
		respuestaT = xmlDoc.getElementsByTagName("respuesta")[0].childNodes[0].nodeValue;
		respuestaCH = respuestaT.split(" ");
		
		var k = 0;
		respuesta = [];
		for(i=0;i<respuestaCH.length;i++)
		{
			if(respuestaCH[i] != "")
			{
				respuesta[k] = respuestaCH[i];
				k++;
			}
		}
		
		if((xmlDoc.getElementsByTagName("imagen")[0].childNodes[0] != undefined)&&(xmlDoc.getElementsByTagName("imagen")[0].childNodes[0] != null)) imagen = xmlDoc.getElementsByTagName("imagen")[0].childNodes[0].nodeValue;
		else imagen = "";
  		
  		var idioma = xmlDoc.getElementsByTagName("idioma")[0];
  		txtAutor = idioma.getElementsByTagName("txtAutor")[0].childNodes[0].nodeValue;
  		txtAquiEstanLasPalabras = idioma.getElementsByTagName("txtAquiEstanLasPalabras")[0].childNodes[0].nodeValue;
	}

//Creamos la versión imprimible
	
	function crearPrint()
	{
		$("#txtTitAct").html(titulo);
		$("#textoAutor").html(txtAutor+" : ");
		$("#nombreAutor").html(autor);
		$('#pTexto').html(pregunta);
		$('#tituloPalabras').text(txtAquiEstanLasPalabras);
		
		if(imagen == "")
		{
			$("#pImagen").hide();
		}
		else
		{
			$("#contenidoPista").addClass("conImagen");
			var rutaImagen = rutaRecursos+imagen;
			var imagenCadena = "<img id='pistaImagen' src='"+rutaImagen+"'>";
			$("#pImagen").html(imagenCadena);
		}
		
		cargarPrint();
	}
				
//Creo las letras con las características necesarias

	function cargarPrint()
	{
		for(i=0;i<respuesta.length;i++)
		{
			if(i<10) var ix = "0"+i;
			else var ix = i;
								
			var divCuadro = $("<div>",
			{
				id: "cuadro"+ix,
				"class": "cuadroPalabras"
				
			});
			$('#palabrasDisponibles').append(divCuadro);
				
			var divPalabra = $("<div>",
			{
				id: "cajaPalabra"+ix,
				"class": "cajaPalabras"
			});
			$('#cuadro'+ix).append(divPalabra);
			
			var divHueco = $("<div>",
			{
				id: "hueco"+ix,
				"class": "cuadroPalabras huecoPalabras"
			});
			$('#palabrasOrdenar').append(divHueco);
		}
		cargar();
	}

//Cargamos las letras de manera aleatoria sobre las cajas creadas
	
	function cargar()
	{
		var colocadas = [];
		var aceptar = 0;
		for(i=0;i<respuesta.length;i++)
		{
			if(i<10) var ix = "0"+i;
			else var ix = i;
					
			while(aceptar == 0)
			{
				posicion = Math.floor((Math.random()*100));
				if((posicion < respuesta.length))
				{
					aceptar=1;
					for(k=0;k<colocadas.length;k++)
					{
						if(colocadas[k] == posicion)
						{
							aceptar=0;
						}
					}
				}
			}
			colocadas[i] = posicion;
			aceptar=0;
			$("#cajaPalabra"+ix).html(respuesta[posicion]);
		}
	}
