var API = null;               /* SCORM API */
var _nPageIndex = 0;          /* index of our current page */
var _bTerminated = false;     /* have we terminated this course */
var _nInteractionsTotal = -1; /* number of interactions available from the LMS */
var _bFinalPages = true;      /* want final pages instead of storyboards */
var _sSepA  = "++";            /* first separator for all state data */
var _sSepB = "$$";             /* second separator for all state data */
var _sSep1 = "@@";             /* first separator for the content pages */

var _nClientID = 130;
var _nProjectID = 1151;
var _nProjectVersionID = 1645;


var _nQuestionsTotal = 1; /* the total number of questions in all tests */
var _nPassingScore = 100; /* number that the learner must answer correctly */

/*
* called once when the frameset (SCO) is loaded
*/
function initialize() {
	/* init the global SCORM API variable */
	initAPI(window);
	/* tell SCORM API we have started the SCO */
	LMSInitialize();
	if (LMSGetValue("cmi.core.lesson_status") != "passed" ||  LMSGetValue("cmi.core.lesson_status") != "")
	{
		LMSSetValue("cmi.core.lesson_status","incomplete");
	}

	/* set the status to incomplete if this is the first entry into the SCO */
	apiSetInitialStatus();
	var learnerState = LMSGetValue("cmi.core.lesson_status");
		lstate = learnerState;
}


/*
* called when the frameset is unloaded by closing the window or navigating to another SCO
*/
function terminate() {
	console.log("terminate sco");
	/* see if we have terminated to make sure we do this just once */
	if (!_bTerminated) {
		/* we have not, so shut it down */
		_bTerminated = true;

		/* call a function to let the author do final processing before the end of the SCO session
		This function is called only if 50% of video is watched.
		scoIsEnding();*/

		/* save the SCORM data prior to ending this session */
		saveState();

		/* end the SCORM session */
		LMSFinish();

	}

}
/*
* takes a boolean to see if the user wants to see the final page (true) or the storyboard page (false)
* returns the correct URL
*/
function setPage(url) {
	/* see if the user wants the final */
	if (_bFinalPages) {
		return url;
	} else {
		/* user does not want final pages, get the storyboard url and return it */
		var urlparts = url.split("/");
		var finalurl = "";
		var length = urlparts.length - 1;
		for (var i=0; i<length; i++) {
			finalurl = finalurl + urlparts[i] + "/";
		}
		finalurl = finalurl + "storyboard_" + urlparts[length];
		return finalurl;
	}
}


/*
* restore the state of the SCO, return the index of the page last viewed by this learner
*/
function restoreState() {
	/* get the state data from the last launch of the SCO */
	var sData = LMSGetValue("cmi.suspend_data");

	/* see if we can trust this returned value */
	if (LMSGetLastError() == "0") {
		/* we can, see if there is any data */
		if (sData != "") {
			/* there is, parse the state data into bits for individual pages */
			arrayAll = sData.split(_sSepA);

			/* loop through the array if information for pages */
			var nLength = arrayAll.length;
			for (i=0; i<nLength; i++) {
				/* break this item into the index part and the state data part */
				arraySingle = arrayAll[i].split(_sSepB);
				var j=arraySingle[0]-0;

				/* mark this page as visited */
				tocTab[j][4] = "1";

				/* add the state data */
				tocTab[j][5] = arraySingle[1];
			}
		}
	}

	/* get the bookmark - this ia an index to the array of pages */
	var sLastPage = LMSGetValue("cmi.core.lesson_location");

	/* see if the bookmark is empty */
	if (sLastPage == "") {
		/* it is, return an index to the first page */
		return 0;
	}

	/* return the index as an integer */
	return sLastPage-0;
}

/*
* Save the state for this SCO - save the bookmark, state data and record the session time
*/
function saveState() {
	/* save the bookmark - this is the index of the the page array */
	LMSSetValue("cmi.core.lesson_location", _nPageIndex+"");


	/* initialize the buffer to hold the state data for the SCO */
	var sData = "";

	/* store the state data in cmi.suspend_data */
	LMSSetValue("cmi.suspend_data", sData);

	/* record the session time */
	LMSSetValue("cmi.core.session_time", getSessionTime());
}

/* FUNCTIONS TO USE THE SCORM RUNTIME API */
/* look up through the frameset hierarchy for the SCORM API */
function findAPI(win) {
	while ((win.API == null) && (win.parent != null) && (win.parent != win)) {
		win = win.parent;
	}
	API = win.API;
}
/* init the SCORM API */
function initAPI(win) {
	/* look for the SCORM API up in the frameset */
	findAPI(win);

	/* if we still have not found the API, look at the opener and it's frameset */
	if ((API == null) && (win.opener != null)) {
		findAPI(win.opener);
	}
}
function LMSInitialize() {
	if (API == null)
		return "false";

	var result = API.LMSInitialize("");
	return result;
}
function LMSFinish() {
	if (API == null)
		return "false";

	var result = API.LMSFinish("");
	API == null;
	return result;
}
function LMSGetValue(name) {
	if (API == null)
		return "";

	var value = API.LMSGetValue(name);
	var errCode = API.LMSGetLastError();
	if (errCode != "0") {
		return "";
	} else {
		return value;
	}
}
function LMSSetValue(name, value) {
	if (API == null)
		return "";

	var result = API.LMSSetValue(name, value+"");
	return result;
}
function LMSGetLastError() {
	if (API == null) {
		/* there is no API available, by returning a not implemented
		*  error code, we let caller assume that the last SCORM
		*  function failed */
		return "401";
	}
	return API.LMSGetLastError();
}

/*
* get the session time
*/
dateStart = new Date(); /* start data and time of this sesstion */
timeStart = dateStart.getTime();

function getSessionTime() {
	/* get the current time */
	var dateNow = new Date();
	var timeNow = dateNow.getTime();

	/* convert to hh:mm:ss */
	var timeElapsed = Math.round((timeNow - timeStart) / 1000);
	var hh = Math.floor(timeElapsed / 3600);
	timeElapsed -= hh * 3600;
	var mm = Math.floor(timeElapsed / 60);
	timeElapsed -= mm * 60;
	var ss = timeElapsed;
	if (hh<10) hh = "0" + hh;
	if (mm<10) mm = "0" + mm;
	if (ss<10) ss = "0" + ss;

	/* return it */
	return hh + ":" + mm +":" + ss;
}

/*
* provide the state information for the currently diplayed page
*/
function apiGetState() {
	if (tocTab.length) {
		return tocTab[_nPageIndex][5];
	} else {
		return "";
	}
}

/*
* provide the first separator character for the page to use to store state data
*/
function apiGetSep1() {
	return _sSep1;
}

/*************
* SetInteraction- sets the interaction
**************/
function apiSetInteraction(sName,type,response,correct,sResult,weight,sTime) {
	var iString;

	/* see if we have got the number of interactions previously sent to the LMS  */
	if (_nInteractionsTotal == -1) {
		/* we have not, get the count of interactions from the LMS */
		_nInteractionsTotal = LMSGetValue("cmi.interactions._count");

		/* see if we can trust this returned value */
		if (LMSGetLastError() != "0") {
			/* we cannot, set the number of interactions to 0 */
			_nInteractionsTotal = 0;
		}
	}

	/* tell the LMS about the interaction */
	iString = "cmi.interactions." + _nInteractionsTotal + ".";
	LMSSetValue(iString + "id", sName);
	LMSSetValue(iString + "type", type);
	LMSSetValue(iString + "student_response", response);
	LMSSetValue(iString + "correct_responses.0.pattern", correct);
	LMSSetValue(iString + "result", sResult);
	if (weight != null) LMSSetValue(iString + "weighting", weight);
	_nInteractionsTotal++;
}

/*
* set the score of the SCO
*/
function apiSetScore(nMin, nMax, nRaw) {
	/* set the min, max and raw scores for the SCO */
	/* force the values to be character strings */
	LMSSetValue("cmi.core.score.min",nMin+"");
	LMSSetValue("cmi.core.score.max",nMax+"");
	LMSSetValue("cmi.core.score.raw",nRaw+"");
}

/*
* set the score and status of an objective
*/
function apiSetObjectiveScore(sObjName,nMin, nMax, nRaw, sStatus) {
	/* get the count of objectives from the LMS */
	var nObjectivesTotal = LMSGetValue("cmi.objectives._count");

	/* see if we can trust this returned value */
	if (LMSGetLastError() != "0") {
		/* we cannot, set the number of interactions to 0 */
		nObjectivesTotal = 0;
	} else {
		/* use the returned value (convert to an integer) */
		nObjectivesTotal -= 0;
	}

	/* see if objectives have already been set */
	if (nObjectivesTotal > 0) {
		/* they have, loop through the list of objectives */
		for (var i=0; i<nObjectivesTotal; i++) {
			/* see if this objective matches our name */
			if (LMSGetValue("cmi.objectives." + i + ".id") == sObjName) {
				/* it does, use this index to set the objective */
				nObjectivesTotal = i;

				/* done looking, break out */
				break;
			}
		}
	}

	/* tell the LMS about the score of the objective */
	var sObjString = "cmi.objectives." + nObjectivesTotal + ".";
	LMSSetValue(sObjString + "id", sObjName);
	LMSSetValue(sObjString + "score.min", nMin+"");
	LMSSetValue(sObjString + "score.max", nMax+"");
	LMSSetValue(sObjString + "score.raw", nRaw+"");

	/* see if we have a status */
	if (sStatus != "") {
		/* we do, set it */
		LMSSetValue(sObjString + "status", sStatus);
	}
}

/*
* record the objective status
*/
function recordObjectiveStatus(sObjName,sStatus) {
	/* see if we have parent functions to set status */
	if (parent.apiSetObjectiveStatus) {
		/* we do, set the objective status */
		parent.apiSetObjectiveStatus(sObjName,sStatus);
	}
}

/*
* is the objective complete
*/
function isObjectiveComplete(nObjPos) {

	var i = nObjPos;

	do {
		if (tocTab[i][4] != 1) {
			return false;
		}
		if ((tocTab[++i][3] == "o") || (tocTab[i][3] == "eo")) {
			return true;
		}
	}	while (i <= nArray)

	return true;
}

/*
* set status of all objectives
*/
function apiSetAllObjectiveStatus(sStatus) {
	for (i=0; i<nArray; i++) {
		if (tocTab[i][3] == "o") {
			apiSetObjectiveStatus(tocTab[i][1].replace(/\s+/g, '_'), sStatus);
		}
	}
}

/*
* set status of an objective
*/
function apiSetObjectiveStatus(sObjName, sStatus) {
	/* get the count of objectives from the LMS */
	var nObjectivesTotal = LMSGetValue("cmi.objectives._count");
	/* see if we can trust this returned value */
	if (LMSGetLastError() != "0") {
		/* we cannot, set the number of interactions to 0 */
		nObjectivesTotal = 0;
	} else {
		/* use the returned value (convert to an integer) */
		nObjectivesTotal -= 0;
	}

	/* see if objectives have already been set */
	if (nObjectivesTotal > 0) {
		/* they have, loop through the list of objectives */
		for (var i=0; i<nObjectivesTotal; i++) {
			/* see if this objective matches our name */
			if (LMSGetValue("cmi.objectives." + i + ".id") == sObjName) {
				/* it does, use this index to set the objective */
				nObjectivesTotal = i;

				/* done looking, break out */
				break;
			}
		}
	}

	/* tell the LMS about the status of the objective */
	var sObjString = "cmi.objectives." + nObjectivesTotal + ".";
	LMSSetValue(sObjString + "id", sObjName);

	/* see if we have a status */
	if (sStatus != "") {
		/* we do, set it */
		LMSSetValue(sObjString + "status", sStatus);
	}
}



/*
* set the status of the SCO - this is the instructional status of the SCO
* 	values are incomplete, completed, passed or failed
*/
function apiSetStatus(sStatus) {
	LMSSetValue("cmi.core.lesson_status",sStatus);

	/* call the authors function to tell him the status has been set */
	scoCompletionSet(sStatus);
}

/*
* set the exit status of the SCO. Values are "" for normal and "suspend"
*/
function apiSetExitStatus(sStatus) {
	LMSSetValue("cmi.core.exit",sStatus);
}

/*
* sets the status to incomplete if this is the first time in the SCO
*/
function apiSetInitialStatus() {

	/* get the entry status */
	var sEntry = LMSGetValue("cmi.core.entry");

	/* see if this is the first time in the SCO */
	if (sEntry == "ab-initio") {

		/* it is, set the status to incomplete */
		LMSSetValue("cmi.core.lesson_status","incomplete");
		//LMSSetValue("cmi.core.exit","resume");
	}
}


function scoIsEnding() {

    /* init a var to count up the number of correct questions */
    var nCorrect = 0;

    /* see if there is a passing score */
    if (nCorrect >= _nPassingScore) {
        /* there is, set the SCO completion status */
        apiSetStatus("passed");

        /* set the score */
        apiSetScore(0, 100, Math.round(100 * nCorrect / _nQuestionsTotal));
    }
    else {
        /* the learner did not pass, set the SCO completion status to incomplete*/
        //apiSetStatus("incomplete");
		apiSetStatus("passed");
    }

    /* see if there is a passing score */
    if (nCorrect >= _nPassingScore) {
        /* there is, set the SCO completion status */
        apiSetStatus("passed");

        /* set the score */
        apiSetScore(0, 100, Math.round(100 * nCorrect / _nQuestionsTotal));
    }
    else {
        /* the learner did not pass, set the SCO completion status to incomplete*/
        //apiSetStatus("incomplete");
          apiSetStatus("passed");
    }
}

/* this function is called after the SCO completion status has been set */
/* sStatus is the status set to incomplete, passed, failed or completed */
function scoCompletionSet(sStatus) {
    /* see if this status is passed, failed or completed */
    if (sStatus == "passed" || sStatus == "failed" || sStatus == "completed") {
        /* it is, tell the LMS that the learner is has a normal exit */
        apiSetExitStatus("");
    } else {
        /* must be incomplete, set the exit status to resume */
        apiSetExitStatus("suspend");
    }
}
