var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"test","title":"Intro to JS: types and values","exercises":"[{\"type\":\"exercise\",\"title\":\"Introduction\",\"description\":\"To return the result of the exercises you have to use the <code>return</code> statement, as we show in this example.\\nAfter the <code>return</code> statement the rest of the code will not be executed.\\nIn this example, we return as a result the words \\\"Hello World\\\".\\nClicking on the icon \\\"exec code\\\" you can see the result of the execution.\\nThis test comprises several exercises. You can go to the next exercise by clicking on the test title \\\"Intro to JS: types and values\\\" where you can see a dropdown with the different exercises.\",\"editorMode\":\"JavaScript\",\"content\":\"return \\\"Hello World\\\";\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"'typeof' operator\",\"description\":\"The <code>typeof</code> operator allows us to know the <b>type</b> of a <b>variable</b>.\\nIn the next example you can see some variables with different types.\\nUse the <b>typeof</b> operator to get the type of each one of them.\\nFor this, you can replace the variable in the <code>return (typeof a);</code> statement.\",\"editorMode\":\"JavaScript\",\"content\":\"//Primitive types\\nvar a = 5;\\nvar b = \\\"Five\\\";\\nvar c = true;\\n\\n//Objects\\nvar d = {};\\n\\n//Special types\\nvar e = undefined;\\nvar f = null;\\n\\nreturn (typeof a);\\n\\n/*\\n  Check that the types returned are the following ones:\\n  Variable a type: 'number'\\n  Numbers have type 'number'.\\n  \\n  Variable b type: 'string'\\n  Text (words, paragraphs, ...) has type 'string'.\\n  \\n  Variable c type: 'boolean'\\n  Boolean values are true and false.\\n  \\n  Variable d: 'object'\\n  Any variable that is not a primitive type will be an object.\\n  \\n  Variable e type: 'undefined'\\n  'undefined' is a special value, variables that have not been defined or initialized.\\n  \\n  Variable f: 'null'\\n  'null' is another special value that represents the null object.\\n\\n*/\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"Numbers: type 'number'\",\"description\":\"With variables of type 'number' we can apply all kind of mathematical operations.\\nIn this exercise we have defined two functions: <code>add</code> and <code>subtract</code>.\\nFill in the body of the function <code>multiply</code> to return the result of the multiplication of the a and b variables.\",\"content\":\"var add = function(a,b){\\n  return (a+b);\\n};\\n\\nvar subtract = function(a,b){\\n  return (a-b);\\n};\\n\\nvar multiply = function(a,b){\\n  //Write your solution here\\n  \\n};\\n\",\"editorMode\":\"JavaScript\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var multiply = variablesHash[\\\"multiply\\\"];\\n  \\n  if(typeof multiply != \\\"function\\\"){\\n    grade.errors.push(\\\"'multiply' function not found.\\\");\\n  } else {\\n    var testA = multiply(5,5);\\n    if((multiply(5,4)===20)&&(multiply(3,7)===21)&&(multiply(3,0)===0)){\\n      grade.score = 10;\\n    } else {\\n      grade.errors.push(\\\"Function 'multiply' does not work as expected.\\\");\\n    }\\n  }\\n\\n  return grade;\\n};\",\"score_function_vars\":[\"multiply\"]},{\"type\":\"exercise\",\"title\":\"Booleans: type 'boolean'\",\"description\":\"There are only two boolean types: 'true' and 'false'.\\nThe unary operator <b><code>!</code></b> changes a logical value to the opposite.\\nBooleans are used to take decissions in conditional statements <b>if/else</b>.\\nIn this example we show a conditional statement using boolean variables. Analize it.\\n<i>Clarification:</i> the expression <code> result += s </code> is equivalent to <code> result = result + s </code>.\",\"editorMode\":\"JavaScript\",\"content\":\"var a = true;\\nvar b = false;\\nvar c = !b;\\n\\nvar result = \\\"\\\";\\n\\nif(a){\\n  result += \\\"Variable A is true.\\\\n\\\"\\n} else {\\n  result += \\\"Variable A is false.\\\\n\\\"\\n}\\n\\nif(b){\\n  result += \\\"Variable B is true.\\\\n\\\"\\n} else {\\n  result += \\\"Variable B is false.\\\\n\\\"\\n}\\n\\nif(c){\\n  result += \\\"Variable C is true.\\\"\\n} else {\\n  result += \\\"Variable C is false.\\\"\\n}\\n\\nreturn result;\\n\\n\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"Identity, comparation and logical operators\",\"description\":\"All these operators return a boolean type (true or false)\\nCheck the restuls of the <b>c-h</b> variables and analize these results\",\"editorMode\":\"JavaScript\",\"content\":\"var n = 20;\\nvar a = true;\\nvar b = false;\\n\\n\\n/*\\n Identity or strict equality: \\\"===\\\"\\n Returns \\\"true\\\" when both variables are equal in type and value.\\n c will be \\\"true\\\" because 20 (n value) is equal to 10+10\\n*/\\nvar c = (n===(10+10)); \\n\\n\\n/*\\n Strict inequality: \\\"!==\\\"\\n Returns \\\"true\\\" when both variables are different in type or value.\\n d will be \\\"false\\\" because 20 (n value) is different to 10+10\\n*/\\nvar d = (n!==(10+10)); \\n\\n\\n/*\\n Comparison operators:\\n \\\">\\\": greater than\\n \\\"<\\\": lower than\\n \\\">=\\\": greater or equal than\\n \\\"<=\\\": lower or equal than\\n Return \\\"true\\\" when the condition is met\\n e will be \\\"true\\\" because 20 is greater than 10.\\n f will be \\\"false\\\" because 20 is not lower or equal than 10.\\n*/\\nvar e = (n>10);\\nvar f = (n<=10);\\n\\n\\n/*\\n Logical operators\\n &&: AND\\n ||: OR\\n g will be \\\"true\\\" if and only if a and b are also true.\\n h will be \\\"true\\\" if a is \\\"true\\\" or b is \\\"true\\\"\\n*/\\n\\nvar g = (a&&b); //In this case it will be \\\"false\\\" because \\\"b\\\" is false.\\nvar h = (a||b); //In this case it will be \\\"true\\\" because \\\"a\\\" is \\\"true\\\".\\n\\n\\n//Check the value of any of the c-h variables:\\nreturn c;\\n\\n\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"if-else statements\",\"description\":\"If/else statements allow the execution of blocks of code in a conditional way.\\nIn this exercise the general structure of the if/else statement is shown. Together with the function <code>exampleLogic</code> that returns \\\"true\\\" when \\\"a\\\" is \\\"true\\\" and b is equal to the number 5.\\nFill in the function <code>logic</code> to return \\\"true\\\" only when all the next conditions are met at the same time: <b>a and b are true</b>, <b>c is equal to \\\"Hello World\\\"</b> and <b>the negation of variable d (using !) is false</b>.\",\"editorMode\":\"JavaScript\",\"content\":\"//General structure of a if/else statement\\n\\nvar condition = true;\\n\\nif(condition){\\n  //If condition is met, this means if condition is true, this block of code will be executed\\n} else {\\n  //If the condition is not met, this means if the condition is false, this block of code will be executed.\\n}\\n\\nvar exampleLogic = function(a,b){\\n  return (a&&(b===5));\\n};\\n\\nvar logic = function(a,b,c,d){\\n  //Write your solution here\\n  \\n};\\n\\n\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var logic = variablesHash[\\\"logic\\\"];\\n  \\n  if(typeof logic === \\\"function\\\"){\\n    var testA = logic(true,true,\\\"Hello World\\\",true); //true\\n    var testB = logic(false,true,\\\"Hello World\\\",true); //false\\n    var testC = logic(true,false,\\\"Hello World\\\",true); //false\\n    var testD = logic(true,true,\\\"HelloWorld\\\",true); //false\\n    var testE = logic(true,true,\\\"Hello World\\\",false); //false\\n    if((testA===true)&&(testB===false)&&(testC===false)&&(testD===false)&&(testE===false)){\\n      grade.successes.push(\\\"Correcto.\\\");\\n      grade.score += 10;\\n    } else {\\n      if(testB===true){\\n         grade.feedback.push(\\\"Check variable 'a'.\\\");\\n      } else if (testC===true){\\n        grade.feedback.push(\\\"Check variable 'b'.\\\");\\n      } else if (testD===true){\\n        grade.feedback.push(\\\"Check variable 'c'.\\\");\\n      } else if (testE===true){\\n        grade.feedback.push(\\\"Check variable 'd'.\\\");\\n      }\\n      grade.errors.push(\\\"Function 'logic' does not work as expected.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"Función 'logic' not defined.\\\");\\n  }\\n  \\n  return grade;\\n};\\n\\n\\n/* \\n  Solución\\n  var logic = function(a,b,c,d){\\n    return (a&&(b)&&(c===\\\"Hola Mundo\\\")&&(d===true));\\n  };\\n*/\\n\\n\",\"score_function_vars\":[\"logic\"]},{\"type\":\"exercise\",\"title\":\"if-else statements (II)\",\"description\":\"It is possible to create if/else statements a little bit more complex using several variables.\\nAnalize this new example and fill in the function <code>logic</code> to return <b>\\\"A\\\" if 'number' is greater or equal to 10<b>, <b>\\\"B\\\" if 'number' is lower than 10 but greater than 5</b> and <b>\\\"C\\\" in any other case</b>.\",\"editorMode\":\"JavaScript\",\"content\":\"//General structure of an if-else sentence with several variables\\n\\nvar condition1 = false;\\nvar condition2 = true;\\n\\nif(condition1){\\n  //condition1===true\\n} else if(condition2) {\\n  //condition1!==true && condition2===true\\n} else {\\n  //condition1!==true && condition2!==true\\n}\\n\\n\\n\\n  var logic = function(number){\\n    if(number>=10){\\n      return \\\"A\\\";\\n    } else if(number>5){\\n      return \\\"B\\\";\\n    } else {\\n      return \\\"F\\\";\\n    }\\n  };\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var logic = variablesHash[\\\"logic\\\"];\\n  \\n  if(typeof logic === \\\"function\\\"){\\n    var testA = logic(20); //\\\"A\\\"\\n    var testB = logic(10); //\\\"A\\\"\\n    var testC = logic(7); //B\\n    var testD = logic(4); //C\\n    if((testA===\\\"A\\\")&&(testB===\\\"A\\\")&&(testC===\\\"B\\\")&&(testD===\\\"C\\\")){\\n      grade.successes.push(\\\"Right.\\\");\\n      grade.score += 10;\\n    } \\n    if((testA!==\\\"A\\\")||(testB!==\\\"A\\\")){\\n      grade.errors.push(\\\"Function 'logic' does not return 'A' if 'number' is greater or equal to 10.\\\");\\n    } \\n    if(testC!==\\\"B\\\"){\\n      grade.errors.push(\\\"Function 'logic' does not return 'b' if 'number' is lower than 10 but greater than 5.\\\");\\n    } \\n    if(testD!==\\\"C\\\"){\\n      grade.errors.push(\\\"Function 'logic' does not return 'C' in the rest of the cases.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"Function 'logic' is not defined.\\\");\\n  }\\n  \\n  return grade;\\n};\\n\\n\\n/* \\n  Solución\\n  var logic = function(number){\\n    if(number>=10){\\n      return \\\"A\\\";\\n    } else if(number>5){\\n      return \\\"B\\\";\\n    } else {\\n      return \\\"C\\\";\\n    }\\n  };\\n*/\",\"score_function_vars\":[\"logic\"]},{\"type\":\"exercise\",\"title\":\"Exercise about types and values\",\"description\":\"Using the function <b>typeof</b> fill in the function <code>add</code> so that:\\n* if the variables a and b are numbers, the function will return the addition of both.\\n* if variable a is a number but b is not, it will return a, but if b is a number but a isn't, then it will return b.\\n* if neither of both variables is a number, it will return the string \\\"Error\\\"\\n<i>Note:</i> use the expression <code>typeof var === \\\"number\\\"</code> to check the type of the variables.\",\"editorMode\":\"JavaScript\",\"content\":\"var add = function(a,b){\\n  //Write your solution here\\n};\\n\\n\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var add = variablesHash[\\\"add\\\"];\\n  \\n  if(typeof add === \\\"function\\\"){\\n    var testA = add(2,8); //10\\n    var testB = add(2); //2\\n    var testC = add(\\\"Dos\\\",8); //8\\n    var testD = add(); //\\\"Error\\\"\\n    if(typeof testD == \\\"string\\\"){\\n      testD = testD.toLowerCase().trim();\\n    }\\n    if((testA===10)&&(testB===2)&&(testC===8)&&(testD===\\\"error\\\")){\\n      grade.successes.push(\\\"Right.\\\");\\n      grade.score += 10;\\n    } else {\\n      if(testA!==10){\\n        grade.feedback.push(\\\"When a and b are numbers the function does not return the addition.\\\");\\n      } else if(testB!==2){\\n        grade.feedback.push(\\\"When a is a number but b is not the function should return the value of a.\\\");\\n      } else if(testC!==8){\\n        grade.feedback.push(\\\"When a is not a number, but b is, the function should return b.\\\");\\n      } else if(testD!==\\\"error\\\"){\\n        grade.feedback.push(\\\"When a and b are not numbers the function should return the word 'Error'.\\\");\\n      }\\n      grade.errors.push(\\\"Function 'add' does not work according to the wording.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"Function 'add' is not defined.\\\");\\n  }\\n\\n  return grade;\\n};\\n\\n/*\\n  Solución\\n  var add = function(a,b){\\n    if((typeof a == \\\"number\\\")&&(typeof b == \\\"number\\\")){\\n      return a+b;\\n    }\\n    if(typeof a == \\\"number\\\"){\\n      return a;\\n    }\\n    if(typeof b == \\\"number\\\"){\\n      return b;\\n    }\\n    return \\\"Error\\\";\\n  };\\n*/\",\"score_function_vars\":[\"add\"]}]","exercisesQuantity":8,"parsed_exercises":[{"type":"exercise","title":"Introduction","description":"To return the result of the exercises you have to use the <code>return</code> statement, as we show in this example.\nAfter the <code>return</code> statement the rest of the code will not be executed.\nIn this example, we return as a result the words \"Hello World\".\nClicking on the icon \"exec code\" you can see the result of the execution.\nThis test comprises several exercises. You can go to the next exercise by clicking on the test title \"Intro to JS: types and values\" where you can see a dropdown with the different exercises.","editorMode":"JavaScript","content":"return \"Hello World\";","progress":{"score":0,"passed":false},"id":1},{"type":"exercise","title":"'typeof' operator","description":"The <code>typeof</code> operator allows us to know the <b>type</b> of a <b>variable</b>.\nIn the next example you can see some variables with different types.\nUse the <b>typeof</b> operator to get the type of each one of them.\nFor this, you can replace the variable in the <code>return (typeof a);</code> statement.","editorMode":"JavaScript","content":"//Primitive types\nvar a = 5;\nvar b = \"Five\";\nvar c = true;\n\n//Objects\nvar d = {};\n\n//Special types\nvar e = undefined;\nvar f = null;\n\nreturn (typeof a);\n\n/*\n  Check that the types returned are the following ones:\n  Variable a type: 'number'\n  Numbers have type 'number'.\n  \n  Variable b type: 'string'\n  Text (words, paragraphs, ...) has type 'string'.\n  \n  Variable c type: 'boolean'\n  Boolean values are true and false.\n  \n  Variable d: 'object'\n  Any variable that is not a primitive type will be an object.\n  \n  Variable e type: 'undefined'\n  'undefined' is a special value, variables that have not been defined or initialized.\n  \n  Variable f: 'null'\n  'null' is another special value that represents the null object.\n\n*/","progress":{"score":0,"passed":false},"id":2},{"type":"exercise","title":"Numbers: type 'number'","description":"With variables of type 'number' we can apply all kind of mathematical operations.\nIn this exercise we have defined two functions: <code>add</code> and <code>subtract</code>.\nFill in the body of the function <code>multiply</code> to return the result of the multiplication of the a and b variables.","content":"var add = function(a,b){\n  return (a+b);\n};\n\nvar subtract = function(a,b){\n  return (a-b);\n};\n\nvar multiply = function(a,b){\n  //Write your solution here\n  \n};\n","editorMode":"JavaScript","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var multiply = variablesHash[\"multiply\"];\n  \n  if(typeof multiply != \"function\"){\n    grade.errors.push(\"'multiply' function not found.\");\n  } else {\n    var testA = multiply(5,5);\n    if((multiply(5,4)===20)&&(multiply(3,7)===21)&&(multiply(3,0)===0)){\n      grade.score = 10;\n    } else {\n      grade.errors.push(\"Function 'multiply' does not work as expected.\");\n    }\n  }\n\n  return grade;\n};","score_function_vars":["multiply"],"id":3},{"type":"exercise","title":"Booleans: type 'boolean'","description":"There are only two boolean types: 'true' and 'false'.\nThe unary operator <b><code>!</code></b> changes a logical value to the opposite.\nBooleans are used to take decissions in conditional statements <b>if/else</b>.\nIn this example we show a conditional statement using boolean variables. Analize it.\n<i>Clarification:</i> the expression <code> result += s </code> is equivalent to <code> result = result + s </code>.","editorMode":"JavaScript","content":"var a = true;\nvar b = false;\nvar c = !b;\n\nvar result = \"\";\n\nif(a){\n  result += \"Variable A is true.\\n\"\n} else {\n  result += \"Variable A is false.\\n\"\n}\n\nif(b){\n  result += \"Variable B is true.\\n\"\n} else {\n  result += \"Variable B is false.\\n\"\n}\n\nif(c){\n  result += \"Variable C is true.\"\n} else {\n  result += \"Variable C is false.\"\n}\n\nreturn result;\n\n","progress":{"score":0,"passed":false},"id":4},{"type":"exercise","title":"Identity, comparation and logical operators","description":"All these operators return a boolean type (true or false)\nCheck the restuls of the <b>c-h</b> variables and analize these results","editorMode":"JavaScript","content":"var n = 20;\nvar a = true;\nvar b = false;\n\n\n/*\n Identity or strict equality: \"===\"\n Returns \"true\" when both variables are equal in type and value.\n c will be \"true\" because 20 (n value) is equal to 10+10\n*/\nvar c = (n===(10+10)); \n\n\n/*\n Strict inequality: \"!==\"\n Returns \"true\" when both variables are different in type or value.\n d will be \"false\" because 20 (n value) is different to 10+10\n*/\nvar d = (n!==(10+10)); \n\n\n/*\n Comparison operators:\n \">\": greater than\n \"<\": lower than\n \">=\": greater or equal than\n \"<=\": lower or equal than\n Return \"true\" when the condition is met\n e will be \"true\" because 20 is greater than 10.\n f will be \"false\" because 20 is not lower or equal than 10.\n*/\nvar e = (n>10);\nvar f = (n<=10);\n\n\n/*\n Logical operators\n &&: AND\n ||: OR\n g will be \"true\" if and only if a and b are also true.\n h will be \"true\" if a is \"true\" or b is \"true\"\n*/\n\nvar g = (a&&b); //In this case it will be \"false\" because \"b\" is false.\nvar h = (a||b); //In this case it will be \"true\" because \"a\" is \"true\".\n\n\n//Check the value of any of the c-h variables:\nreturn c;\n\n","progress":{"score":0,"passed":false},"id":5},{"type":"exercise","title":"if-else statements","description":"If/else statements allow the execution of blocks of code in a conditional way.\nIn this exercise the general structure of the if/else statement is shown. Together with the function <code>exampleLogic</code> that returns \"true\" when \"a\" is \"true\" and b is equal to the number 5.\nFill in the function <code>logic</code> to return \"true\" only when all the next conditions are met at the same time: <b>a and b are true</b>, <b>c is equal to \"Hello World\"</b> and <b>the negation of variable d (using !) is false</b>.","editorMode":"JavaScript","content":"//General structure of a if/else statement\n\nvar condition = true;\n\nif(condition){\n  //If condition is met, this means if condition is true, this block of code will be executed\n} else {\n  //If the condition is not met, this means if the condition is false, this block of code will be executed.\n}\n\nvar exampleLogic = function(a,b){\n  return (a&&(b===5));\n};\n\nvar logic = function(a,b,c,d){\n  //Write your solution here\n  \n};\n\n","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var logic = variablesHash[\"logic\"];\n  \n  if(typeof logic === \"function\"){\n    var testA = logic(true,true,\"Hello World\",true); //true\n    var testB = logic(false,true,\"Hello World\",true); //false\n    var testC = logic(true,false,\"Hello World\",true); //false\n    var testD = logic(true,true,\"HelloWorld\",true); //false\n    var testE = logic(true,true,\"Hello World\",false); //false\n    if((testA===true)&&(testB===false)&&(testC===false)&&(testD===false)&&(testE===false)){\n      grade.successes.push(\"Correcto.\");\n      grade.score += 10;\n    } else {\n      if(testB===true){\n         grade.feedback.push(\"Check variable 'a'.\");\n      } else if (testC===true){\n        grade.feedback.push(\"Check variable 'b'.\");\n      } else if (testD===true){\n        grade.feedback.push(\"Check variable 'c'.\");\n      } else if (testE===true){\n        grade.feedback.push(\"Check variable 'd'.\");\n      }\n      grade.errors.push(\"Function 'logic' does not work as expected.\");\n    }\n  } else {\n    grade.errors.push(\"Función 'logic' not defined.\");\n  }\n  \n  return grade;\n};\n\n\n/* \n  Solución\n  var logic = function(a,b,c,d){\n    return (a&&(b)&&(c===\"Hola Mundo\")&&(d===true));\n  };\n*/\n\n","score_function_vars":["logic"],"id":6},{"type":"exercise","title":"if-else statements (II)","description":"It is possible to create if/else statements a little bit more complex using several variables.\nAnalize this new example and fill in the function <code>logic</code> to return <b>\"A\" if 'number' is greater or equal to 10<b>, <b>\"B\" if 'number' is lower than 10 but greater than 5</b> and <b>\"C\" in any other case</b>.","editorMode":"JavaScript","content":"//General structure of an if-else sentence with several variables\n\nvar condition1 = false;\nvar condition2 = true;\n\nif(condition1){\n  //condition1===true\n} else if(condition2) {\n  //condition1!==true && condition2===true\n} else {\n  //condition1!==true && condition2!==true\n}\n\n\n\n  var logic = function(number){\n    if(number>=10){\n      return \"A\";\n    } else if(number>5){\n      return \"B\";\n    } else {\n      return \"F\";\n    }\n  };","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var logic = variablesHash[\"logic\"];\n  \n  if(typeof logic === \"function\"){\n    var testA = logic(20); //\"A\"\n    var testB = logic(10); //\"A\"\n    var testC = logic(7); //B\n    var testD = logic(4); //C\n    if((testA===\"A\")&&(testB===\"A\")&&(testC===\"B\")&&(testD===\"C\")){\n      grade.successes.push(\"Right.\");\n      grade.score += 10;\n    } \n    if((testA!==\"A\")||(testB!==\"A\")){\n      grade.errors.push(\"Function 'logic' does not return 'A' if 'number' is greater or equal to 10.\");\n    } \n    if(testC!==\"B\"){\n      grade.errors.push(\"Function 'logic' does not return 'b' if 'number' is lower than 10 but greater than 5.\");\n    } \n    if(testD!==\"C\"){\n      grade.errors.push(\"Function 'logic' does not return 'C' in the rest of the cases.\");\n    }\n  } else {\n    grade.errors.push(\"Function 'logic' is not defined.\");\n  }\n  \n  return grade;\n};\n\n\n/* \n  Solución\n  var logic = function(number){\n    if(number>=10){\n      return \"A\";\n    } else if(number>5){\n      return \"B\";\n    } else {\n      return \"C\";\n    }\n  };\n*/","score_function_vars":["logic"],"id":7},{"type":"exercise","title":"Exercise about types and values","description":"Using the function <b>typeof</b> fill in the function <code>add</code> so that:\n* if the variables a and b are numbers, the function will return the addition of both.\n* if variable a is a number but b is not, it will return a, but if b is a number but a isn't, then it will return b.\n* if neither of both variables is a number, it will return the string \"Error\"\n<i>Note:</i> use the expression <code>typeof var === \"number\"</code> to check the type of the variables.","editorMode":"JavaScript","content":"var add = function(a,b){\n  //Write your solution here\n};\n\n","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var add = variablesHash[\"add\"];\n  \n  if(typeof add === \"function\"){\n    var testA = add(2,8); //10\n    var testB = add(2); //2\n    var testC = add(\"Dos\",8); //8\n    var testD = add(); //\"Error\"\n    if(typeof testD == \"string\"){\n      testD = testD.toLowerCase().trim();\n    }\n    if((testA===10)&&(testB===2)&&(testC===8)&&(testD===\"error\")){\n      grade.successes.push(\"Right.\");\n      grade.score += 10;\n    } else {\n      if(testA!==10){\n        grade.feedback.push(\"When a and b are numbers the function does not return the addition.\");\n      } else if(testB!==2){\n        grade.feedback.push(\"When a is a number but b is not the function should return the value of a.\");\n      } else if(testC!==8){\n        grade.feedback.push(\"When a is not a number, but b is, the function should return b.\");\n      } else if(testD!==\"error\"){\n        grade.feedback.push(\"When a and b are not numbers the function should return the word 'Error'.\");\n      }\n      grade.errors.push(\"Function 'add' does not work according to the wording.\");\n    }\n  } else {\n    grade.errors.push(\"Function 'add' is not defined.\");\n  }\n\n  return grade;\n};\n\n/*\n  Solución\n  var add = function(a,b){\n    if((typeof a == \"number\")&&(typeof b == \"number\")){\n      return a+b;\n    }\n    if(typeof a == \"number\"){\n      return a;\n    }\n    if(typeof b == \"number\"){\n      return b;\n    }\n    return \"Error\";\n  };\n*/","score_function_vars":["add"],"id":8}],"metadata":{"title":"Intro to JS: types and values","language":"es"}}