var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"test","title":"Calculadora","exercises":"[{\"type\":\"exercise\",\"title\":\"Introducción\",\"description\":\"A continuación se muestra el código de una página HTML con una calculadora muy simple que permite realizar únicamente sumas con 2 operandos.\\nPulsando sobre el botón de <b>Ejecutar Código</b> (play) puedes visualizar la página HTML.\\nPulsando sobre el título <b>Calculadora</b> o el selector puedes acceder a los diferentes ejercicios de este test de autoevaluación.\\nPulsa el botón Ejecutar Código, prueba la calculadora y avanza al primer ejercicio.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"a) Etiquetas HTML\",\"description\":\"Añada al documento HTML una cabecera (mediante la etiqueta <code><header></code>) con identificador \\\"cabecera\\\", clase \\\"grande\\\", un atributo \\\"title\\\" con valor \\\"Cabecera principal\\\" y contenido \\\"Bienvenido a mi calculadora\\\".\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  //Existencia de la cabecera <header>.\\n\\tif($(document).find(\\\"header\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"No añadiste la cabecera <header>.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"La cabecera <header> debe estar dentro de <body>.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#cabecera\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"La cabecera <header> debe tener el identificador 'cabecera'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#cabecera.grande\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"La cabecera <header> debe tener la clase 'grande'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#cabecera.grande[title]\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"La cabecera <header> debe tener un atributo 'title'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"body header#cabecera.grande[title='Cabecera principal']\\\").length === 0){\\n\\t  \\tgrade.errors.push(\\\"La cabecera <header> debe tener un atributo 'title' con valor 'Cabecera principal'.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tvar header = $(document).find(\\\"body header#cabecera.grande[title='Cabecera principal']\\\");\\n\\tvar headerContent = $(header).html();\\n\\t\\n\\tif(headerContent.replace(/ +/g,\\\"\\\").toLowerCase().indexOf(\\\"bienvenidoamicalculadora\\\")==-1){\\n\\t  grade.errors.push(\\\"El contenido de la cabecera <header> debe ser 'Bienvenido a mi calculadora'.\\\");\\n\\t  return grade;\\n\\t}\\n\\t\\n  grade.score = 10;\\n  grade.successes.push(\\\"Perfecto.\\\");\\n\\n  return grade;\\n};\"},{\"type\":\"exercise\",\"title\":\"b) Estilos CSS\",\"description\":\"Complete y modifique el contenido de la etiqueta <code><style type=\\\"text/css\\\"></code> <b>sin modificar el arbol DOM de la página</b> para que:\\n* La pantalla de la calculadora tenga el fondo negro pero los números se muestren en color blanco.\\n* Todos los botones dentro de <code><div class=\\\"calculadora botonera\\\"></code> tengan fondo negro y letra blanca.\\n* Todos los botones dentro de <code><div class=\\\"calculadora botonera\\\"></code> con un atributo \\\"operacion\\\" igual a \\\"true\\\" tengan un borde de color azul.\\n* Todos los inputs de tipo texto (incluida la pantalla) tengan un borde de color rojo mientras que su <div> contenedor tenga la clase \\\"error\\\".\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n\\t<style type=\\\"text/css\\\">\\n\\t  /* Escriba aquí su solución */\\n\\t  #pantalla {\\n\\t    background: white;\\n\\t  }\\n\\t</style>\\n</head>\\n<body>\\n\\n\\t<div class=\\\"calculadora botonera\\\">\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\" operacion=\\\"true\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  //Replace content\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    var bodyContent = '<div class=\\\"calculadora botonera\\\"> Número: <input type=\\\"text\\\" id=\\\"pantalla\\\"> <button id=\\\"suma\\\" operacion=\\\"true\\\">+</button> <button id=\\\"igual\\\">=</button> <input id=\\\"test6\\\" operacion=\\\"true\\\" style=\\\"display:none\\\"> </div> <div id=\\\"test1\\\" class=\\\"calculadora\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operacion=\\\"true\\\">op</button> </div> <div id=\\\"test2\\\" class=\\\"botonera\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operacion=\\\"true\\\">op</button> </div> <article id=\\\"test3\\\" class=\\\"calculadora botonera\\\" style=\\\"display:none\\\"> <input> <button>b</button> <button operacion=\\\"true\\\">op</button> </article> <div id=\\\"test4\\\" class=\\\"error\\\" style=\\\"display:none\\\"> <input type=\\\"text\\\"> <input type=\\\"number\\\"> <div type=\\\"text\\\"></div> </div> <article id=\\\"test5\\\" class=\\\"error\\\" style=\\\"display:none\\\"> <input type=\\\"text\\\"> <input type=\\\"number\\\"> <div type=\\\"text\\\"></div> </article> <script type=\\\"text/javascript\\\"> var acc = 0; var op; $(document).ready(function(){ $(\\\"#pantalla\\\").click(function(){ $(this).val(\\\"\\\"); }); $(\\\"#suma\\\").click(function(){ acc = parseFloat($(\\\"#pantalla\\\").val()); op = \\\"+\\\"; }); $(\\\"#igual\\\").click(function(){ var n = parseFloat($(\\\"#pantalla\\\").val()); if(op === \\\"+\\\"){ acc += n; } else { acc = n; } $(\\\"#pantalla\\\").val(acc); acc = 0; op = undefined; }); }); </script>';\\n    $(document).find(\\\"body\\\").html(bodyContent);\\n    \\n    //Restore events\\n    $(document).find(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t});\\n\\t\\t$(document).find(\\\"#suma\\\").click(function(){\\n\\t\\t\\tacc = parseFloat($(document).find(\\\"#pantalla\\\").val());\\n\\t\\t\\top = \\\"+\\\";\\n\\t\\t});\\n\\t\\t$(document).find(\\\"#igual\\\").click(function(){\\n\\t\\t\\tvar n = parseFloat($(document).find(\\\"#pantalla\\\").val());\\n\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\tacc += n;\\n\\t\\t\\t} else {\\n\\t\\t\\t\\tacc = n;\\n\\t\\t\\t}\\n\\t\\t\\t$(document).find(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\tacc = 0;\\n\\t\\t\\top = undefined;\\n\\t\\t});\\n  }\\n  \\n  //Tests\\n\\tif($(document).find(\\\"#pantalla\\\").css(\\\"background-color\\\") != \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"La pantalla de la calculadora debería tener el fondo negro.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"#pantalla\\\").css(\\\"color\\\") != \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"La pantalla de la calculadora debería mostrar el texto en color blanco.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"input\\\").not(\\\"#pantalla\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Solo el <input> de la pantalla de la calculadora debería tener el fondo negro.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"input\\\").not(\\\"#pantalla\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  grade.errors.push(\\\"Solo el <input> de la pantalla de la calculadora debería mostrar el texto en color blanco.\\\");\\n\\t  return grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculadora.botonera button\\\").css(\\\"background-color\\\") != \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> deben tener fondo negro.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculadora.botonera button\\\").css(\\\"color\\\") != \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> deben tener letra blanca.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div.calculadora.botonera button[operacion='true']\\\").css(\\\"border-top-color\\\") != \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Todos los botones de <div class=\\\\\\\"calculadora botonera\\\\\\\"> que tengan un atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" deben tener borde azul.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\t//Check CSS double class selector\\n\\tif($(document).find(\\\"div#test2.botonera button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test2.botonera button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test2.botonera button[operacion='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> con atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test1.calculadora button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test1.calculadora button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div#test1.calculadora button[operacion='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> con atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"article#test3.calculadora.botonera button\\\").css(\\\"background-color\\\") == \\\"rgb(0, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"article#test3.calculadora.botonera button\\\").css(\\\"color\\\") == \\\"rgb(255, 255, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"article#test3.calculadora.botonera button[operacion='true']\\\").css(\\\"color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> con atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div.calculadora.botonera button[operacion!='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> con atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\tif($(document).find(\\\"div.calculadora.botonera input#test6[operacion='true']\\\").css(\\\"border-top-color\\\") == \\\"rgb(0, 0, 255)\\\"){\\n      grade.feedback.push()\\t     \\n\\t  \\tgrade.errors.push(\\\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\\\\\"calculadora botonera\\\\\\\"> con atributo \\\\\\\"operación\\\\\\\" igual a \\\\\\\"true\\\\\\\" no es correcto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div input[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Los inputs de tipo texto solo deberían tener borde rojo si su <div> contenedor tiene la clase \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error input[type='text']\\\").css(\\\"border-top-color\\\") != \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Los inputs de tipo texto deberían tener borde rojo si su <div> contenedor tiene la clase \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"article#test5.error input[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Los inputs de tipo texto solo deberían tener borde rojo si contenedor es un <div>.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error input[type!='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Los inputs solo deberían tener borde rojo si son de tipo texto.\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"div#test4.error div[type='text']\\\").css(\\\"border-top-color\\\") == \\\"rgb(255, 0, 0)\\\"){\\n\\t  \\tgrade.errors.push(\\\"Solamente los inputs y no otros elementos HTML deberían tener borde rojo si su <div> contenedor tiene la clase \\\\\\\"error\\\\\\\".\\\");\\n\\t  \\treturn grade;\\n\\t}\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n\\n  return grade;\\n};\"},{\"type\":\"exercise\",\"title\":\"c) Gestión de errores\",\"description\":\"Modifique la calculadora para que cuando alguno de los operandos introducidos sea una cadena de texto en lugar de un número muestre por la pantalla el mensaje <b>\\\"Error\\\"</b>.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#pantalla\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <input> con id 'pantalla'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#suma\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'suma'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#igual\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'igual'.\\\");\\n\\t}\\n\\t\\n  var pantalla = $(document).find(\\\"input#pantalla\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(5);\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(2);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 7){\\n    return returnWithError(document,content,grade,\\\"La función suma no funciona correctamente.\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(3);\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(7);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"La función suma no funciona correctamente.\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n  \\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\\n\"},{\"type\":\"exercise\",\"title\":\"d) Multiplicación\",\"description\":\"Añada un nuevo botón a la calculadora con identificador \\\"multiplicacion\\\" y texto \\\"x\\\" que permita realizar multiplicaciones con dos operandos.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#pantalla\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <input> con id 'pantalla'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#suma\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'suma'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#igual\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'igual'.\\\");\\n\\t}\\n\\tvar multiplicacion;\\n\\tif($(document).find(\\\"button#multiplicacion\\\").length === 0){\\n\\t  return returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'multiplicacion'.\\\");\\n\\t} else {\\n\\t   multiplicacion = $(document).find(\\\"button#multiplicacion\\\");\\n\\t}\\n\\t\\n\\tif($(multiplicacion).html().toLowerCase().trim() != \\\"x\\\"){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"El <button> con id 'multiplicacion' debe tener el texto \\\\\\\"x\\\\\\\".\\\");\\n\\t}\\n\\t\\n  var pantalla = $(document).find(\\\"input#pantalla\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(5);\\n  $(multiplicacion).trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(2);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"La función multiplicación no funciona correctamente\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(3);\\n  $(multiplicacion).trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(7);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 21){\\n    return returnWithError(document,content,grade,\\\"La función multiplicación no funciona correctamente\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(multiplicacion).trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(multiplicacion).trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(multiplicacion).trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\"},{\"type\":\"exercise\",\"title\":\"e) Función f(b,x)\",\"description\":\"Añada un nuevo botón a la calculadora con identificador \\\"fbx\\\" y texto \\\"f(b,x)\\\" que implemente la siguiente operación matemática: <code> f(b,x) = logb(x) = log10(x)/log10(b) </code>. \\nDonde <code>logb(x)</code> es el logaritmo en base <b>b</b> de <b>x</b>, y las variables b y x son, respectivamente, el primer y segundo operando introducido en la calculadora.\\nLa función deberá mostrar por la pantalla el mensaje \\\"Error\\\" si <b>b no es un numero natural mayor de 1</b> o si <b>x no es un número real positivo</b>.\\nDe este modo, al realizar la siguiente interacción (2)[f(b,x)](8) el resultado final mostrado por la pantalla debería ser 3.\\n<i>NOTA: Puede utilizar la función de JavaScript <code>Math.log10</code> para calcular logaritmos en base 10.</i>\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#pantalla\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <input> con id 'pantalla'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#suma\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'suma'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#igual\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'igual'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#fbx\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'fbx'.\\\");\\n\\t}\\n\\t\\n\\tif($(document).find(\\\"button#fbx\\\").html().toLowerCase().trim() != \\\"f(b,x)\\\"){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"El <button> con id 'multiplicacion' debe tener el texto \\\\\\\"f(b,x)\\\\\\\".\\\");\\n\\t}\\n\\t\\n  var pantalla = $(document).find(\\\"input#pantalla\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(2);\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(8);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(Math.abs(3-parseFloat($(pantalla).val())) > 0.1){\\n    return returnWithError(document,content,grade,\\\"La función f(b,x) no funciona correctamente\\\");\\n  }\\n  \\n  var pantalla = $(document).find(\\\"input#pantalla\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(5);\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(625);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(Math.abs(4-parseFloat($(pantalla).val())) > 0.1){\\n    return returnWithError(document,content,grade,\\\"La función f(b,x) no funciona correctamente\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  //B natural negativo\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"-2\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"125\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'b' sea un número negativo\\\");\\n  }\\n  \\n  //B=1\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"1\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"125\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'b' no sea mayor de 1\\\");\\n  }\\n  \\n  //B decimal\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"2.5\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"125\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'b' no sea un número natural\\\");\\n  }\\n  \\n  //X negativo\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"-125\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'x' no sea un número real positivo\\\");\\n  }\\n  \\n  //X decimal positivo\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"125.5\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() == \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora no debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'x' sea un número real positivo\\\");\\n  }\\n  \\n  //X=0\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"3\\\");\\n  $(document).find(\\\"button#fbx\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"0\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando el operando 'x' sea 0\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\"},{\"type\":\"exercise\",\"title\":\"f) Contador de errores\",\"description\":\"Este apartado muestra una modificación de la calculadora que muestra por pantalla el mensaje <b>\\\"Error\\\"</b> cuando alguno de los operandos introducidos es una cadena de texto en lugar de un número. Realice las siguientes modificaciones:\\n1) Añada un <i><div></i> con identificador \\\"contador\\\" que muestre la cantidad de errores producidos en la calculadora. El contador empezará con el valor 0 y se incrementará en 1 cada vez que se muestre un error en la pantalla de la calculadora.\\n2) Haga uso de la clase <i>error</i> definida en la etiqueta <code><style></code> para que los mensajes \\\"Error\\\" se muestren de color rojo en la pantalla de la calculadora, pero el resto de valores se muestren con el color habitual.\",\"editorMode\":\"HTML\",\"content\":\"<!DOCTYPE html>\\n<html>\\n<head>\\n\\t<title>Calculadora</title>\\n\\t<meta charset=\\\"utf-8\\\">\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar protocol = (document.location.protocol==\\\"file:\\\" ? \\\"http:\\\" : document.location.protocol);\\n\\t\\tdocument.write(unescape(\\\"%3Cscript src='\\\" + protocol + \\\"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\\\"));\\n\\t</script>\\n\\t<style type=\\\"text/css\\\">\\n\\t  .error {\\n\\t    color: red;\\n\\t  }\\n\\t</style>\\n</head>\\n<body>\\n\\n\\t<div>\\n\\t\\tNúmero: <input type=\\\"text\\\" id=\\\"pantalla\\\"/>\\n\\t\\t<button id=\\\"suma\\\">+</button>\\n\\t\\t<button id=\\\"igual\\\">=</button>\\n\\t</div>\\n\\n\\t<script type=\\\"text/javascript\\\">\\n\\t\\tvar acc = 0;\\n\\t\\tvar op;\\n\\n\\t\\t$(document).ready(function(){ \\n\\t\\t\\t$(\\\"#pantalla\\\").click(function(){\\n\\t\\t\\t\\t$(this).val(\\\"\\\");\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#suma\\\").click(function(){\\n\\t\\t\\t\\tacc = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\top = \\\"+\\\";\\n\\t\\t\\t});\\n\\t\\t\\t$(\\\"#igual\\\").click(function(){\\n\\t\\t\\t\\tvar n = parseFloat($(\\\"#pantalla\\\").val());\\n\\t\\t\\t\\tif(op === \\\"+\\\"){\\n\\t\\t\\t\\t\\tacc += n;\\n\\t\\t\\t\\t} else {\\n\\t\\t\\t\\t\\tacc = n;\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\tif((typeof acc != \\\"number\\\")||(isNaN(acc))){\\n\\t\\t\\t\\t\\tacc = \\\"Error\\\";\\n\\t\\t\\t\\t}\\n\\t\\t\\t\\t$(\\\"#pantalla\\\").val(acc);\\n\\t\\t\\t\\tacc = 0;\\n\\t\\t\\t\\top = undefined;\\n\\t\\t\\t});\\n\\t\\t});\\n\\t</script>\\n</body>\\n</html>\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(document){\\n  var grade = {};\\n  grade.score = 0;\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  \\n  //Content\\n  var content;\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")){\\n    content = document.documentElement.outerHTML;\\n  }\\n  \\n  //Existencia de elementos del DOM.\\n\\tif($(document).find(\\\"input#pantalla\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <input> con id 'pantalla'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#suma\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'suma'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"button#igual\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <button> con id 'igual'.\\\");\\n\\t}\\n\\tif($(document).find(\\\"div#contador\\\").length === 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"No se encontró el <div> con id 'contador'.\\\");\\n\\t}\\n\\tif(parseInt($(document).find(\\\"div#contador\\\").html()) != 0){\\n\\t  \\treturn returnWithError(document,content,grade,\\\"El contador debería tener un valor inicial de 0.\\\");\\n\\t}\\n\\t\\n  var pantalla = $(document).find(\\\"input#pantalla\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(5);\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(2);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 7){\\n    return returnWithError(document,content,grade,\\\"La función suma no funciona correctamente\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(3);\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(7);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"La función suma no funciona correctamente\\\");\\n  }\\n  \\n  //Trigger error\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Gato\\\");\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(\\\"Perro\\\");\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  if(parseInt($(document).find(\\\"div#contador\\\").html()) != 1){\\n\\t  return returnWithError(document,content,grade,\\\"El contador debería tener un valor de 1 después de producirse un error.\\\");\\n\\t}\\n\\t\\n\\tvar errorsToTrigger = 5;\\n\\tfor(var i=0; i<errorsToTrigger; i++){\\n  \\t//Trigger error\\n    $(pantalla).trigger(\\\"click\\\");\\n    $(pantalla).val(\\\"Gato\\\");\\n    $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n    $(pantalla).trigger(\\\"click\\\");\\n    $(pantalla).val(\\\"Perro\\\");\\n    $(document).find(\\\"#igual\\\").trigger(\\\"click\\\"); \\n\\t}\\n\\n  if($(pantalla).val() != \\\"Error\\\"){\\n    return returnWithError(document,content,grade,\\\"La calculadora debería mostrar \\\\\\\"Error\\\\\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\\\");\\n  }\\n  \\n  if(parseInt($(document).find(\\\"div#contador\\\").html()) != (errorsToTrigger+1)){\\n\\t  return returnWithError(document,content,grade,\\\"El contador no cuenta correctamente los errores.\\\");\\n\\t}\\n\\t\\n\\tif(!$(pantalla).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"La pantalla de la calculadora debería tener la clase 'error' al mostrar los mensajes de texto \\\\\\\"Error\\\\\\\".\\\");\\n  }\\n  \\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(3);\\n  if($(pantalla).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"La pantalla de la calculadora solo debería tener la clase 'error' al mostrar los mensajes de error.\\\");\\n  }\\n  $(document).find(\\\"#suma\\\").trigger(\\\"click\\\");\\n  $(pantalla).trigger(\\\"click\\\");\\n  $(pantalla).val(7);\\n  $(document).find(\\\"#igual\\\").trigger(\\\"click\\\");\\n  \\n  if(parseFloat($(pantalla).val()) != 10){\\n    return returnWithError(document,content,grade,\\\"La función suma no funciona correctamente tras producirse un error.\\\");\\n  }\\n  \\n  if($(pantalla).hasClass(\\\"error\\\")){\\n    return returnWithError(document,content,grade,\\\"La pantalla de la calculadora solo debería tener la clase 'error' al mostrar los mensajes de error.\\\");\\n  }\\n\\n  grade.score = 10;\\n  grade.successes.push(\\\"Correcto.\\\");\\n\\n  resetState(document,content);\\n  return grade;\\n};\\n\\nvar returnWithError = function(document,content,grade,msg){\\n  resetState(document,content);\\n  grade.errors.push(msg);\\n  return grade;\\n};\\n\\nvar resetState = function(document,content){\\n  if((typeof document != \\\"undefined\\\")&&(typeof document.documentElement != \\\"undefined\\\")&&(typeof content != \\\"undefined\\\")){\\n\\t  document.open();\\n\\t  document.writeln(content);\\n\\t  document.close();\\n  }\\n};\\n\\n\"}]","exercisesQuantity":7,"parsed_exercises":[{"type":"exercise","title":"Introducción","description":"A continuación se muestra el código de una página HTML con una calculadora muy simple que permite realizar únicamente sumas con 2 operandos.\nPulsando sobre el botón de <b>Ejecutar Código</b> (play) puedes visualizar la página HTML.\nPulsando sobre el título <b>Calculadora</b> o el selector puedes acceder a los diferentes ejercicios de este test de autoevaluación.\nPulsa el botón Ejecutar Código, prueba la calculadora y avanza al primer ejercicio.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"id":1},{"type":"exercise","title":"a) Etiquetas HTML","description":"Añada al documento HTML una cabecera (mediante la etiqueta <code><header></code>) con identificador \"cabecera\", clase \"grande\", un atributo \"title\" con valor \"Cabecera principal\" y contenido \"Bienvenido a mi calculadora\".","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  //Existencia de la cabecera <header>.\n\tif($(document).find(\"header\").length === 0){\n\t  \tgrade.errors.push(\"No añadiste la cabecera <header>.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header\").length === 0){\n\t  \tgrade.errors.push(\"La cabecera <header> debe estar dentro de <body>.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#cabecera\").length === 0){\n\t  \tgrade.errors.push(\"La cabecera <header> debe tener el identificador 'cabecera'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#cabecera.grande\").length === 0){\n\t  \tgrade.errors.push(\"La cabecera <header> debe tener la clase 'grande'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#cabecera.grande[title]\").length === 0){\n\t  \tgrade.errors.push(\"La cabecera <header> debe tener un atributo 'title'.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"body header#cabecera.grande[title='Cabecera principal']\").length === 0){\n\t  \tgrade.errors.push(\"La cabecera <header> debe tener un atributo 'title' con valor 'Cabecera principal'.\");\n\t  \treturn grade;\n\t}\n\tvar header = $(document).find(\"body header#cabecera.grande[title='Cabecera principal']\");\n\tvar headerContent = $(header).html();\n\t\n\tif(headerContent.replace(/ +/g,\"\").toLowerCase().indexOf(\"bienvenidoamicalculadora\")==-1){\n\t  grade.errors.push(\"El contenido de la cabecera <header> debe ser 'Bienvenido a mi calculadora'.\");\n\t  return grade;\n\t}\n\t\n  grade.score = 10;\n  grade.successes.push(\"Perfecto.\");\n\n  return grade;\n};","id":2},{"type":"exercise","title":"b) Estilos CSS","description":"Complete y modifique el contenido de la etiqueta <code><style type=\"text/css\"></code> <b>sin modificar el arbol DOM de la página</b> para que:\n* La pantalla de la calculadora tenga el fondo negro pero los números se muestren en color blanco.\n* Todos los botones dentro de <code><div class=\"calculadora botonera\"></code> tengan fondo negro y letra blanca.\n* Todos los botones dentro de <code><div class=\"calculadora botonera\"></code> con un atributo \"operacion\" igual a \"true\" tengan un borde de color azul.\n* Todos los inputs de tipo texto (incluida la pantalla) tengan un borde de color rojo mientras que su <div> contenedor tenga la clase \"error\".","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n\t<style type=\"text/css\">\n\t  /* Escriba aquí su solución */\n\t  #pantalla {\n\t    background: white;\n\t  }\n\t</style>\n</head>\n<body>\n\n\t<div class=\"calculadora botonera\">\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\" operacion=\"true\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  //Replace content\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    var bodyContent = '<div class=\"calculadora botonera\"> Número: <input type=\"text\" id=\"pantalla\"> <button id=\"suma\" operacion=\"true\">+</button> <button id=\"igual\">=</button> <input id=\"test6\" operacion=\"true\" style=\"display:none\"> </div> <div id=\"test1\" class=\"calculadora\" style=\"display:none\"> <input> <button>b</button> <button operacion=\"true\">op</button> </div> <div id=\"test2\" class=\"botonera\" style=\"display:none\"> <input> <button>b</button> <button operacion=\"true\">op</button> </div> <article id=\"test3\" class=\"calculadora botonera\" style=\"display:none\"> <input> <button>b</button> <button operacion=\"true\">op</button> </article> <div id=\"test4\" class=\"error\" style=\"display:none\"> <input type=\"text\"> <input type=\"number\"> <div type=\"text\"></div> </div> <article id=\"test5\" class=\"error\" style=\"display:none\"> <input type=\"text\"> <input type=\"number\"> <div type=\"text\"></div> </article> <script type=\"text/javascript\"> var acc = 0; var op; $(document).ready(function(){ $(\"#pantalla\").click(function(){ $(this).val(\"\"); }); $(\"#suma\").click(function(){ acc = parseFloat($(\"#pantalla\").val()); op = \"+\"; }); $(\"#igual\").click(function(){ var n = parseFloat($(\"#pantalla\").val()); if(op === \"+\"){ acc += n; } else { acc = n; } $(\"#pantalla\").val(acc); acc = 0; op = undefined; }); }); </script>';\n    $(document).find(\"body\").html(bodyContent);\n    \n    //Restore events\n    $(document).find(\"#pantalla\").click(function(){\n\t\t\t$(this).val(\"\");\n\t\t});\n\t\t$(document).find(\"#suma\").click(function(){\n\t\t\tacc = parseFloat($(document).find(\"#pantalla\").val());\n\t\t\top = \"+\";\n\t\t});\n\t\t$(document).find(\"#igual\").click(function(){\n\t\t\tvar n = parseFloat($(document).find(\"#pantalla\").val());\n\t\t\tif(op === \"+\"){\n\t\t\t\tacc += n;\n\t\t\t} else {\n\t\t\t\tacc = n;\n\t\t\t}\n\t\t\t$(document).find(\"#pantalla\").val(acc);\n\t\t\tacc = 0;\n\t\t\top = undefined;\n\t\t});\n  }\n  \n  //Tests\n\tif($(document).find(\"#pantalla\").css(\"background-color\") != \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"La pantalla de la calculadora debería tener el fondo negro.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"#pantalla\").css(\"color\") != \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"La pantalla de la calculadora debería mostrar el texto en color blanco.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"input\").not(\"#pantalla\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"Solo el <input> de la pantalla de la calculadora debería tener el fondo negro.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"input\").not(\"#pantalla\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  grade.errors.push(\"Solo el <input> de la pantalla de la calculadora debería mostrar el texto en color blanco.\");\n\t  return grade;\n\t}\n\t\n\tif($(document).find(\"div.calculadora.botonera button\").css(\"background-color\") != \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"Todos los botones dentro de <div class=\\\"calculadora botonera\\\"> deben tener fondo negro.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div.calculadora.botonera button\").css(\"color\") != \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"Todos los botones dentro de <div class=\\\"calculadora botonera\\\"> deben tener letra blanca.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div.calculadora.botonera button[operacion='true']\").css(\"border-top-color\") != \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"Todos los botones de <div class=\\\"calculadora botonera\\\"> que tengan un atributo \\\"operación\\\" igual a \\\"true\\\" deben tener borde azul.\");\n\t  \treturn grade;\n\t}\n\t\n\t//Check CSS double class selector\n\tif($(document).find(\"div#test2.botonera button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test2.botonera button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test2.botonera button[operacion='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> con atributo \\\"operación\\\" igual a \\\"true\\\" no es correcto.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test1.calculadora button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test1.calculadora button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div#test1.calculadora button[operacion='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> con atributo \\\"operación\\\" igual a \\\"true\\\" no es correcto.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"article#test3.calculadora.botonera button\").css(\"background-color\") == \"rgb(0, 0, 0)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"article#test3.calculadora.botonera button\").css(\"color\") == \"rgb(255, 255, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"article#test3.calculadora.botonera button[operacion='true']\").css(\"color\") == \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> con atributo \\\"operación\\\" igual a \\\"true\\\" no es correcto.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div.calculadora.botonera button[operacion!='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> con atributo \\\"operación\\\" igual a \\\"true\\\" no es correcto.\");\n\t  \treturn grade;\n\t}\n\tif($(document).find(\"div.calculadora.botonera input#test6[operacion='true']\").css(\"border-top-color\") == \"rgb(0, 0, 255)\"){\n      grade.feedback.push()\t     \n\t  \tgrade.errors.push(\"El selector CSS para aplicar el estilo a todos los botones dentro de <div class=\\\"calculadora botonera\\\"> con atributo \\\"operación\\\" igual a \\\"true\\\" no es correcto.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div input[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Los inputs de tipo texto solo deberían tener borde rojo si su <div> contenedor tiene la clase \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error input[type='text']\").css(\"border-top-color\") != \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Los inputs de tipo texto deberían tener borde rojo si su <div> contenedor tiene la clase \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"article#test5.error input[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Los inputs de tipo texto solo deberían tener borde rojo si contenedor es un <div>.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error input[type!='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Los inputs solo deberían tener borde rojo si son de tipo texto.\");\n\t  \treturn grade;\n\t}\n\t\n\tif($(document).find(\"div#test4.error div[type='text']\").css(\"border-top-color\") == \"rgb(255, 0, 0)\"){\n\t  \tgrade.errors.push(\"Solamente los inputs y no otros elementos HTML deberían tener borde rojo si su <div> contenedor tiene la clase \\\"error\\\".\");\n\t  \treturn grade;\n\t}\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n\n  return grade;\n};","id":3},{"type":"exercise","title":"c) Gestión de errores","description":"Modifique la calculadora para que cuando alguno de los operandos introducidos sea una cadena de texto en lugar de un número muestre por la pantalla el mensaje <b>\"Error\"</b>.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#pantalla\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <input> con id 'pantalla'.\");\n\t}\n\tif($(document).find(\"button#suma\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'suma'.\");\n\t}\n\tif($(document).find(\"button#igual\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'igual'.\");\n\t}\n\t\n  var pantalla = $(document).find(\"input#pantalla\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(5);\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(2);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 7){\n    return returnWithError(document,content,grade,\"La función suma no funciona correctamente.\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(3);\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(7);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 10){\n    return returnWithError(document,content,grade,\"La función suma no funciona correctamente.\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n  \n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};\n","id":4},{"type":"exercise","title":"d) Multiplicación","description":"Añada un nuevo botón a la calculadora con identificador \"multiplicacion\" y texto \"x\" que permita realizar multiplicaciones con dos operandos.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#pantalla\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <input> con id 'pantalla'.\");\n\t}\n\tif($(document).find(\"button#suma\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'suma'.\");\n\t}\n\tif($(document).find(\"button#igual\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'igual'.\");\n\t}\n\tvar multiplicacion;\n\tif($(document).find(\"button#multiplicacion\").length === 0){\n\t  return returnWithError(document,content,grade,\"No se encontró el <button> con id 'multiplicacion'.\");\n\t} else {\n\t   multiplicacion = $(document).find(\"button#multiplicacion\");\n\t}\n\t\n\tif($(multiplicacion).html().toLowerCase().trim() != \"x\"){\n\t  \treturn returnWithError(document,content,grade,\"El <button> con id 'multiplicacion' debe tener el texto \\\"x\\\".\");\n\t}\n\t\n  var pantalla = $(document).find(\"input#pantalla\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(5);\n  $(multiplicacion).trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(2);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 10){\n    return returnWithError(document,content,grade,\"La función multiplicación no funciona correctamente\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(3);\n  $(multiplicacion).trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(7);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 21){\n    return returnWithError(document,content,grade,\"La función multiplicación no funciona correctamente\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(multiplicacion).trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(multiplicacion).trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(multiplicacion).trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};","id":5},{"type":"exercise","title":"e) Función f(b,x)","description":"Añada un nuevo botón a la calculadora con identificador \"fbx\" y texto \"f(b,x)\" que implemente la siguiente operación matemática: <code> f(b,x) = logb(x) = log10(x)/log10(b) </code>. \nDonde <code>logb(x)</code> es el logaritmo en base <b>b</b> de <b>x</b>, y las variables b y x son, respectivamente, el primer y segundo operando introducido en la calculadora.\nLa función deberá mostrar por la pantalla el mensaje \"Error\" si <b>b no es un numero natural mayor de 1</b> o si <b>x no es un número real positivo</b>.\nDe este modo, al realizar la siguiente interacción (2)[f(b,x)](8) el resultado final mostrado por la pantalla debería ser 3.\n<i>NOTA: Puede utilizar la función de JavaScript <code>Math.log10</code> para calcular logaritmos en base 10.</i>","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#pantalla\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <input> con id 'pantalla'.\");\n\t}\n\tif($(document).find(\"button#suma\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'suma'.\");\n\t}\n\tif($(document).find(\"button#igual\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'igual'.\");\n\t}\n\tif($(document).find(\"button#fbx\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'fbx'.\");\n\t}\n\t\n\tif($(document).find(\"button#fbx\").html().toLowerCase().trim() != \"f(b,x)\"){\n\t  \treturn returnWithError(document,content,grade,\"El <button> con id 'multiplicacion' debe tener el texto \\\"f(b,x)\\\".\");\n\t}\n\t\n  var pantalla = $(document).find(\"input#pantalla\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(2);\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(8);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(Math.abs(3-parseFloat($(pantalla).val())) > 0.1){\n    return returnWithError(document,content,grade,\"La función f(b,x) no funciona correctamente\");\n  }\n  \n  var pantalla = $(document).find(\"input#pantalla\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(5);\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(625);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(Math.abs(4-parseFloat($(pantalla).val())) > 0.1){\n    return returnWithError(document,content,grade,\"La función f(b,x) no funciona correctamente\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  //B natural negativo\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"-2\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"125\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando el operando 'b' sea un número negativo\");\n  }\n  \n  //B=1\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"1\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"125\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando el operando 'b' no sea mayor de 1\");\n  }\n  \n  //B decimal\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"2.5\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"125\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando el operando 'b' no sea un número natural\");\n  }\n  \n  //X negativo\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"-125\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando el operando 'x' no sea un número real positivo\");\n  }\n  \n  //X decimal positivo\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"125.5\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() == \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora no debería mostrar \\\"Error\\\" cuando el operando 'x' sea un número real positivo\");\n  }\n  \n  //X=0\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"3\");\n  $(document).find(\"button#fbx\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"0\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando el operando 'x' sea 0\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};","id":6},{"type":"exercise","title":"f) Contador de errores","description":"Este apartado muestra una modificación de la calculadora que muestra por pantalla el mensaje <b>\"Error\"</b> cuando alguno de los operandos introducidos es una cadena de texto en lugar de un número. Realice las siguientes modificaciones:\n1) Añada un <i><div></i> con identificador \"contador\" que muestre la cantidad de errores producidos en la calculadora. El contador empezará con el valor 0 y se incrementará en 1 cada vez que se muestre un error en la pantalla de la calculadora.\n2) Haga uso de la clase <i>error</i> definida en la etiqueta <code><style></code> para que los mensajes \"Error\" se muestren de color rojo en la pantalla de la calculadora, pero el resto de valores se muestren con el color habitual.","editorMode":"HTML","content":"<!DOCTYPE html>\n<html>\n<head>\n\t<title>Calculadora</title>\n\t<meta charset=\"utf-8\">\n\t<script type=\"text/javascript\">\n\t\tvar protocol = (document.location.protocol==\"file:\" ? \"http:\" : document.location.protocol);\n\t\tdocument.write(unescape(\"%3Cscript src='\" + protocol + \"//code.jquery.com/jquery-2.2.1.min.js' type='text/javascript'%3E%3C/script%3E\"));\n\t</script>\n\t<style type=\"text/css\">\n\t  .error {\n\t    color: red;\n\t  }\n\t</style>\n</head>\n<body>\n\n\t<div>\n\t\tNúmero: <input type=\"text\" id=\"pantalla\"/>\n\t\t<button id=\"suma\">+</button>\n\t\t<button id=\"igual\">=</button>\n\t</div>\n\n\t<script type=\"text/javascript\">\n\t\tvar acc = 0;\n\t\tvar op;\n\n\t\t$(document).ready(function(){ \n\t\t\t$(\"#pantalla\").click(function(){\n\t\t\t\t$(this).val(\"\");\n\t\t\t});\n\t\t\t$(\"#suma\").click(function(){\n\t\t\t\tacc = parseFloat($(\"#pantalla\").val());\n\t\t\t\top = \"+\";\n\t\t\t});\n\t\t\t$(\"#igual\").click(function(){\n\t\t\t\tvar n = parseFloat($(\"#pantalla\").val());\n\t\t\t\tif(op === \"+\"){\n\t\t\t\t\tacc += n;\n\t\t\t\t} else {\n\t\t\t\t\tacc = n;\n\t\t\t\t}\n\t\t\t\tif((typeof acc != \"number\")||(isNaN(acc))){\n\t\t\t\t\tacc = \"Error\";\n\t\t\t\t}\n\t\t\t\t$(\"#pantalla\").val(acc);\n\t\t\t\tacc = 0;\n\t\t\t\top = undefined;\n\t\t\t});\n\t\t});\n\t</script>\n</body>\n</html>","progress":{"score":0,"passed":false},"score_function":"var score = function(document){\n  var grade = {};\n  grade.score = 0;\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  \n  //Content\n  var content;\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")){\n    content = document.documentElement.outerHTML;\n  }\n  \n  //Existencia de elementos del DOM.\n\tif($(document).find(\"input#pantalla\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <input> con id 'pantalla'.\");\n\t}\n\tif($(document).find(\"button#suma\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'suma'.\");\n\t}\n\tif($(document).find(\"button#igual\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <button> con id 'igual'.\");\n\t}\n\tif($(document).find(\"div#contador\").length === 0){\n\t  \treturn returnWithError(document,content,grade,\"No se encontró el <div> con id 'contador'.\");\n\t}\n\tif(parseInt($(document).find(\"div#contador\").html()) != 0){\n\t  \treturn returnWithError(document,content,grade,\"El contador debería tener un valor inicial de 0.\");\n\t}\n\t\n  var pantalla = $(document).find(\"input#pantalla\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(5);\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(2);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 7){\n    return returnWithError(document,content,grade,\"La función suma no funciona correctamente\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(3);\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(7);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 10){\n    return returnWithError(document,content,grade,\"La función suma no funciona correctamente\");\n  }\n  \n  //Trigger error\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Gato\");\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(\"Perro\");\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  if(parseInt($(document).find(\"div#contador\").html()) != 1){\n\t  return returnWithError(document,content,grade,\"El contador debería tener un valor de 1 después de producirse un error.\");\n\t}\n\t\n\tvar errorsToTrigger = 5;\n\tfor(var i=0; i<errorsToTrigger; i++){\n  \t//Trigger error\n    $(pantalla).trigger(\"click\");\n    $(pantalla).val(\"Gato\");\n    $(document).find(\"#suma\").trigger(\"click\");\n    $(pantalla).trigger(\"click\");\n    $(pantalla).val(\"Perro\");\n    $(document).find(\"#igual\").trigger(\"click\"); \n\t}\n\n  if($(pantalla).val() != \"Error\"){\n    return returnWithError(document,content,grade,\"La calculadora debería mostrar \\\"Error\\\" cuando alguno de los operandos es una cadena de texto en lugar de un número\");\n  }\n  \n  if(parseInt($(document).find(\"div#contador\").html()) != (errorsToTrigger+1)){\n\t  return returnWithError(document,content,grade,\"El contador no cuenta correctamente los errores.\");\n\t}\n\t\n\tif(!$(pantalla).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"La pantalla de la calculadora debería tener la clase 'error' al mostrar los mensajes de texto \\\"Error\\\".\");\n  }\n  \n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(3);\n  if($(pantalla).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"La pantalla de la calculadora solo debería tener la clase 'error' al mostrar los mensajes de error.\");\n  }\n  $(document).find(\"#suma\").trigger(\"click\");\n  $(pantalla).trigger(\"click\");\n  $(pantalla).val(7);\n  $(document).find(\"#igual\").trigger(\"click\");\n  \n  if(parseFloat($(pantalla).val()) != 10){\n    return returnWithError(document,content,grade,\"La función suma no funciona correctamente tras producirse un error.\");\n  }\n  \n  if($(pantalla).hasClass(\"error\")){\n    return returnWithError(document,content,grade,\"La pantalla de la calculadora solo debería tener la clase 'error' al mostrar los mensajes de error.\");\n  }\n\n  grade.score = 10;\n  grade.successes.push(\"Correcto.\");\n\n  resetState(document,content);\n  return grade;\n};\n\nvar returnWithError = function(document,content,grade,msg){\n  resetState(document,content);\n  grade.errors.push(msg);\n  return grade;\n};\n\nvar resetState = function(document,content){\n  if((typeof document != \"undefined\")&&(typeof document.documentElement != \"undefined\")&&(typeof content != \"undefined\")){\n\t  document.open();\n\t  document.writeln(content);\n\t  document.close();\n  }\n};\n\n","id":7}],"metadata":{"title":"Calculadora","language":"es"}}