var CODEditor = CODEditor || {};
CODEditor.Viewer = true;
CODEditor.File = {"type":"test","title":"Introducción a JavaScript: Tipos y valores","exercises":"[{\"type\":\"exercise\",\"title\":\"Introducción\",\"description\":\"Para devolver el resultado de los ejercicios debes utilizar la sentencia <code>return</code>, tal y como se muestra en el siguiente ejemplo. \\nUna vez ejecutada una sentencia <code>return</code>, el resto del código no será evaluado.\\nEn este caso, se devuelve como resultado la palabra \\\"Hola Mundo\\\".\\nPulsando sobre el icono de 'Ejecutar Código' podrás ver el resultado de la ejecución.\\nCuando quieras avanzar al siguiente ejercicio pulsa sobre el título del test: 'Introducción a JavaScript: Tipos y valores'.\",\"editorMode\":\"JavaScript\",\"content\":\"return \\\"Hola Mundo\\\";\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"El operador 'typeof'\",\"description\":\"El operador <code>typeof</code> nos permite conocer el <b>tipo</b> de una <b>variable</b>.\\nA continuación se muestran una serie de variables de diferentes tipos.\\nUtilice el operador <b>typeof</b> para saber el tipo de cada una de ellas. \\nPara ello, puede reemplazar la variable en la sentencia <code>return (typeof a);</code>.\",\"editorMode\":\"JavaScript\",\"content\":\"//Tipos primitivos\\nvar a = 5;\\nvar b = \\\"Cinco\\\";\\nvar c = true;\\n\\n//Objetos\\nvar d = {};\\n\\n//Tipos especiales\\nvar e = undefined;\\nvar f = null;\\n\\nreturn (typeof a);\\n\\n/*\\n  Compruebe que los tipos obtenidos son los siguientes:\\n  \\n  Tipo de la variable a: 'number'\\n  Los números tienen el tipo 'number'.\\n  \\n  Tipo de la variable b: 'string'\\n  Las cadenas de texto (palabras, párrafos, ...) tienen el tipo 'string'.\\n  \\n  Tipo de la variable c: 'boolean'\\n  Existen dos valores de tipo booleano: 'true' y 'false'.\\n  \\n  Tipo de la variable d: 'object'\\n  Cualquier variable que no sea un tipo primitivo será un objeto.\\n  \\n  Tipo de la variable e: 'undefined'\\n  'undefined' es un valor especial, que tienen las variables que no han sido definidas.\\n  \\n  Tipo de la variable f: 'object'\\n  'null' es otro valor especial, que representa al objeto 'nulo'.\\n\\n*/\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"Números: tipo 'number'\",\"description\":\"Con las variables de tipo 'number' podemos aplicar todo tipo de operaciones matemáticas.\\nEn este ejercicio se han definido dos funciones: <code>sumar</code> y <code>restar</code>.\\nRellene el cuerpo de la función <code>multiplicar</code> para que devuelva como resultado la multiplicación de las variables a y b.\",\"content\":\"var sumar = function(a,b){\\n  return (a+b);\\n};\\n\\nvar restar = function(a,b){\\n  return (a-b);\\n};\\n\\nvar multiplicar = function(a,b){\\n  //Escriba su solución aquí\\n  \\n};\",\"editorMode\":\"JavaScript\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var multiplicar = variablesHash[\\\"multiplicar\\\"];\\n  \\n  if(typeof multiplicar != \\\"function\\\"){\\n    grade.errors.push(\\\"No se encontró la función 'multiplicar'.\\\");\\n  } else {\\n    var testA = multiplicar(5,5);\\n    if((multiplicar(5,4)===20)&&(multiplicar(3,7)===21)&&(multiplicar(3,0)===0)){\\n      grade.score = 10;\\n    } else {\\n      grade.errors.push(\\\"La función 'multiplicar' no funciona conforme a lo esperado.\\\");\\n    }\\n  }\\n\\n  return grade;\\n};\",\"score_function_vars\":[\"multiplicar\"]},{\"type\":\"exercise\",\"title\":\"Cadenas de texto: tipo 'string'.\",\"description\":\"Las variables de tipo 'string' son textos delimitados por comillas <code>\\\"Hola Mundo\\\"</code> o apóstrofes <code>'Hola Mundo'</code>.\\nEl operador <code>+</code> se puede utilizar para concatenar strings: <code>\\\"Hola\\\" + \\\"Mundo\\\" => \\\"HolaMundo\\\"</code>.\\nLa propiedad <b>length</b> devuelve la longitud de la cadena de texto: <code>\\\"Hola Mundo\\\".length => 10</code>.\\nAsigne a la variable \\\"nombre\\\" su nombre, y a la variable \\\"longitud\\\" la longitud del mismo. No incluya sentencia <code>return</code>.\\n\",\"editorMode\":\"JavaScript\",\"content\":\"var a = \\\"Hola\\\";\\nvar b = a + \\\" Mundo\\\";\\n//La variable b vale \\\"Hola Mundo\\\"\\n\\nvar c = b.length;\\n//La variable c valdrá 10 porque \\\"Hola Mundo\\\" tiene 10 caracteres (incluyendo el espacio).\\n\\n\\n//Escriba su solución aquí.\\n\\nvar nombre;\\nvar longitud;\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n   \\n  var nombre = variablesHash[\\\"nombre\\\"];\\n  var longitud = variablesHash[\\\"longitud\\\"];\\n\\n  if(typeof nombre === \\\"string\\\"){\\n     grade.score += 4;\\n     if((typeof longitud === \\\"number\\\")&&(longitud===nombre.length)){\\n        grade.score += 6;\\n        grade.successes.push(\\\"Correcto.\\\");\\n     } else {\\n       grade.errors.push(\\\"La variable 'longitud' no tiene el valor correcto.\\\");\\n     }\\n  } else {\\n    grade.errors.push(\\\"La variable 'nombre' no es de tipo 'string'.\\\");\\n  }\\n\\n  return grade;\\n};\",\"score_function_vars\":[\"nombre\",\"longitud\"]},{\"type\":\"exercise\",\"title\":\"Booleanos: tipo 'boolean'\",\"description\":\"Solo existen dos valores de tipo booleano: 'true' (verdadero) y 'false' (falso).\\nEl operador unitario negación <b><code>!</code></b> convierte un valor lógico en el opuesto.\\nSe utilizan para tomar decisiones en sentencias condicionales: <b>if/else</b>.\\nEn este ejemplo se muestra una sentencia condicional empleando variables booleanas. Analícela.\\n<i>Aclaración:</i> la expresión <code> resultado += s </code> es equivalente a <code> resultado = resultado + s </code>.\",\"editorMode\":\"JavaScript\",\"content\":\"var a = true;\\nvar b = false;\\nvar c = !b;\\n\\nvar resultado = \\\"\\\";\\n\\nif(a){\\n  resultado += \\\"La variable A es verdadera.\\\\n\\\"\\n} else {\\n  resultado += \\\"La variable A es falsa.\\\\n\\\"\\n}\\n\\nif(b){\\n  resultado += \\\"La variable B es verdadera.\\\\n\\\"\\n} else {\\n  resultado += \\\"La variable B es falsa.\\\\n\\\"\\n}\\n\\nif(c){\\n  resultado += \\\"La variable C es verdadera.\\\"\\n} else {\\n  resultado += \\\"La variable C es falsa.\\\"\\n}\\n\\nreturn resultado;\\n\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"Operadores de identidad, de comparación y lógicos\",\"description\":\"Todos estos operadores devuelven un tipo booleano (true o false).\\nCompruebe los resultados de las variables <b>c-h</b> y analice el porqué de esos resultados.\",\"editorMode\":\"JavaScript\",\"content\":\"var n = 20;\\nvar a = true;\\nvar b = false;\\n\\n\\n/*\\n Identidad o igualdad estricta: \\\"===\\\"\\n Devuelve 'true' cuando ambas variables son iguales en tipo y valor.\\n \\n c será 'true' porque 20 (valor de n) es igual a 10+10.\\n*/\\nvar c = (n===(10+10)); \\n\\n\\n/*\\n Desigualdad estricta: \\\"!==\\\"\\n Devuelve 'true' cuando ambas variables son diferentes en tipo y/o valor.\\n \\n d será 'false' porque 20 no es diferente a 10+10.\\n*/\\nvar d = (n!==(10+10)); \\n\\n\\n/*\\n Operadores de comparación: \\n \\\">\\\": mayor que\\n \\\"<\\\": menor que\\n \\\">=\\\": mayor o igual que\\n \\\"<=\\\": menor o igual que\\n Devuelve 'true' cuando se cumple la condición.\\n \\n e será 'true' porque 20 es mayor que 10.\\n f será 'false' porque 20 no es menor o igual a 10.\\n*/\\nvar e = (n>10);\\nvar f = (n<=10);\\n\\n\\n/*\\n Operadores lógicos\\n &&: operador lógico AND\\n ||: operador lógico OR\\n \\n g será 'true' si (y solo si) a y b también lo son.\\n h será 'true' si a es 'true' o b lo es.\\n*/\\n\\nvar g = (a&&b); //En este caso será 'false' porque 'b' es 'false'.\\nvar h = (a||b); //En este caso será 'true' porque 'a' es 'true'.\\n\\n\\n//Compruebe el valor de cada una de las variables c-h:\\nreturn c;\\n\\n\",\"progress\":{\"score\":0,\"passed\":false}},{\"type\":\"exercise\",\"title\":\"Sentencias if-else\",\"description\":\"Las sentencias if/else permiten la ejecución de bloques de código de forma condicional.\\nEn este ejercicio se muestra la estructura general de una sentencia if/else, junto a una función <code>logicaEjemplo</code> que devuelve 'true' cuando 'a' es 'true' y b es igual al número 5.\\nRellene la función <code>logica</code> para que devuelva 'true' solo cuando <b>a y b sean verdaderas</b>, <b>c sea igual a \\\"Hola Mundo\\\"</b> y la <b>negación de d sea falsa</b>.\",\"editorMode\":\"JavaScript\",\"content\":\"//Estructura general de una sentencia if-else\\n\\nvar condicion = true;\\n\\nif(condicion){\\n  //Si se cumple la condición, es decir, si condicion===true, entonces se ejecutará este bloque de código.\\n} else {\\n  //Si no se cumple la condición, es decir, si condicion!==true, entonces se ejecutará este otro bloque de código.\\n}\\n\\nvar logicaEjemplo = function(a,b){\\n  //Escriba su solución aquí\\n  return (a&&(b===5));\\n};\\n\\nvar logica = function(a,b,c,d){\\n  //Escriba su solución aquí\\n  \\n};\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var logica = variablesHash[\\\"logica\\\"];\\n  \\n  if(typeof logica === \\\"function\\\"){\\n    var testA = logica(true,true,\\\"Hola Mundo\\\",true); //true\\n    var testB = logica(false,true,\\\"Hola Mundo\\\",true); //false\\n    var testC = logica(true,false,\\\"Hola Mundo\\\",true); //false\\n    var testD = logica(true,true,\\\"HolaMundo\\\",true); //false\\n    var testE = logica(true,true,\\\"Hola Mundo\\\",false); //false\\n    if((testA===true)&&(testB===false)&&(testC===false)&&(testD===false)&&(testE===false)){\\n      grade.successes.push(\\\"Correcto.\\\");\\n      grade.score += 10;\\n    } else {\\n      if(testB===true){\\n         grade.feedback.push(\\\"Revisa la variable 'a'.\\\");\\n      } else if (testC===true){\\n        grade.feedback.push(\\\"Revisa la variable 'b'.\\\");\\n      } else if (testD===true){\\n        grade.feedback.push(\\\"Revisa la variable 'c'.\\\");\\n      } else if (testE===true){\\n        grade.feedback.push(\\\"Revisa la variable 'd'.\\\");\\n      }\\n      grade.errors.push(\\\"La función 'logica' no funciona conforme a lo esperado.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"La función 'logica' no se ha definido.\\\");\\n  }\\n  \\n  return grade;\\n};\\n\\n\\n/* \\n  Solución\\n  var logica = function(a,b,c,d){\\n    return (a&&(b)&&(c===\\\"Hola Mundo\\\")&&(d===true));\\n  };\\n*/\\n\\n\",\"score_function_vars\":[\"logica\"]},{\"type\":\"exercise\",\"title\":\"Sentencias if-else (II)\",\"description\":\"Es posible construir sentencias if/else un poco más complejas tomando en consideración varias variables.\\nAnalice el nuevo ejemplo y rellene la función <code>logica</code> para que devuelva <b>\\\"A\\\" si 'numero' es mayor o igual a 10</b>, <b>\\\"B\\\" si 'numero' es menor que 10 pero mayor que 5</b>, y <b>\\\"C\\\" en cualquier otro caso</b>.\",\"editorMode\":\"JavaScript\",\"content\":\"//Estructura general de una sentencia if-else con varias variables\\n\\nvar condicion1 = false;\\nvar condicion2 = true;\\n\\nif(condicion1){\\n  //condicion1===true\\n} else if(condicion2) {\\n  //condicion1!==true && condicion2===true\\n} else {\\n  //condicion1!==true && condicion2!==true\\n}\\n\\nvar logica = function(numero){\\n  //Escriba su solución aquí\\n};\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var logica = variablesHash[\\\"logica\\\"];\\n  \\n  if(typeof logica === \\\"function\\\"){\\n    var testA = logica(20); //\\\"A\\\"\\n    var testB = logica(10); //\\\"A\\\"\\n    var testC = logica(7); //B\\n    var testD = logica(4); //C\\n    if((testA===\\\"A\\\")&&(testB===\\\"A\\\")&&(testC===\\\"B\\\")&&(testD===\\\"C\\\")){\\n      grade.successes.push(\\\"Correcto.\\\");\\n      grade.score += 10;\\n    } else {\\n      grade.errors.push(\\\"La función 'logica' no funciona acorde a lo especificado por el enunciado.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"La función 'logica' no se ha definido.\\\");\\n  }\\n  \\n  return grade;\\n};\\n\\n\\n/* \\n  Solución\\n  var logica = function(numero){\\n    if(numero>=10){\\n      return \\\"A\\\";\\n    } else if(numero>5){\\n      return \\\"B\\\";\\n    } else {\\n      return \\\"C\\\";\\n    }\\n  };\\n*/\",\"score_function_vars\":[\"logica\"]},{\"type\":\"exercise\",\"title\":\"Ejercicio sobre tipos y valores\",\"description\":\"Haciendo uso de la función <b>typeof</b> rellene la función <code>suma</code> de modo que:\\n* Si las variables a y b son números, la función devolverá la suma de los mismos.\\n* Si la variable a es un número pero b no lo es, devolverá a, mientras que si b es un número pero a no lo es, devolverá b.\\n* Si ninguna de las variables es un número, devolverá la cadena de texto \\\"Error\\\".\\n<i>Nota:</i> utilice la expresión <code>typeof var === \\\"number\\\"</code> para comprobar el tipo de las variables.\",\"editorMode\":\"JavaScript\",\"content\":\"var suma = function(a,b){\\n  //Escriba su solución aquí\\n};\",\"progress\":{\"score\":0,\"passed\":false},\"score_function\":\"var score = function(result,variablesHash){\\n  var grade = {};\\n  grade.successes = [];\\n  grade.errors = [];\\n  grade.feedback = [];\\n  grade.score = 0;\\n  \\n  var suma = variablesHash[\\\"suma\\\"];\\n  \\n  if(typeof suma === \\\"function\\\"){\\n    var testA = suma(2,8); //10\\n    var testB = suma(2); //2\\n    var testC = suma(\\\"Dos\\\",8); //8\\n    var testD = suma(); //\\\"Error\\\"\\n    if(typeof testD == \\\"string\\\"){\\n      testD = testD.toLowerCase().trim();\\n    }\\n    if((testA===10)&&(testB===2)&&(testC===8)&&(testD===\\\"error\\\")){\\n      grade.successes.push(\\\"Correcto.\\\");\\n      grade.score += 10;\\n    } else {\\n      if(testA!==10){\\n        grade.feedback.push(\\\"Cuando a y b son números la función no devuelve la suma.\\\");\\n      } else if(testB!==2){\\n        grade.feedback.push(\\\"Cuando a es un número pero b no lo es la función debe devolver el valor de a.\\\");\\n      } else if(testC!==8){\\n        grade.feedback.push(\\\"Cuando a no es un número pero b si lo es la función debe devolver el valor de b.\\\");\\n      } else if(testD!==\\\"error\\\"){\\n        grade.feedback.push(\\\"Cuando a y b no son números la función debe devolver la palabra \\\\\\\"Error\\\\\\\".\\\");\\n      }\\n      grade.errors.push(\\\"La función 'suma' no funciona acorde a lo especificado por el enunciado.\\\");\\n    }\\n  } else {\\n    grade.errors.push(\\\"La función 'suma' no se ha definido.\\\");\\n  }\\n\\n  return grade;\\n};\\n\\n/*\\n  Solución\\n  var suma = function(a,b){\\n    if((typeof a == \\\"number\\\")&&(typeof b == \\\"number\\\")){\\n      return a+b;\\n    }\\n    if(typeof a == \\\"number\\\"){\\n      return a;\\n    }\\n    if(typeof b == \\\"number\\\"){\\n      return b;\\n    }\\n    return \\\"Error\\\";\\n  };\\n*/\",\"score_function_vars\":[\"suma\"]}]","exercisesQuantity":9,"parsed_exercises":[{"type":"exercise","title":"Introducción","description":"Para devolver el resultado de los ejercicios debes utilizar la sentencia <code>return</code>, tal y como se muestra en el siguiente ejemplo. \nUna vez ejecutada una sentencia <code>return</code>, el resto del código no será evaluado.\nEn este caso, se devuelve como resultado la palabra \"Hola Mundo\".\nPulsando sobre el icono de 'Ejecutar Código' podrás ver el resultado de la ejecución.\nCuando quieras avanzar al siguiente ejercicio pulsa sobre el título del test: 'Introducción a JavaScript: Tipos y valores'.","editorMode":"JavaScript","content":"return \"Hola Mundo\";","progress":{"score":0,"passed":false},"id":1},{"type":"exercise","title":"El operador 'typeof'","description":"El operador <code>typeof</code> nos permite conocer el <b>tipo</b> de una <b>variable</b>.\nA continuación se muestran una serie de variables de diferentes tipos.\nUtilice el operador <b>typeof</b> para saber el tipo de cada una de ellas. \nPara ello, puede reemplazar la variable en la sentencia <code>return (typeof a);</code>.","editorMode":"JavaScript","content":"//Tipos primitivos\nvar a = 5;\nvar b = \"Cinco\";\nvar c = true;\n\n//Objetos\nvar d = {};\n\n//Tipos especiales\nvar e = undefined;\nvar f = null;\n\nreturn (typeof a);\n\n/*\n  Compruebe que los tipos obtenidos son los siguientes:\n  \n  Tipo de la variable a: 'number'\n  Los números tienen el tipo 'number'.\n  \n  Tipo de la variable b: 'string'\n  Las cadenas de texto (palabras, párrafos, ...) tienen el tipo 'string'.\n  \n  Tipo de la variable c: 'boolean'\n  Existen dos valores de tipo booleano: 'true' y 'false'.\n  \n  Tipo de la variable d: 'object'\n  Cualquier variable que no sea un tipo primitivo será un objeto.\n  \n  Tipo de la variable e: 'undefined'\n  'undefined' es un valor especial, que tienen las variables que no han sido definidas.\n  \n  Tipo de la variable f: 'object'\n  'null' es otro valor especial, que representa al objeto 'nulo'.\n\n*/","progress":{"score":0,"passed":false},"id":2},{"type":"exercise","title":"Números: tipo 'number'","description":"Con las variables de tipo 'number' podemos aplicar todo tipo de operaciones matemáticas.\nEn este ejercicio se han definido dos funciones: <code>sumar</code> y <code>restar</code>.\nRellene el cuerpo de la función <code>multiplicar</code> para que devuelva como resultado la multiplicación de las variables a y b.","content":"var sumar = function(a,b){\n  return (a+b);\n};\n\nvar restar = function(a,b){\n  return (a-b);\n};\n\nvar multiplicar = function(a,b){\n  //Escriba su solución aquí\n  \n};","editorMode":"JavaScript","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var multiplicar = variablesHash[\"multiplicar\"];\n  \n  if(typeof multiplicar != \"function\"){\n    grade.errors.push(\"No se encontró la función 'multiplicar'.\");\n  } else {\n    var testA = multiplicar(5,5);\n    if((multiplicar(5,4)===20)&&(multiplicar(3,7)===21)&&(multiplicar(3,0)===0)){\n      grade.score = 10;\n    } else {\n      grade.errors.push(\"La función 'multiplicar' no funciona conforme a lo esperado.\");\n    }\n  }\n\n  return grade;\n};","score_function_vars":["multiplicar"],"id":3},{"type":"exercise","title":"Cadenas de texto: tipo 'string'.","description":"Las variables de tipo 'string' son textos delimitados por comillas <code>\"Hola Mundo\"</code> o apóstrofes <code>'Hola Mundo'</code>.\nEl operador <code>+</code> se puede utilizar para concatenar strings: <code>\"Hola\" + \"Mundo\" => \"HolaMundo\"</code>.\nLa propiedad <b>length</b> devuelve la longitud de la cadena de texto: <code>\"Hola Mundo\".length => 10</code>.\nAsigne a la variable \"nombre\" su nombre, y a la variable \"longitud\" la longitud del mismo. No incluya sentencia <code>return</code>.\n","editorMode":"JavaScript","content":"var a = \"Hola\";\nvar b = a + \" Mundo\";\n//La variable b vale \"Hola Mundo\"\n\nvar c = b.length;\n//La variable c valdrá 10 porque \"Hola Mundo\" tiene 10 caracteres (incluyendo el espacio).\n\n\n//Escriba su solución aquí.\n\nvar nombre;\nvar longitud;","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n   \n  var nombre = variablesHash[\"nombre\"];\n  var longitud = variablesHash[\"longitud\"];\n\n  if(typeof nombre === \"string\"){\n     grade.score += 4;\n     if((typeof longitud === \"number\")&&(longitud===nombre.length)){\n        grade.score += 6;\n        grade.successes.push(\"Correcto.\");\n     } else {\n       grade.errors.push(\"La variable 'longitud' no tiene el valor correcto.\");\n     }\n  } else {\n    grade.errors.push(\"La variable 'nombre' no es de tipo 'string'.\");\n  }\n\n  return grade;\n};","score_function_vars":["nombre","longitud"],"id":4},{"type":"exercise","title":"Booleanos: tipo 'boolean'","description":"Solo existen dos valores de tipo booleano: 'true' (verdadero) y 'false' (falso).\nEl operador unitario negación <b><code>!</code></b> convierte un valor lógico en el opuesto.\nSe utilizan para tomar decisiones en sentencias condicionales: <b>if/else</b>.\nEn este ejemplo se muestra una sentencia condicional empleando variables booleanas. Analícela.\n<i>Aclaración:</i> la expresión <code> resultado += s </code> es equivalente a <code> resultado = resultado + s </code>.","editorMode":"JavaScript","content":"var a = true;\nvar b = false;\nvar c = !b;\n\nvar resultado = \"\";\n\nif(a){\n  resultado += \"La variable A es verdadera.\\n\"\n} else {\n  resultado += \"La variable A es falsa.\\n\"\n}\n\nif(b){\n  resultado += \"La variable B es verdadera.\\n\"\n} else {\n  resultado += \"La variable B es falsa.\\n\"\n}\n\nif(c){\n  resultado += \"La variable C es verdadera.\"\n} else {\n  resultado += \"La variable C es falsa.\"\n}\n\nreturn resultado;\n","progress":{"score":0,"passed":false},"id":5},{"type":"exercise","title":"Operadores de identidad, de comparación y lógicos","description":"Todos estos operadores devuelven un tipo booleano (true o false).\nCompruebe los resultados de las variables <b>c-h</b> y analice el porqué de esos resultados.","editorMode":"JavaScript","content":"var n = 20;\nvar a = true;\nvar b = false;\n\n\n/*\n Identidad o igualdad estricta: \"===\"\n Devuelve 'true' cuando ambas variables son iguales en tipo y valor.\n \n c será 'true' porque 20 (valor de n) es igual a 10+10.\n*/\nvar c = (n===(10+10)); \n\n\n/*\n Desigualdad estricta: \"!==\"\n Devuelve 'true' cuando ambas variables son diferentes en tipo y/o valor.\n \n d será 'false' porque 20 no es diferente a 10+10.\n*/\nvar d = (n!==(10+10)); \n\n\n/*\n Operadores de comparación: \n \">\": mayor que\n \"<\": menor que\n \">=\": mayor o igual que\n \"<=\": menor o igual que\n Devuelve 'true' cuando se cumple la condición.\n \n e será 'true' porque 20 es mayor que 10.\n f será 'false' porque 20 no es menor o igual a 10.\n*/\nvar e = (n>10);\nvar f = (n<=10);\n\n\n/*\n Operadores lógicos\n &&: operador lógico AND\n ||: operador lógico OR\n \n g será 'true' si (y solo si) a y b también lo son.\n h será 'true' si a es 'true' o b lo es.\n*/\n\nvar g = (a&&b); //En este caso será 'false' porque 'b' es 'false'.\nvar h = (a||b); //En este caso será 'true' porque 'a' es 'true'.\n\n\n//Compruebe el valor de cada una de las variables c-h:\nreturn c;\n\n","progress":{"score":0,"passed":false},"id":6},{"type":"exercise","title":"Sentencias if-else","description":"Las sentencias if/else permiten la ejecución de bloques de código de forma condicional.\nEn este ejercicio se muestra la estructura general de una sentencia if/else, junto a una función <code>logicaEjemplo</code> que devuelve 'true' cuando 'a' es 'true' y b es igual al número 5.\nRellene la función <code>logica</code> para que devuelva 'true' solo cuando <b>a y b sean verdaderas</b>, <b>c sea igual a \"Hola Mundo\"</b> y la <b>negación de d sea falsa</b>.","editorMode":"JavaScript","content":"//Estructura general de una sentencia if-else\n\nvar condicion = true;\n\nif(condicion){\n  //Si se cumple la condición, es decir, si condicion===true, entonces se ejecutará este bloque de código.\n} else {\n  //Si no se cumple la condición, es decir, si condicion!==true, entonces se ejecutará este otro bloque de código.\n}\n\nvar logicaEjemplo = function(a,b){\n  //Escriba su solución aquí\n  return (a&&(b===5));\n};\n\nvar logica = function(a,b,c,d){\n  //Escriba su solución aquí\n  \n};","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var logica = variablesHash[\"logica\"];\n  \n  if(typeof logica === \"function\"){\n    var testA = logica(true,true,\"Hola Mundo\",true); //true\n    var testB = logica(false,true,\"Hola Mundo\",true); //false\n    var testC = logica(true,false,\"Hola Mundo\",true); //false\n    var testD = logica(true,true,\"HolaMundo\",true); //false\n    var testE = logica(true,true,\"Hola Mundo\",false); //false\n    if((testA===true)&&(testB===false)&&(testC===false)&&(testD===false)&&(testE===false)){\n      grade.successes.push(\"Correcto.\");\n      grade.score += 10;\n    } else {\n      if(testB===true){\n         grade.feedback.push(\"Revisa la variable 'a'.\");\n      } else if (testC===true){\n        grade.feedback.push(\"Revisa la variable 'b'.\");\n      } else if (testD===true){\n        grade.feedback.push(\"Revisa la variable 'c'.\");\n      } else if (testE===true){\n        grade.feedback.push(\"Revisa la variable 'd'.\");\n      }\n      grade.errors.push(\"La función 'logica' no funciona conforme a lo esperado.\");\n    }\n  } else {\n    grade.errors.push(\"La función 'logica' no se ha definido.\");\n  }\n  \n  return grade;\n};\n\n\n/* \n  Solución\n  var logica = function(a,b,c,d){\n    return (a&&(b)&&(c===\"Hola Mundo\")&&(d===true));\n  };\n*/\n\n","score_function_vars":["logica"],"id":7},{"type":"exercise","title":"Sentencias if-else (II)","description":"Es posible construir sentencias if/else un poco más complejas tomando en consideración varias variables.\nAnalice el nuevo ejemplo y rellene la función <code>logica</code> para que devuelva <b>\"A\" si 'numero' es mayor o igual a 10</b>, <b>\"B\" si 'numero' es menor que 10 pero mayor que 5</b>, y <b>\"C\" en cualquier otro caso</b>.","editorMode":"JavaScript","content":"//Estructura general de una sentencia if-else con varias variables\n\nvar condicion1 = false;\nvar condicion2 = true;\n\nif(condicion1){\n  //condicion1===true\n} else if(condicion2) {\n  //condicion1!==true && condicion2===true\n} else {\n  //condicion1!==true && condicion2!==true\n}\n\nvar logica = function(numero){\n  //Escriba su solución aquí\n};","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var logica = variablesHash[\"logica\"];\n  \n  if(typeof logica === \"function\"){\n    var testA = logica(20); //\"A\"\n    var testB = logica(10); //\"A\"\n    var testC = logica(7); //B\n    var testD = logica(4); //C\n    if((testA===\"A\")&&(testB===\"A\")&&(testC===\"B\")&&(testD===\"C\")){\n      grade.successes.push(\"Correcto.\");\n      grade.score += 10;\n    } else {\n      grade.errors.push(\"La función 'logica' no funciona acorde a lo especificado por el enunciado.\");\n    }\n  } else {\n    grade.errors.push(\"La función 'logica' no se ha definido.\");\n  }\n  \n  return grade;\n};\n\n\n/* \n  Solución\n  var logica = function(numero){\n    if(numero>=10){\n      return \"A\";\n    } else if(numero>5){\n      return \"B\";\n    } else {\n      return \"C\";\n    }\n  };\n*/","score_function_vars":["logica"],"id":8},{"type":"exercise","title":"Ejercicio sobre tipos y valores","description":"Haciendo uso de la función <b>typeof</b> rellene la función <code>suma</code> de modo que:\n* Si las variables a y b son números, la función devolverá la suma de los mismos.\n* Si la variable a es un número pero b no lo es, devolverá a, mientras que si b es un número pero a no lo es, devolverá b.\n* Si ninguna de las variables es un número, devolverá la cadena de texto \"Error\".\n<i>Nota:</i> utilice la expresión <code>typeof var === \"number\"</code> para comprobar el tipo de las variables.","editorMode":"JavaScript","content":"var suma = function(a,b){\n  //Escriba su solución aquí\n};","progress":{"score":0,"passed":false},"score_function":"var score = function(result,variablesHash){\n  var grade = {};\n  grade.successes = [];\n  grade.errors = [];\n  grade.feedback = [];\n  grade.score = 0;\n  \n  var suma = variablesHash[\"suma\"];\n  \n  if(typeof suma === \"function\"){\n    var testA = suma(2,8); //10\n    var testB = suma(2); //2\n    var testC = suma(\"Dos\",8); //8\n    var testD = suma(); //\"Error\"\n    if(typeof testD == \"string\"){\n      testD = testD.toLowerCase().trim();\n    }\n    if((testA===10)&&(testB===2)&&(testC===8)&&(testD===\"error\")){\n      grade.successes.push(\"Correcto.\");\n      grade.score += 10;\n    } else {\n      if(testA!==10){\n        grade.feedback.push(\"Cuando a y b son números la función no devuelve la suma.\");\n      } else if(testB!==2){\n        grade.feedback.push(\"Cuando a es un número pero b no lo es la función debe devolver el valor de a.\");\n      } else if(testC!==8){\n        grade.feedback.push(\"Cuando a no es un número pero b si lo es la función debe devolver el valor de b.\");\n      } else if(testD!==\"error\"){\n        grade.feedback.push(\"Cuando a y b no son números la función debe devolver la palabra \\\"Error\\\".\");\n      }\n      grade.errors.push(\"La función 'suma' no funciona acorde a lo especificado por el enunciado.\");\n    }\n  } else {\n    grade.errors.push(\"La función 'suma' no se ha definido.\");\n  }\n\n  return grade;\n};\n\n/*\n  Solución\n  var suma = function(a,b){\n    if((typeof a == \"number\")&&(typeof b == \"number\")){\n      return a+b;\n    }\n    if(typeof a == \"number\"){\n      return a;\n    }\n    if(typeof b == \"number\"){\n      return b;\n    }\n    return \"Error\";\n  };\n*/","score_function_vars":["suma"],"id":9}],"metadata":{"title":"Introducción a JavaScript: Tipos y valores","language":"es"}}