/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.LocatorClassLoader;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.LocatorURL;
import com.hp.hpl.jena.util.LocatorZip;
import com.hp.hpl.jena.util.TypedStream;
import java.util.Iterator;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.stream.LocationMapper;
import org.apache.jena.riot.stream.Locator;

class AdapterLib {
    AdapterLib() {
    }

    public static TypedStream convert(TypedInputStream in) {
        return new TypedStream(in, in.getContentType(), in.getCharset());
    }

    public static LocationMapper copyConvert(com.hp.hpl.jena.util.LocationMapper locMap) {
        LocationMapper lmap2 = new LocationMapper();
        if (locMap == null) {
            return null;
        }
        Iterator<String> sIter1 = locMap.listAltEntries();
        while (sIter1.hasNext()) {
            String k = sIter1.next();
            lmap2.addAltEntry(k, locMap.getAltEntry(k));
        }
        Iterator<String> sIter2 = locMap.listAltPrefixes();
        while (sIter2.hasNext()) {
            String k = sIter1.next();
            lmap2.addAltEntry(k, locMap.getAltPrefix(k));
        }
        return lmap2;
    }

    public static Locator convert(com.hp.hpl.jena.util.Locator oldloc) {
        if (oldloc instanceof LocatorFile) {
            LocatorFile lFile = (LocatorFile)oldloc;
            return new org.apache.jena.riot.stream.LocatorFile(lFile.getDir());
        }
        if (oldloc instanceof LocatorClassLoader) {
            LocatorClassLoader classLoc = (LocatorClassLoader)oldloc;
            return new org.apache.jena.riot.stream.LocatorClassLoader(classLoc.getClassLoader());
        }
        if (oldloc instanceof LocatorURL) {
            return new org.apache.jena.riot.stream.LocatorURL();
        }
        if (oldloc instanceof LocatorZip) {
            LocatorZip zipLoc = (LocatorZip)oldloc;
            return new org.apache.jena.riot.stream.LocatorZip(zipLoc.getZipFileName());
        }
        throw new RiotException("Unrecognized Locator: " + Utils.className(oldloc));
    }
}

