/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.ChallengeState;
import org.apache.http.client.AuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;

public class PreemptiveBasicAuthenticator
implements HttpAuthenticator {
    private HttpAuthenticator authenticator;
    private boolean isProxy = false;

    public PreemptiveBasicAuthenticator(HttpAuthenticator authenticator) {
        this(authenticator, false);
    }

    public PreemptiveBasicAuthenticator(HttpAuthenticator authenticator, boolean forProxy) {
        if (authenticator == null) {
            throw new IllegalArgumentException("Must provide an authenticator to decorate");
        }
        this.authenticator = authenticator;
    }

    @Override
    public void apply(AbstractHttpClient client, HttpContext httpContext, URI target) {
        this.authenticator.apply(client, httpContext, target);
        AuthCache authCache = (AuthCache)httpContext.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            authCache = new BasicAuthCache();
        }
        BasicScheme basicAuth = new BasicScheme(this.isProxy ? ChallengeState.PROXY : ChallengeState.TARGET);
        authCache.put(new HttpHost(target.getHost(), target.getPort()), basicAuth);
        httpContext.setAttribute("http.auth.auth-cache", authCache);
    }
}

