/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class BigIntegerValue
extends IntegerValue {
    private BigInteger value;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final BigIntegerValue ZERO = new BigIntegerValue(BigInteger.ZERO);

    public BigIntegerValue(BigInteger value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public BigIntegerValue(BigInteger value, AtomicType typeLabel) {
        this.value = value;
        this.typeLabel = typeLabel;
    }

    public BigIntegerValue(long value) {
        this.value = BigInteger.valueOf(value);
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        BigIntegerValue v = new BigIntegerValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public ValidationFailure convertToSubType(BuiltInAtomicType type, boolean validate) {
        if (!validate) {
            this.typeLabel = type;
            return null;
        }
        if (IntegerValue.checkBigRange(this.value, type)) {
            this.typeLabel = type;
            return null;
        }
        ValidationFailure err = new ValidationFailure("Integer value is out of range for subtype " + type.getDisplayName());
        err.setErrorCode("FORG0001");
        return err;
    }

    public ValidationFailure validateAgainstSubType(BuiltInAtomicType type) {
        if (IntegerValue.checkBigRange(this.value, type)) {
            this.typeLabel = type;
            return null;
        }
        ValidationFailure err = new ValidationFailure("Integer value is out of range for subtype " + type.getDisplayName());
        err.setErrorCode("FORG0001");
        return err;
    }

    public int hashCode() {
        if (this.value.compareTo(MIN_INT) >= 0 && this.value.compareTo(MAX_INT) <= 0) {
            return this.value.intValue();
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger asBigInteger() {
        return this.value;
    }

    public boolean isWithinLongRange() {
        return this.value.compareTo(MIN_LONG) >= 0 && this.value.compareTo(MAX_LONG) <= 0;
    }

    public BigDecimal asDecimal() {
        return new BigDecimal(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value.compareTo(BigInteger.ZERO) != 0;
    }

    public int compareTo(Object other) {
        if (other instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)other).value);
        }
        if (other instanceof DecimalValue) {
            return this.asDecimal().compareTo(((DecimalValue)other).getDecimalValue());
        }
        return super.compareTo(other);
    }

    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigInteger.valueOf(other));
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue());
            }
            case 532: 
            case 632: 
            case 635: {
                return this;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 542: 
            case 543: 
            case 544: {
                if (this.isWithinLongRange()) {
                    Int64Value val = Int64Value.makeIntegerValue(this.longValue());
                    ValidationFailure err = val.convertToSubType(requiredType, validate);
                    if (err == null) {
                        return val;
                    }
                    return err;
                }
                BigIntegerValue val = new BigIntegerValue(this.value);
                ValidationFailure err = val.convertToSubType(requiredType, validate);
                if (err == null) {
                    return val;
                }
                return err;
            }
            case 541: {
                if (this.value.signum() < 0 || this.value.bitLength() > 64) {
                    ValidationFailure err = new ValidationFailure("Integer value is out of range for type " + requiredType.getDisplayName());
                    err.setErrorCode("FORG0001");
                    return err;
                }
                if (this.isWithinLongRange()) {
                    Int64Value val = Int64Value.makeIntegerValue(this.longValue());
                    ValidationFailure err = val.convertToSubType(requiredType, validate);
                    if (err != null) {
                        return err;
                    }
                    return val;
                }
                BigIntegerValue nv = new BigIntegerValue(this.value);
                ValidationFailure err = nv.convertToSubType(requiredType, validate);
                if (err != null) {
                    return err;
                }
                return nv;
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 515: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert integer to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.value);
    }

    public NumericValue negate() {
        return new BigIntegerValue(this.value.negate());
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        if (scale >= 0) {
            return this;
        }
        BigInteger factor = BigInteger.valueOf(10L).pow(-scale);
        BigInteger[] pair = this.value.divideAndRemainder(factor);
        int up = pair[1].compareTo(factor.divide(BigInteger.valueOf(2L)));
        if (up > 0) {
            pair[0] = pair[0].add(BigInteger.valueOf(1L));
        } else if (up == 0 && pair[0].mod(BigInteger.valueOf(2L)).signum() != 0) {
            pair[0] = pair[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeIntegerValue(pair[0].multiply(factor));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return true;
    }

    public IntegerValue plus(IntegerValue other) {
        if (other instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.add(((BigIntegerValue)other).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.add(BigInteger.valueOf(((Int64Value)other).longValue())));
    }

    public IntegerValue minus(IntegerValue other) {
        if (other instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.subtract(((BigIntegerValue)other).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.subtract(BigInteger.valueOf(((Int64Value)other).longValue())));
    }

    public IntegerValue times(IntegerValue other) {
        if (other instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.multiply(((BigIntegerValue)other).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.multiply(BigInteger.valueOf(((Int64Value)other).longValue())));
    }

    public NumericValue div(IntegerValue other) throws XPathException {
        BigInteger oi = other instanceof BigIntegerValue ? ((BigIntegerValue)other).value : BigInteger.valueOf(other.longValue());
        DecimalValue a = new DecimalValue(new BigDecimal(this.value));
        DecimalValue b = new DecimalValue(new BigDecimal(oi));
        return (NumericValue)Calculator.DECIMAL_DECIMAL[3].compute(a, b, null);
    }

    public IntegerValue mod(IntegerValue other) throws XPathException {
        try {
            if (other instanceof BigIntegerValue) {
                return BigIntegerValue.makeIntegerValue(this.value.remainder(((BigIntegerValue)other).value));
            }
            return BigIntegerValue.makeIntegerValue(this.value.remainder(BigInteger.valueOf(other.longValue())));
        }
        catch (ArithmeticException err) {
            XPathException e2 = BigInteger.valueOf(other.longValue()).signum() == 0 ? new XPathException("Integer modulo zero", "FOAR0001") : new XPathException("Integer mod operation failure", err);
            throw e2;
        }
    }

    public IntegerValue idiv(IntegerValue other) throws XPathException {
        BigInteger oi = other instanceof BigIntegerValue ? ((BigIntegerValue)other).value : BigInteger.valueOf(other.longValue());
        try {
            return BigIntegerValue.makeIntegerValue(this.value.divide(oi));
        }
        catch (ArithmeticException err) {
            XPathException e2 = "/ by zero".equals(err.getMessage()) ? new XPathException("Integer division by zero", "FOAR0001") : new XPathException("Integer division failure", err);
            throw e2;
        }
    }

    public Comparable getSchemaComparable() {
        return new BigIntegerComparable(this);
    }

    public Value reduce() throws XPathException {
        if (this.compareTo(Long.MAX_VALUE) < 0 && this.compareTo(Long.MIN_VALUE) > 0) {
            Int64Value iv = new Int64Value(this.longValue());
            iv.setTypeLabel(this.typeLabel);
            return iv;
        }
        return this;
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (this.isWithinLongRange()) {
            Int64Value val = Int64Value.makeIntegerValue(this.longValue());
            return val.convertToJava(target, context);
        }
        if (target.isAssignableFrom(Int64Value.class)) {
            return this;
        }
        if (target == BigInteger.class) {
            return this.value;
        }
        return this.convertPrimitive(BuiltInAtomicType.DECIMAL, true, context).asAtomic().convertToJava(target, context);
    }

    protected static class BigIntegerComparable
    implements Comparable {
        protected BigIntegerValue value;

        public BigIntegerComparable(BigIntegerValue value) {
            this.value = value;
        }

        public BigInteger asBigInteger() {
            return this.value.asBigInteger();
        }

        public int compareTo(Object o) {
            if (o instanceof Int64Value.Int64Comparable) {
                return this.asBigInteger().compareTo(BigInteger.valueOf(((Int64Value.Int64Comparable)o).asLong()));
            }
            if (o instanceof BigIntegerComparable) {
                return this.asBigInteger().compareTo(((BigIntegerComparable)o).asBigInteger());
            }
            if (o instanceof DecimalValue.DecimalComparable) {
                return this.value.getDecimalValue().compareTo(((DecimalValue.DecimalComparable)o).asBigDecimal());
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            BigInteger big = this.value.asBigInteger();
            if (big.compareTo(MAX_LONG) < 0 && big.compareTo(MIN_LONG) > 0) {
                Int64Value iv = new Int64Value(big.longValue());
                return iv.hashCode();
            }
            return big.hashCode();
        }
    }
}

