/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.Err;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.regex.RegexData;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.value.Whitespace;

public abstract class RegexTranslator {
    protected CharSequence regExp;
    protected int xmlVersion;
    protected boolean isXPath;
    protected boolean ignoreWhitespace;
    protected boolean inCharClassExpr;
    protected boolean caseBlind;
    protected int pos = 0;
    protected int length;
    protected char curChar;
    protected boolean eos = false;
    protected int currentCapture = 0;
    protected IntHashSet captures = new IntHashSet();
    protected final FastStringBuffer result = new FastStringBuffer(32);
    public static final int NONE = -1;
    public static final int SOME = 0;
    public static final int ALL = 1;
    public static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    public static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    public static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";

    protected void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected end of string");
        }
    }

    protected void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    protected void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    protected abstract boolean translateAtom() throws RegexSyntaxException;

    protected void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                break;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
                break;
            }
            default: {
                return;
            }
        }
        if (this.curChar == '?' && this.isXPath) {
            this.copyCurChar();
        }
    }

    protected void translateQuantity() throws RegexSyntaxException {
        block7: {
            String lower = ((Object)this.parseQuantExact()).toString();
            int lowerValue = -1;
            try {
                lowerValue = Integer.parseInt(lower);
                this.result.append(lower);
            }
            catch (NumberFormatException e2) {
                this.result.append("2147483647");
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String upper = ((Object)this.parseQuantExact()).toString();
                    try {
                        int upperValue = Integer.parseInt(upper);
                        this.result.append(upper);
                        if (lowerValue < 0 || upperValue < lowerValue) {
                            throw this.makeException("invalid range in quantifier");
                        }
                    }
                    catch (NumberFormatException e3) {
                        this.result.append("2147483647");
                        if (lowerValue >= 0 || new BigDecimal(lower).compareTo(new BigDecimal(upper)) <= 0) break block7;
                        throw this.makeException("invalid range in quantifier");
                    }
                }
            }
        }
    }

    protected CharSequence parseQuantExact() throws RegexSyntaxException {
        FastStringBuffer buf = new FastStringBuffer(10);
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected digit in quantifier");
            }
            buf.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return buf;
    }

    protected void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    protected void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
            if (this.ignoreWhitespace && !this.inCharClassExpr) {
                while (Whitespace.isWhitespace(this.curChar)) {
                    this.advance();
                }
            }
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    protected int absorbSurrogatePair() throws RegexSyntaxException {
        if (UTF16.isSurrogate(this.curChar)) {
            if (!UTF16.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            char c1 = this.curChar;
            this.advance();
            if (!UTF16.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            return UTF16.combinePair(c1, this.curChar);
        }
        return this.curChar;
    }

    protected void recede() {
        if (this.eos) {
            this.curChar = this.regExp.charAt(this.length - 1);
            this.pos = this.length;
            this.eos = false;
        } else {
            this.curChar = this.regExp.charAt(--this.pos - 1);
        }
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            while (Whitespace.isWhitespace(this.curChar)) {
                this.recede();
            }
        }
    }

    protected void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    protected RegexSyntaxException makeException(String key) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + key);
    }

    protected RegexSyntaxException makeException(String key, String arg) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + key + " (" + arg + ')');
    }

    protected static boolean isJavaMetaChar(int c) {
        switch (c) {
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    protected static String highSurrogateRanges(List ranges) {
        FastStringBuffer highRanges = new FastStringBuffer(ranges.size() * 2);
        int len = ranges.size();
        for (int i = 0; i < len; ++i) {
            Range r = (Range)ranges.get(i);
            char min1 = UTF16.highSurrogate(r.getMin());
            char min2 = UTF16.lowSurrogate(r.getMin());
            char max1 = UTF16.highSurrogate(r.getMax());
            char max2 = UTF16.lowSurrogate(r.getMax());
            if (min2 != '\udc00') {
                min1 = (char)(min1 + '\u0001');
            }
            if (max2 != '\udfff') {
                max1 = (char)(max1 - '\u0001');
            }
            if (max1 < min1) continue;
            highRanges.append(min1);
            highRanges.append(max1);
        }
        return highRanges.toString();
    }

    protected static String lowSurrogateRanges(List ranges) {
        FastStringBuffer lowRanges = new FastStringBuffer(ranges.size() * 2);
        int len = ranges.size();
        for (int i = 0; i < len; ++i) {
            Range r = (Range)ranges.get(i);
            char min1 = UTF16.highSurrogate(r.getMin());
            char min2 = UTF16.lowSurrogate(r.getMin());
            char max1 = UTF16.highSurrogate(r.getMax());
            char max2 = UTF16.lowSurrogate(r.getMax());
            if (min1 == max1) {
                if (min2 == '\udc00' && max2 == '\udfff') continue;
                lowRanges.append(min1);
                lowRanges.append(min2);
                lowRanges.append(max2);
                continue;
            }
            if (min2 != '\udc00') {
                lowRanges.append(min1);
                lowRanges.append(min2);
                lowRanges.append('\udfff');
            }
            if (max2 == '\udfff') continue;
            lowRanges.append(max1);
            lowRanges.append('\udc00');
            lowRanges.append(max2);
        }
        return lowRanges.toString();
    }

    protected static void sortRangeList(List ranges) {
        Collections.sort(ranges);
        int toIndex = 0;
        int fromIndex = 0;
        int len = ranges.size();
        while (fromIndex < len) {
            Range r2;
            Range r = (Range)ranges.get(fromIndex);
            int min2 = r.getMin();
            int max2 = r.getMax();
            while (++fromIndex < len && (r2 = (Range)ranges.get(fromIndex)).getMin() <= max2 + 1) {
                if (r2.getMax() <= max2) continue;
                max2 = r2.getMax();
            }
            if (max2 != r.getMax()) {
                r = new Range(min2, max2);
            }
            ranges.set(toIndex++, r);
        }
        while (len > toIndex) {
            ranges.remove(--len);
        }
    }

    protected static boolean isBlock(String name) {
        for (int i = 0; i < RegexData.blockNames.length; ++i) {
            if (!name.equals(RegexData.blockNames[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean isAsciiAlnum(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    public static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        public Range(int min2, int max2) {
            this.min = min2;
            this.max = max2;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int compareTo(Object o) {
            Range other = (Range)o;
            if (this.min < other.min) {
                return -1;
            }
            if (this.min > other.min) {
                return 1;
            }
            if (this.max > other.max) {
                return -1;
            }
            if (this.max < other.max) {
                return 1;
            }
            return 0;
        }
    }
}

