/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;

public class NumberFormatter
implements Serializable {
    public static boolean methodInitialized = false;
    public static Method isLetterOrDigitMethod = null;
    private static int[] nonBmpZeroDigits = new int[]{66720, 67534, 67544, 67554, 67564, 67574};
    private ArrayList formatTokens;
    private ArrayList punctuationTokens;
    private boolean startsWithPunctuation;

    public void prepare(String format) {
        if (format.length() == 0) {
            format = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        int len = format.length();
        int i = 0;
        boolean first = true;
        this.startsWithPunctuation = true;
        while (i < len) {
            int c = format.charAt(i);
            int t = i++;
            if (UTF16.isHighSurrogate(c)) {
                c = UTF16.combinePair((char)c, format.charAt(i));
            }
            while (NumberFormatter.isLetterOrDigit(c) && ++i != len) {
                c = format.charAt(i);
                if (!UTF16.isHighSurrogate(c)) continue;
                c = UTF16.combinePair((char)c, format.charAt(++i));
            }
            if (i > t) {
                String tok = format.substring(t, i);
                this.formatTokens.add(tok);
                if (first) {
                    this.punctuationTokens.add(".");
                    this.startsWithPunctuation = false;
                    first = false;
                }
            }
            if (i == len) break;
            t = i;
            c = format.charAt(i);
            if (UTF16.isHighSurrogate(c)) {
                c = UTF16.combinePair((char)c, format.charAt(++i));
            }
            while (!NumberFormatter.isLetterOrDigit(c)) {
                first = false;
                if (++i == len) break;
                c = format.charAt(i);
                if (!UTF16.isHighSurrogate(c)) continue;
                c = UTF16.combinePair((char)c, format.charAt(++i));
            }
            if (i <= t) continue;
            String sep = format.substring(t, i);
            this.punctuationTokens.add(sep);
        }
        if (this.formatTokens.size() == 0) {
            this.formatTokens.add("1");
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    private static boolean isLetterOrDigit(int c) {
        Object[] args;
        if (c <= 65535) {
            return Character.isLetterOrDigit((char)c);
        }
        if (!methodInitialized) {
            try {
                args = new Class[]{Integer.TYPE};
                isLetterOrDigitMethod = Character.class.getDeclaredMethod("isLetterOrDigit", (Class<?>[])args);
            }
            catch (NoSuchMethodException err) {
                // empty catch block
            }
        }
        if (isLetterOrDigitMethod != null) {
            try {
                args = new Object[]{new Integer(c)};
                Boolean b = (Boolean)isLetterOrDigitMethod.invoke(null, args);
                return b;
            }
            catch (IllegalAccessException e2) {
                return false;
            }
            catch (InvocationTargetException e3) {
                return false;
            }
        }
        return NumberFormatter.getDigitValue(c) != -1;
    }

    public static int getDigitValue(int in) {
        if (in <= 65535) {
            if (Character.isDigit((char)in)) {
                return Character.getNumericValue((char)in);
            }
            return -1;
        }
        for (int z = 0; z < nonBmpZeroDigits.length; ++z) {
            if (in < nonBmpZeroDigits[z] || in > nonBmpZeroDigits[z] + 9) continue;
            return in - nonBmpZeroDigits[z];
        }
        return -1;
    }

    public CharSequence format(List numbers, int groupSize, String groupSeparator, String letterValue, String ordinal, Numberer numberer) {
        FastStringBuffer sb = new FastStringBuffer(20);
        int num = 0;
        int tok = 0;
        if (this.startsWithPunctuation) {
            sb.append((String)this.punctuationTokens.get(tok));
        }
        while (num < numbers.size()) {
            String s;
            Object o;
            if (num > 0) {
                if (tok == 0 && this.startsWithPunctuation) {
                    sb.append(".");
                } else {
                    sb.append((String)this.punctuationTokens.get(tok));
                }
            }
            if ((o = numbers.get(num++)) instanceof Long) {
                long nr = (Long)o;
                s = numberer.format(nr, (String)this.formatTokens.get(tok), groupSize, groupSeparator, letterValue, ordinal);
            } else {
                s = o.toString();
            }
            sb.append(s);
            if (++tok != this.formatTokens.size()) continue;
            --tok;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            sb.append((String)this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return sb.condense();
    }
}

