/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;

public final class GlobalParam
extends GlobalVariable {
    public int getInstructionNameCode() {
        return 170;
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        boolean wasSupplied;
        Controller controller = context.getController();
        Bindery b = controller.getBindery();
        try {
            wasSupplied = b.useGlobalParameter(this.getVariableQName(), this.getSlotNumber(), this.getRequiredType(), context);
        }
        catch (XPathException e2) {
            e2.setLocator(this);
            throw e2;
        }
        ValueRepresentation val = b.getGlobalVariableValue(this);
        if (wasSupplied || val != null) {
            return val;
        }
        if (this.isRequiredParam()) {
            XPathException e3 = new XPathException("No value supplied for required parameter $" + this.getVariableQName().getDisplayName());
            e3.setXPathContext(context);
            e3.setLocator(this.getSourceLocator());
            e3.setErrorCode(this.isXSLT() ? "XTDE0050" : "XPDY0002");
            throw e3;
        }
        if (this.isImplicitlyRequiredParam()) {
            XPathException e4 = new XPathException("A value must be supplied for parameter $" + this.getVariableQName().getDisplayName() + " because there is no default value for the required type");
            e4.setXPathContext(context);
            e4.setLocator(this.getSourceLocator());
            e4.setErrorCode("XTDE0610");
            throw e4;
        }
        try {
            b.setExecuting(this, true);
            ValueRepresentation value = this.getSelectValue(context);
            b.defineGlobalVariable(this, value);
            b.setExecuting(this, false);
            return value;
        }
        catch (XPathException err) {
            b.setExecuting(this, false);
            if (err instanceof XPathException.Circularity) {
                XPathException e5 = new XPathException("Circular definition of parameter " + this.getVariableQName().getDisplayName());
                e5.setXPathContext(context);
                e5.setErrorCode(this.isXSLT() ? "XTDE0640" : "XQST0054");
                this.select = new ErrorExpression(e5);
                throw e5;
            }
            throw err;
        }
    }
}

