/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.IsWholeNumber;
import net.sf.saxon.functions.ItemAt;
import net.sf.saxon.functions.Parse;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class VendorFunctionLibrary
implements FunctionLibrary {
    private HashMap functionTable;

    public VendorFunctionLibrary() {
        this.init();
    }

    protected StandardFunction.Entry register(String name, Class implementationClass, int opcode, int minArguments, int maxArguments, ItemType itemType, int cardinality) {
        StandardFunction.Entry e2 = StandardFunction.makeEntry(name, implementationClass, opcode, minArguments, maxArguments, itemType, cardinality);
        this.functionTable.put(name, e2);
        return e2;
    }

    protected void init() {
        this.functionTable = new HashMap(30);
        StandardFunction.Entry e2 = this.register("evaluate", Evaluate.class, 0, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(e2, 0, BuiltInAtomicType.STRING, 16384, null);
        e2 = this.register("evaluate-node", Evaluate.class, 3, 1, 1, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(e2, 0, Type.NODE_TYPE, 16384, null);
        e2 = this.register("eval", Evaluate.class, 2, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(e2, 0, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
        e2 = this.register("expression", Evaluate.class, 1, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 16384);
        StandardFunction.arg(e2, 0, BuiltInAtomicType.STRING, 16384, null);
        e2 = this.register("is-whole-number", IsWholeNumber.class, 1, 1, 1, BuiltInAtomicType.BOOLEAN, 16384);
        StandardFunction.arg(e2, 0, BuiltInAtomicType.NUMERIC, 24576, null);
        e2 = this.register("item-at", ItemAt.class, 1, 2, 2, StandardFunction.SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(e2, 0, Type.ITEM_TYPE, 57344, null);
        StandardFunction.arg(e2, 1, BuiltInAtomicType.NUMERIC, 24576, null);
        e2 = this.register("parse", Parse.class, 0, 1, 1, NodeKindTest.DOCUMENT, 16384);
        StandardFunction.arg(e2, 0, BuiltInAtomicType.STRING, 16384, null);
        e2 = this.register("serialize", Serialize.class, 0, 2, 2, BuiltInAtomicType.STRING, 16384);
        StandardFunction.arg(e2, 0, Type.NODE_TYPE, 24576, null);
        StandardFunction.arg(e2, 1, Type.ITEM_TYPE, 16384, null);
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        if (functionName.getNamespaceURI().equals("http://saxon.sf.net/")) {
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(functionName.getLocalName());
            return entry != null && (arity == -1 || arity >= entry.minArguments && arity <= entry.maxArguments);
        }
        return false;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        if (uri.equals("http://saxon.sf.net/")) {
            SystemFunction f;
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(local);
            if (entry == null) {
                return null;
            }
            Class functionClass = entry.implementationClass;
            try {
                f = (SystemFunction)functionClass.newInstance();
            }
            catch (Exception err) {
                throw new AssertionError((Object)("Failed to load Saxon extension function: " + err.getMessage()));
            }
            f.setDetails(entry);
            f.setFunctionName(functionName);
            f.setArguments(staticArgs);
            this.checkArgumentCount(staticArgs.length, entry.minArguments, entry.maxArguments, local);
            return f;
        }
        return null;
    }

    public Expression makeSaxonFunction(String localName, StaticContext env, Expression[] arguments) throws XPathException {
        String uri = "http://saxon.sf.net/";
        StructuredQName functionName = new StructuredQName("saxon", uri, localName);
        return this.bind(functionName, arguments, env);
    }

    private int checkArgumentCount(int numArgs, int min2, int max2, String local) throws XPathException {
        if (min2 == max2 && numArgs != min2) {
            throw new XPathException("Function " + Err.wrap("saxon:" + local, 3) + " must have " + min2 + VendorFunctionLibrary.pluralArguments(min2));
        }
        if (numArgs < min2) {
            throw new XPathException("Function " + Err.wrap("saxon:" + local, 3) + " must have at least " + min2 + VendorFunctionLibrary.pluralArguments(min2));
        }
        if (numArgs > max2) {
            throw new XPathException("Function " + Err.wrap("saxon:" + local, 3) + " must have no more than " + max2 + VendorFunctionLibrary.pluralArguments(max2));
        }
        return numArgs;
    }

    public static String pluralArguments(int num) {
        if (num == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

