/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;

public final class Date {
    private Date() {
    }

    public static String dateTime(XPathContext context) throws XPathException {
        return context.getCurrentDateTime().getStringValue();
    }

    public static String date(String dateTime) {
        int offset = 0;
        if (dateTime.length() >= 1 && (dateTime.charAt(0) == '-' || dateTime.charAt(0) == '+')) {
            offset = 1;
        }
        if (dateTime.length() >= offset + 10) {
            return dateTime.substring(0, offset + 10);
        }
        return "";
    }

    public static String date(XPathContext context) throws XPathException {
        return Date.date(Date.dateTime(context));
    }

    public static String time(String dateTime) {
        int t = dateTime.indexOf(84);
        if (t < 0 || t == dateTime.length() - 1) {
            return "";
        }
        return dateTime.substring(t + 1);
    }

    public static String time(XPathContext context) throws XPathException {
        return Date.time(Date.dateTime(context));
    }

    public static double year(String dateTime) {
        if (dateTime.startsWith("-")) {
            return Double.NaN;
        }
        try {
            return Integer.parseInt(dateTime.substring(0, 4));
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double year(XPathContext context) throws XPathException {
        return Date.year(Date.dateTime(context));
    }

    public static boolean leapYear(String dateTime) {
        double year = Date.year(dateTime);
        if (Double.isNaN(year)) {
            return false;
        }
        int y = (int)year;
        return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0);
    }

    public static boolean leapYear(XPathContext context) throws XPathException {
        return Date.leapYear(Date.dateTime(context));
    }

    public static double monthInYear(String dateTime) {
        try {
            if (dateTime.startsWith("--")) {
                return Integer.parseInt(dateTime.substring(2, 4));
            }
            if (dateTime.indexOf(45) != 4) {
                return Double.NaN;
            }
            return Integer.parseInt(dateTime.substring(5, 7));
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double monthInYear(XPathContext context) throws XPathException {
        return Date.monthInYear(Date.dateTime(context));
    }

    public static String monthName(String date2) {
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        double m = Date.monthInYear(date2);
        if (Double.isNaN(m)) {
            return "";
        }
        return months[(int)m - 1];
    }

    public static String monthName(XPathContext context) throws XPathException {
        return Date.monthName(Date.dateTime(context));
    }

    public static String monthAbbreviation(String date2) {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double m = Date.monthInYear(date2);
        if (Double.isNaN(m)) {
            return "";
        }
        return months[(int)m - 1];
    }

    public static String monthAbbreviation(XPathContext context) throws XPathException {
        return Date.monthAbbreviation(Date.dateTime(context));
    }

    public static double weekInYear(String dateTime) {
        int dayInYear = (int)Date.dayInYear(dateTime);
        String firstJan = dateTime.substring(0, 4) + "-01-01";
        int jan1day = ((int)Date.dayInWeek(firstJan) + 5) % 7;
        int daysInFirstWeek = jan1day == 0 ? 0 : 7 - jan1day;
        int rawWeek = (dayInYear - daysInFirstWeek + 6) / 7;
        if (daysInFirstWeek >= 4) {
            return rawWeek + 1;
        }
        if (rawWeek > 0) {
            return rawWeek;
        }
        int lastYear = Integer.parseInt(dateTime.substring(0, 4)) - 1;
        String dec31 = lastYear + "-12-31";
        return Date.weekInYear(dec31);
    }

    public static double weekInYear(XPathContext context) throws XPathException {
        return Date.weekInYear(Date.dateTime(context));
    }

    public static double weekInMonth(String dateTime) {
        return (int)((Date.dayInMonth(dateTime) - 1.0) / 7.0 + 1.0);
    }

    public static double weekInMonth(XPathContext context) throws XPathException {
        return Date.weekInMonth(Date.dateTime(context));
    }

    public static double dayInYear(String dateTime) {
        int month = (int)Date.monthInYear(dateTime);
        int day = (int)Date.dayInMonth(dateTime);
        int[] prev = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        int leap = month > 2 && Date.leapYear(dateTime) ? 1 : 0;
        return prev[month - 1] + leap + day;
    }

    public static double dayInYear(XPathContext context) throws XPathException {
        return Date.dayInYear(Date.dateTime(context));
    }

    public static double dayInMonth(String dateTime) {
        try {
            if (dateTime.startsWith("---")) {
                return Integer.parseInt(dateTime.substring(3, 5));
            }
            if (dateTime.startsWith("--")) {
                return Integer.parseInt(dateTime.substring(5, 7));
            }
            return Integer.parseInt(dateTime.substring(8, 10));
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double dayInMonth(XPathContext context) throws XPathException {
        return Date.dayInMonth(Date.dateTime(context));
    }

    public static double dayOfWeekInMonth(String dateTime) {
        double dd = Date.dayInMonth(dateTime);
        if (Double.isNaN(dd)) {
            return dd;
        }
        return ((int)dd - 1) / 7 + 1;
    }

    public static double dayOfWeekInMonth(XPathContext context) throws XPathException {
        return Date.dayOfWeekInMonth(Date.dateTime(context));
    }

    public static double dayInWeek(String dateTime) {
        double yy = Date.year(dateTime);
        double mm = Date.monthInYear(dateTime);
        double dd = Date.dayInMonth(dateTime);
        if (Double.isNaN(yy) || Double.isNaN(mm) || Double.isNaN(dd)) {
            return Double.NaN;
        }
        GregorianCalendar calDate = new GregorianCalendar((int)yy, (int)mm - 1, (int)dd);
        calDate.setFirstDayOfWeek(1);
        return calDate.get(7);
    }

    public static double dayInWeek(XPathContext context) throws XPathException {
        return Date.dayInWeek(Date.dateTime(context));
    }

    public static String dayName(String dateTime) {
        String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        double d = Date.dayInWeek(dateTime);
        if (Double.isNaN(d)) {
            return "";
        }
        return days[(int)d - 1];
    }

    public static String dayName(XPathContext context) throws XPathException {
        return Date.dayName(Date.dateTime(context));
    }

    public static String dayAbbreviation(String dateTime) {
        String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        double d = Date.dayInWeek(dateTime);
        if (Double.isNaN(d)) {
            return "";
        }
        return days[(int)d - 1];
    }

    public static String dayAbbreviation(XPathContext context) throws XPathException {
        return Date.dayAbbreviation(Date.dateTime(context));
    }

    public static double hourInDay(String dateTime) {
        int t = dateTime.indexOf(84);
        try {
            int hh = Integer.parseInt(dateTime.substring(t + 1, t + 3));
            return hh;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double hourInDay(XPathContext context) throws XPathException {
        return Date.hourInDay(Date.dateTime(context));
    }

    public static double minuteInHour(String dateTime) {
        int t = dateTime.indexOf(84);
        try {
            int mm = Integer.parseInt(dateTime.substring(t + 4, t + 6));
            return mm;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double minuteInHour(XPathContext context) throws XPathException {
        return Date.minuteInHour(Date.dateTime(context));
    }

    public static double secondInMinute(String dateTime) {
        int t = dateTime.indexOf(84);
        try {
            int ss = Integer.parseInt(dateTime.substring(t + 7, t + 9));
            return ss;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public static double secondInMinute(XPathContext context) throws XPathException {
        return Date.secondInMinute(Date.dateTime(context));
    }
}

