/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import licef.IOUtil;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(String sourceDir, String destinationFile) {
        File srcDir = new File(sourceDir);
        if (!srcDir.exists()) {
            return false;
        }
        File destFile = new File(destinationFile);
        if (destFile.exists()) {
            destFile.delete();
        }
        if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(new FileOutputStream(destFile));
            ZipUtil.zipFileRec(srcDir, "", zout);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zout.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zipFileRec(File srcDir, String path, ZipOutputStream zout) throws IOException {
        File longPath = new File(srcDir, path);
        File[] files = longPath.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (".".equals(f.getName()) || "..".equals(f.getName())) continue;
            if (f.isDirectory()) {
                ZipUtil.zipFileRec(srcDir, path.length() == 0 ? f.getName() : path + "/" + f.getName(), zout);
                continue;
            }
            InputStream in = null;
            try {
                in = new FileInputStream(new File(longPath, f.getName()));
                String entryName = path.length() == 0 ? f.getName() : path + "/" + f.getName();
                ZipEntry entry = new ZipEntry(entryName);
                zout.putNextEntry(entry);
                IOUtil.copy(in, zout);
                zout.closeEntry();
                continue;
            }
            finally {
                in.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFile(String zipFile, String destinationDir) {
        File dstDir = new File(destinationDir);
        if (!dstDir.exists() && !dstDir.mkdirs()) {
            System.err.println("Could not create directory: " + destinationDir);
            return false;
        }
        BufferedInputStream in = null;
        ZipInputStream zin = null;
        try {
            ZipEntry e2;
            in = new BufferedInputStream(new FileInputStream(zipFile));
            zin = new ZipInputStream(in);
            while ((e2 = zin.getNextEntry()) != null) {
                File outputLocation = new File(destinationDir, e2.getName());
                if (e2.isDirectory()) {
                    outputLocation.mkdirs();
                    continue;
                }
                ZipUtil.unzip(zin, outputLocation);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zin.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void unzip(ZipInputStream zin, File outputFile) throws IOException {
        File parentDir = outputFile.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outputFile);
        IOUtil.copy(zin, out);
        out.close();
    }
}

