/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import licef.CommonNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    private static String ELEMENT_NAME_FUNC = "/name()";
    private static XPathFactory xPathFactory = XPathFactory.newInstance();

    public static Node getFirstChildElementNode(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType()) continue;
            return child;
        }
        return null;
    }

    public static String getXMLString(Node node, boolean omitXmlDeclaration) throws TransformerConfigurationException, TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource domSource = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
        serializer.transform(domSource, result);
        return writer.toString();
    }

    public static String getXMLString(Node node) throws TransformerConfigurationException, TransformerException {
        return XMLUtil.getXMLString(node, false);
    }

    public static Node getXMLNode(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(xmlString));
        return XMLUtil.getXMLNode(inputSource);
    }

    public static Node getXMLNode(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new BufferedInputStream(new FileInputStream(xmlFile)));
        return XMLUtil.getXMLNode(inputSource);
    }

    public static Node getXMLNode(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    public static String getString(Node node, String xpath) {
        NodeList nodeList = XMLUtil.getNodeList(node, xpath);
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getNodeName();
            }
            return "";
        }
        return XMLUtil.serialize(nodeList);
    }

    public static String serialize(NodeList nodeList) throws DOMException {
        return XMLUtil.serialize(nodeList, false);
    }

    public static String serialize(Node node, boolean format) throws DOMException {
        StringWriter writer = new StringWriter();
        XMLUtil.serialize(node, format, (Writer)writer);
        return writer.toString();
    }

    public static void serialize(final Node node, boolean format, Writer writer) throws DOMException {
        if (node.getNodeType() == 9) {
            XMLUtil.serialize(node.getChildNodes(), format, writer);
        } else {
            XMLUtil.serialize(new NodeList(){

                public Node item(int index) {
                    return node;
                }

                public int getLength() {
                    return 1;
                }
            }, format, writer);
        }
    }

    public static String serialize(NodeList nodeList, boolean format) throws DOMException {
        StringWriter writer = new StringWriter();
        XMLUtil.serialize(nodeList, format, (Writer)writer);
        return writer.toString();
    }

    public static void serialize(NodeList nodeList, boolean format, Writer writer) throws DOMException {
        if (nodeList == null) {
            throw new IllegalArgumentException("null 'subtree' NodeIterator arg in method call.");
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (format) {
                try {
                    factory.setAttribute("indent-number", new Integer(4));
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            }
            int listLength2 = nodeList.getLength();
            for (int i = 0; i < listLength2; ++i) {
                Node node = nodeList.item(i);
                if (XMLUtil.isTextNode(node)) {
                    writer.write(node.getNodeValue());
                    continue;
                }
                if (node.getNodeType() == 2) {
                    writer.write(((Attr)node).getValue());
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
        }
        catch (Exception e3) {
            DOMException domExcep = new DOMException(15, "Unable to serailise DOM subtree.");
            domExcep.initCause(e3);
            throw domExcep;
        }
    }

    public static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public static NodeList getNodeList(Node node, String xpath) {
        if (node == null) {
            throw new IllegalArgumentException("null 'document' arg in method call.");
        }
        if (xpath == null) {
            throw new IllegalArgumentException("null 'xpath' arg in method call.");
        }
        try {
            XPath xpathEvaluater = xPathFactory.newXPath();
            xpathEvaluater.setNamespaceContext(CommonNamespaceContext.getInstance());
            if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
                return (NodeList)xpathEvaluater.evaluate(xpath.substring(0, xpath.length() - ELEMENT_NAME_FUNC.length()), node, XPathConstants.NODESET);
            }
            return (NodeList)xpathEvaluater.evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e2) {
            throw new IllegalArgumentException("bad 'xpath' expression [" + xpath + "].");
        }
    }

    public static String[] getSubXML(String xml, String xpath) throws Exception {
        if (xpath == null || "".equals(xpath)) {
            return new String[0];
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(CommonNamespaceContext.getInstance());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        NodeList list = document.getDocumentElement().getChildNodes();
        NodeList s = (NodeList)xPath.evaluate(xpath, list, XPathConstants.NODESET);
        String[] res = new String[s.getLength()];
        for (int i = 0; i < s.getLength(); ++i) {
            Node n = s.item(i);
            Node sibling = n.getNextSibling();
            if (sibling != null && sibling.getNodeType() == 4) {
                n = sibling;
            }
            res[i] = XMLUtil.serialize(n, false);
        }
        return res;
    }

    public static String substituteXMLContent(String xml, String xpath, Hashtable values, boolean keepCDATA) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(CommonNamespaceContext.getInstance());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        NodeList list = document.getDocumentElement().getChildNodes();
        NodeList s = (NodeList)xPath.evaluate(xpath, list, XPathConstants.NODESET);
        for (int i = 0; i < s.getLength(); ++i) {
            Node n = s.item(i);
            Node sibling = n.getNextSibling();
            boolean isCDATANode = false;
            if (n.getNodeType() == 4) {
                isCDATANode = true;
            } else if (sibling != null && sibling.getNodeType() == 4) {
                n = sibling;
                isCDATANode = true;
            }
            String key = n.getTextContent();
            String newValue = (String)values.get(key);
            if (newValue == null) continue;
            if (isCDATANode && !keepCDATA) {
                Text newNode = document.createTextNode(newValue);
                n.getParentNode().replaceChild(newNode, n);
                continue;
            }
            n.setNodeValue(newValue);
        }
        return XMLUtil.getXMLString(document);
    }

    public static String removeHeaderDirective(String xml) {
        int indexOfDirStart = xml.indexOf("<?");
        if (indexOfDirStart == -1) {
            return xml;
        }
        int indexOfDirEnd = xml.indexOf("?>", indexOfDirStart + 2);
        if (indexOfDirEnd == -1) {
            return xml;
        }
        return xml.substring(xml.indexOf("<", indexOfDirEnd + 2));
    }

    public static String getRootTagName(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        return document.getDocumentElement().getTagName();
    }

    public static Hashtable getAttributes(String xml, String xpath) throws Exception {
        String[] array = XMLUtil.getSubXML(xml, xpath);
        if (array.length == 0) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(array[0])));
        NamedNodeMap nnm = document.getDocumentElement().getAttributes();
        Hashtable<String, String> res = new Hashtable<String, String>();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            res.put(node.getLocalName(), node.getTextContent());
        }
        return res;
    }

    public static String applyXslToDocument(Source xslt, Source doc, URIResolver resolver, Properties transformerProperties, HashMap<String, String> params) throws IOException, TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (resolver != null) {
            transformerFactory.setURIResolver(resolver);
        }
        Transformer transformer = transformerFactory.newTransformer(xslt);
        if (transformerFactory != null) {
            transformer.setOutputProperties(transformerProperties);
        }
        if (params != null) {
            for (Map.Entry<String, String> cursor : params.entrySet()) {
                transformer.setParameter(cursor.getKey(), cursor.getValue());
            }
        }
        StringWriter strWriter = new StringWriter();
        StreamResult result = new StreamResult(strWriter);
        transformer.transform(doc, result);
        return strWriter.toString();
    }

    public static Node applyXslToDocument2(Source xslt, Source doc, URIResolver resolver, Properties transformerProperties, HashMap<String, String> params) throws IOException, TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (resolver != null) {
            transformerFactory.setURIResolver(resolver);
        }
        Transformer transformer = transformerFactory.newTransformer(xslt);
        if (transformerFactory != null) {
            transformer.setOutputProperties(transformerProperties);
        }
        if (params != null) {
            for (Map.Entry<String, String> cursor : params.entrySet()) {
                transformer.setParameter(cursor.getKey(), cursor.getValue());
            }
        }
        DOMResult result = new DOMResult();
        transformer.transform(doc, result);
        return result.getNode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VALIDATION_TYPE {
        NONE,
        DTD,
        XSD;

    }
}

