/*
 * Decompiled with CFR 0.152.
 */
package licef;

import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreePath;

public class SwingsUtil {
    public static void expandAllNodes(JTree tree, boolean expand) {
        Object root = tree.getModel().getRoot();
        SwingsUtil.expandAllNodes(tree, new TreePath(root), expand);
    }

    public static void expandAllNodes(JTree tree, TreePath parent, boolean expand) {
        if (parent == null) {
            return;
        }
        Object node = parent.getLastPathComponent();
        if (node != null) {
            for (int i = 0; i < tree.getModel().getChildCount(node); ++i) {
                Object child = tree.getModel().getChild(node, i);
                TreePath path = parent.pathByAddingChild(child);
                SwingsUtil.expandAllNodes(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void expandNodes(JTree tree, TreePath parent, boolean expand, int depth) {
        if (parent == null || depth == 0) {
            return;
        }
        Object node = parent.getLastPathComponent();
        if (node != null) {
            for (int i = 0; i < tree.getModel().getChildCount(node); ++i) {
                Object child = tree.getModel().getChild(node, i);
                TreePath path = parent.pathByAddingChild(child);
                SwingsUtil.expandNodes(tree, path, expand, depth - 1);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void clear(JTextPane textPane) {
        Document doc = textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException ignore) {
            ignore.printStackTrace();
        }
    }

    public static void setText(JTextPane textPane, String[] textArray, String[] styleArray) {
        StyledDocument doc = textPane.getStyledDocument();
        try {
            doc.remove(0, doc.getLength());
            for (int i = 0; i < textArray.length; ++i) {
                int offset = doc.getLength();
                Style style = textPane.getStyle(styleArray[i]);
                doc.insertString(offset, textArray[i], style);
                doc.setParagraphAttributes(offset, textArray[i].length(), style, true);
            }
            textPane.setCaretPosition(0);
        }
        catch (BadLocationException ignore) {
            ignore.printStackTrace();
        }
    }
}

