/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class StreamUtil {
    public static String enc(String in) {
        String inStr = in;
        if (inStr == null) {
            inStr = "";
        }
        StringBuffer out = new StringBuffer();
        StreamUtil.enc(inStr, out);
        return out.toString();
    }

    public static void enc(String in, StringBuffer out) {
        for (int i = 0; i < in.length(); ++i) {
            StreamUtil.enc(in.charAt(i), out);
        }
    }

    public static void enc(char[] in, int start, int length, StringBuffer out) {
        for (int i = start; i < length + start; ++i) {
            StreamUtil.enc(in[i], out);
        }
    }

    public static void enc(char in, StringBuffer out) {
        if (in == '&') {
            out.append("&amp;");
        } else if (in == '<') {
            out.append("&lt;");
        } else if (in == '>') {
            out.append("&gt;");
        } else if (in == '\"') {
            out.append("&quot;");
        } else if (in == '\'') {
            out.append("&apos;");
        } else {
            out.append(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            int len;
            byte[] buf = new byte[bufSize];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e2) {
                System.err.println("Unable to close stream.");
                e2.printStackTrace();
            }
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.pipeStream(in, out, 4096);
        return out.toByteArray();
    }

    public static InputStream getStream(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
    }
}

