/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import licef.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LOMUtil {
    public static String buildMinimalLom(String englishTitle, String frenchTitle, String metadataLang, String location) {
        Calendar cal = Calendar.getInstance();
        String now2 = cal.get(1) + "-";
        now2 = now2 + StringUtil.insertLeading('0', 2, cal.get(2) + 1 + "");
        now2 = now2 + "-";
        now2 = now2 + StringUtil.insertLeading('0', 2, cal.get(5) + "");
        StringBuffer lom = new StringBuffer();
        lom.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        lom.append("<lom xmlns=\"http://ltsc.ieee.org/xsd/LOM\" ");
        lom.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchemainstance\" ");
        lom.append("xsi:schemaLocation=\"http://ltsc.ieee.org/xsd/LOM ");
        lom.append("http://ltsc.ieee.org/xsd/lomv1.0/lom.xsd\">\n");
        lom.append("<general><title>");
        if (englishTitle != null) {
            lom.append("<string language=\"en\">").append(englishTitle).append("</string>");
        }
        if (frenchTitle != null) {
            lom.append("<string language=\"fr\">").append(frenchTitle).append("</string>");
        }
        lom.append("</title></general>");
        lom.append("<metaMetadata><contribute><role><source>LOMv1.0</source><value>creator</value></role>");
        lom.append("<date><dateTime>").append(now2).append("</dateTime></date></contribute>");
        lom.append("<metadataSchema>LOMv1.0</metadataSchema>");
        if (metadataLang != null) {
            lom.append("<language>").append(metadataLang).append("</language>");
        }
        lom.append("</metaMetadata>");
        if (location != null) {
            lom.append("<technical>");
            lom.append("<location>").append(location).append("</location>");
            lom.append("</technical>");
        }
        lom.append("</lom>");
        return lom.toString();
    }

    public static class LOMTitlesRetriever
    extends DefaultHandler {
        private StringBuffer title = null;
        private String language = null;
        private boolean isTitleParsed = false;
        private Hashtable hTitle = new Hashtable();
        private Stack tagStack = new Stack();
        private String encoding = null;

        public LOMTitlesRetriever(String xml, String encoding) {
            this.encoding = encoding;
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser parser = parserFactory.newSAXParser();
                parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)this);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (ParserConfigurationException e3) {
                e3.printStackTrace();
            }
            catch (SAXException e4) {
                e4.printStackTrace();
            }
        }

        public LOMTitlesRetriever(String xml) {
            this(xml, "ISO-8859-1");
        }

        public Enumeration getTitles(String language) {
            Vector titles = (Vector)this.hTitle.get(language);
            if (titles == null) {
                return null;
            }
            return titles.elements();
        }

        public String getFirstTitle(String language) {
            Vector titles = (Vector)this.hTitle.get(language);
            if (titles == null || titles.size() == 0) {
                return null;
            }
            return (String)titles.firstElement();
        }

        public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
            this.tagStack.push(qName);
            if ("string".equals(qName) && "lom|general|title|string|".equals(this.getPath())) {
                this.title = new StringBuffer();
                this.isTitleParsed = false;
                this.language = attribs.getValue("language");
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String str2 = new String(ch, start, length);
            if (!this.isTitleParsed && "string".equals(this.tagStack.peek()) && "lom|general|title|string|".equals(this.getPath())) {
                this.title.append(str2);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.isTitleParsed && "string".equals(qName) && "lom|general|title|string|".equals(this.getPath())) {
                this.isTitleParsed = true;
                Vector<String> vTitle = (Vector<String>)this.hTitle.get(this.language);
                if (vTitle == null) {
                    vTitle = new Vector<String>();
                    this.hTitle.put(this.language, vTitle);
                }
                this.isTitleParsed = false;
                try {
                    vTitle.addElement(new String(this.title.toString().getBytes(), this.encoding));
                }
                catch (UnsupportedEncodingException ex) {
                    vTitle.addElement(this.title.toString());
                }
            }
            this.tagStack.pop();
        }

        private String getPath() {
            StringBuffer strPath = new StringBuffer();
            Enumeration e2 = this.tagStack.elements();
            while (e2.hasMoreElements()) {
                strPath.append(e2.nextElement().toString()).append("|");
            }
            return strPath.toString();
        }
    }
}

