/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.w3c.util.DateParser;

public class DateUtil {
    static int MILLIS_IN_DAY = 86400000;

    public static boolean isSameTime(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5) && cal1.get(11) == cal2.get(11) && cal1.get(12) == cal2.get(12);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static int toSeconds(int h, int m, int s) {
        int sec = 0;
        sec += h * 3600;
        sec += m * 60;
        return sec += s;
    }

    public static String toISOString(Date date2, String format, TimeZone tz) {
        if (format == null) {
            format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        f.setTimeZone(tz);
        return f.format(date2);
    }

    public static Date toDate(String isoDate) throws Exception {
        return DateParser.parse(isoDate).getTime();
    }

    public static String nextDay(String strDate) {
        String[] spl = strDate.split("-");
        Date date2 = new Date(Integer.parseInt(spl[0]) - 1900, Integer.parseInt(spl[1]) - 1, Integer.parseInt(spl[2]));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date2.getTime() + (long)MILLIS_IN_DAY);
    }

    public static long[] getDuration(Date date1, Date date2) {
        return DateUtil.getDuration(date2.getTime() - date1.getTime());
    }

    public static long[] getDuration(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero!");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        return new long[]{days, hours, minutes, seconds};
    }
}

