/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SingleFiledLayout
implements LayoutManager,
Serializable {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static int DEFAULT_GAP = 5;
    protected int orientation;
    protected int justification;
    protected int gap;

    public SingleFiledLayout() {
        this(0, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int orientation) {
        this(orientation, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int orientation, int justification, int gap) {
        if (orientation != 1) {
            orientation = 0;
        }
        if (justification != 1 && justification != 2 && justification != 4) {
            justification = 0;
        }
        if (gap < 0) {
            gap = 0;
        }
        this.orientation = orientation;
        this.justification = justification;
        this.gap = gap;
    }

    public void layoutContainer(Container container2) {
        Dimension size = container2.getSize();
        Insets inset = container2.getInsets();
        int x = inset.left;
        int y = inset.top;
        Component[] component = container2.getComponents();
        if (this.orientation == 0) {
            for (int counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        x = inset.left;
                        break;
                    }
                    case 1: {
                        x = (size.width - d.width >> 1) + inset.left - inset.right;
                        break;
                    }
                    case 2: {
                        x = inset.left;
                        d.width = size.width - inset.left - inset.right;
                        break;
                    }
                    case 4: {
                        x = size.width - d.width - inset.right;
                    }
                }
                component[counter].setBounds(x, y, d.width, d.height);
                y += d.height + this.gap;
            }
        } else {
            for (int counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        y = inset.top;
                        break;
                    }
                    case 1: {
                        y = (size.height - d.height >> 1) + inset.top - inset.bottom;
                        break;
                    }
                    case 2: {
                        y = inset.top;
                        d.height = size.height - inset.top - inset.bottom;
                        break;
                    }
                    case 3: {
                        y = size.height - d.height - inset.bottom;
                    }
                }
                component[counter].setBounds(x, y, d.width, d.height);
                x += d.width + this.gap;
            }
        }
    }

    public Dimension preferredLayoutSize(Container container2) {
        int counter;
        int totalWidth = 0;
        int totalHeight = 0;
        Component[] component = container2.getComponents();
        if (this.orientation == 0) {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getPreferredSize();
                if (totalWidth < d.width) {
                    totalWidth = d.width;
                }
                totalHeight += d.height + this.gap;
            }
            totalHeight -= this.gap;
        } else {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getPreferredSize();
                totalWidth += d.width + this.gap;
                if (totalHeight >= d.height) continue;
                totalHeight = d.height;
            }
            totalWidth -= this.gap;
        }
        Insets inset = container2.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    public Dimension minimumLayoutSize(Container container2) {
        int counter;
        int totalWidth = 0;
        int totalHeight = 0;
        Component[] component = container2.getComponents();
        if (this.orientation == 0) {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getMinimumSize();
                if (totalWidth < d.width) {
                    totalWidth = d.width;
                }
                totalHeight += d.height + this.gap;
            }
            totalHeight -= this.gap;
        } else {
            for (counter = 0; counter < component.length; ++counter) {
                Dimension d = component[counter].getMinimumSize();
                totalWidth += d.width + this.gap;
                if (totalHeight >= d.height) continue;
                totalHeight = d.height;
            }
            totalWidth = -this.gap;
        }
        Insets inset = container2.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

