/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.util.Iso;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.update.Update;
import org.apache.jena.atlas.lib.Lib;

public class UpdateLoad
extends Update {
    private final String source;
    private final Node dest;
    private boolean silent;

    public UpdateLoad(String source, String dest) {
        this(source, NodeFactory.createURI(dest), false);
    }

    public UpdateLoad(String source, String dest, boolean silent) {
        this(source, NodeFactory.createURI(dest), silent);
    }

    public UpdateLoad(String source, Node dest) {
        this(source, dest, false);
    }

    public UpdateLoad(String source, Node dest, boolean silent) {
        this.source = source;
        this.dest = dest;
        this.silent = silent;
    }

    public String getSource() {
        return this.source;
    }

    public Node getDest() {
        return this.dest;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Override
    public void visit(UpdateVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equalTo(Update obj, NodeIsomorphismMap isoMap) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateLoad other = (UpdateLoad)obj;
        return this.silent == other.silent && Lib.equal(this.source, other.source) && Iso.nodeIso(this.dest, other.dest, isoMap);
    }
}

