/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.JPanelForm;
import ca.licef.lompad.Preferences;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import licef.IOUtil;

class Util {
    static ResourceBundle resBundleLabel;
    static ResourceBundle resBundleTag;
    static ResourceBundle resBundlePosTag;
    static ResourceBundle resBundleVocabulary;
    static ResourceBundle resBundleXMLVocabulary;
    static ResourceBundle resBundlePosVocabulary;
    static ResourceBundle resBundleExternalVocabularySource;
    static String externalProfile;
    static ResourceBundle resBundleProfileVocabulary;
    static ResourceBundle resBundleProfileXMLVocabulary;
    static ResourceBundle resBundleProfilePosVocabulary;
    static ResourceBundle resBundleProfileVocabularySource;
    static Image imageApp;
    static Image imageAbout;
    static ImageIcon imageIconCollapse;
    static ImageIcon imageIconExpand;
    static ImageIcon plusIcon;
    static ImageIcon minusIcon;
    static ImageIcon wizardIcon;
    static ImageIcon cancoreIcon;
    static ImageIcon normeticIcon;
    static ImageIcon normeticDisabledIcon;
    static ImageIcon redIcon;
    static ImageIcon yellowIcon;
    static ImageIcon greenIcon;
    static ImageIcon greenRedIcon;
    static ImageIcon yellowRedIcon;
    static ImageIcon greenYellowRedIcon;
    static ImageIcon folderIcon;
    static ImageIcon fileIcon;
    static ImageIcon rootIcon;
    static ImageIcon vcardIcon;

    Util() {
    }

    static void setExternalVocabulary(String profile) {
        try {
            externalProfile = profile;
            resBundleProfileVocabulary = ResourceBundle.getBundle("properties." + profile + "_Vocabulary", Preferences.getInstance().getLocale());
            resBundleProfileXMLVocabulary = ResourceBundle.getBundle("properties." + profile + "_Vocabulary", new Locale(""));
            resBundleProfilePosVocabulary = ResourceBundle.getBundle("properties." + profile + "_PosVocabulary");
            resBundleProfileVocabularySource = ResourceBundle.getBundle("properties." + profile + "_VocabularySource");
        }
        catch (Exception e2) {
            externalProfile = null;
            resBundleProfileVocabulary = null;
            resBundleProfileXMLVocabulary = null;
            resBundleProfilePosVocabulary = null;
            resBundleProfileVocabularySource = null;
        }
    }

    static String getBundleValue(ResourceBundle resBundle, String key) {
        String res = null;
        try {
            res = resBundle.getString(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    static int getPosValue(ResourceBundle resBundle, String key) throws IllegalTagException {
        int pos = -1;
        String s = Util.getBundleValue(resBundle, key);
        if (s == null) {
            throw new IllegalTagException();
        }
        pos = Integer.parseInt(s);
        return pos;
    }

    static void setBundleLocale(Locale locale) {
        resBundleLabel = ResourceBundle.getBundle("properties.LomLabel", locale);
        resBundleVocabulary = ResourceBundle.getBundle("properties.LomVocabulary", locale);
        if (externalProfile != null) {
            resBundleProfileVocabulary = ResourceBundle.getBundle("properties." + externalProfile + "_Vocabulary", locale);
        }
    }

    static String getLabel(String key) {
        return Util.getBundleValue(resBundleLabel, key);
    }

    static String getTag(String key) {
        return Util.getBundleValue(resBundleTag, key);
    }

    static int getPosTag(String key) throws IllegalTagException {
        StringBuffer altKey = new StringBuffer();
        Pattern pattern = Pattern.compile("(.+?):(.+?)(/|$)");
        Matcher matcher = pattern.matcher(key);
        while (matcher.find()) {
            matcher.appendReplacement(altKey, matcher.group(2) + matcher.group(3));
        }
        matcher.appendTail(altKey);
        return Util.getPosValue(resBundlePosTag, altKey.toString());
    }

    static String getVocabulary(String key) {
        if (key.startsWith("x")) {
            String profileLabel = externalProfile;
            int indexOfUnderscore = externalProfile.indexOf("_");
            if (indexOfUnderscore != -1) {
                profileLabel = externalProfile.substring(0, indexOfUnderscore) + " " + externalProfile.substring(indexOfUnderscore + 1).replaceAll("p", ".");
            }
            return profileLabel + ": " + Util.getBundleValue(resBundleProfileVocabulary, key);
        }
        return Util.getBundleValue(resBundleVocabulary, key);
    }

    static String getXMLVocabulary(String key) {
        if (key.startsWith("x")) {
            return Util.getBundleValue(resBundleProfileXMLVocabulary, key);
        }
        return Util.getBundleValue(resBundleXMLVocabulary, key);
    }

    static int getPosVocabulary(String key, boolean isProfileKey) throws IllegalTagException {
        if (isProfileKey) {
            return Util.getPosValue(resBundleProfilePosVocabulary, key);
        }
        return Util.getPosValue(resBundlePosVocabulary, key);
    }

    static String getProfileVocabularySource(String key) {
        return Util.getBundleValue(resBundleProfileVocabularySource, key);
    }

    static String getExternalProfileFromVocabularySource(String key) {
        return Util.getBundleValue(resBundleExternalVocabularySource, key);
    }

    public static String convertSpecialCharactersForXML(String str2) {
        if (str2 == null) {
            return "";
        }
        String res = "";
        for (int i = 0; i < str2.length(); ++i) {
            char c = str2.charAt(i);
            res = c == '&' ? res + "&amp;" : (c == '<' ? res + "&lt;" : (c == '>' ? res + "&gt;" : (c == '\"' ? res + "&quot;" : res + c)));
        }
        return res;
    }

    static void initImageIcon(Class cl) {
        imageApp = Util.getImage(cl, "app.gif");
        imageAbout = Util.getImage(cl, "about.gif");
        imageIconExpand = new ImageIcon(Util.getImage(cl, "handleExpand.gif"));
        imageIconCollapse = new ImageIcon(Util.getImage(cl, "handleCollapse.gif"));
        plusIcon = new ImageIcon(Util.getImage(cl, "plus.gif"));
        minusIcon = new ImageIcon(Util.getImage(cl, "minus.gif"));
        wizardIcon = new ImageIcon(Util.getImage(cl, "wizard.gif"));
        cancoreIcon = new ImageIcon(Util.getImage(cl, "cancore.gif"));
        normeticIcon = new ImageIcon(Util.getImage(cl, "normetic.gif"));
        normeticDisabledIcon = new ImageIcon(Util.getImage(cl, "normeticDisabled.gif"));
        redIcon = new ImageIcon(Util.getImage(cl, "red.gif"));
        yellowIcon = new ImageIcon(Util.getImage(cl, "yellow.gif"));
        greenIcon = new ImageIcon(Util.getImage(cl, "green.gif"));
        greenRedIcon = new ImageIcon(Util.getImage(cl, "greenRed.gif"));
        yellowRedIcon = new ImageIcon(Util.getImage(cl, "yellowRed.gif"));
        greenYellowRedIcon = new ImageIcon(Util.getImage(cl, "greenYellowRed.gif"));
        folderIcon = new ImageIcon(Util.getImage(cl, "folder.gif"));
        fileIcon = new ImageIcon(Util.getImage(cl, "file.gif"));
        rootIcon = new ImageIcon(Util.getImage(cl, "root.gif"));
        vcardIcon = new ImageIcon(Util.getImage(cl, "vcard.png"));
    }

    public static Image getImage(Class cl, String name) {
        Image image = null;
        try {
            BufferedInputStream in = new BufferedInputStream(cl.getResourceAsStream("/images/" + name));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtil.copy(in, out);
            image = Toolkit.getDefaultToolkit().createImage(out.toByteArray());
        }
        catch (Exception e2) {
            return null;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, Writer out) throws IOException {
        Reader reader = in;
        synchronized (reader) {
            Writer writer = out;
            synchronized (writer) {
                int charRead;
                char[] buffer = new char[1024];
                while ((charRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, charRead);
                }
            }
        }
    }

    public static Object[] readFile(String url) {
        Object[] res = null;
        ArrayList<String> list = new ArrayList<String>();
        String nextLine = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((nextLine = in.readLine()) != null) {
                list.add(nextLine);
            }
            in.close();
            res = list.toArray();
        }
        catch (IOException e2) {
            System.out.println("e = " + e2);
        }
        return res;
    }

    public static Object[] readFile(Class cl, String filename) {
        Object[] res = null;
        ArrayList<String> list = new ArrayList<String>();
        String nextLine = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(cl.getResourceAsStream("/res/" + filename)));
            while ((nextLine = in.readLine()) != null) {
                list.add(nextLine);
            }
            in.close();
            res = list.toArray();
            return res;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static JFrame getTopJFrame(Container c) {
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        Container theFrame = c;
        while ((theFrame = theFrame.getParent()) != null && !(theFrame instanceof JFrame)) {
        }
        if (theFrame == null) {
            theFrame = new JFrame();
        }
        return (JFrame)theFrame;
    }

    static void launchFile(String filePath) {
        String osName = System.getProperty("os.name").toLowerCase();
        String commandLine = null;
        if (osName.startsWith("windows")) {
            commandLine = osName.startsWith("windows 9") || osName.startsWith("windows me") ? "start " + filePath : "cmd /c start \"nom\" \"" + filePath + "\"";
        } else if (osName.startsWith("mac")) {
            commandLine = "/usr/bin/open " + filePath;
        } else if (osName.startsWith("linux")) {
            commandLine = "/usr/bin/xdg-open " + filePath;
        }
        try {
            Runtime.getRuntime().exec(commandLine);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static String completeDigit(String s, int length) {
        if (s.length() == length) {
            return s;
        }
        String prefix = "";
        for (int i = 0; i < length - s.length(); ++i) {
            prefix = prefix + "0";
        }
        return prefix + s;
    }

    public static boolean isShowHiddenDirectoryOptionAvailable() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac") || osName.startsWith("linux");
    }

    public static String getDataFolder() {
        String dataFolder = null;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            String appDataFolder = System.getenv().get("LOCALAPPDATA");
            if (appDataFolder == null || "".equals(appDataFolder)) {
                appDataFolder = System.getenv().get("APPDATA");
            }
            dataFolder = appDataFolder + "/lompad";
        } else if (osName.startsWith("mac") || osName.startsWith("linux")) {
            dataFolder = System.getProperty("user.home") + "/.lompad";
        }
        if (dataFolder != null) {
            IOUtil.createDirectory(dataFolder);
        }
        return dataFolder;
    }

    public static String getClassificationFolder() {
        String classifFolder = Util.getDataFolder();
        if (classifFolder == null) {
            return null;
        }
        classifFolder = classifFolder + "/classif";
        IOUtil.createDirectory(classifFolder);
        return classifFolder;
    }

    public static Object[] initVocabularyValues(String title) {
        return Util.initVocabularyValues(title, true);
    }

    public static Object[] initVocabularyValues(String title, boolean isFirstValueEmpty) {
        ArrayList listVocab = new ArrayList();
        if (isFirstValueEmpty) {
            listVocab.add(null);
        }
        Util.fillVocabularies(resBundleVocabulary, title, listVocab);
        String selectedProfile = JPanelForm.instance.getCurrentSelectedProfile();
        if (!selectedProfile.equals("IEEE")) {
            try {
                if (externalProfile != null) {
                    Util.fillVocabularies(resBundleProfileVocabulary, "x" + title, listVocab);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listVocab.toArray();
    }

    private static void fillVocabularies(ResourceBundle resBundle, String prefixKey, ArrayList listVocab) {
        int i = 1;
        try {
            while (true) {
                String key = prefixKey + "-" + i;
                resBundle.getString(key);
                listVocab.add(key);
                ++i;
            }
        }
        catch (MissingResourceException e2) {
            return;
        }
    }

    static {
        ToolTipManager.sharedInstance().setDismissDelay(8000);
        try {
            resBundleLabel = ResourceBundle.getBundle("properties.LomLabel", Preferences.getInstance().getLocale());
            resBundleTag = ResourceBundle.getBundle("properties.LomTag");
            resBundlePosTag = ResourceBundle.getBundle("properties.LomPosTag");
            resBundleVocabulary = ResourceBundle.getBundle("properties.LomVocabulary", Preferences.getInstance().getLocale());
            resBundleXMLVocabulary = ResourceBundle.getBundle("properties.LomVocabulary", new Locale(""));
            resBundlePosVocabulary = ResourceBundle.getBundle("properties.LomPosVocabulary");
            resBundleExternalVocabularySource = ResourceBundle.getBundle("properties.ExternalVocabularySource");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

