/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormMediator;
import ca.licef.lompad.JTextAreaPopup;
import ca.licef.lompad.JTextFieldPopup;
import ca.licef.lompad.NumericTextField;
import ca.licef.lompad.Util;
import java.awt.Color;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextComponent
extends FormComponent {
    JScrollPane jScrollPaneTextArea;
    JTextComponent currentJTextComponent;

    public TextComponent(FormMediator mediator, boolean isOneLine) {
        super(mediator);
        if (isOneLine) {
            this.currentJTextComponent = new JTextFieldPopup();
            this.jPanelGauche.add(this.currentJTextComponent);
        } else {
            this.jScrollPaneTextArea = new JScrollPane();
            this.jPanelGauche.add("Center", this.jScrollPaneTextArea);
            this.currentJTextComponent = new JTextAreaPopup();
            ((JTextAreaPopup)this.currentJTextComponent).setLineWrap(true);
            this.jScrollPaneTextArea.getViewport().add(this.currentJTextComponent);
        }
    }

    @Override
    boolean isFilled() {
        return !this.currentJTextComponent.getText().trim().equals("");
    }

    @Override
    public void setEnabled(boolean b) {
        this.currentJTextComponent.setEditable(b);
        this.currentJTextComponent.setBackground(Color.white);
    }

    @Override
    void updateAfterAdded() {
        this.currentJTextComponent.requestFocus();
    }

    void setNumericTextField(Object[] numericParam) {
        this.jPanelGauche.removeAll();
        this.currentJTextComponent = new NumericTextField((Integer)numericParam[0], (String)numericParam[1], (String)numericParam[2]);
        this.jPanelGauche.add(this.currentJTextComponent);
    }

    @Override
    public void clear() {
        this.currentJTextComponent.setText(null);
    }

    void setValue(String text) {
        this.currentJTextComponent.setText(text);
        this.currentJTextComponent.setCaretPosition(0);
    }

    @Override
    String toXML(String key) {
        String xml = null;
        if (!this.currentJTextComponent.getText().equals("")) {
            xml = Util.convertSpecialCharactersForXML(this.currentJTextComponent.getText());
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        if (e2.getFirstChild() != null) {
            this.currentJTextComponent.setText(e2.getFirstChild().getNodeValue().trim());
            this.currentJTextComponent.setCaretPosition(0);
        }
    }

    @Override
    String toHTML(String key) {
        String html = null;
        if (this.isFilled()) {
            html = this.currentJTextComponent.getText();
            if ("4.3".equals(key)) {
                html = "<a href=\"" + html + "\" target=\"_blank\">" + html + "</a>";
            }
            if ("9.2.1".equals(key)) {
                html = Util.getLabel(key) + " : " + html;
            }
            html = html + "<br>";
            if (this.currentJTextComponent instanceof JTextArea) {
                html = html.replaceAll("\n", "<br>");
                html = html + "<br>";
            }
        }
        return html;
    }
}

