/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.FormWrapper;
import ca.licef.lompad.JDialogTaxonPathSelector;
import ca.licef.lompad.LangstringForm;
import ca.licef.lompad.TaxonForm;
import ca.licef.lompad.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaxonPathForm
extends FormContainer {
    public TaxonPathForm(String title, boolean isLine, boolean isMultiple) {
        super(title, isLine, isMultiple);
    }

    @Override
    public void clearFormIcon() {
    }

    @Override
    void addFormContent() {
        FormWrapperTP wrapper = new FormWrapperTP("", true);
        wrapper.addToggle();
        LangstringForm source = new LangstringForm("9.2.1", false, true, true);
        source.setIcon(Util.redIcon);
        source.addFormContent();
        wrapper.addComponent(source);
        wrapper.addSpace(5);
        TaxonForm taxon = new TaxonForm(null, false, true);
        taxon.addFormContent();
        wrapper.addComponent(taxon);
        this.addComponent(wrapper);
    }

    void addValues(String src, Object[] taxonPath) {
        FormWrapperTP c = null;
        if (this.isFilled()) {
            this.addFormContent();
            c = (FormWrapperTP)this.vComponents.lastElement();
        } else {
            c = (FormWrapperTP)this.vComponents.firstElement();
        }
        c.setValues(src, taxonPath);
    }

    @Override
    String toXML(String key) {
        String xml = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = ((FormWrapper)c).toXML(key, true);
            if (res == null) continue;
            xml = xml + "<" + Util.getTag(key) + ">" + res + "</" + Util.getTag(key) + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        FormWrapper c = null;
        if (this.isFilled()) {
            if (!this.isMultipleContainer) {
                return;
            }
            this.addFormContent();
            c = (FormWrapper)this.vComponents.lastElement();
        } else {
            c = (FormWrapper)this.vComponents.firstElement();
        }
        c.fromXML(path, e2, true, observations);
    }

    @Override
    String toHTML(String key) {
        String html = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = ((FormWrapper)c).toHTML(key, true);
            if (res == null) continue;
            html = html + (html.equals("") ? "" : "<br>") + res;
        }
        html = !html.equals("") ? "<TR><TD WIDTH=\"160\" VALIGN=\"TOP\"><B>" + Util.getLabel(key) + "</B></TD>" + "<TD VALIGN=\"TOP\">" + html + "</TD></TR>" : null;
        return html;
    }

    class FormWrapperTP
    extends FormWrapper {
        JButton jButtonWizard;
        Component horizontalStrut;

        public FormWrapperTP(String title, boolean isLine) {
            super(title, isLine);
            this.jButtonWizard = new JButton(Util.wizardIcon);
            this.jButtonWizard.setFont(new Font("Dialog", 0, 12));
            this.jButtonWizard.setFocusPainted(false);
            this.jButtonWizard.setBorderPainted(false);
            this.jButtonWizard.setPreferredSize(new Dimension(23, 23));
            this.horizontalStrut = Box.createHorizontalStrut(5);
            this.jPanelDroite.add(this.jButtonWizard);
            this.jButtonWizard.addActionListener(new SymAction());
            this.jButtonWizard.addMouseListener(new FormContainer.SymMouse());
            this.add(this.horizontalStrut);
        }

        public void updateContentVisible() {
            super.updateContentVisible();
            this.jButtonWizard.setVisible(this.jToggleButtonHandle.isSelected());
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.horizontalStrut.setVisible(b);
            this.jButtonWizard.setVisible(b);
        }

        void setValues(String src, Object[] taxonPath) {
            LangstringForm source = (LangstringForm)this.vComponents.firstElement();
            source.setValues(src, null);
            TaxonForm taxonForm = (TaxonForm)this.vComponents.lastElement();
            for (int i = 0; i < taxonPath.length; ++i) {
                Object[] taxon = (Object[])taxonPath[i];
                taxonForm.setTaxon(taxon);
            }
        }

        private Object[] selectClassificationPath() {
            JDialogTaxonPathSelector jDialog = new JDialogTaxonPathSelector(Util.getTopJFrame(this));
            jDialog.setVisible(true);
            Object[] taxonPath = null;
            String source = null;
            if (jDialog.bOk) {
                source = jDialog.source;
                taxonPath = jDialog.taxonPath;
            }
            jDialog.dispose();
            return new Object[]{source, taxonPath};
        }

        void jButtonWizard_actionPerformed(ActionEvent event) {
            Object[] res = this.selectClassificationPath();
            if (res[0] != null) {
                this.clear();
                this.setValues((String)res[0], (Object[])res[1]);
            }
        }

        class SymAction
        implements ActionListener {
            SymAction() {
            }

            public void actionPerformed(ActionEvent event) {
                Object object = event.getSource();
                if (object.equals(FormWrapperTP.this.jButtonWizard)) {
                    FormWrapperTP.this.jButtonWizard_actionPerformed(event);
                }
            }
        }
    }
}

