/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.JTextFieldPopup;
import ca.licef.lompad.LocalizeJLabel;
import ca.licef.lompad.OrderedValue;
import ca.licef.lompad.Util;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrCompositeComponent
extends FormComponent {
    JPanel jPanelWrapperGauche;
    JPanel jPanelWrapperDroite;
    JPanel jPanelOrCompGauche;
    JPanel jPanelOrCompDroite;
    LocalizeJLabel jLabelType;
    LocalizeJLabel jLabelName;
    LocalizeJLabel jLabelMinVer;
    LocalizeJLabel jLabelMaxVer;
    JComboBox jComboBoxType;
    JComboBox jComboBoxName;
    JTextFieldPopup jTextFieldMinVer;
    JTextFieldPopup jTextFieldMaxVer;
    String[] typeValues = new String[]{"4.4.1.1-1", "4.4.1.1-2"};

    public OrCompositeComponent() {
        super(null);
        this.jPanelWrapperGauche = new JPanel();
        this.jPanelWrapperGauche.setOpaque(false);
        this.jPanelWrapperDroite = new JPanel();
        this.jPanelWrapperDroite.setOpaque(false);
        this.jPanelOrCompGauche = new JPanel();
        this.jPanelOrCompGauche.setOpaque(false);
        this.jPanelOrCompDroite = new JPanel();
        this.jPanelOrCompDroite.setOpaque(false);
        this.jLabelType = new LocalizeJLabel("4.4.1.1");
        this.jLabelType.setFont(new Font("Dialog", 0, 12));
        this.jLabelName = new LocalizeJLabel("4.4.1.2");
        this.jLabelName.setFont(this.jLabelType.getFont());
        this.jLabelMinVer = new LocalizeJLabel("4.4.1.3");
        this.jLabelMinVer.setFont(this.jLabelType.getFont());
        this.jLabelMaxVer = new LocalizeJLabel("4.4.1.4");
        this.jLabelMaxVer.setFont(this.jLabelType.getFont());
        this.jComboBoxName = new JComboBox();
        this.jComboBoxName.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxType = new JComboBox();
        this.jComboBoxType.setFont(this.jComboBoxName.getFont());
        this.jComboBoxType.addActionListener(new SymAction());
        this.jComboBoxType.addItem(null);
        this.jComboBoxType.addItem(new OrderedValue(this.typeValues[0], 1, true));
        this.jComboBoxType.addItem(new OrderedValue(this.typeValues[1], 2, true));
        this.jTextFieldMinVer = new JTextFieldPopup();
        this.jTextFieldMaxVer = new JTextFieldPopup();
        this.jPanelWrapperGauche.setLayout(new CardLayout(5, 0));
        this.jPanelWrapperDroite.setLayout(new CardLayout(5, 0));
        this.jPanelOrCompGauche.setLayout(new GridLayout(4, 1, 0, 2));
        this.jPanelOrCompDroite.setLayout(new GridLayout(4, 1, 0, 2));
        this.jPanelOrCompGauche.add(this.jLabelType);
        this.jPanelOrCompDroite.add(this.jComboBoxType);
        this.jPanelOrCompGauche.add(this.jLabelName);
        this.jPanelOrCompDroite.add(this.jComboBoxName);
        this.jPanelOrCompGauche.add(this.jLabelMinVer);
        this.jPanelOrCompDroite.add(this.jTextFieldMinVer);
        this.jPanelOrCompGauche.add(this.jLabelMaxVer);
        this.jPanelOrCompDroite.add(this.jTextFieldMaxVer);
        this.jPanelWrapperGauche.add("g", this.jPanelOrCompGauche);
        this.jPanelWrapperDroite.add("d", this.jPanelOrCompDroite);
        this.jPanelGauche.add("West", this.jPanelWrapperGauche);
        this.jPanelGauche.add("Center", this.jPanelWrapperDroite);
    }

    @Override
    boolean isFilled() {
        return this.jComboBoxName.getSelectedItem() != null || !this.jTextFieldMinVer.getText().trim().equals("") || !this.jTextFieldMaxVer.getText().trim().equals("");
    }

    @Override
    public void setEnabled(boolean b) {
        this.jComboBoxType.setEnabled(b);
        this.jComboBoxName.setEnabled(b);
        this.jTextFieldMinVer.setEditable(b);
        this.jTextFieldMinVer.setBackground(Color.white);
        this.jTextFieldMaxVer.setEditable(b);
        this.jTextFieldMaxVer.setBackground(Color.white);
    }

    @Override
    String toXML(String key) {
        String xml = "";
        if (this.jComboBoxName.getSelectedItem() != null) {
            xml = xml + "<" + Util.getTag(key + ".1") + ">" + "<source>LOMv1.0</source>\n" + "<value>" + Util.getXMLVocabulary(((OrderedValue)this.jComboBoxType.getSelectedItem()).value.toString()) + "</value>\n" + "</" + Util.getTag(key + ".1") + ">\n";
            xml = xml + "<" + Util.getTag(key + ".2") + ">" + "<source>LOMv1.0</source>\n" + "<value>" + Util.getXMLVocabulary(((OrderedValue)this.jComboBoxName.getSelectedItem()).value.toString()) + "</value>\n" + "</" + Util.getTag(key + ".2") + ">\n";
        }
        if (!this.jTextFieldMinVer.getText().trim().equals("")) {
            xml = xml + "<" + Util.getTag(key + ".3") + ">" + Util.convertSpecialCharactersForXML(this.jTextFieldMinVer.getText().trim()) + "</" + Util.getTag(key + ".3") + ">\n";
        }
        if (!this.jTextFieldMaxVer.getText().trim().equals("")) {
            xml = xml + "<" + Util.getTag(key + ".4") + ">" + Util.convertSpecialCharactersForXML(this.jTextFieldMaxVer.getText().trim()) + "</" + Util.getTag(key + ".4") + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        NodeList list = e2.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            try {
                int index;
                String key;
                Element val;
                NodeList nl;
                int pos = Util.getPosTag(path + "/" + child.getTagName().toLowerCase());
                if (pos == 1 && (nl = child.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "value")).getLength() != 0 && (val = (Element)nl.item(0)).getFirstChild() != null) {
                    key = val.getFirstChild().getNodeValue().trim();
                    index = Util.getPosVocabulary(key, false);
                    this.jComboBoxType.setSelectedIndex(index);
                }
                if (pos == 2 && (nl = child.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "value")).getLength() != 0 && (val = (Element)nl.item(0)).getFirstChild() != null) {
                    key = val.getFirstChild().getNodeValue().trim();
                    index = Util.getPosVocabulary(key, false);
                    this.jComboBoxName.setSelectedIndex(index);
                }
                if (pos == 3 && child.getFirstChild() != null) {
                    this.jTextFieldMinVer.setText(child.getFirstChild().getNodeValue());
                }
                if (pos != 4 || child.getFirstChild() == null) continue;
                this.jTextFieldMaxVer.setText(child.getFirstChild().getNodeValue());
                continue;
            }
            catch (IllegalTagException illegalTagException) {
                // empty catch block
            }
        }
    }

    @Override
    String toHTML(String key) {
        String html = "";
        if (this.jComboBoxName.getSelectedItem() != null) {
            html = html + Util.getVocabulary(((OrderedValue)this.jComboBoxType.getSelectedItem()).value.toString()) + " : " + this.jComboBoxName.getSelectedItem() + "<br>";
        }
        if (!this.jTextFieldMinVer.getText().trim().equals("")) {
            html = html + Util.getLabel(key + ".1.3") + " : " + this.jTextFieldMinVer.getText().trim() + "<br>";
        }
        if (!this.jTextFieldMaxVer.getText().trim().equals("")) {
            html = html + Util.getLabel(key + ".1.4") + " : " + this.jTextFieldMaxVer.getText().trim() + "<br>";
        }
        if (html.equals("")) {
            html = null;
        }
        return html;
    }

    private Object[] getOSValues() {
        return Util.initVocabularyValues("4.4.1.2.os", false);
    }

    private Object[] getBrowserValues() {
        return Util.initVocabularyValues("4.4.1.2.browser", false);
    }

    private DefaultComboBoxModel getOSComboBoxModel() {
        DefaultComboBoxModel<OrderedValue> model = new DefaultComboBoxModel<OrderedValue>();
        Object[] values = this.getOSValues();
        for (int i = 0; i < values.length; ++i) {
            model.addElement(new OrderedValue(values[i], i, true));
        }
        return model;
    }

    private DefaultComboBoxModel getBrowserComboBoxModel() {
        DefaultComboBoxModel<OrderedValue> model = new DefaultComboBoxModel<OrderedValue>();
        Object[] values = this.getBrowserValues();
        for (int i = 0; i < values.length; ++i) {
            model.addElement(new OrderedValue(values[i], i, true));
        }
        return model;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == OrCompositeComponent.this.jComboBoxType) {
                OrCompositeComponent.this.jComboBoxName.removeAllItems();
                int index = OrCompositeComponent.this.jComboBoxType.getSelectedIndex();
                if (index == 1) {
                    OrCompositeComponent.this.jComboBoxName.setModel(OrCompositeComponent.this.getOSComboBoxModel());
                } else if (index == 2) {
                    OrCompositeComponent.this.jComboBoxName.setModel(OrCompositeComponent.this.getBrowserComboBoxModel());
                }
            }
        }
    }
}

