/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.JTextFieldPopup;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

class NumericTextField
extends JTextFieldPopup {
    int length = -1;
    String minMask;
    String maxMask;
    int minValue;
    int maxValue;

    public NumericTextField() {
        this(-1, null, null);
    }

    public NumericTextField(int length, String minMask, String maxMask) {
        this.length = length;
        this.minMask = minMask;
        this.maxMask = maxMask;
        if (minMask != null) {
            this.minValue = Integer.parseInt(minMask);
        }
        if (maxMask != null) {
            this.maxValue = Integer.parseInt(maxMask);
        }
        this.addKeyListener(new SymKey());
    }

    boolean isFilled() {
        return this.length != -1 ? this.getText().length() == this.length : !this.getText().trim().equals("");
    }

    boolean isPermitted(char c) {
        int value;
        if (this.length != -1 && this.getText().length() == this.length) {
            return false;
        }
        if (this.minMask != null && (this.getText().length() == 0 ? c < this.minMask.charAt(0) : this.getText().length() < this.minMask.length() && (value = Integer.parseInt(this.getText() + c)) < this.minValue)) {
            return false;
        }
        return this.maxMask == null || !(this.getText().length() == 0 ? c > this.maxMask.charAt(0) : (value = Integer.parseInt(this.getText() + c)) > this.maxValue);
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                data = data.replaceAll("\\s+", "");
                data = data.replaceAll("\\u00A0", "");
                int numValue = Integer.parseInt(data);
                System.out.println("numValue = " + numValue);
                clipboard.setContents(new StringSelection(numValue + ""), null);
                super.paste();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }

    void NumericTextField_keyTyped(KeyEvent event) {
        char c = event.getKeyChar();
        boolean bConsume = false;
        if (c != '\b' && c != '\u007f' && c != '\n' && c != '\t' && !Character.isDigit(c)) {
            bConsume = true;
        }
        if (Character.isDigit(c) && !this.isPermitted(c)) {
            bConsume = true;
        }
        if (bConsume) {
            event.consume();
        }
    }

    class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        public void keyTyped(KeyEvent event) {
            Object object = event.getSource();
            if (object == NumericTextField.this) {
                NumericTextField.this.NumericTextField_keyTyped(event);
            }
        }
    }
}

