/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ClassifTree;
import ca.licef.lompad.ClassifTreeModel;
import ca.licef.lompad.Classification;
import ca.licef.lompad.JDialogTaxonPathSelector;
import ca.licef.lompad.JPanelForm;
import ca.licef.lompad.LocalizeTaxon;
import ca.licef.lompad.Preferences;
import com.hp.hpl.jena.rdf.model.Model;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JPanelTaxonomy
extends JPanel {
    private JDialogTaxonPathSelector parentDialog;
    JPanel jPanelClassifications;
    public JComboBox jComboBoxClassification;
    private JCheckBox jCheckBoxShowTaxumId;
    ArrayList trees = new ArrayList();
    ArrayList<String> classifUrl = new ArrayList();
    ArrayList associatedPurpose = new ArrayList();
    private int prevSelectedClassifIndex = 0;

    public JPanelTaxonomy(JDialogTaxonPathSelector parentDialog) {
        this.parentDialog = parentDialog;
        this.setLayout(new BorderLayout());
        Font defaultFont = new Font("Dialog", 0, 12);
        this.jComboBoxClassification = new JComboBox(){

            public Insets getInsets() {
                return new Insets(5, 2, 5, 2);
            }
        };
        this.jComboBoxClassification.setFocusable(false);
        this.jComboBoxClassification.setFont(new Font("Dialog", 0, 12));
        this.jCheckBoxShowTaxumId = new JCheckBox("", Preferences.getInstance().isShowTaxumId());
        this.jCheckBoxShowTaxumId.setFont(defaultFont);
        this.jCheckBoxShowTaxumId.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                try {
                    Preferences.getInstance().setShowTaxumId(JPanelTaxonomy.this.jCheckBoxShowTaxumId.isSelected());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JPanelTaxonomy.this.update();
            }
        });
        this.add("North", this.jComboBoxClassification);
        this.jPanelClassifications = new JPanel(new CardLayout());
        this.add("Center", this.jPanelClassifications);
        this.add("South", this.jCheckBoxShowTaxumId);
        this.initClassifications();
        SymAction lSymAction = new SymAction();
        this.jComboBoxClassification.addActionListener(lSymAction);
        String prevSelectedClassif = Preferences.getInstance().getPrevSelectedClassif();
        if (prevSelectedClassif != null && !"".equals(prevSelectedClassif)) {
            Classification selectedClassif = new Classification(Preferences.getInstance().getPrevSelectedClassif(), null);
            int selectedIndex = ((DefaultComboBoxModel)this.jComboBoxClassification.getModel()).getIndexOf(selectedClassif);
            if (selectedIndex == -1) {
                this.jComboBoxClassification_actionPerformed(null);
            } else {
                this.jComboBoxClassification.setSelectedItem(selectedClassif);
            }
        } else {
            this.jComboBoxClassification_actionPerformed(null);
        }
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JPanelTaxonomyRes", Preferences.getInstance().getLocale());
        this.jCheckBoxShowTaxumId.setText(resBundle.getString("showTaxumId"));
    }

    public void setVisible(boolean b) {
        if (b) {
            this.update();
        }
    }

    public void update() {
        for (JTree tree : this.trees) {
            tree.clearSelection();
            tree.updateUI();
        }
    }

    private void initClassifications() {
        this.trees.clear();
        this.classifUrl.clear();
        this.jPanelClassifications.removeAll();
        this.jComboBoxClassification.removeAllItems();
        int i = 0;
        for (Classification classif : Classification.getAll()) {
            try {
                this.initClassification(i, classif);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            ++i;
        }
        this.addImportClassifItem();
    }

    private void addImportClassifItem() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JPanelTaxonomyRes", Preferences.getInstance().getLocale());
        this.jComboBoxClassification.addItem(resBundle.getString("ImportClassification"));
    }

    private void initClassification(int index, Classification classif) throws MalformedURLException, IOException, ParserConfigurationException, SAXException {
        JPanel jPanelClassif = new JPanel(new BorderLayout());
        ClassifTree classifTree = new ClassifTree();
        jPanelClassif.add((Component)new JScrollPane(classifTree), "Center");
        this.trees.add(classifTree);
        this.classifUrl.add(classif.getUrl());
        this.parentDialog.addTreeListener(classifTree);
        this.jPanelClassifications.add("" + index, jPanelClassif);
        if (index < this.jComboBoxClassification.getItemCount()) {
            this.jComboBoxClassification.insertItemAt(classif, index);
        } else {
            this.jComboBoxClassification.addItem(classif);
        }
    }

    public int getSelectedIndex() {
        return this.jComboBoxClassification.getSelectedIndex();
    }

    public JTree getCurrentTree() {
        int index = this.getSelectedIndex();
        if (index != -1 && index < this.jComboBoxClassification.getItemCount() - 1) {
            JTree tree = (JTree)this.trees.get(index);
            tree.expandPath(new TreePath(((DefaultMutableTreeNode)tree.getModel().getRoot()).getPath()));
            return tree;
        }
        return null;
    }

    public ArrayList getTrees() {
        return this.trees;
    }

    public Object[] getTaxonPath() {
        Object[] nodes = this.getCurrentTree().getSelectionPath().getPath();
        Object[] taxonPath = new Object[nodes.length - 1];
        for (int i = 1; i < nodes.length; ++i) {
            Object[] taxon;
            LocalizeTaxon lt = (LocalizeTaxon)((DefaultMutableTreeNode)nodes[i]).getUserObject();
            taxonPath[i - 1] = taxon = new Object[]{lt.id, lt.getOrderedTitles()};
        }
        return taxonPath;
    }

    void jComboBoxClassification_actionPerformed(ActionEvent event) {
        int selectedIndex = this.jComboBoxClassification.getSelectedIndex();
        if (event != null && selectedIndex == this.jComboBoxClassification.getItemCount() - 1) {
            this.jComboBoxClassification.hidePopup();
            this.parentDialog.setVisible(false);
            JPanelForm.instance.manageLocalClassifications();
        } else {
            this.prevSelectedClassifIndex = selectedIndex;
            this.updateCurrentSelectedClassif();
        }
    }

    private void updateCurrentSelectedClassif() {
        Object selectedItem = this.jComboBoxClassification.getSelectedItem();
        if (selectedItem instanceof Classification) {
            Model model;
            Classification selectedClassif = (Classification)this.jComboBoxClassification.getSelectedItem();
            if (selectedClassif != null && (model = selectedClassif.getModel()) != null) {
                JTree tree = (JTree)this.trees.get(this.getSelectedIndex());
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("Hidden Root Node");
                ClassifTreeModel treeModel = new ClassifTreeModel((TreeNode)root, model);
                tree.setModel(treeModel);
            }
            int selectedIndex = this.jComboBoxClassification.getSelectedIndex();
            try {
                Preferences.getInstance().setPrevSelectedClassif(selectedClassif.getUrl());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            CardLayout cardLayout = (CardLayout)this.jPanelClassifications.getLayout();
            cardLayout.show(this.jPanelClassifications, selectedIndex + "");
            for (JTree tree : this.trees) {
                tree.clearSelection();
                tree.expandPath(new TreePath(((DefaultMutableTreeNode)tree.getModel().getRoot()).getPath()));
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JPanelTaxonomy.this.jComboBoxClassification) {
                JPanelTaxonomy.this.jComboBoxClassification_actionPerformed(event);
            }
        }
    }
}

