/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ClassifTree;
import ca.licef.lompad.ClassifTreeModel;
import ca.licef.lompad.Classification;
import ca.licef.lompad.JDialogQuestion;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class JDialogManageClassifications
extends JDialog {
    private DefaultListModel listModelClassifs;
    private ListSelectionListener listSelectionListenerClassifs;
    private JList jListClassifs;
    private JTree jTreeClassif;
    private JCheckBox jCheckBoxShowTaxumId;
    private Map<String, TreeModel> treeModels = new HashMap<String, TreeModel>();

    public JDialogManageClassifications(JFrame parent) {
        super(parent);
        Font defaultFont = new Font("Dialog", 0, 12);
        Border margin = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel jPanelMain = new JPanel(new BorderLayout());
        this.jListClassifs = new JList();
        this.jListClassifs.setFont(defaultFont);
        JScrollPane jScrollPaneClassifs = new JScrollPane(this.jListClassifs);
        JPanel jPanelClassifs = new JPanel(new BorderLayout(5, 5));
        jPanelClassifs.add("Center", jScrollPaneClassifs);
        this.jTreeClassif = new ClassifTree();
        this.updateClassifTree(null);
        JScrollPane jScrollPaneClassifTree = new JScrollPane(this.jTreeClassif);
        this.jCheckBoxShowTaxumId = new JCheckBox("", Preferences.getInstance().isShowTaxumId());
        this.jCheckBoxShowTaxumId.setFont(defaultFont);
        this.jCheckBoxShowTaxumId.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                try {
                    Preferences.getInstance().setShowTaxumId(JDialogManageClassifications.this.jCheckBoxShowTaxumId.isSelected());
                }
                catch (Exception e22) {
                    e22.printStackTrace();
                }
                JDialogManageClassifications.this.jTreeClassif.updateUI();
            }
        });
        JPanel jPanelClassifTree = new JPanel(new BorderLayout(5, 5));
        jPanelClassifTree.add("Center", jScrollPaneClassifTree);
        jPanelClassifTree.add("South", this.jCheckBoxShowTaxumId);
        JSplitPane jPanelCenter = new JSplitPane(1, jPanelClassifs, jPanelClassifTree);
        jPanelCenter.setBorder(margin);
        jPanelCenter.setDividerLocation(260);
        Dimension minSize = new Dimension(100, 50);
        jPanelClassifs.setMinimumSize(minSize);
        jPanelClassifTree.setMinimumSize(minSize);
        JPanel jPanelSouth = new JPanel(new FlowLayout(0, 5, 10));
        ActionAddClassif actionAddClassif = new ActionAddClassif();
        JButton buttonAddClassif = new JButton(actionAddClassif);
        buttonAddClassif.setFont(defaultFont);
        ActionRemoveClassif actionRemoveClassif = new ActionRemoveClassif();
        JButton buttonRemoveClassif = new JButton(actionRemoveClassif);
        buttonRemoveClassif.setFont(defaultFont);
        jPanelSouth.add(buttonAddClassif);
        jPanelSouth.add(buttonRemoveClassif);
        jPanelMain.add("Center", jPanelCenter);
        jPanelMain.add("South", jPanelSouth);
        JButton ok = new JButton();
        ok.setFont(defaultFont);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JDialogManageClassifications.this.dispose();
            }
        });
        JPanel jPanelButtons = new JPanel(new FlowLayout(2));
        jPanelButtons.add(ok);
        cp.add("Center", jPanelMain);
        cp.add("South", jPanelButtons);
        this.setSize(400, 150);
        this.treeModels.clear();
        this.listModelClassifs = new DefaultListModel();
        for (Classification classif : Classification.getAll()) {
            this.listModelClassifs.addElement(classif);
        }
        this.jListClassifs.setModel(this.listModelClassifs);
        this.listSelectionListenerClassifs = new ListSelectionListenerClassifs();
        this.jListClassifs.addListSelectionListener(this.listSelectionListenerClassifs);
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JDialogManageClassificationsRes", Preferences.getInstance().getLocale());
        this.setTitle(resBundle.getString("title"));
        this.jCheckBoxShowTaxumId.setText(resBundle.getString("showTaxumId"));
        actionAddClassif.putValue("Name", resBundle.getString("addClassif"));
        actionRemoveClassif.putValue("Name", resBundle.getString("removeClassif"));
        ok.setText(resBundle.getString("ok"));
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(isVisible);
    }

    private void update() {
        int selectedIndex = this.jListClassifs.getSelectedIndex();
        if (selectedIndex == -1) {
            this.updateClassifTree(null);
        } else {
            Classification selectedClassif = (Classification)this.jListClassifs.getModel().getElementAt(selectedIndex);
            this.updateClassifTree(selectedClassif.getUrl());
        }
    }

    private void updateClassifTree(String urlStr) {
        DefaultMutableTreeNode rootNode;
        String key = urlStr == null ? "" : urlStr;
        TreeModel model = this.treeModels.get(key);
        if (model == null) {
            rootNode = new DefaultMutableTreeNode("Hidden Root Node");
            if (urlStr == null) {
                model = new DefaultTreeModel(rootNode);
            } else {
                Classification classif = Classification.get(urlStr);
                model = new ClassifTreeModel((TreeNode)rootNode, classif.getModel());
            }
            this.treeModels.put(key, model);
        }
        this.jTreeClassif.setModel(model);
        this.jTreeClassif.updateUI();
        rootNode = (DefaultMutableTreeNode)this.jTreeClassif.getModel().getRoot();
        this.jTreeClassif.expandPath(new TreePath(rootNode.getPath()));
    }

    class ListSelectionListenerClassifs
    implements ListSelectionListener {
        ListSelectionListenerClassifs() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                JDialogManageClassifications.this.update();
            }
        }
    }

    class ActionRemoveClassif
    extends AbstractAction {
        public ActionRemoveClassif() {
            super("RemoveClassif", Util.minusIcon);
        }

        public void actionPerformed(ActionEvent evt) {
            JDialogQuestion dialog = new JDialogQuestion(JDialogManageClassifications.this, "title", "confirmRemoveClassif");
            dialog.setVisible(true);
            if (dialog.res == JDialogQuestion.YES) {
                ArrayList<Classification> itemsToRemove = new ArrayList<Classification>();
                int[] indices = JDialogManageClassifications.this.jListClassifs.getSelectedIndices();
                for (int i = 0; i < indices.length; ++i) {
                    Classification classif = (Classification)JDialogManageClassifications.this.jListClassifs.getModel().getElementAt(indices[i]);
                    if (!classif.delete()) continue;
                    if (classif.getUrl().equals(Preferences.getInstance().getPrevSelectedClassif())) {
                        try {
                            Preferences.getInstance().setPrevSelectedClassif(null);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    itemsToRemove.add(classif);
                    JDialogManageClassifications.this.treeModels.remove(classif.getUrl());
                }
                JDialogManageClassifications.this.jListClassifs.removeListSelectionListener(JDialogManageClassifications.this.listSelectionListenerClassifs);
                for (Classification classif : itemsToRemove) {
                    JDialogManageClassifications.this.listModelClassifs.removeElement(classif);
                }
                JDialogManageClassifications.this.jListClassifs.addListSelectionListener(JDialogManageClassifications.this.listSelectionListenerClassifs);
                JDialogManageClassifications.this.update();
            }
        }
    }

    class ActionAddClassif
    extends AbstractAction {
        public ActionAddClassif() {
            super("AddClassif", Util.plusIcon);
        }

        public void actionPerformed(ActionEvent evt) {
            File classifFile = Classification.doImportFile(JDialogManageClassifications.this);
            if (classifFile != null) {
                try {
                    Classification classif = new Classification(classifFile);
                    classif.register();
                    if (JDialogManageClassifications.this.listModelClassifs.contains(classif)) {
                        JDialogManageClassifications.this.listModelClassifs.removeElement(classif);
                        JDialogManageClassifications.this.treeModels.remove(classif.getUrl());
                    }
                    JDialogManageClassifications.this.listModelClassifs.addElement(classif);
                    JDialogManageClassifications.this.update();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

