/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class JDialogFormatSelector
extends JDialog {
    JPanel jPanelContent;
    JPanel jPanelButton;
    JButton jButtonOk;
    JButton jButtonCancel;
    JRadioButton jRadioButtonNonDigital;
    JRadioButton jRadioButtonDigital;
    JComboBox jComboBoxCategory;
    private DefaultTableModel mimeSubtypeListModel;
    private JTable mimeSubtypeList;
    private String mimeSubtypeListLabel;
    boolean bOk;
    String format;

    public JDialogFormatSelector(JFrame parent) {
        super(parent, "title", true);
        this.setSize(400, 300);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout(0, 5));
        this.jPanelContent = new JPanel(){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.jPanelContent.setLayout(new BorderLayout(0, 5));
        cp.add((Component)this.jPanelContent, "Center");
        this.jRadioButtonNonDigital = new JRadioButton("  non-digital");
        this.jRadioButtonNonDigital.setFocusPainted(false);
        this.jRadioButtonNonDigital.setFont(new Font("Dialog", 0, 12));
        this.jPanelContent.add((Component)this.jRadioButtonNonDigital, "North");
        JPanel jPanelDigital = new JPanel();
        jPanelDigital.setLayout(new BorderLayout(5, 0));
        JPanel jPanelDigitalWest = new JPanel();
        jPanelDigitalWest.setLayout(new BorderLayout());
        this.jRadioButtonDigital = new JRadioButton();
        this.jRadioButtonDigital.setSelected(true);
        this.jRadioButtonDigital.setFocusPainted(false);
        jPanelDigitalWest.add((Component)this.jRadioButtonDigital, "North");
        jPanelDigital.add((Component)jPanelDigitalWest, "West");
        JPanel jPanelDigitalCenter = new JPanel();
        jPanelDigitalCenter.setLayout(new BorderLayout(0, 5));
        this.jComboBoxCategory = new JComboBox();
        this.jComboBoxCategory.setFont(this.jRadioButtonNonDigital.getFont());
        jPanelDigitalCenter.add((Component)this.jComboBoxCategory, "North");
        this.mimeSubtypeListModel = new DefaultTableModel();
        this.mimeSubtypeList = new JTable(this.mimeSubtypeListModel);
        this.mimeSubtypeList.setShowGrid(false);
        this.mimeSubtypeList.getSelectionModel().setSelectionMode(0);
        this.mimeSubtypeList.setFont(this.jRadioButtonNonDigital.getFont());
        this.mimeSubtypeList.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e2) {
                try {
                    Preferences.getInstance().setMimeSubtypeSortMode((Preferences.getInstance().getMimeSubtypeSortMode() + 1) % 3);
                    JDialogFormatSelector.this.updateMimeSubtypes();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.mimeSubtypeList);
        jPanelDigitalCenter.add((Component)jScrollPane, "Center");
        jPanelDigital.add((Component)jPanelDigitalCenter, "Center");
        this.jPanelContent.add((Component)jPanelDigital, "Center");
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRadioButtonNonDigital);
        group.add(this.jRadioButtonDigital);
        this.jButtonOk = new JButton("OK");
        this.jButtonOk.setFont(this.jRadioButtonNonDigital.getFont());
        this.jButtonCancel = new JButton("cancel");
        this.jButtonCancel.setFont(this.jButtonOk.getFont());
        this.jPanelButton = new JPanel();
        this.jPanelButton.setLayout(new FlowLayout(2));
        this.jPanelButton.add(this.jButtonOk);
        this.jPanelButton.add(this.jButtonCancel);
        cp.add((Component)this.jPanelButton, "South");
        SymAction lSymAction = new SymAction();
        this.jRadioButtonNonDigital.addActionListener(lSymAction);
        this.jRadioButtonDigital.addActionListener(lSymAction);
        this.jComboBoxCategory.addActionListener(lSymAction);
        this.jButtonOk.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JDialogFormatSelectorRes", Preferences.getInstance().getLocale());
        this.setTitle(" " + resBundle.getString("title"));
        this.jButtonCancel.setText(resBundle.getString("cancel"));
        this.mimeSubtypeListLabel = resBundle.getString("subtypes");
        this.init();
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        }
        super.setVisible(b);
    }

    void updateMimeSubtypes() {
        int i;
        Object[] mimeTypeValues = Util.readFile(this.getClass(), this.jComboBoxCategory.getSelectedItem() + ".txt");
        switch (Preferences.getInstance().getMimeSubtypeSortMode()) {
            case 1: {
                Arrays.sort(mimeTypeValues);
                break;
            }
            case 2: {
                Arrays.sort(mimeTypeValues);
                Object[] reversed = new Object[mimeTypeValues.length];
                for (i = 0; i < mimeTypeValues.length; ++i) {
                    reversed[i] = mimeTypeValues[mimeTypeValues.length - 1 - i];
                }
                mimeTypeValues = reversed;
            }
        }
        Object[][] data = new Object[mimeTypeValues.length][];
        for (i = 0; i < mimeTypeValues.length; ++i) {
            data[i] = new Object[]{mimeTypeValues[i]};
        }
        this.mimeSubtypeListModel.setDataVector(data, new String[]{this.mimeSubtypeListLabel});
        DefaultTableCellRenderer leftAlignedHeaderRenderer = new DefaultTableCellRenderer();
        leftAlignedHeaderRenderer.setHorizontalAlignment(2);
        LookAndFeel.installColorsAndFont(leftAlignedHeaderRenderer, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installBorder(this.mimeSubtypeList.getTableHeader(), "TableHeader.cellBorder");
        this.mimeSubtypeList.getColumnModel().getColumn(0).setHeaderRenderer(leftAlignedHeaderRenderer);
    }

    void jButtonOk_actionPerformed() {
        if (this.jRadioButtonNonDigital.isSelected()) {
            this.format = "non-digital";
        } else {
            int selectedRow = this.mimeSubtypeList.getSelectedRow();
            if (selectedRow != -1) {
                this.format = this.jComboBoxCategory.getSelectedItem() + "/" + this.mimeSubtypeListModel.getValueAt(selectedRow, 0);
            } else {
                return;
            }
        }
        this.bOk = true;
        this.setVisible(false);
    }

    void jButtonCancel_actionPerformed() {
        this.setVisible(false);
    }

    void init() {
        Object[] data = Util.readFile(this.getClass(), "formats.txt");
        for (int i = 0; i < data.length; ++i) {
            this.jComboBoxCategory.addItem(data[i]);
        }
        this.updateMimeSubtypes();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JDialogFormatSelector.this.jComboBoxCategory) {
                JDialogFormatSelector.this.updateMimeSubtypes();
            } else if (object == JDialogFormatSelector.this.jRadioButtonNonDigital) {
                JDialogFormatSelector.this.jComboBoxCategory.setEnabled(false);
                JDialogFormatSelector.this.mimeSubtypeList.setEnabled(false);
            } else if (object == JDialogFormatSelector.this.jRadioButtonDigital) {
                JDialogFormatSelector.this.jComboBoxCategory.setEnabled(true);
                JDialogFormatSelector.this.mimeSubtypeList.setEnabled(true);
            } else if (object == JDialogFormatSelector.this.jButtonOk) {
                JDialogFormatSelector.this.jButtonOk_actionPerformed();
            } else if (object == JDialogFormatSelector.this.jButtonCancel) {
                JDialogFormatSelector.this.jButtonCancel_actionPerformed();
            }
        }
    }
}

