/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormWrapper;
import ca.licef.lompad.IconTitledBorder;
import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.JPanelForm;
import ca.licef.lompad.LocalizeTitledBorder;
import ca.licef.lompad.MultiFormContainer;
import ca.licef.lompad.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FormContainer
extends FormComponent {
    protected Vector vComponents = new Vector();
    int offset;
    String title;
    boolean isLine;
    boolean isMultipleContainer;
    boolean alignRight = false;
    JToggleButton jToggleButtonHandle;
    JPanel jPanelGaucheContainer;
    JButton jButtonAdd;
    Hashtable removeMapping;
    SymAction lSymAction;
    SymMouse aSymMouse;
    int CONTROL_WIDTH = 24;
    int CONTROL_SPACE = 5;

    public FormContainer() {
        this(null, false, false);
    }

    public FormContainer(String title, boolean isLine) {
        this(title, isLine, false);
    }

    public FormContainer(boolean isMultipleContainer) {
        this(null, false, isMultipleContainer);
    }

    public FormContainer(String title, boolean isLine, boolean isMultipleContainer) {
        this.title = title;
        this.isLine = isLine;
        this.isMultipleContainer = isMultipleContainer;
        this.lSymAction = new SymAction();
        this.aSymMouse = new SymMouse();
        this.offset = 5;
        this.jPanelGaucheContainer = new JPanel();
        this.jPanelGaucheContainer.setOpaque(false);
        this.jPanelGaucheContainer.setLayout(new BoxLayout(this.jPanelGaucheContainer, 1));
        this.jPanelGauche.add("Center", this.jPanelGaucheContainer);
        if (isMultipleContainer) {
            this.removeMapping = new Hashtable();
            this.jButtonAdd = new JButton(Util.plusIcon);
            this.jButtonAdd.setBorderPainted(false);
            this.jButtonAdd.setFocusPainted(false);
            this.jButtonAdd.setMargin(new Insets(1, 1, 1, 2));
            this.jButtonAdd.setPreferredSize(new Dimension(24, 24));
            this.jButtonAdd.setOpaque(false);
            this.jButtonAdd.addActionListener(this.lSymAction);
            this.jButtonAdd.addMouseListener(this.aSymMouse);
        }
        if (title != null) {
            LocalizeTitledBorder border = isLine ? new LocalizeTitledBorder(title) : new LocalizeTitledBorder(BorderFactory.createEmptyBorder(), title);
            border.setTitleFont(new Font("Dialog", 0, 12));
            border.setTitleColor(Color.black);
            this.jPanelContent.setBorder(border);
        }
    }

    void setIcon(ImageIcon icon) {
        IconTitledBorder border = (IconTitledBorder)this.jPanelContent.getBorder();
        if (border != null) {
            border.setIcon(icon);
        }
    }

    @Override
    boolean isFilled() {
        FormComponent c;
        boolean res = false;
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements() && !(res = (c = (FormComponent)e2.nextElement()).isFilled())) {
        }
        return res;
    }

    @Override
    public void setEnabled(boolean b) {
        Enumeration<Object> e2;
        if (this.isMultipleContainer) {
            this.jButtonAdd.setVisible(b);
            e2 = this.removeMapping.keys();
            while (e2.hasMoreElements()) {
                JButton button = (JButton)e2.nextElement();
                button.setVisible(b);
            }
            if (b) {
                if (this.jPanelControl.getComponentCount() > 0) {
                    this.jPanelControl.remove(0);
                }
            } else {
                this.jPanelControl.add(Box.createHorizontalStrut(this.CONTROL_WIDTH));
            }
        }
        e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            ((FormComponent)e2.nextElement()).setEnabled(b);
        }
    }

    @Override
    public void preUpdateVocabularies() {
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            ((FormComponent)e2.nextElement()).preUpdateVocabularies();
        }
    }

    @Override
    public void updateVocabularies() {
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            ((FormComponent)e2.nextElement()).updateVocabularies();
        }
    }

    abstract void addFormContent();

    void addToggle() {
        this.jToggleButtonHandle = new JToggleButton();
        this.jToggleButtonHandle.setOpaque(false);
        this.jToggleButtonHandle.setSelected(true);
        this.jToggleButtonHandle.setPreferredSize(new Dimension(18, 16));
        this.jToggleButtonHandle.setBorder(new EmptyBorder(this.jToggleButtonHandle.getInsets()));
        this.jToggleButtonHandle.setIcon(Util.imageIconCollapse);
        this.jToggleButtonHandle.setSelectedIcon(Util.imageIconExpand);
        this.jToggleButtonHandle.setContentAreaFilled(false);
        this.jToggleButtonHandle.setFocusPainted(false);
        JPanel jPanelHandle = new JPanel();
        jPanelHandle.setOpaque(false);
        jPanelHandle.setLayout(new FlowLayout(0, 0, 0));
        jPanelHandle.add(this.jToggleButtonHandle);
        this.add((Component)jPanelHandle, 0);
        this.add(Box.createHorizontalStrut(5), 1);
        this.jToggleButtonHandle.addActionListener(this.lSymAction);
        jPanelHandle.setAlignmentY(0.0f);
        this.jPanelContent.setAlignmentY(0.0f);
    }

    void addSpace(int space) {
        Component c = Box.createVerticalStrut(space);
        this.jPanelGaucheContainer.add(c);
    }

    public void setFormVisible(boolean b) {
        if (this.getSpace() != null) {
            this.getSpace().setVisible(b);
        }
        this.setVisible(b);
    }

    public void clearFormIcon() {
        for (int i = 0; i < this.vComponents.size(); ++i) {
            Object c = this.vComponents.elementAt(i);
            if (c instanceof FormContainer) {
                ((FormContainer)c).clearFormIcon();
                continue;
            }
            if (!(c instanceof MultiFormContainer)) continue;
            ((MultiFormContainer)c).clearFormIcon();
        }
        this.setFormIcon(null);
    }

    public void setFormIcon(ImageIcon icon) {
        this.setIcon(icon);
    }

    public void clearFormToolTipText() {
        for (int i = 0; i < this.vComponents.size(); ++i) {
            Object c = this.vComponents.elementAt(i);
            if (c instanceof FormContainer) {
                ((FormContainer)c).clearFormToolTipText();
                continue;
            }
            if (!(c instanceof MultiFormContainer)) continue;
            ((MultiFormContainer)c).clearFormToolTipText();
        }
        this.setToolTipText(null);
    }

    public void setFormToolTipText(String text) {
        this.setToolTipText(text);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        ImageIcon icon;
        Rectangle rect = null;
        IconTitledBorder border = (IconTitledBorder)this.jPanelContent.getBorder();
        if (border != null && (icon = border.getIcon()) != null) {
            Point iconLoc = border.getIconLocation();
            rect = new Rectangle(this.jPanelContent.getLocation().x + iconLoc.x, this.jPanelContent.getLocation().y + iconLoc.y, icon.getIconWidth(), icon.getIconHeight());
        }
        return rect != null && rect.contains(evt.getX(), evt.getY()) ? this.getToolTipText() : null;
    }

    public void setFormIconEff(String key, ImageIcon icon) {
        if (key.indexOf(".") == -1) {
            int pos = Integer.parseInt(key);
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormIcon(icon);
        } else {
            int pos = Integer.parseInt(key.substring(0, key.indexOf(".")));
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormIcon(key.substring(key.indexOf(".") + 1), icon);
        }
    }

    public void setFormToolTipTextEff(String key, String text) {
        if (key.indexOf(".") == -1) {
            int pos = Integer.parseInt(key);
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormToolTipText(text);
        } else {
            int pos = Integer.parseInt(key.substring(0, key.indexOf(".")));
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormToolTipText(key.substring(key.indexOf(".") + 1), text);
        }
    }

    public void setFormVisibleEff(String key, boolean isVisible) {
        if (key.indexOf(".") == -1) {
            int pos = Integer.parseInt(key);
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormVisible(isVisible);
        } else {
            int pos = Integer.parseInt(key.substring(0, key.indexOf(".")));
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            c.setFormVisible(key.substring(key.indexOf(".") + 1), isVisible);
        }
    }

    public void setFormVisible(String key, boolean isVisible) {
        if (this.isMultipleContainer) {
            Enumeration e2 = this.vComponents.elements();
            while (e2.hasMoreElements()) {
                FormContainer c1 = (FormContainer)e2.nextElement();
                c1.setFormVisibleEff(key, isVisible);
            }
        } else {
            this.setFormVisibleEff(key, isVisible);
        }
    }

    public void setFormIcon(String key, ImageIcon icon) {
        if (this.isMultipleContainer) {
            Enumeration e2 = this.vComponents.elements();
            while (e2.hasMoreElements()) {
                FormContainer c1 = (FormContainer)e2.nextElement();
                c1.setFormIconEff(key, icon);
            }
        } else {
            this.setFormIconEff(key, icon);
        }
    }

    public void setFormToolTipText(String key, String text) {
        if (this.isMultipleContainer) {
            Enumeration e2 = this.vComponents.elements();
            while (e2.hasMoreElements()) {
                FormContainer c1 = (FormContainer)e2.nextElement();
                c1.setFormToolTipTextEff(key, text);
            }
        } else {
            this.setFormToolTipTextEff(key, text);
        }
    }

    public boolean isCompleteEff(String key) {
        if (key.indexOf(".") == -1) {
            int pos = Integer.parseInt(key);
            FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
            return c.isFilled();
        }
        int pos = Integer.parseInt(key.substring(0, key.indexOf(".")));
        FormContainer c = (FormContainer)this.vComponents.elementAt(pos - 1);
        return c.isComplete(key.substring(key.indexOf(".") + 1));
    }

    public boolean isComplete(String key) {
        boolean res = true;
        if (this.isMultipleContainer) {
            Enumeration e2 = this.vComponents.elements();
            while (e2.hasMoreElements()) {
                FormContainer c1 = (FormContainer)e2.nextElement();
                if (res = res && c1.isCompleteEff(key)) continue;
                break;
            }
        } else {
            res = this.isCompleteEff(key);
        }
        return res;
    }

    public void updateContentVisible() {
        this.jPanelGaucheContainer.setVisible(this.jToggleButtonHandle.isSelected());
        this.jToggleButtonHandle.setPressedIcon(this.jToggleButtonHandle.isSelected() ? Util.imageIconExpand : Util.imageIconCollapse);
    }

    void setAlignRight() {
        this.alignRight = true;
    }

    void setEnabledButtonAdd(boolean b) {
        if (this.isMultipleContainer) {
            this.jButtonAdd.setEnabled(b);
        }
    }

    void update() {
        JRootPane jc = SwingUtilities.getRootPane(this);
        if (jc != null) {
            jc.invalidate();
            jc.validate();
        }
    }

    FormComponent wrapIntoRemovableComponent(FormComponent c) {
        FormWrapper c2 = new FormWrapper();
        c2.mediator = c.mediator;
        c2.jPanelGaucheContainer.add(c);
        c2.jPanelControl.add(Box.createHorizontalStrut(this.CONTROL_SPACE));
        if (this.jPanelGaucheContainer.getComponentCount() == 0) {
            c2.jPanelControl.add(this.jButtonAdd);
        } else {
            JButton jButtonRemove = new JButton(Util.minusIcon);
            jButtonRemove.setBorderPainted(false);
            jButtonRemove.setFocusPainted(false);
            jButtonRemove.setMargin(new Insets(1, 1, 1, 2));
            jButtonRemove.setOpaque(false);
            jButtonRemove.setPreferredSize(new Dimension(24, 24));
            jButtonRemove.addActionListener(this.lSymAction);
            jButtonRemove.addMouseListener(this.aSymMouse);
            this.removeMapping.put(jButtonRemove, c2);
            c2.jPanelControl.add(jButtonRemove);
        }
        c2.setMinimumSize(c.getMinimumSize());
        c2.setPreferredSize(c.getPreferredSize());
        c2.setMaximumSize(c.getMaximumSize());
        return c2;
    }

    public void addComponent(FormComponent c) {
        this.vComponents.addElement(c);
        if (this.isMultipleContainer) {
            c = this.wrapIntoRemovableComponent(c);
        } else if (this.alignRight) {
            c.jPanelControl.add(Box.createHorizontalStrut(this.CONTROL_WIDTH + this.CONTROL_SPACE));
        }
        c.setAlignmentX(0.0f);
        if (this.jPanelGaucheContainer.getComponentCount() != 0) {
            Component space = Box.createVerticalStrut(this.offset);
            c.setSpace(space);
            this.jPanelGaucheContainer.add(space);
        }
        this.jPanelGaucheContainer.add(c);
        this.update();
        JPanelForm.instance.doFilter();
    }

    public void removeComponent(FormContainer c) {
        this.jPanelGaucheContainer.remove(c.getSpace());
        this.jPanelGaucheContainer.remove(c);
        this.update();
        if (this.mediator != null) {
            this.mediator.buttonRemoveComponentPerformed((FormComponent)c.jPanelGaucheContainer.getComponent(0));
        } else {
            this.vComponents.removeElement((FormComponent)c.jPanelGaucheContainer.getComponent(0));
        }
    }

    public void clear(int index) {
        FormComponent component = (FormComponent)this.vComponents.elementAt(index);
        if (index != 0 && this.removeMapping != null) {
            Enumeration e2 = this.removeMapping.elements();
            while (e2.hasMoreElements()) {
                FormComponent c = (FormComponent)e2.nextElement();
                if (((FormWrapper)c).jPanelGaucheContainer.getComponent(0) != component) continue;
                this.removeComponent((FormContainer)c);
            }
        } else {
            component.clear();
        }
    }

    @Override
    public void clear() {
        Enumeration<Object> e2;
        if (this.removeMapping != null) {
            e2 = this.removeMapping.elements();
            while (e2.hasMoreElements()) {
                FormComponent c = (FormComponent)e2.nextElement();
                if (c instanceof FormContainer) {
                    this.removeComponent((FormContainer)c);
                    continue;
                }
                c.clear();
            }
        }
        e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            ((FormComponent)e2.nextElement()).clear();
        }
    }

    void jButton_mouseInOut(JButton jButton, boolean in) {
        jButton.setBorderPainted(in);
    }

    int getMinimumHeight() {
        int height = 0;
        if (this.jPanelGaucheContainer.isVisible()) {
            Component[] arrayComp = this.jPanelGaucheContainer.getComponents();
            for (int i = 0; i < arrayComp.length; ++i) {
                if (!arrayComp[i].isVisible()) continue;
                if (arrayComp[i] instanceof FormContainer) {
                    height += ((FormContainer)arrayComp[i]).getMinimumHeight();
                    continue;
                }
                height += arrayComp[i].getMinimumSize().height;
            }
        }
        if (this.title != null) {
            height += this.isLine ? 10 : 8;
            if (!this.title.equals("")) {
                height += 20;
            } else if (this.jToggleButtonHandle != null && !this.jToggleButtonHandle.isSelected()) {
                height += 16;
            }
        }
        return height;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, this.getMinimumHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, this.getMinimumHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(2000, this.getMinimumHeight());
    }

    @Override
    void graphicalUpdate() {
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            ((FormComponent)e2.nextElement()).graphicalUpdate();
        }
    }

    @Override
    String toXML(String key) {
        String xml = "";
        int i = 1;
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toXML(key + "." + i);
            if (res != null) {
                xml = xml + res;
            }
            ++i;
        }
        xml = !xml.equals("") ? "<" + Util.getTag(key) + ">" + xml + "</" + Util.getTag(key) + ">\n" : null;
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        NodeList list = e2.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String pathElem = path + "/" + child.getTagName().toLowerCase();
            try {
                int pos = Util.getPosTag(pathElem);
                FormComponent c = (FormComponent)this.vComponents.elementAt(pos - 1);
                c.fromXML(pathElem, child, observations);
                continue;
            }
            catch (IllegalTagException illegalTagException) {
                // empty catch block
            }
        }
    }

    @Override
    String toHTML(String key) {
        String html = "";
        int i = 1;
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toHTML(key + "." + i);
            if (res != null) {
                html = html + res;
            }
            ++i;
        }
        html = !html.equals("") ? "<TABLE BORDER=\"0\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"95%\">\n<TR VALIGN=\"TOP\"><TD><P><B>" + Util.getLabel(key) + "</B>\n" + "</TD></TR></TABLE>" + html : null;
        return html;
    }

    String toHTMLCategory(String key) {
        String html = "";
        int i = 1;
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toHTML(key + "." + i);
            if (res != null) {
                html = html + res;
            }
            ++i;
        }
        html = !html.equals("") ? "<TABLE BORDER=\"0\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"95%\">\n<TR VALIGN=\"TOP\"><TD><P><B>" + Util.getLabel(key) + "</B>\n" + "</TD></TR></TABLE>" + "<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"95%\">\n" + html + "</TABLE><br><br>" : null;
        return html;
    }

    String toHTMLRow(String key) {
        String html = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toHTML(key);
            if (res == null) continue;
            html = html + res;
        }
        html = !html.equals("") ? "<TR><TD WIDTH=\"160\" VALIGN=\"TOP\"><B>" + Util.getLabel(key) + "</B></TD>" + "<TD VALIGN=\"TOP\">" + html + "</TD></TR>" : null;
        return html;
    }

    @Override
    String toHTMLData(String key) {
        String html = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c instanceof FormContainer ? c.toHTMLData(key) : c.toHTML(key);
            if (res == null) continue;
            html = html + res;
        }
        if (html.equals("")) {
            html = null;
        }
        return html;
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseEntered(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                FormContainer.this.jButton_mouseInOut((JButton)object, true);
            }
        }

        public void mouseExited(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                FormContainer.this.jButton_mouseInOut((JButton)object, false);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FormContainer.this.jToggleButtonHandle) {
                FormContainer.this.updateContentVisible();
            } else if (object == FormContainer.this.jButtonAdd) {
                FormContainer.this.addFormContent();
            } else if (FormContainer.this.removeMapping.containsKey(object)) {
                FormContainer.this.removeComponent((FormContainer)FormContainer.this.removeMapping.get(object));
            }
        }
    }
}

