/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import java.awt.Font;
import java.util.List;
import javax.swing.JComboBox;
import licef.StringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVocabularyComponent
extends FormComponent {
    JComboBox jComboBoxVocabulary = new JComboBox();
    String source;
    String value;

    public ExternalVocabularyComponent() {
        this.jComboBoxVocabulary.setFont(new Font("Dialog", 0, 11));
        this.jPanelGauche.add(this.jComboBoxVocabulary);
    }

    @Override
    boolean isFilled() {
        return this.jComboBoxVocabulary.getSelectedItem() != null;
    }

    @Override
    String toXML(String key) {
        String xml = null;
        if (this.isFilled()) {
            xml = "";
            if (!StringUtil.isEmpty(this.source)) {
                xml = xml + "<source>" + this.source + "</source>\n";
            }
            if (!StringUtil.isEmpty(this.value)) {
                xml = xml + "<value>" + this.value + "</value>\n";
            }
        }
        return xml;
    }

    void fromXML(String path, Element e2, boolean firstField, List<String> observations) {
        NodeList listSrc = e2.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "source");
        if (listSrc.getLength() == 0) {
            this.source = "";
        } else {
            Element childSrc = (Element)listSrc.item(0);
            this.source = childSrc.getFirstChild().getNodeValue();
        }
        NodeList list = e2.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "value");
        if (list.getLength() > 0) {
            Element child = (Element)list.item(0);
            this.value = child.getFirstChild().getNodeValue().trim();
        }
        String profile = Util.getExternalProfileFromVocabularySource(this.source);
        if (Preferences.getInstance().getApplicationProfileView().startsWith("NORMETIC") && profile != null && profile.startsWith("NORMETIC") && Util.externalProfile != null && Util.externalProfile.startsWith("NORMETIC") && !profile.equals(Util.externalProfile) && observations != null) {
            observations.add("mismatchProfileVersionDetected");
        }
        String src = this.source;
        if (profile != null && profile.equals(Util.externalProfile)) {
            src = profile;
        }
        String item = src + ": " + this.value;
        if (firstField) {
            this.jComboBoxVocabulary.addItem(null);
        }
        this.jComboBoxVocabulary.addItem(item);
        this.jComboBoxVocabulary.setSelectedIndex(firstField ? 1 : 0);
    }

    @Override
    String toHTML(String key) {
        String html = null;
        if (this.isFilled()) {
            String profile = Util.getExternalProfileFromVocabularySource(this.source);
            String src = this.source;
            if (profile != null) {
                src = profile;
            }
            html = src + ": " + this.value + "<br>";
        }
        return html;
    }
}

