/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Classification;
import ca.licef.lompad.LangStrings;
import ca.licef.lompad.LocalizeTaxon;
import ca.licef.lompad.Preferences;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import licef.IOUtil;

public class ClassifTreeModel
extends DefaultTreeModel {
    static boolean controlledPosition;
    private Model model;

    public ClassifTreeModel(TreeNode root, Model model) {
        super(root);
        this.model = model;
        try {
            this.buildNodes();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public ClassifTreeModel(TreeNode root, URL rdfData) {
        this(root, rdfData, false);
    }

    public ClassifTreeModel(TreeNode root, URL rdfData, boolean isInferenceNeeded) {
        super(root);
        try {
            InputStream is = (InputStream)rdfData.getContent();
            this.init(is, isInferenceNeeded);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public ClassifTreeModel(TreeNode root, File rdfData) {
        this(root, rdfData, false);
    }

    public ClassifTreeModel(TreeNode root, File rdfData, boolean isInferenceNeeded) {
        super(root);
        try {
            FileInputStream is = new FileInputStream(rdfData);
            this.init(is, isInferenceNeeded);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is, boolean isInferenceNeeded) {
        try {
            this.model = ModelFactory.createDefaultModel();
            this.model.read(is, null);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (isInferenceNeeded) {
            this.doInference();
        }
        try {
            this.buildNodes();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void addChildrenNodesIfNeeded(DefaultMutableTreeNode node) throws IOException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.getChildCount() != 0) continue;
            String childUri = ((LocalizeTaxon)childNode.getUserObject()).uri;
            String[] childrenConceptUris = this.getChildrenConcepts(childUri);
            this.buildChildrenNodes(childNode, childrenConceptUris);
        }
    }

    private void doInference() {
        Model modelSkos = ModelFactory.createDefaultModel();
        InputStream is = this.getClass().getResourceAsStream("/skos.rdf");
        this.model.read(is, "");
        Reasoner reasoner = ReasonerRegistry.getOWLMicroReasoner();
        reasoner = reasoner.bindSchema(modelSkos);
        InfModel infModel = ModelFactory.createInfModel(reasoner, this.model);
        this.model.add(infModel.listStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQuery(String queryId, Object ... params) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        InputStream is = this.getClass().getResourceAsStream("/queries/" + queryId);
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            IOUtil.copy(bis, bos);
        }
        finally {
            bis.close();
            bos.close();
        }
        String rawQuery = baos.toString("UTF-8");
        if (params == null || params.length == 0) {
            return rawQuery;
        }
        String query2 = MessageFormat.format(rawQuery, params);
        return query2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getChildrenConcepts(String parentUri) throws IOException {
        controlledPosition = false;
        ArrayList<String> childrenConceptUris = new ArrayList<String>();
        String queryStr = this.getQuery("getChildrenConcepts.sparql", parentUri);
        Query query2 = QueryFactory.create(queryStr, parentUri);
        QueryExecution exec = QueryExecutionFactory.create(query2, this.model);
        int nbPos = 0;
        try {
            ResultSet results = exec.execSelect();
            while (results.hasNext()) {
                QuerySolution res = results.nextSolution();
                Iterator<String> it = res.varNames();
                while (it.hasNext()) {
                    String varName = it.next().toString();
                    if ("pos".equals(varName)) {
                        ++nbPos;
                        continue;
                    }
                    if (!"o".equals(varName)) continue;
                    RDFNode n = res.get(varName);
                    childrenConceptUris.add(n.toString());
                }
            }
            controlledPosition = nbPos == childrenConceptUris.size();
        }
        finally {
            exec.close();
        }
        return childrenConceptUris.toArray(new String[childrenConceptUris.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTopConcepts() throws IOException {
        controlledPosition = false;
        ArrayList<String> topConceptUris = new ArrayList<String>();
        String queryStr = this.getQuery("getTopConcepts.sparql", new Object[0]);
        Query query2 = QueryFactory.create(queryStr);
        QueryExecution exec = QueryExecutionFactory.create(query2, this.model);
        int nbPos = 0;
        try {
            ResultSet results = exec.execSelect();
            while (results.hasNext()) {
                QuerySolution res = results.nextSolution();
                Iterator<String> it = res.varNames();
                while (it.hasNext()) {
                    String varName = it.next().toString();
                    if ("pos".equals(varName)) {
                        ++nbPos;
                        continue;
                    }
                    if (!"s".equals(varName)) continue;
                    RDFNode n = res.get(varName);
                    topConceptUris.add(n.toString());
                }
            }
            controlledPosition = nbPos == topConceptUris.size();
        }
        finally {
            exec.close();
        }
        return topConceptUris.toArray(new String[topConceptUris.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChildrenNodes(DefaultMutableTreeNode parentNode, String[] childrenUris) throws IOException {
        int i;
        DefaultMutableTreeNode[] childrenNodes = new DefaultMutableTreeNode[childrenUris.length];
        for (i = 0; i < childrenUris.length; ++i) {
            DefaultMutableTreeNode newChild;
            String childUri = childrenUris[i];
            HashMap<String, String> titles = new HashMap<String, String>();
            String queryStr = this.getQuery("getPrefLabels.sparql", childUri);
            Query query2 = QueryFactory.create(queryStr, childUri);
            QueryExecution exec = QueryExecutionFactory.create(query2, this.model);
            try {
                ResultSet results = exec.execSelect();
                while (results.hasNext()) {
                    QuerySolution res = results.nextSolution();
                    Iterator<String> it = res.varNames();
                    while (it.hasNext()) {
                        String varName = it.next().toString();
                        RDFNode n = res.get(varName);
                        if (!(n instanceof Literal)) continue;
                        Literal literal = (Literal)n;
                        String lang = literal.getLanguage();
                        String label = literal.getValue().toString().trim();
                        titles.put(lang, label);
                    }
                }
            }
            finally {
                exec.close();
            }
            String taxonPathId = Classification.retrieveTaxonPathId(childUri);
            LocalizeTaxon taxon = new LocalizeTaxon(taxonPathId, childUri, new LangStrings(titles));
            childrenNodes[i] = newChild = new DefaultMutableTreeNode(taxon);
        }
        if (!controlledPosition) {
            Arrays.sort(childrenNodes, new Comparator<DefaultMutableTreeNode>(){

                @Override
                public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
                    LocalizeTaxon taxon1 = (LocalizeTaxon)n1.getUserObject();
                    LocalizeTaxon taxon2 = (LocalizeTaxon)n2.getUserObject();
                    if (taxon1.id != null && taxon1.id.toLowerCase().indexOf("uuid") != -1) {
                        Locale locale = Preferences.getInstance().getLocale();
                        String lang = locale.getLanguage();
                        Collator collator = Collator.getInstance(locale);
                        String title1 = taxon1.getTitle(lang, false);
                        String title2 = taxon2.getTitle(lang, false);
                        return collator.compare(title1, title2);
                    }
                    return taxon1.id.compareTo(taxon2.id);
                }
            });
        }
        for (i = 0; i < childrenNodes.length; ++i) {
            DefaultMutableTreeNode childNode = childrenNodes[i];
            parentNode.add(childNode);
        }
    }

    private void buildNodes() throws IOException {
        String[] topConceptUris = this.getTopConcepts();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getRoot();
        this.buildChildrenNodes(rootNode, topConceptUris);
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            String childUri = ((LocalizeTaxon)childNode.getUserObject()).uri;
            String[] childrenConceptUris = this.getChildrenConcepts(childUri);
            this.buildChildrenNodes(childNode, childrenConceptUris);
        }
    }
}

